/*****************************************************************************
   Major portions of this software are copyrighted by the Medical College
   of Wisconsin, 1994-2000, and are released under the Gnu General Public
   License, Version 2.  See the file README.Copyright for details.
******************************************************************************/
   
#include <stdlib.h>

/*------------- constants for Laguerre integration, orders 2-20 -------------*/
/*------------- adapted from quadrule.f by John Burkardt        -------------*/

static double xlag2[] = { 0.585786437626904951198311275790e+00,
          0.341421356237309504880168872421e+01 } ;

static double wlag2[] = { 0.853553390593273762200422181052e+00,
          0.146446609406726237799577818948e+00 } ;

static double xlag3[] = { 0.415774556783479083311533873128e+00,
          0.229428036027904171982205036136e+01, 0.628994508293747919686641576551e+01 } ;

static double wlag3[] = { 0.711093009929173015449590191143e+00,
          0.278517733569240848801444888457e+00, 0.103892565015861357489649204007e-01 } ;


static double xlag4[] = { 0.322547689619392311800361943361e+00,
          0.174576110115834657568681671252e+01, 0.453662029692112798327928538496e+01,
          0.939507091230113312923353644342e+01 } ;

static double wlag4[] = { 0.603154104341633601635966023818e+00,
          0.357418692437799686641492017458e+00, 0.388879085150053842724381681562e-01,
          0.539294705561327450103790567621e-03 } ;

static double xlag5[] = { 0.263560319718140910203061943361e+00,
          0.141340305910651679221840798019e+01, 0.359642577104072208122318658878e+01,
          0.708581000585883755692212418111e+01, 0.126408008442757826594332193066e+02 } ;

static double wlag5[] = { 0.521755610582808652475860928792e+00,
          0.398666811083175927454133348144e+00, 0.759424496817075953876533114055e-01,
          0.361175867992204845446126257304e-02, 0.233699723857762278911490845516e-04 } ;

static double xlag6[] = { 0.222846604179260689464354826787e+00,
          0.118893210167262303074315092194e+01, 0.299273632605931407769132528451e+01,
          0.577514356910451050183983036943e+01, 0.983746741838258991771554702994e+01,
          0.159828739806017017825457915674e+02 } ;

static double wlag6[] = { 0.458964673949963593568284877709e+00,
         0.417000830772120994113377566193e+00, 0.113373382074044975738706185098e+00,
         0.103991974531490748989133028469e-01, 0.261017202814932059479242860001e-03,
         0.898547906429621238825292052825e-06 } ;

static double xlag7[] = { 0.193043676560362413838247885004e+00,
            0.102666489533919195034519944317e+01, 0.256787674495074620690778622666e+01,
            0.490035308452648456810171437810e+01, 0.818215344456286079108182755123e+01,
            0.127341802917978137580126424582e+02, 0.193957278622625403117125820576e+02 } ;

static double wlag7[] = { 0.409318951701273902130432880018e+00,
         0.421831277861719779929281005417e+00, 0.147126348657505278395374184637e+00,
         0.206335144687169398657056149642e-01, 0.107401014328074552213195962843e-02,
         0.158654643485642012687326223234e-04, 0.317031547899558056227132215385e-07 } ;

static double xlag8[] = { 0.170279632305100999788861856608e+00,
            0.903701776799379912186020223555e+00, 0.225108662986613068930711836697e+01,
            0.426670017028765879364942182690e+01, 0.704590540239346569727932548212e+01,
            0.107585160101809952240599567880e+02, 0.157406786412780045780287611584e+02,
            0.228631317368892641057005342974e+02 } ;

static double wlag8[] = { 0.369188589341637529920582839376e+00,
         0.418786780814342956076978581333e+00, 0.175794986637171805699659866777e+00,
         0.333434922612156515221325349344e-01, 0.279453623522567252493892414793e-02,
         0.907650877335821310423850149336e-04, 0.848574671627253154486801830893e-06,
         0.104800117487151038161508853552e-08 } ;

static double xlag9[] = { 0.152322227731808247428107073127e+00,
            0.807220022742255847741419210952e+00, 0.200513515561934712298303324701e+01,
            0.378347397333123299167540609364e+01, 0.620495677787661260697353521006e+01,
            0.937298525168757620180971073215e+01, 0.134662369110920935710978818397e+02,
            0.188335977889916966141498992996e+02, 0.263740718909273767961410072937e+02 } ;

static double wlag9[] = { 0.336126421797962519673467717606e+00,
         0.411213980423984387309146942793e+00, 0.199287525370885580860575607212e+00,
         0.474605627656515992621163600479e-01, 0.559962661079458317700419900556e-02,
         0.305249767093210566305412824291e-03, 0.659212302607535239225572284875e-05,
         0.411076933034954844290241040330e-07, 0.329087403035070757646681380323e-10 } ;

static double xlag10[] = { 0.137793470540492430830772505653e+00,
            0.729454549503170498160373121676e+00, 0.180834290174031604823292007575e+01,
            0.340143369785489951448253222141e+01, 0.555249614006380363241755848687e+01,
            0.833015274676449670023876719727e+01, 0.118437858379000655649185389191e+02,
            0.162792578313781020995326539358e+02, 0.219965858119807619512770901956e+02,
           0.299206970122738915599087933408e+02 } ;

static double wlag10[] = { 0.308441115765020141547470834678e+00,
         0.401119929155273551515780309913e+00, 0.218068287611809421588648523475e+00,
         0.620874560986777473929021293135e-01, 0.950151697518110055383907219417e-02,
         0.753008388587538775455964353676e-03, 0.282592334959956556742256382685e-04,
         0.424931398496268637258657665975e-06, 0.183956482397963078092153522436e-08,
        0.991182721960900855837754728324e-12 } ;

static double xlag11[] = { 0.125796442187967522675794577516e+00,
            0.665418255839227841678127839420e+00, 0.164715054587216930958700321365e+01,
            0.309113814303525495330195934259e+01, 0.502928440157983321236999508366e+01,
            0.750988786380661681941099714450e+01, 0.106059509995469677805559216457e+02,
            0.144316137580641855353200450349e+02, 0.191788574032146786478174853989e+02,
           0.252177093396775611040909447797e+02, 0.334971928471755372731917259395e+02 } ;

static double wlag11[] = { 0.284933212894200605056051024724e+00,
         0.389720889527849377937553508048e+00, 0.232781831848991333940223795543e+00,
         0.765644535461966864008541790132e-01, 0.143932827673506950918639187409e-01,
         0.151888084648487306984777640042e-02, 0.851312243547192259720424170600e-04,
         0.229240387957450407857683270709e-05, 0.248635370276779587373391491114e-07,
        0.771262693369132047028152590222e-10, 0.288377586832362386159777761217e-13 } ;

static double xlag12[] = { 0.115722117358020675267196428240e+00,
            0.611757484515130665391630053042e+00, 0.151261026977641878678173792687e+01,
            0.283375133774350722862747177657e+01, 0.459922763941834848460572922485e+01,
            0.684452545311517734775433041849e+01, 0.962131684245686704391238234923e+01,
            0.130060549933063477203460524294e+02, 0.171168551874622557281840528008e+02,
           0.221510903793970056699218950837e+02, 0.284879672509840003125686072325e+02,
           0.370991210444669203366389142764e+02 } ;

static double wlag12[] = { 0.264731371055443190349738892056e+00,
         0.377759275873137982024490556707e+00, 0.244082011319877564254870818274e+00,
         0.904492222116809307275054934667e-01, 0.201023811546340965226612867827e-01,
         0.266397354186531588105415760678e-02, 0.203231592662999392121432860438e-03,
         0.836505585681979874533632766396e-05, 0.166849387654091026116989532619e-06,
        0.134239103051500414552392025055e-08, 0.306160163503502078142407718971e-11,
        0.814807746742624168247311868103e-15 } ;

static double xlag13[] = { 0.107142388472252310648493376977e+00,
            0.566131899040401853406036347177e+00, 0.139856433645101971792750259921e+01,
            0.261659710840641129808364008472e+01, 0.423884592901703327937303389926e+01,
            0.629225627114007378039376523025e+01, 0.881500194118697804733348868036e+01,
            0.118614035888112425762212021880e+02, 0.155107620377037527818478532958e+02,
           0.198846356638802283332036594634e+02, 0.251852638646777580842970297823e+02,
           0.318003863019472683713663283526e+02, 0.407230086692655795658979667001e+02 } ;

static double wlag13[] = { 0.247188708429962621346249185964e+00,
         0.365688822900521945306717530893e+00, 0.252562420057658502356824288815e+00,
         0.103470758024183705114218631672e+00, 0.264327544155616157781587735702e-01,
         0.422039604025475276555209292644e-02, 0.411881770472734774892472527082e-03,
         0.235154739815532386882897300772e-04, 0.731731162024909910401047197761e-06,
        0.110884162570398067979150974759e-07, 0.677082669220589884064621459082e-10,
        0.115997995990507606094507145382e-12, 0.224509320389275841599187226865e-16 } ;

static double xlag14[] = { 0.997475070325975745736829452514e-01,
            0.526857648851902896404583451502e+00, 0.130062912125149648170842022116e+01,
            0.243080107873084463616999751038e+01, 0.393210282229321888213134366778e+01,
            0.582553621830170841933899983898e+01, 0.814024014156514503005978046052e+01,
            0.109164995073660188408130510904e+02, 0.142108050111612886831059780825e+02,
           0.181048922202180984125546272083e+02, 0.227233816282696248232280886985e+02,
           0.282729817232482056954158923218e+02, 0.351494436605924265828643121364e+02,
           0.443660817111174230416312423666e+02 } ;

static double wlag14[] = { 0.231815577144864977840774861104e+00,
         0.353784691597543151802331301273e+00, 0.258734610245428085987320561144e+00,
         0.115482893556923210087304988673e+00, 0.331920921593373600387499587137e-01,
         0.619286943700661021678785967675e-02, 0.739890377867385942425890907080e-03,
         0.549071946684169837857331777667e-04, 0.240958576408537749675775256553e-05,
        0.580154398167649518088619303904e-07, 0.681931469248497411961562387084e-09,
        0.322120775189484793980885399656e-11, 0.422135244051658735159797335643e-14,
        0.605237502228918880839870806281e-18 } ;

static double xlag15[] = { 0.933078120172818047629030383672e-01,
            0.492691740301883908960101791412e+00, 0.121559541207094946372992716488e+01,
            0.226994952620374320247421741375e+01, 0.366762272175143727724905959436e+01,
            0.542533662741355316534358132596e+01, 0.756591622661306786049739555812e+01,
            0.101202285680191127347927394568e+02, 0.131302824821757235640991204176e+02,
           0.166544077083299578225202408430e+02, 0.207764788994487667729157175676e+02,
           0.256238942267287801445868285977e+02, 0.314075191697539385152432196202e+02,
           0.385306833064860094162515167595e+02, 0.480260855726857943465734308508e+02 } ;

static double wlag15[] = { 0.218234885940086889856413236448e+00,
         0.342210177922883329638948956807e+00, 0.263027577941680097414812275022e+00,
         0.126425818105930535843030549378e+00, 0.402068649210009148415854789871e-01,
         0.856387780361183836391575987649e-02, 0.121243614721425207621920522467e-02,
         0.111674392344251941992578595518e-03, 0.645992676202290092465319025312e-05,
        0.222631690709627263033182809179e-06, 0.422743038497936500735127949331e-08,
        0.392189726704108929038460981949e-10, 0.145651526407312640633273963455e-12,
        0.148302705111330133546164737187e-15, 0.160059490621113323104997812370e-19 } ;

static double xlag16[] = { 0.876494104789278403601980973401e-01,
            0.462696328915080831880838260664e+00, 0.114105777483122685687794501811e+01,
            0.212928364509838061632615907066e+01, 0.343708663389320664523510701675e+01,
            0.507801861454976791292305830814e+01, 0.707033853504823413039598947080e+01,
            0.943831433639193878394724672911e+01, 0.122142233688661587369391246088e+02,
           0.154415273687816170767647741622e+02, 0.191801568567531348546631409497e+02,
           0.235159056939919085318231872752e+02, 0.285787297428821403675206137099e+02,
           0.345833987022866258145276871778e+02, 0.419404526476883326354722330252e+02,
           0.517011603395433183643426971197e+02 } ;

static double wlag16[] = { 0.206151714957800994334273636741e+00,
         0.331057854950884165992983098710e+00, 0.265795777644214152599502020650e+00,
         0.136296934296377539975547513526e+00, 0.473289286941252189780623392781e-01,
         0.112999000803394532312490459701e-01, 0.184907094352631086429176783252e-02,
         0.204271915308278460126018338421e-03, 0.148445868739812987713515067551e-04,
        0.682831933087119956439559590327e-06, 0.188102484107967321388159920418e-07,
        0.286235024297388161963062629156e-09, 0.212707903322410296739033610978e-11,
        0.629796700251786778717446214552e-14, 0.505047370003551282040213233303e-17,
        0.416146237037285519042648356116e-21 } ;

static double xlag17[] = { 0.826382147089476690543986151980e-01,
            0.436150323558710436375959029847e+00, 0.107517657751142857732980316755e+01,
            0.200519353164923224070293371933e+01, 0.323425612404744376157380120696e+01,
            0.477351351370019726480932076262e+01, 0.663782920536495266541643929703e+01,
            0.884668551116980005369470571184e+01, 0.114255293193733525869726151469e+02,
           0.144078230374813180021982874959e+02, 0.178382847307011409290658752412e+02,
           0.217782682577222653261749080522e+02, 0.263153178112487997766149598369e+02,
           0.315817716804567331343908517497e+02, 0.377960938374771007286092846663e+02,
           0.453757165339889661829258363215e+02, 0.553897517898396106640900199790e+02 } ;

static double wlag17[] = { 0.195332205251770832145927297697e+00,
         0.320375357274540281336625631970e+00, 0.267329726357171097238809604160e+00,
         0.145129854358758625407426447473e+00, 0.544369432453384577793805803066e-01,
         0.143572977660618672917767247431e-01, 0.266282473557277256843236250006e-02,
         0.343679727156299920611775097985e-03, 0.302755178378287010943703641131e-04,
        0.176851505323167689538081156159e-05, 0.657627288681043332199222748162e-07,
        0.146973093215954679034375821888e-08, 0.181691036255544979555476861323e-10,
        0.109540138892868740297645078918e-12, 0.261737388222337042155132062413e-15,
        0.167293569314615469085022374652e-18, 0.106562631627404278815253271162e-22 } ;

static double xlag18[] = { 0.781691666697054712986747615334e-01,
            0.412490085259129291039101536536e+00, 0.101652017962353968919093686187e+01,
            0.189488850996976091426727831954e+01, 0.305435311320265975115241130719e+01,
            0.450420553888989282633795571455e+01, 0.625672507394911145274209116326e+01,
            0.832782515660563002170470261564e+01, 0.107379900477576093352179033397e+02,
           0.135136562075550898190863812108e+02, 0.166893062819301059378183984163e+02,
           0.203107676262677428561313764553e+02, 0.244406813592837027656442257980e+02,
           0.291682086625796161312980677805e+02, 0.346279270656601721454012429438e+02,
           0.410418167728087581392948614284e+02, 0.488339227160865227486586093290e+02,
           0.590905464359012507037157810181e+02 } ;

static double wlag18[] = { 0.185588603146918805623337752284e+00,
         0.310181766370225293649597595713e+00, 0.267866567148536354820854394783e+00,
         0.152979747468074906553843082053e+00, 0.614349178609616527076780103487e-01,
         0.176872130807729312772600233761e-01, 0.366017976775991779802657207890e-02,
         0.540622787007735323128416319257e-03, 0.561696505121423113817929049294e-04,
        0.401530788370115755858883625279e-05, 0.191466985667567497969210011321e-06,
        0.583609526863159412918086289717e-08, 0.107171126695539012772851317562e-09,
        0.108909871388883385562011298291e-11, 0.538666474837830887608094323164e-14,
        0.104986597803570340877859934846e-16, 0.540539845163105364356554467358e-20,
        0.269165326920102862708377715980e-24 } ;

static double xlag19[] = { 0.741587837572050877131369916024e-01,
            0.391268613319994607337648350299e+00, 0.963957343997958058624879377130e+00,
            0.179617558206832812557725825252e+01, 0.289365138187378399116494713237e+01,
            0.426421553962776647436040018167e+01, 0.591814156164404855815360191408e+01,
            0.786861891533473373105668358176e+01, 0.101324237168152659251627415800e+02,
           0.127308814638423980045092979656e+02, 0.156912783398358885454136069861e+02,
           0.190489932098235501532136429732e+02, 0.228508497608294829323930586693e+02,
           0.271606693274114488789963947149e+02, 0.320691222518622423224362865906e+02,
           0.377129058012196494770647508283e+02, 0.443173627958314961196067736013e+02,
           0.523129024574043831658644222420e+02, 0.628024231535003758413504690673e+02 } ;

static double wlag19[] = { 0.176768474915912502251035479815e+00,
         0.300478143607254379482156807712e+00, 0.267599547038175030772695440648e+00,
         0.159913372135580216785512147895e+00, 0.682493799761491134552355368344e-01,
         0.212393076065443249244062193091e-01, 0.484162735114839596725013121019e-02,
         0.804912747381366766594647138204e-03, 0.965247209315350170843161738801e-04,
        0.820730525805103054408982992869e-05, 0.483056672473077253944806671560e-06,
        0.190499136112328569993615674552e-07, 0.481668463092806155766936380273e-09,
        0.734825883955114437684376840171e-11, 0.620227538757261639893719012423e-13,
        0.254143084301542272371866857954e-15, 0.407886129682571235007187465134e-18,
        0.170775018759383706100412325084e-21, 0.671506464990818995998969111749e-26 } ;

static double xlag20[] = { 0.705398896919887533666890045842e-01,
            0.372126818001611443794241388761e+00, 0.916582102483273564667716277074e+00,
            0.170730653102834388068768966741e+01, 0.274919925530943212964503046049e+01,
            0.404892531385088692237495336913e+01, 0.561517497086161651410453988565e+01,
            0.745901745367106330976886021837e+01, 0.959439286958109677247367273428e+01,
           0.120388025469643163096234092989e+02, 0.148142934426307399785126797100e+02,
           0.179488955205193760173657909926e+02, 0.214787882402850109757351703696e+02,
           0.254517027931869055035186774846e+02, 0.299325546317006120067136561352e+02,
           0.350134342404790000062849359067e+02, 0.408330570567285710620295677078e+02,
           0.476199940473465021399416271529e+02, 0.558107957500638988907507734445e+02,
           0.665244165256157538186403187915e+02 } ;

static double wlag20[] = { 0.168746801851113862149223899689e+00,
         0.291254362006068281716795323812e+00, 0.266686102867001288549520868998e+00,
         0.166002453269506840031469127816e+00, 0.748260646687923705400624639615e-01,
         0.249644173092832210728227383234e-01, 0.620255084457223684744754785395e-02,
         0.114496238647690824203955356969e-02, 0.155741773027811974779809513214e-03,
        0.154014408652249156893806714048e-04, 0.108648636651798235147970004439e-05,
        0.533012090955671475092780244305e-07, 0.175798117905058200357787637840e-08,
        0.372550240251232087262924585338e-10, 0.476752925157819052449488071613e-12,
        0.337284424336243841236506064991e-14, 0.115501433950039883096396247181e-16,
        0.153952214058234355346383319667e-19, 0.528644272556915782880273587683e-23,
        0.165645661249902329590781908529e-27 } ;

static double * xlag[21] = { NULL,NULL,xlag2 ,xlag3 ,xlag4 ,xlag5 ,xlag6 ,
                                       xlag7 ,xlag8 ,xlag9 ,xlag10,
                                xlag11,xlag12,xlag13,xlag14,xlag15,xlag16,
                                       xlag17,xlag18,xlag19,xlag20} ;

static double * wlag[21] = { NULL,NULL,wlag2 ,wlag3 ,wlag4 ,wlag5 ,wlag6 ,
                                       wlag7 ,wlag8 ,wlag9 ,wlag10,
                                wlag11,wlag12,wlag13,wlag14,wlag15,wlag16,
                                       wlag17,wlag18,wlag19,wlag20} ;

/*-------------------------------------------------------------------------------*/

void get_laguerre_table( int n , double ** xx , double ** ww )  /* 12 Mar 2000 */
{
   if( xx == NULL || ww == NULL ) return ;
   if( n < 2 || n > 20  ){ *xx = *ww = NULL ; return ; }

   *xx = xlag[n] ; *ww = wlag[n] ; return ;
}
