% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StEM_mirt.R
\name{StEM_mirt}
\alias{StEM_mirt}
\title{Stochastic EM algorithm for solving multivariate item response theory model}
\usage{
StEM_mirt(response, Q, A0, d0, theta0, sigma0, m = 200, TT = 20,
  max_attempt = 40, tol = 1.5, precision = 0.01, parallel = FALSE)
}
\arguments{
\item{response}{N by J matrix containing 0/1 responses, where N is the number of respondents and J is the number of items.}

\item{Q}{J by K matrix containing 0/1 entries, where J is the number of items and K is the number of latent traits. Each entry indicates whether an item measures a certain latent trait.}

\item{A0}{J by K matrix, the initial value of loading matrix, satisfying the constraints given by Q.}

\item{d0}{Length J vector, the initial value of intercept parameters.}

\item{theta0}{N by K matrix, the initial value of latent traits for each respondent.}

\item{sigma0}{K by K matrix, the initial value of correlations among the latent traits.}

\item{m}{The length of Markov chain window for choosing burn-in size with a default value 200.}

\item{TT}{The batch size with a default value 20.}

\item{max_attempt}{The maximum number of batches before stopping.}

\item{tol}{The tolerance of geweke statistic used for determining burn-in size with a default value 1.5.}

\item{precision}{The precision value for determining the stopping of the algorithm with a default value 1e-2.}

\item{parallel}{Whether or not enable the parallel computing with a default value FALSE.}
}
\value{
The function returns a list with the following components:
\describe{
  \item{A_hat}{The estimated loading matrix.}
  \item{d_hat}{The estimated value of intercept parameters.}
  \item{sigma_hat}{The estimated value of correlation matrix of latent traits.}
  \item{burn_in_T}{The length of burn-in size.}
}
}
\description{
Stochastic EM algorithm for solving multivariate item response theory model
}
\examples{
# run a toy example based on the M2PL model

# load a simulated dataset
attach(data_sim_mirt)

# generate starting values for the algorithm
A0 <- Q
d0 <- rep(0, J)
theta0 <- matrix(rnorm(N*K, 0, 1),N)
sigma0 <- diag(1, K) 

# do the confirmatory MIRT analysis
# to enable multicore processing, set parallel = T
mirt_res <- StEM_mirt(response, Q, A0, d0, theta0, sigma0)

}
\references{
Zhang, S., Chen, Y. and Liu, Y. (2018). An Improved Stochastic EM Algorithm for Large-Scale Full-information Item Factor Analysis. \emph{British Journal of Mathematical and Statistical Psychology}. To appear.
D.C. Liu and J. Nocedal. On the Limited Memory Method for Large Scale Optimization (1989), Mathematical Programming B, 45, 3, pp. 503-528.
}
