% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R
\name{check_assertr_expression}
\alias{check_assertr_expression}
\title{Defensive wrapper to add evaluation error to regular validation errors.}
\usage{
check_assertr_expression(this_call, data, description, error_fun)
}
\arguments{
\item{this_call}{assertion command that is checked for valuation errors.}

\item{data}{A data.frame or tibble to test.}

\item{description}{A character string with description of assertion.}

\item{error_fun}{Function that is called when the validation fails}
}
\value{
validation object with evaluation errors added to the list if occurred.
}
\description{
Defensive wrapper to add evaluation error to regular validation errors.
}
\examples{
\dontrun{
library(fixtuRes)
library(magrittr)
library(assertr)
library(data.validator)

my_mock_generator <- fixtuRes::MockDataGenerator$new("fixtures_config.yml")
my_data_frame <- my_mock_generator$get_data("my_data_frame", 10)

report <- data.validator::data_validation_report()

validate(my_data_frame, name = "Verifying data uniqueness") \%>\%
  validate_if(has_all_names("id", "code", "test"), description = "All columns are there") \%>\%
  validate_if(is.character(test), description = "TEST column is string") \%>\%
  validate_if(is_uniq(id), description = "ID column is unique") \%>\%
  validate_if(!is.na(id) & id != "", description = "ID column is not empty") \%>\%
  validate_if(is.character(code), description = "CODE column is string") \%>\%
  validate_rows(col_concat, is_uniq, code, type, description = "CODE and TYPE is unique") \%>\%
  add_results(report)

print(report)
}
}
\seealso{
validate_if
}
\keyword{internal}
