% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/path.R
\name{set_cmdstan_path}
\alias{set_cmdstan_path}
\alias{cmdstan_path}
\alias{cmdstan_version}
\title{Get or set the file path to the CmdStan installation}
\usage{
set_cmdstan_path(path = NULL)

cmdstan_path()

cmdstan_version(error_on_NA = TRUE)
}
\arguments{
\item{path}{(string) The full file path to the CmdStan installation. If
\code{NULL} (the default) then the path is set to the default path used by
\code{\link[=install_cmdstan]{install_cmdstan()}} if it exists.}

\item{error_on_NA}{(logical) Should an error be thrown if CmdStan is not
found. The default is \code{TRUE}. If \code{FALSE}, \code{cmdstan_version()} returns
\code{NULL}.}
}
\value{
A string. Either the file path to the CmdStan installation or the
CmdStan version number.

CmdStan version string if available. If CmdStan is not found and
\code{error_on_NA} is \code{FALSE}, \code{cmdstan_version()} returns \code{NULL}.
}
\description{
Use the \code{set_cmdstan_path()} function to tell CmdStanR where the
CmdStan installation in located. Once the path has been set,
\code{cmdstan_path()} will return the full path to the CmdStan installation and
\code{cmdstan_version()} will return the CmdStan version number. See \strong{Details}
for how to avoid manually setting the path in each \R session.
}
\details{
Before the package can be used it needs to know where the CmdStan
installation is located. When the package is loaded it tries to help automate
this to avoid having to manually set the path every session:
\itemize{
\item If the \link[=Sys.setenv]{environment variable} \code{"CMDSTAN"} exists at load time
then its value will be automatically set as the default path to CmdStan for
the \R session. If the environment variable \code{"CMDSTAN"} is set, but a valid
CmdStan is not found in the supplied path, the path is treated as a top
folder that contains CmdStan installations. In that case, the CmdStan
installation with the largest version number will be set as the path to
CmdStan for the \R session.
\item If no environment variable is found when loaded but any directory in the
form \code{".cmdstan/cmdstan-[version]"} (e.g., \code{".cmdstan/cmdstan-2.23.0"}),
exists in the user's home directory (\code{Sys.getenv("HOME")}, \emph{not} the current
working directory) then the path to the cmdstan with the largest version
number will be set as the path to CmdStan for the \R session. This is the
same as the default directory that \code{\link[=install_cmdstan]{install_cmdstan()}} would use to install
the latest version of CmdStan.
}

It is always possible to change the path after loading the package using
\code{set_cmdstan_path(path)}.
}
