% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{model-method-format}
\alias{model-method-format}
\alias{format}
\title{Run stanc's auto-formatter on the model code.}
\usage{
format(
  overwrite_file = FALSE,
  canonicalize = FALSE,
  backup = TRUE,
  max_line_length = NULL,
  quiet = FALSE
)
}
\arguments{
\item{overwrite_file}{(logical) Should the formatted code be written back
to the input model file. The default is \code{FALSE}.}

\item{canonicalize}{(list or logical) Defines whether or not the compiler
should 'canonicalize' the Stan model, removing things like deprecated syntax.
Default is \code{FALSE}. If \code{TRUE}, all canonicalizations are run. You can also
supply a list of strings which represent options. In that case the options
are passed to stanc (new in Stan 2.29). See the \href{https://mc-stan.org/docs/stan-users-guide/stanc-pretty-printing.html#canonicalizing}{User's guide section}
for available canonicalization options.}

\item{backup}{(logical) If \code{TRUE}, create stanfile.bak backups before
writing to the file. Disable this option if you're sure you have other
copies of the file or are using a version control system like Git. Defaults
to \code{TRUE}. The value is ignored if \code{overwrite_file = FALSE}.}

\item{max_line_length}{(integer) The maximum length of a line when formatting.
The default is \code{NULL}, which defers to the default line length of stanc.}

\item{quiet}{(logical) Should informational messages be suppressed? The
default is \code{FALSE}.}
}
\value{
The \verb{$format()} method returns \code{TRUE} (invisibly) if the model
is valid.
}
\description{
The \verb{$format()} method of a \code{\link{CmdStanModel}} object
runs stanc's auto-formatter on the model code. Either saves the formatted
model directly back to the file or prints it for inspection.
}
\examples{
\dontrun{

# Example of fixing old syntax
# real x[2] --> array[2] real x;
file <- write_stan_file("
parameters {
  real x[2];
}
model {
  x ~ std_normal();
}
")

# set compile=FALSE then call format to fix old syntax
mod <- cmdstan_model(file, compile = FALSE)
mod$format(canonicalize = list("deprecations"))

# overwrite the original file instead of just printing it
mod$format(canonicalize = list("deprecations"), overwrite_file = TRUE)
mod$compile()


# Example of removing unnecessary whitespace
file <- write_stan_file("
data {
  int N;
  array[N] int y;
}
parameters {
  real                     lambda;
}
model {
  target +=
 poisson_lpmf(y | lambda);
}
")
mod <- cmdstan_model(file, compile = FALSE)
mod$format(canonicalize = TRUE)
}

}
\seealso{
The CmdStanR website
(\href{https://mc-stan.org/cmdstanr/}{mc-stan.org/cmdstanr}) for online
documentation and tutorials.

The Stan and CmdStan documentation:
\itemize{
\item Stan documentation: \href{https://mc-stan.org/users/documentation/}{mc-stan.org/users/documentation}
\item CmdStan User’s Guide: \href{https://mc-stan.org/docs/cmdstan-guide/}{mc-stan.org/docs/cmdstan-guide}
}

Other CmdStanModel methods: 
\code{\link{model-method-check_syntax}},
\code{\link{model-method-compile}},
\code{\link{model-method-diagnose}},
\code{\link{model-method-expose_functions}},
\code{\link{model-method-generate-quantities}},
\code{\link{model-method-laplace}},
\code{\link{model-method-optimize}},
\code{\link{model-method-pathfinder}},
\code{\link{model-method-sample}},
\code{\link{model-method-sample_mpi}},
\code{\link{model-method-variables}},
\code{\link{model-method-variational}}
}
\concept{CmdStanModel methods}
