% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.R
\name{fit-method-time}
\alias{fit-method-time}
\alias{time}
\title{Report timing of CmdStan runs}
\usage{
time()
}
\value{
A list with elements
\itemize{
\item \code{total}: (scalar) The total run time. For MCMC this may be different than
the sum of the chain run times if parallelization was used.
\item \code{chains}: (data frame) For MCMC only, timing info for the individual
chains. The data frame has columns \code{"chain_id"}, \code{"warmup"}, \code{"sampling"},
and \code{"total"}.
}
}
\description{
Report the run time in seconds. For MCMC additional information
is provided about the run times of individual chains and the warmup and
sampling phases. For Laplace approximation the time only include the time
for drawing the approximate sample and does not include the time
taken to run the \verb{$optimize()} method.
}
\examples{
\dontrun{
fit_mcmc <- cmdstanr_example("logistic", method = "sample")
fit_mcmc$time()

fit_vb <- cmdstanr_example("logistic", method = "variational")
fit_vb$time()

fit_mle <- cmdstanr_example("logistic", method = "optimize", jacobian = TRUE)
fit_mle$time()

# use fit_mle to draw samples from laplace approximation
fit_laplace <- cmdstanr_example("logistic", method = "laplace", mode = fit_mle)
fit_laplace$time() # just time for drawing sample not for running optimize
fit_laplace$time()$total + fit_mle$time()$total # total time
}

}
\seealso{
\code{\link{CmdStanMCMC}}, \code{\link{CmdStanMLE}}, \code{\link{CmdStanVB}}, \code{\link{CmdStanGQ}}
}
