% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.R
\name{fit-method-profiles}
\alias{fit-method-profiles}
\alias{profiles}
\title{Return profiling data}
\usage{
profiles()
}
\value{
A list of data frames with profiling data if the profiling CSV files
were created.
}
\description{
The \verb{$profiles()} method returns a list of data frames with
profiling data if any profiling data was written to the profile CSV files.
See \code{\link[=save_profile_files]{save_profile_files()}} to control where the files are saved.

Support for profiling Stan programs is available with CmdStan >= 2.26 and
requires adding profiling statements to the Stan program.
}
\examples{

\dontrun{
# first fit a model using MCMC
mcmc_program <- write_stan_file(
  'data {
    int<lower=0> N;
    array[N] int<lower=0,upper=1> y;
  }
  parameters {
    real<lower=0,upper=1> theta;
  }
  model {
    profile("likelihood") {
      y ~ bernoulli(theta);
    }
  }
  generated quantities {
    array[N] int y_rep;
    profile("gq") {
      y_rep = bernoulli_rng(rep_vector(theta, N));
    }
  }
'
)
mod_mcmc <- cmdstan_model(mcmc_program)

data <- list(N = 10, y = c(1,1,0,0,0,1,0,1,0,0))
fit <- mod_mcmc$sample(data = data, seed = 123, refresh = 0)

fit$profiles()
}

}
\seealso{
\code{\link{CmdStanMCMC}}, \code{\link{CmdStanMLE}}, \code{\link{CmdStanVB}}, \code{\link{CmdStanGQ}}
}
