% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/censored-package.R
\docType{package}
\name{censored-package}
\alias{censored}
\alias{censored-package}
\title{censored: parsnip Engines for Survival Models}
\description{
censored provides engines for survival models from the parsnip package.
The models include parametric survival models, proportional hazards models,
decision trees, boosted trees, bagged trees, and random forests. See the
"Fitting and Predicting with censored" article for various examples. See
below for examples of classic survival models and how to fit them with
censored.
}
\examples{
# Accelerated Failure Time (AFT) model

fit_aft <- survival_reg(dist = "weibull") \%>\%
  set_engine("survival") \%>\%
  fit(Surv(time, status) ~ age + sex + ph.karno, data = lung)
predict(fit_aft, lung[1:3, ], type = "time")


# Cox's Proportional Hazards model

fit_cox <- proportional_hazards() \%>\%
  set_engine("survival") \%>\%
  fit(Surv(time, status) ~ age + sex + ph.karno, data = lung)
predict(fit_cox, lung[1:3, ], type = "time")


# Andersen-Gill model for recurring events

fit_ag <- proportional_hazards() \%>\%
  set_engine("survival") \%>\%
  fit(Surv(tstart, tstop, status) ~ treat + inherit + age + strata(hos.cat),
    data = cgd
  )
predict(fit_ag, cgd[1:3, ], type = "time")

}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/tidymodels/censored}
  \item \url{https://censored.tidymodels.org}
  \item Report bugs at \url{https://github.com/tidymodels/censored/issues}
}

}
\author{
\strong{Maintainer}: Hannah Frick \email{hannah@posit.co} (\href{https://orcid.org/0000-0002-6049-5258}{ORCID})

Authors:
\itemize{
  \item Emil Hvitfeldt \email{emil.hvitfeldt@posit.co} (\href{https://orcid.org/0000-0002-0679-1945}{ORCID})
}

Other contributors:
\itemize{
  \item Posit Software, PBC [copyright holder, funder]
}

}
