% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funcs.R
\name{boot.proportions}
\alias{boot.proportions}
\title{Heatmap of the proportion of bootstrap replicates where objects cluster together}
\usage{
boot.proportions(
  x,
  col = grDevices::heat.colors(101, rev = TRUE),
  show.vals = F,
  text.col = "black",
  cluster.col = "firebrick",
  ...
)
}
\arguments{
\item{x}{an object of class clusboot}

\item{col}{vector of colours for shading to indicate proportion values}

\item{show.vals}{logical value indicating whether proportion values should be added to individual cells}

\item{text.col}{colour of text for show.vals if \code{TRUE}}

\item{cluster.col}{colour of lines demarcating cluster membership}

\item{...}{more arguments to be passed to \code{plot()}}
}
\description{
Heatmap of the proportion of bootstrap replicates where objects cluster together
}
\examples{
out <- clusboot (scale(case.study.psychiatrist), B=100, k=6, clustering.func=complete.linkage)
boot.proportions(out)
}
