/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.markdown.core.block;

import org.eclipse.mylyn.internal.wikitext.markdown.core.block.NestableBlock;
import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.markup.Block;

public class ParagraphBlock
extends NestableBlock {
    private int blockLineCount = 0;

    public boolean canStart(String line, int lineOffset) {
        this.blockLineCount = 0;
        return true;
    }

    protected int processLineContent(String line, int offset) {
        if (this.blockLineCount == 0) {
            this.builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, new Attributes());
        }
        if (this.markupLanguage.isEmptyLine(line.substring(offset))) {
            this.setClosed(true);
            return offset;
        }
        for (Block block : this.markupLanguage.getParagraphBreakingBlocks()) {
            if (!block.canStart(line, offset)) continue;
            this.setClosed(true);
            return offset;
        }
        if (this.blockLineCount > 0) {
            this.builder.characters("\n");
        }
        this.getMarkupLanguage().emitMarkupLine(this.getParser(), this.state, line, offset);
        ++this.blockLineCount;
        return -1;
    }

    public void setClosed(boolean closed) {
        if (closed && !this.isClosed()) {
            this.builder.endBlock();
        }
        super.setClosed(closed);
    }
}

