/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jpa.verification.rules.entity;

import com.sun.source.tree.Tree;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.lang.model.element.TypeElement;
import org.netbeans.modules.j2ee.jpa.model.AccessType;
import org.netbeans.modules.j2ee.jpa.model.AttributeWrapper;
import org.netbeans.modules.j2ee.jpa.model.ModelUtils;
import org.netbeans.modules.j2ee.jpa.verification.JPAEntityAttributeCheck;
import org.netbeans.modules.j2ee.jpa.verification.JPAProblemContext;
import org.netbeans.modules.j2ee.jpa.verification.JPAProblemFinder;
import org.netbeans.modules.j2ee.jpa.verification.rules.attribute.GeneratedValueIsId;
import org.netbeans.modules.j2ee.jpa.verification.rules.attribute.MVRelationshipForEntityTypeAttrDefined;
import org.netbeans.modules.j2ee.jpa.verification.rules.attribute.RelationshipForEntityTypeAttrDefined;
import org.netbeans.modules.j2ee.jpa.verification.rules.attribute.TemporalFieldsAnnotated;
import org.netbeans.modules.j2ee.jpa.verification.rules.attribute.ValidBasicType;
import org.netbeans.modules.j2ee.jpa.verification.rules.attribute.ValidColumnName;
import org.netbeans.modules.j2ee.jpa.verification.rules.attribute.ValidModifiers;
import org.netbeans.modules.j2ee.jpa.verification.rules.attribute.ValidVersionType;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Basic;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Embeddable;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Entity;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.EntityMappingsMetadata;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Id;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.MappedSuperclass;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Version;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.java.hints.HintContext;

public class ValidAttributes {
    private static JPAEntityAttributeCheck[] attribChecks = new JPAEntityAttributeCheck[]{new ValidColumnName(), new ValidModifiers(), new ValidBasicType(), new RelationshipForEntityTypeAttrDefined(), new MVRelationshipForEntityTypeAttrDefined(), new ValidVersionType(), new GeneratedValueIsId(), new TemporalFieldsAnnotated()};

    public static Collection<ErrorDescription> apply(HintContext hc) {
        if (hc.isCanceled() || hc.getPath().getLeaf().getKind() != Tree.Kind.IDENTIFIER || hc.getPath().getParentPath().getLeaf().getKind() != Tree.Kind.ANNOTATION) {
            return null;
        }
        final JPAProblemContext ctx = ModelUtils.getOrCreateCachedContext(hc);
        if (ctx == null || hc.isCanceled()) {
            return null;
        }
        TypeElement subject = ctx.getJavaClass();
        ArrayList<ErrorDescription> problemsFound = new ArrayList<ErrorDescription>();
        final ArrayList attrs = new ArrayList();
        try {
            MetadataModel<EntityMappingsMetadata> model = ModelUtils.getModel(hc.getInfo().getFileObject());
            model.runReadAction((MetadataModelAction)new MetadataModelAction<EntityMappingsMetadata, Void>(){

                public Void run(EntityMappingsMetadata metadata) {
                    Basic[] basicFields = null;
                    Id[] idFields = null;
                    Version[] versionFields = null;
                    if (ctx.getModelElement() instanceof Entity) {
                        Entity entity = (Entity)ctx.getModelElement();
                        basicFields = entity.getAttributes().getBasic();
                        idFields = entity.getAttributes().getId();
                        versionFields = entity.getAttributes().getVersion();
                    } else if (ctx.getModelElement() instanceof Embeddable) {
                        Embeddable embeddable = (Embeddable)ctx.getModelElement();
                        basicFields = embeddable.getAttributes().getBasic();
                    } else if (ctx.getModelElement() instanceof MappedSuperclass) {
                        MappedSuperclass mappedSuperclass = (MappedSuperclass)ctx.getModelElement();
                        basicFields = mappedSuperclass.getAttributes().getBasic();
                        idFields = mappedSuperclass.getAttributes().getId();
                        versionFields = mappedSuperclass.getAttributes().getVersion();
                    }
                    if (basicFields != null) {
                        for (Basic basic : basicFields) {
                            attrs.add(new AttributeWrapper(basic));
                        }
                    }
                    if (idFields != null) {
                        for (Basic basic : idFields) {
                            attrs.add(new AttributeWrapper(basic));
                        }
                    }
                    if (versionFields != null) {
                        for (Basic basic : versionFields) {
                            attrs.add(new AttributeWrapper(basic));
                        }
                    }
                    return null;
                }
            });
        }
        catch (IOException model) {
            // empty catch block
        }
        JPAProblemContext jpaCtx = ctx;
        if (jpaCtx.getAccessType() == AccessType.INCONSISTENT) {
            JPAProblemFinder.LOG.fine("Skipping attribute checks due to inconsistent access type");
        } else {
            for (AttributeWrapper attr : attrs) {
                ModelUtils.resolveJavaElementFromModel(jpaCtx, attr);
                if (attr.getJavaElement() == null) {
                    JPAProblemFinder.LOG.severe("Failed to resolve java model element for JPA merged model element " + subject.getSimpleName() + "." + attr.getName());
                    continue;
                }
                for (JPAEntityAttributeCheck check : attribChecks) {
                    Collection<ErrorDescription> attrProblems = check.check(jpaCtx, hc, attr);
                    if (attrProblems == null) continue;
                    problemsFound.addAll(attrProblems);
                }
            }
        }
        return problemsFound;
    }
}

