/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.php.api.editor.PhpBaseElement;
import org.netbeans.modules.php.api.editor.PhpType;
import org.netbeans.modules.php.api.editor.PhpVariable;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.editor.Cache;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.NavUtils;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.api.elements.ParameterElement;
import org.netbeans.modules.php.editor.api.elements.PhpElement;
import org.netbeans.modules.php.editor.api.elements.TypeResolver;
import org.netbeans.modules.php.editor.elements.TypeResolverImpl;
import org.netbeans.modules.php.editor.elements.VariableElementImpl;
import org.netbeans.modules.php.editor.model.ArrowFunctionScope;
import org.netbeans.modules.php.editor.model.ClassScope;
import org.netbeans.modules.php.editor.model.CodeMarker;
import org.netbeans.modules.php.editor.model.ConstantElement;
import org.netbeans.modules.php.editor.model.FileScope;
import org.netbeans.modules.php.editor.model.FunctionScope;
import org.netbeans.modules.php.editor.model.IndexScope;
import org.netbeans.modules.php.editor.model.MethodScope;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.NamespaceScope;
import org.netbeans.modules.php.editor.model.Occurence;
import org.netbeans.modules.php.editor.model.Scope;
import org.netbeans.modules.php.editor.model.TraitScope;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.model.VariableName;
import org.netbeans.modules.php.editor.model.VariableScope;
import org.netbeans.modules.php.editor.model.VariableScopeFinder;
import org.netbeans.modules.php.editor.model.impl.AssignmentImpl;
import org.netbeans.modules.php.editor.model.impl.ClassScopeImpl;
import org.netbeans.modules.php.editor.model.impl.CodeMarkerBuilder;
import org.netbeans.modules.php.editor.model.impl.ConstantElementImpl;
import org.netbeans.modules.php.editor.model.impl.FieldElementImpl;
import org.netbeans.modules.php.editor.model.impl.FileScopeImpl;
import org.netbeans.modules.php.editor.model.impl.FunctionScopeImpl;
import org.netbeans.modules.php.editor.model.impl.IndexScopeImpl;
import org.netbeans.modules.php.editor.model.impl.MethodScopeImpl;
import org.netbeans.modules.php.editor.model.impl.ModelBuilder;
import org.netbeans.modules.php.editor.model.impl.NamespaceScopeImpl;
import org.netbeans.modules.php.editor.model.impl.OccurenceBuilder;
import org.netbeans.modules.php.editor.model.impl.ScalarConstantElementImpl;
import org.netbeans.modules.php.editor.model.impl.ScopeImpl;
import org.netbeans.modules.php.editor.model.impl.VarAssignmentImpl;
import org.netbeans.modules.php.editor.model.impl.VariableNameFactory;
import org.netbeans.modules.php.editor.model.impl.VariableNameImpl;
import org.netbeans.modules.php.editor.model.impl.VariousUtils;
import org.netbeans.modules.php.editor.model.nodes.ASTNodeInfo;
import org.netbeans.modules.php.editor.model.nodes.ConstantDeclarationInfo;
import org.netbeans.modules.php.editor.model.nodes.GroupUseStatementPartInfo;
import org.netbeans.modules.php.editor.model.nodes.PhpDocTypeTagInfo;
import org.netbeans.modules.php.editor.model.nodes.SingleUseStatementPartInfo;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.api.Utils;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.ArrayAccess;
import org.netbeans.modules.php.editor.parser.astnodes.ArrayCreation;
import org.netbeans.modules.php.editor.parser.astnodes.ArrayElement;
import org.netbeans.modules.php.editor.parser.astnodes.ArrowFunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Assignment;
import org.netbeans.modules.php.editor.parser.astnodes.AttributeDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Block;
import org.netbeans.modules.php.editor.parser.astnodes.CaseDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.CatchClause;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassInstanceCreation;
import org.netbeans.modules.php.editor.parser.astnodes.ClassName;
import org.netbeans.modules.php.editor.parser.astnodes.Comment;
import org.netbeans.modules.php.editor.parser.astnodes.ConstantDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.DoStatement;
import org.netbeans.modules.php.editor.parser.astnodes.EnumDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.ExpressionArrayAccess;
import org.netbeans.modules.php.editor.parser.astnodes.FieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.FieldsDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ForEachStatement;
import org.netbeans.modules.php.editor.parser.astnodes.ForStatement;
import org.netbeans.modules.php.editor.parser.astnodes.FormalParameter;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionName;
import org.netbeans.modules.php.editor.parser.astnodes.GlobalStatement;
import org.netbeans.modules.php.editor.parser.astnodes.GotoLabel;
import org.netbeans.modules.php.editor.parser.astnodes.GotoStatement;
import org.netbeans.modules.php.editor.parser.astnodes.GroupUseStatementPart;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.IfStatement;
import org.netbeans.modules.php.editor.parser.astnodes.Include;
import org.netbeans.modules.php.editor.parser.astnodes.InstanceOfExpression;
import org.netbeans.modules.php.editor.parser.astnodes.InterfaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.IntersectionType;
import org.netbeans.modules.php.editor.parser.astnodes.LambdaFunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.MethodDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.MethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceName;
import org.netbeans.modules.php.editor.parser.astnodes.NullableType;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocBlock;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocMethodTag;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTag;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTypeTag;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocVarTypeTag;
import org.netbeans.modules.php.editor.parser.astnodes.PHPVarComment;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.editor.parser.astnodes.Reference;
import org.netbeans.modules.php.editor.parser.astnodes.ReflectionVariable;
import org.netbeans.modules.php.editor.parser.astnodes.ReturnStatement;
import org.netbeans.modules.php.editor.parser.astnodes.Scalar;
import org.netbeans.modules.php.editor.parser.astnodes.SingleFieldDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.SingleUseStatementPart;
import org.netbeans.modules.php.editor.parser.astnodes.StaticConstantAccess;
import org.netbeans.modules.php.editor.parser.astnodes.StaticFieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.StaticMethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.SwitchStatement;
import org.netbeans.modules.php.editor.parser.astnodes.TraitConflictResolutionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.TraitDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.TraitMethodAliasDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.TryStatement;
import org.netbeans.modules.php.editor.parser.astnodes.UnionType;
import org.netbeans.modules.php.editor.parser.astnodes.UseStatement;
import org.netbeans.modules.php.editor.parser.astnodes.UseTraitStatementPart;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.php.editor.parser.astnodes.VariableBase;
import org.netbeans.modules.php.editor.parser.astnodes.Variadic;
import org.netbeans.modules.php.editor.parser.astnodes.WhileStatement;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultTreePathVisitor;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.php.project.api.PhpEditorExtender;
import org.netbeans.modules.php.spi.annotation.AnnotationParsedLine;
import org.netbeans.modules.php.spi.editor.EditorExtender;
import org.openide.filesystems.FileObject;
import org.openide.util.Parameters;

public final class ModelVisitor
extends DefaultTreePathVisitor {
    private final FileScopeImpl fileScope;
    private IndexScope indexScope;
    private Map<Scope, Map<String, VariableNameImpl>> vars;
    private final Map<String, List<PhpDocTypeTagInfo>> varTypeComments;
    private volatile OccurenceBuilder occurencesBuilder;
    private volatile CodeMarkerBuilder markerBuilder;
    private final ModelBuilder modelBuilder;
    private final PHPParseResult info;
    private boolean askForEditorExtensions = true;
    private final Object lock = new Object();
    private final List<PhpBaseElement> baseElements;
    private final Cache<Scope, Map<String, AssignmentImpl>> assignmentMapCache = new Cache();
    private boolean lazyScan = true;
    private volatile Scope previousScope;
    private volatile List<String> currentLexicalVariables = new LinkedList<String>();
    private volatile boolean isReturnType = false;
    private volatile boolean isLexicalVariable = false;
    private static final Set<String> recursionDetection = new HashSet<String>();

    public ModelVisitor(PHPParseResult info) {
        this.fileScope = new FileScopeImpl(info);
        this.varTypeComments = new HashMap<String, List<PhpDocTypeTagInfo>>();
        this.occurencesBuilder = new OccurenceBuilder();
        this.markerBuilder = new CodeMarkerBuilder();
        this.modelBuilder = new ModelBuilder(this.fileScope);
        this.info = info;
        this.baseElements = new ArrayList<PhpBaseElement>();
    }

    public ParserResult getCompilationInfo() {
        return this.info;
    }

    @Override
    public void scan(ASTNode node) {
        super.scan(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PhpBaseElement> extendedElements() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.askForEditorExtensions) {
                return new ArrayList<PhpBaseElement>(this.baseElements);
            }
            this.askForEditorExtensions = false;
        }
        this.baseElements.clear();
        FileObject fileObject = this.fileScope.getFileObject();
        EditorExtender editorExtender = PhpEditorExtender.forFileObject((FileObject)fileObject);
        List elements = editorExtender.getElementsForCodeCompletion(fileObject);
        this.baseElements.addAll(elements);
        if (elements.size() > 0) {
            for (PhpBaseElement element : elements) {
                if (!(element instanceof PhpVariable)) continue;
                PhpVariable phpVariable = (PhpVariable)element;
                Collection<? extends NamespaceScope> declaredNamespaces = this.fileScope.getDeclaredNamespaces();
                for (NamespaceScope namespaceScope : declaredNamespaces) {
                    NamespaceScopeImpl namespaceScope2 = (NamespaceScopeImpl)namespaceScope;
                    if (namespaceScope2 == null) continue;
                    String varName = phpVariable.getName();
                    VariableNameImpl variable = this.findVariable((Scope)namespaceScope, varName);
                    PhpType type = phpVariable.getType();
                    if (variable != null) {
                        variable.indexedElement = VariableElementImpl.create(varName, phpVariable.getOffset(), phpVariable.getFile(), null, type != null ? TypeResolverImpl.parseTypes(type.getFullyQualifiedName()) : Collections.emptySet(), false);
                        continue;
                    }
                    int offset = namespaceScope2.getOffset();
                    VariableElementImpl var = VariableElementImpl.create(varName, offset, phpVariable.getFile(), null, type != null ? TypeResolverImpl.parseTypes(type.getFullyQualifiedName()) : Collections.emptySet(), false);
                    namespaceScope2.createElement(var);
                }
            }
        }
        return new ArrayList<PhpBaseElement>(this.baseElements);
    }

    @Override
    public void visit(PHPDocMethodTag node) {
        MethodScope methodScope;
        AnnotationParsedLine kind = node.getKind();
        Scope currentScope = this.modelBuilder.getCurrentScope();
        boolean scopeHasBeenModified = false;
        if (currentScope instanceof MethodScope) {
            methodScope = (MethodScope)currentScope;
            currentScope = methodScope.getInScope();
            this.modelBuilder.setCurrentScope((ScopeImpl)currentScope);
            scopeHasBeenModified = true;
        }
        if (currentScope instanceof TypeScope && kind.equals((Object)PHPDocTag.Type.METHOD)) {
            this.modelBuilder.buildMagicMethod(node, this.occurencesBuilder);
            this.occurencesBuilder.prepare(node, currentScope);
        }
        if (scopeHasBeenModified) {
            this.modelBuilder.reset();
        }
        if (currentScope instanceof TypeScope) {
            methodScope = MethodScopeImpl.createElement(currentScope, node);
            this.modelBuilder.setCurrentScope((ScopeImpl)((Object)methodScope));
        } else {
            this.modelBuilder.setCurrentScope((ScopeImpl)currentScope);
        }
        super.visit(node);
        this.modelBuilder.reset();
    }

    @Override
    public void visit(ReturnStatement node) {
        super.visit(node);
        ScopeImpl currentScope = this.modelBuilder.getCurrentScope();
        this.markerBuilder.prepare(node, (Scope)currentScope);
        String typeName = null;
        if (currentScope instanceof FunctionScope) {
            FunctionScopeImpl functionScope = (FunctionScopeImpl)currentScope;
            Expression expression = node.getExpression();
            if (expression instanceof ClassInstanceCreation) {
                ClassInstanceCreation instanceCreation = (ClassInstanceCreation)expression;
                ASTNodeInfo<ClassInstanceCreation> inf = ASTNodeInfo.create(instanceCreation);
                String pureTypeName = inf.getQualifiedName().toString();
                typeName = VariousUtils.qualifyTypeNames(pureTypeName, node.getStartOffset(), currentScope);
            } else if (expression instanceof VariableBase) {
                typeName = VariousUtils.extractTypeFroVariableBase((VariableBase)expression);
                if (typeName != null) {
                    if (typeName.equals("@var-type:$this")) {
                        typeName = "\\this";
                    } else {
                        Collection<? extends VariableName> allVariables = VariousUtils.getAllVariables(functionScope, typeName);
                        HashMap<String, String> var2Type = new HashMap<String, String>();
                        for (VariableName variableName : allVariables) {
                            String name = variableName.getName();
                            String type = this.resolveVariableType(name, functionScope, node);
                            String qualifiedType = VariousUtils.qualifyTypeNames(type, node.getStartOffset(), currentScope);
                            var2Type.put(name, qualifiedType);
                        }
                        if (!var2Type.isEmpty()) {
                            typeName = VariousUtils.replaceVarNames(typeName, var2Type);
                        }
                    }
                }
            } else if (expression instanceof Scalar || expression instanceof ArrayCreation) {
                typeName = VariousUtils.extractVariableTypeFromExpression(expression, null);
            }
            if (!StringUtils.isEmpty((String)typeName)) {
                functionScope.addReturnType(QualifiedName.create(typeName).toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    private String resolveVariableType(String varName, FunctionScopeImpl varScope, ReturnStatement node) {
        try {
            if (varName != null && recursionDetection.add(varName)) {
                String typeName;
                AssignmentImpl assignment;
                if (varName.equalsIgnoreCase("$this") && varScope instanceof MethodScope) {
                    String string = varScope.getInScope().getName();
                    return string;
                }
                VariableNameImpl var = (VariableNameImpl)ModelUtils.getFirst(varScope.getDeclaredVariables(), varName);
                if (var != null && (assignment = var.findVarAssignment(node.getStartOffset())) != null && (typeName = assignment.typeNameFromUnion()) != null) {
                    if (!VariousUtils.isSemiType(typeName)) {
                        String string = typeName;
                        return string;
                    }
                    String variableName = ModelVisitor.getName(typeName, VariousUtils.Kind.VAR, true);
                    if (variableName != null && !variableName.equalsIgnoreCase(varName)) {
                        String string = this.resolveVariableType(variableName, varScope, node);
                        return string;
                    }
                    String string = typeName;
                    return string;
                }
            }
        }
        finally {
            if (varName != null) {
                recursionDetection.remove(varName);
            }
        }
        return null;
    }

    public static String getName(String semiType, VariousUtils.Kind kind, boolean strict) {
        String[] split;
        String prefix;
        if (semiType != null && semiType.startsWith(prefix = "@" + kind.toString()) && (split = semiType.split(prefix, 2)).length > 1) {
            if (VariousUtils.isSemiType(split[1])) {
                if (strict) {
                    return null;
                }
                if ((split = split[1].split("@")).length < 1) {
                    return null;
                }
                return split[0];
            }
            return split[1];
        }
        return null;
    }

    @Override
    public void visit(GotoLabel label) {
        super.visit(label);
        this.occurencesBuilder.prepare(label, this.modelBuilder.getCurrentScope());
    }

    @Override
    public void visit(GotoStatement statement) {
        super.visit(statement);
        this.occurencesBuilder.prepare(statement, this.modelBuilder.getCurrentScope());
    }

    @Override
    public void visit(Program program) {
        this.lazyScan = true;
        this.modelBuilder.setProgram(program);
        this.fileScope.setBlockRange(program);
        this.vars = new HashMap<Scope, Map<String, VariableNameImpl>>();
        this.prepareVarComments(program);
        super.visit(program);
        this.handleVarComments();
    }

    @Override
    public void visit(Include node) {
        this.modelBuilder.build(node, this.occurencesBuilder);
        super.visit(node);
    }

    @Override
    public void visit(NamespaceDeclaration node) {
        this.modelBuilder.build(node, this.occurencesBuilder);
        try {
            super.visit(node);
        }
        finally {
            this.modelBuilder.reset();
        }
    }

    @Override
    public void visit(NamespaceName namespaceName) {
        super.visit(namespaceName);
        ASTNode parent = this.getPath().get(0);
        if (parent instanceof FunctionName) {
            this.occurencesBuilder.prepare(ASTNodeInfo.Kind.FUNCTION, (Expression)namespaceName, (Scope)this.fileScope);
        } else if (parent instanceof Program || parent instanceof Block || this.isReturnType) {
            ASTNodeInfo.Kind[] kinds = new ASTNodeInfo.Kind[]{ASTNodeInfo.Kind.CLASS, ASTNodeInfo.Kind.IFACE};
            this.occurencesBuilder.prepare(kinds, namespaceName, (Scope)this.modelBuilder.getCurrentScope());
        } else if (parent instanceof ConstantDeclaration || parent instanceof FieldsDeclaration) {
            if (!this.isDeclaredType(parent, namespaceName)) {
                this.occurencesBuilder.prepare(ASTNodeInfo.Kind.CONSTANT, (Expression)namespaceName, (Scope)this.fileScope);
                return;
            }
        } else if (parent instanceof ClassInstanceCreation) {
            if (((ClassInstanceCreation)parent).isAnonymous()) {
                ASTNodeInfo.Kind[] kinds = new ASTNodeInfo.Kind[]{ASTNodeInfo.Kind.CLASS, ASTNodeInfo.Kind.IFACE};
                this.occurencesBuilder.prepare(kinds, namespaceName, (Scope)this.fileScope);
            }
        } else if (parent instanceof AttributeDeclaration) {
            AttributeDeclaration attributeDeclaration = (AttributeDeclaration)parent;
            List<Expression> parameters = attributeDeclaration.getParameters();
            if (attributeDeclaration.getAttributeName() != namespaceName && parameters != null && !parameters.isEmpty()) {
                AttributeParametersVisitor attributeParametersVisitor = new AttributeParametersVisitor();
                attributeParametersVisitor.scan(parameters);
                if (attributeParametersVisitor.isGlobalConstant(namespaceName)) {
                    this.occurencesBuilder.prepare(ASTNodeInfo.Kind.CONSTANT, (Expression)namespaceName, (Scope)this.fileScope);
                }
            }
        } else if (!(parent instanceof ClassDeclaration || parent instanceof EnumDeclaration || parent instanceof InterfaceDeclaration || parent instanceof FormalParameter || parent instanceof InstanceOfExpression || parent instanceof UseTraitStatementPart || parent instanceof TraitConflictResolutionDeclaration || parent instanceof TraitMethodAliasDeclaration || parent instanceof IntersectionType)) {
            this.occurencesBuilder.prepare(ASTNodeInfo.Kind.CONSTANT, (Expression)namespaceName, (Scope)this.fileScope);
        }
        if (!(parent instanceof FunctionName)) {
            this.occurencesBuilder.prepare(namespaceName, (Scope)this.modelBuilder.getCurrentScope());
        }
    }

    private boolean isDeclaredType(ASTNode node, NamespaceName namespaceName) {
        boolean isDeclaredType = false;
        Expression declaredType = null;
        if (node instanceof ConstantDeclaration) {
            ConstantDeclaration constantDeclaration = (ConstantDeclaration)node;
            declaredType = constantDeclaration.getConstType();
        } else if (node instanceof FieldsDeclaration) {
            FieldsDeclaration fieldsDeclaration = (FieldsDeclaration)node;
            declaredType = fieldsDeclaration.getFieldType();
        }
        if (declaredType != null && declaredType.getStartOffset() <= namespaceName.getStartOffset() && namespaceName.getStartOffset() <= declaredType.getEndOffset()) {
            isDeclaredType = true;
        }
        return isDeclaredType;
    }

    @Override
    public void visit(SingleUseStatementPart statementPart) {
        ASTNode parent = this.getPath().get(0);
        if (!(parent instanceof UseStatement)) {
            return;
        }
        UseStatement.Type type = ((UseStatement)parent).getType();
        SingleUseStatementPartInfo useStatementPartInfo = SingleUseStatementPartInfo.create(statementPart, type);
        this.modelBuilder.getCurrentNameSpace().createUseStatementPart(useStatementPartInfo);
        this.processSingleUseStatement(type, null, statementPart);
    }

    @Override
    public void visit(GroupUseStatementPart statementPart) {
        UseStatement.Type type = ((UseStatement)this.getPath().get(0)).getType();
        GroupUseStatementPartInfo useStatementPartInfo = GroupUseStatementPartInfo.create(statementPart, type);
        this.modelBuilder.getCurrentNameSpace().createUseStatementPart(useStatementPartInfo);
        for (SingleUseStatementPart part : statementPart.getItems()) {
            this.processSingleUseStatement(type, statementPart, part);
        }
    }

    @Override
    public void visit(UseTraitStatementPart node) {
        this.occurencesBuilder.prepare(ASTNodeInfo.Kind.TRAIT, (Expression)node.getName(), (Scope)this.modelBuilder.getCurrentScope());
        super.visit(node);
    }

    @Override
    public void visit(TraitMethodAliasDeclaration node) {
        Expression traitName = node.getTraitName();
        if (traitName instanceof NamespaceName) {
            this.occurencesBuilder.prepare(ASTNodeInfo.Kind.TRAIT, traitName, (Scope)this.modelBuilder.getCurrentScope());
        }
        super.visit(node);
    }

    @Override
    public void visit(TraitConflictResolutionDeclaration node) {
        ScopeImpl currentScope = this.modelBuilder.getCurrentScope();
        Expression preferredTraitName = node.getPreferredTraitName();
        if (preferredTraitName instanceof NamespaceName) {
            this.occurencesBuilder.prepare(ASTNodeInfo.Kind.TRAIT, preferredTraitName, (Scope)currentScope);
        }
        for (Expression suppressedTraitName : node.getSuppressedTraitNames()) {
            if (!(suppressedTraitName instanceof NamespaceName)) continue;
            this.occurencesBuilder.prepare(ASTNodeInfo.Kind.TRAIT, suppressedTraitName, (Scope)currentScope);
        }
        super.visit(node);
    }

    @Override
    public void visit(ClassDeclaration node) {
        this.modelBuilder.build(node, this.occurencesBuilder);
        this.checkComments(node);
        try {
            super.visit(node);
        }
        finally {
            this.modelBuilder.reset();
        }
    }

    @Override
    public void visit(TraitDeclaration node) {
        this.modelBuilder.build(node, this.occurencesBuilder);
        this.checkComments(node);
        try {
            super.visit(node);
        }
        finally {
            this.modelBuilder.reset();
        }
    }

    @Override
    public void visit(InterfaceDeclaration node) {
        this.modelBuilder.build(node, this.occurencesBuilder);
        try {
            super.visit(node);
        }
        finally {
            this.modelBuilder.reset();
        }
    }

    @Override
    public void visit(EnumDeclaration node) {
        this.modelBuilder.build(node, this.occurencesBuilder);
        this.checkComments(node);
        try {
            super.visit(node);
        }
        finally {
            this.modelBuilder.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visit(MethodDeclaration node) {
        if (this.lazyScan) {
            if (CodeUtils.isConstructor(node)) {
                for (FormalParameter formalParameter : node.getFunction().getFormalParameters()) {
                    FieldsDeclaration fieldsDeclaration = FieldsDeclaration.create(formalParameter);
                    if (fieldsDeclaration == null) continue;
                    this.scan(fieldsDeclaration);
                }
            }
            this.modelBuilder.build(node, this.occurencesBuilder, this);
            this.markerBuilder.prepare(node, (Scope)this.modelBuilder.getCurrentScope());
            this.scan(node.getAttributes());
            this.scan(node.getFunction().getReturnType());
            this.checkComments(node);
            Block body = node.getFunction().getBody();
            if (body != null) {
                AnonymousClassesVisitor anonymousClassesVisitor = new AnonymousClassesVisitor();
                anonymousClassesVisitor.visit(body);
                for (ClassInstanceCreation classInstanceCreation : anonymousClassesVisitor.getAnonymousClasses()) {
                    this.scan(classInstanceCreation);
                }
            }
        }
        try {
            if (!this.lazyScan) {
                this.lazyScan = true;
                this.scan(node.getFunction().getFormalParameters());
                this.scan(node.getFunction().getBody());
            }
        }
        finally {
            if (this.lazyScan) {
                this.modelBuilder.reset();
            }
        }
    }

    @Override
    public void visit(FieldsDeclaration node) {
        this.modelBuilder.build(node, this.occurencesBuilder);
        this.checkComments(node);
        super.visit(node);
    }

    @Override
    public void visit(ClassInstanceCreation node) {
        if (node.isAnonymous()) {
            this.modelBuilder.build(node, this.occurencesBuilder);
            this.checkComments(node);
            try {
                super.visit(node);
            }
            finally {
                this.modelBuilder.reset();
            }
        } else {
            Expression name = node.getClassName().getName();
            if (name instanceof Variable || name instanceof StaticFieldAccess || name instanceof FieldAccess) {
                this.scan(name);
            } else {
                ScopeImpl currentScope = this.modelBuilder.getCurrentScope();
                this.occurencesBuilder.prepare(node, (Scope)currentScope);
                if (name instanceof NamespaceName) {
                    this.occurencesBuilder.prepare((NamespaceName)name, (Scope)currentScope);
                }
            }
            this.scan(node.ctorParams());
        }
    }

    @Override
    public void visit(InstanceOfExpression node) {
        ClassName className = node.getClassName();
        Expression expression = node.getExpression();
        if (className.getName() instanceof Variable) {
            this.prepareVariable((Variable)className.getName(), this.modelBuilder.getCurrentScope());
            if (expression instanceof Variable) {
                this.prepareVariable((Variable)expression, this.modelBuilder.getCurrentScope());
            }
        } else {
            String clsName;
            if (className.getName() instanceof NamespaceName) {
                this.occurencesBuilder.prepare((NamespaceName)className.getName(), (Scope)this.modelBuilder.getCurrentScope());
            }
            if ((clsName = CodeUtils.extractClassName(node.getClassName())) != null && expression instanceof Variable) {
                Variable var = (Variable)expression;
                ScopeImpl currentScope = this.modelBuilder.getCurrentScope();
                VariableNameImpl varN = this.findVariable((Scope)currentScope, var);
                if (varN != null) {
                    VarAssignmentImpl varAssignment = varN.createAssignment(currentScope, true, this.getBlockRange(currentScope), ASTNodeInfo.create(var).getRange(), clsName);
                    varN.addElement(varAssignment);
                }
            }
        }
        super.visit(node);
    }

    @Override
    public void visit(MethodInvocation node) {
        FunctionInvocation method = node.getMethod();
        if (method != null) {
            if (this.hasCommonFunctionName(method)) {
                this.occurencesBuilder.prepare(node, (Scope)this.modelBuilder.getCurrentScope());
            } else {
                this.scan(method);
            }
        }
        this.scan(node.getDispatcher());
        this.scan(node.getMethod().getParameters());
    }

    @Override
    public void visit(Scalar scalar) {
        String stringValue = scalar.getStringValue();
        if (stringValue != null && stringValue.trim().length() > 0 && scalar.getScalarType() == Scalar.Type.STRING && !NavUtils.isQuoted(stringValue)) {
            this.occurencesBuilder.prepare(ASTNodeInfo.Kind.CONSTANT, scalar, (Scope)this.fileScope);
        }
        super.visit(scalar);
    }

    @Override
    public void visit(StaticMethodInvocation node) {
        Expression dispatcher;
        ScopeImpl scope = this.modelBuilder.getCurrentScope();
        FunctionInvocation method = node.getMethod();
        if (method != null) {
            if (this.hasCommonFunctionName(method)) {
                this.occurencesBuilder.prepare(node, (Scope)this.modelBuilder.getCurrentScope());
            } else {
                this.scan(method);
            }
        }
        if ((dispatcher = node.getDispatcher()) instanceof NamespaceName) {
            this.occurencesBuilder.prepare((NamespaceName)dispatcher, (Scope)scope);
        } else {
            this.scan(dispatcher);
        }
        this.scan(node.getMethod().getParameters());
    }

    private boolean hasCommonFunctionName(FunctionInvocation functionInvocation) {
        boolean result = false;
        FunctionName functionName = functionInvocation.getFunctionName();
        if (functionName != null) {
            Variable variable;
            Expression name = functionName.getName();
            result = name instanceof Variable ? !(variable = (Variable)name).isDollared() && !(name instanceof ReflectionVariable) : true;
        }
        return result;
    }

    @Override
    public void visit(ClassName node) {
        if (!(node.getName() instanceof Variable) && !(node.getName() instanceof FieldAccess)) {
            ScopeImpl scope = this.modelBuilder.getCurrentScope();
            this.occurencesBuilder.prepare(node, (Scope)scope);
        }
        this.scan(node.getName());
    }

    @Override
    public void visit(StaticConstantAccess node) {
        ScopeImpl scope = this.modelBuilder.getCurrentScope();
        this.occurencesBuilder.prepare(node, (Scope)scope);
        Expression dispatcher = node.getDispatcher();
        if (dispatcher instanceof NamespaceName) {
            ASTNodeInfo.Kind[] kinds = new ASTNodeInfo.Kind[]{ASTNodeInfo.Kind.CLASS, ASTNodeInfo.Kind.IFACE, ASTNodeInfo.Kind.ENUM};
            this.occurencesBuilder.prepare(kinds, (NamespaceName)dispatcher, (Scope)scope);
        } else {
            this.scan(dispatcher);
        }
        Expression constant = node.getConstant();
        if (constant instanceof ExpressionArrayAccess) {
            ExpressionArrayAccess access = (ExpressionArrayAccess)constant;
            this.scan(access.getDimension());
            Expression name = access.getExpression();
            while (name instanceof ExpressionArrayAccess) {
                ExpressionArrayAccess access1 = (ExpressionArrayAccess)name;
                this.scan(access1.getDimension());
                name = access1.getExpression();
            }
        } else if (constant instanceof ReflectionVariable) {
            this.scan(constant);
        }
    }

    @Override
    public void visit(CaseDeclaration node) {
        this.modelBuilder.build(node, this.occurencesBuilder);
        super.visit(node);
    }

    @Override
    public void visit(ConstantDeclaration node) {
        ScopeImpl scope = this.modelBuilder.getCurrentScope();
        if (scope instanceof NamespaceScope) {
            List<? extends ConstantDeclarationInfo> constantDeclarationInfos = ConstantDeclarationInfo.create(node);
            for (ConstantDeclarationInfo constantDeclarationInfo : constantDeclarationInfos) {
                ConstantElementImpl createElement = this.modelBuilder.getCurrentNameSpace().createElement(constantDeclarationInfo);
                this.occurencesBuilder.prepare(constantDeclarationInfo, (ConstantElement)createElement);
            }
        } else {
            this.modelBuilder.build(node, this.occurencesBuilder);
        }
        super.visit(node);
    }

    @Override
    public void visit(SingleFieldDeclaration node) {
        this.scan(node.getValue());
    }

    @Override
    public void visit(ExpressionArrayAccess node) {
        this.scan(node.getDimension());
        Expression expression = node.getExpression();
        while (expression instanceof ExpressionArrayAccess) {
            ExpressionArrayAccess access = (ExpressionArrayAccess)expression;
            this.scan(access.getDimension());
            expression = access.getExpression();
        }
        if (expression instanceof Identifier) {
            Identifier identifier = (Identifier)expression;
            String name = identifier.getName();
            if (!NavUtils.isQuoted(name)) {
                this.occurencesBuilder.prepare(ASTNodeInfo.Kind.CONSTANT, expression, (Scope)this.modelBuilder.getCurrentScope());
            }
        } else {
            this.scan(expression);
        }
    }

    @Override
    public void visit(Variable node) {
        String varName = CodeUtils.extractVariableName(node);
        if (varName == null) {
            return;
        }
        Scope scope = this.modelBuilder.getCurrentScope();
        ASTNodeInfo<Variable> varInfo = ASTNodeInfo.create(node);
        if (ModelUtils.isAnonymousFunction(scope) && "$this".equals(varInfo.getName())) {
            Scope inScope = scope.getInScope();
            while (!(inScope instanceof MethodScope) && inScope instanceof FunctionScope) {
                inScope = inScope.getInScope();
            }
            if (inScope instanceof MethodScope) {
                scope = inScope;
            }
        }
        this.prepareVariable(node, scope);
        if (scope instanceof VariableNameFactory) {
            if (scope instanceof MethodScope && "$this".equals(varInfo.getName())) {
                scope = scope.getInScope();
            }
            if (scope instanceof VariableNameFactory) {
                this.createVariable((VariableNameFactory)scope, node);
            }
        } else assert (scope instanceof TypeScope) : scope;
        super.visit(node);
    }

    private void prepareVariable(Variable node, Scope scope) {
        if (this.isLexicalVariable(scope, node)) {
            Scope inScope = this.previousScope;
            while (inScope instanceof ArrowFunctionScope) {
                ArrowFunctionScope arrowFunctionScope = (ArrowFunctionScope)inScope;
                boolean isArrowFunctionVariable = false;
                for (String string : arrowFunctionScope.getParameterNames()) {
                    if (!string.equals(CodeUtils.extractVariableName(node))) continue;
                    isArrowFunctionVariable = true;
                    break;
                }
                if (isArrowFunctionVariable) break;
                inScope = inScope.getInScope();
            }
            this.occurencesBuilder.prepare(node, inScope);
        } else if (scope instanceof ArrowFunctionScope) {
            this.prepareArrowFunctionVariable(scope, node);
        } else {
            this.occurencesBuilder.prepare(node, scope);
        }
    }

    private boolean isLexicalVariable(Variable variable) {
        return this.currentLexicalVariables.contains(CodeUtils.extractVariableName(variable));
    }

    private boolean isLexicalVariable(Scope scope, Variable variable) {
        return this.previousScope != null && !(scope instanceof ArrowFunctionScope) && this.isLexicalVariable(variable);
    }

    private void prepareArrowFunctionVariable(Scope scope, Variable node) {
        Scope inScope = scope;
        while (inScope instanceof FunctionScope && ((FunctionScope)inScope).isAnonymous()) {
            FunctionScope functionScope = (FunctionScope)inScope;
            Collection declaredVariables = functionScope.getDeclaredVariables();
            List<? extends String> parameterNames = functionScope.getParameterNames();
            for (VariableName declaredVariable : declaredVariables) {
                if (!declaredVariable.getName().equals(CodeUtils.extractVariableName(node))) continue;
                if (this.isLexicalVariable(node) || functionScope instanceof ArrowFunctionScope && !parameterNames.contains(declaredVariable.getName())) {
                    this.occurencesBuilder.prepare(node, inScope.getInScope());
                } else {
                    this.occurencesBuilder.prepare(node, inScope);
                }
                return;
            }
            inScope = inScope.getInScope();
        }
        this.occurencesBuilder.prepare(node, inScope);
    }

    @Override
    public void visit(GlobalStatement node) {
        super.visit(node);
        List<Variable> variables = node.getVariables();
        for (Variable var : variables) {
            ScopeImpl scope;
            String varName = CodeUtils.extractVariableName(var);
            if (varName == null || !((scope = this.modelBuilder.getCurrentScope()) instanceof VariableNameFactory)) continue;
            VariableNameFactory vc = (VariableNameFactory)((Object)scope);
            List<? extends VariableName> variablesImpl = ModelUtils.filter(vc.getDeclaredVariables(), varName);
            VariableNameImpl varElem = (VariableNameImpl)ModelUtils.getFirst(variablesImpl);
            if (varElem != null) {
                varElem.setGloballyVisible(true);
                continue;
            }
            vc = this.modelBuilder.getCurrentNameSpace();
            variablesImpl = ModelUtils.filter(vc.getDeclaredVariables(), varName);
            varElem = (VariableNameImpl)ModelUtils.getFirst(variablesImpl);
            if (varElem == null) continue;
            varElem.setGloballyVisible(true);
        }
    }

    @Override
    public void visit(FieldAccess node) {
        Variable field = node.getField();
        if (field.isDollared() || field instanceof ReflectionVariable) {
            this.scan(field);
        } else {
            this.occurencesBuilder.prepare(node, (Scope)this.modelBuilder.getCurrentScope());
        }
        if (field instanceof ArrayAccess) {
            ArrayAccess access = (ArrayAccess)field;
            this.scan(access.getDimension());
            VariableBase name = access.getName();
            while (name instanceof ArrayAccess) {
                ArrayAccess access1 = (ArrayAccess)name;
                this.scan(access1.getDimension());
                name = access1.getName();
            }
        }
        this.scan(node.getDispatcher());
    }

    private Map<String, AssignmentImpl> getAssignmentMap(Scope scope, VariableBase leftHandSide) {
        HashMap<String, AssignmentImpl> allAssignments = new HashMap<String, AssignmentImpl>();
        Map<String, AssignmentImpl> cachedMap = this.assignmentMapCache.get(scope);
        if (cachedMap == null || cachedMap.isEmpty()) {
            if (scope instanceof VariableScope) {
                VariableScope variableScope = (VariableScope)scope;
                Collection<? extends VariableName> declaredVariables = variableScope.getDeclaredVariables();
                for (VariableName variableName : declaredVariables) {
                    VariableNameImpl vni;
                    AssignmentImpl ai;
                    if (!(variableName instanceof VariableNameImpl) || (ai = (vni = (VariableNameImpl)variableName).findVarAssignment(leftHandSide.getStartOffset())) == null) continue;
                    allAssignments.put(vni.getName(), ai);
                }
            }
            this.assignmentMapCache.save(scope, allAssignments);
        }
        return allAssignments;
    }

    @Override
    public void visit(Assignment node) {
        VariableNameImpl varN;
        StaticFieldAccess staticFieldAccess;
        Expression dispatcher;
        String unqualifiedClassName;
        ScopeImpl scope = this.modelBuilder.getCurrentScope();
        VariableBase leftHandSide = node.getLeftHandSide();
        Expression rightHandSide = node.getRightHandSide();
        super.scan(leftHandSide);
        if (leftHandSide instanceof Variable) {
            VariableNameImpl varN2 = this.findVariable((Scope)scope, leftHandSide);
            if (varN2 != null) {
                Map<String, AssignmentImpl> allAssignments = this.getAssignmentMap(scope, leftHandSide);
                Variable var = (Variable)leftHandSide;
                if (rightHandSide instanceof ArrayCreation) {
                    ArrayCreation arrayCreation = (ArrayCreation)rightHandSide;
                    List<ArrayElement> elements = arrayCreation.getElements();
                    if (!elements.isEmpty()) {
                        for (ArrayElement arrayElement : elements) {
                            Expression value = arrayElement.getValue();
                            String typeName = VariousUtils.extractVariableTypeFromExpression(value, allAssignments);
                            ASTNode conditionalNode = this.findConditionalStatement(this.getPath());
                            VarAssignmentImpl vAssignment = varN2.createAssignment(scope, conditionalNode != null, this.getBlockRange(conditionalNode, scope), new OffsetRange(var.getStartOffset(), var.getEndOffset()), typeName);
                            varN2.addElement(vAssignment);
                            vAssignment.setAsArrayAccess(true);
                        }
                    } else {
                        String typeName = VariousUtils.extractVariableTypeFromExpression(rightHandSide, allAssignments);
                        ASTNode conditionalNode = this.findConditionalStatement(this.getPath());
                        VarAssignmentImpl varAssignment = varN2.createAssignment(scope, conditionalNode != null, this.getBlockRange(conditionalNode, scope), new OffsetRange(var.getStartOffset(), var.getEndOffset()), typeName);
                        varN2.addElement(varAssignment);
                    }
                } else {
                    List<PhpDocTypeTagInfo> vardocComments;
                    ASTNode conditionalNode = this.findConditionalStatement(this.getPath());
                    boolean vardocAdded = false;
                    boolean isEmptyElements = varN2.getElements().isEmpty();
                    if (isEmptyElements && (vardocComments = this.varTypeComments.get(varN2.getName())) != null) {
                        for (PhpDocTypeTagInfo vardocComment : vardocComments) {
                            if (vardocComment.getRange().getEnd() > varN2.getOffset() || !((Object)scope).equals(this.getVariableScope(vardocComment.getRange().getStart()))) continue;
                            VarAssignmentImpl varAssignment = varN2.createAssignment(scope, conditionalNode != null, this.getBlockRange(conditionalNode, scope), new OffsetRange(var.getStartOffset(), var.getEndOffset()), vardocComment.getTypeName());
                            varN2.addElement(varAssignment);
                            vardocAdded = true;
                        }
                    }
                    if (!vardocAdded) {
                        VarAssignmentImpl varAssignment = varN2.createAssignment(scope, conditionalNode != null, this.getBlockRange(conditionalNode, scope), new OffsetRange(var.getStartOffset(), var.getEndOffset()), node, allAssignments);
                        varN2.addElement(varAssignment);
                        if (isEmptyElements) {
                            this.processVarComment(varN2.getName(), scope);
                        }
                    }
                }
                this.prepareVariable((Variable)leftHandSide, scope);
            }
        } else if (leftHandSide instanceof FieldAccess) {
            FieldAccess fieldAccess = (FieldAccess)leftHandSide;
            VariableNameImpl varN3 = this.findVariable((Scope)this.modelBuilder.getCurrentScope(), fieldAccess.getDispatcher());
            if (varN3 != null) {
                varN3.createLazyFieldAssignment(fieldAccess, node, scope);
            }
        } else if (leftHandSide instanceof StaticFieldAccess && VariousUtils.isStaticClassName(unqualifiedClassName = CodeUtils.extractUnqualifiedName(dispatcher = (staticFieldAccess = (StaticFieldAccess)leftHandSide).getDispatcher())) && (varN = this.findVariable((Scope)this.modelBuilder.getCurrentScope(), "$this")) != null) {
            varN.createLazyStaticFieldAssignment(staticFieldAccess, node, scope);
        }
        super.scan(rightHandSide);
    }

    @Override
    public void visit(ForEachStatement node) {
        VariableNameImpl varValue;
        ScopeImpl scope = this.modelBuilder.getCurrentScope();
        super.visit(node);
        Expression expression = node.getExpression();
        Expression value = node.getValue();
        if (value instanceof Variable && (varValue = this.findVariable((Scope)scope, (Variable)value)) != null) {
            varValue.setTypeResolutionKind(VariableNameImpl.TypeResolutionKind.MERGE_ASSIGNMENTS);
            if (expression instanceof Variable) {
                VariableNameImpl varArray = this.findVariable((Scope)scope, (Variable)expression);
                if (varArray != null) {
                    this.processVarComment(varArray.getName(), scope);
                    Collection<? extends String> typeNames = varArray.getArrayAccessTypeNames(node.getStartOffset());
                    for (String string : typeNames) {
                        VarAssignmentImpl varAssignment = varValue.createAssignment(scope, true, this.getBlockRange(scope), new OffsetRange(value.getStartOffset(), value.getEndOffset()), string);
                        varValue.addElement(varAssignment);
                    }
                }
            } else {
                String varType = VariousUtils.extractVariableTypeFromExpression(expression, this.getAssignmentMap(scope, (Variable)value));
                if (varType != null) {
                    VarAssignmentImpl varAssignment = varValue.createAssignment(scope, true, this.getBlockRange(scope), new OffsetRange(value.getStartOffset(), value.getEndOffset()), varType);
                    varValue.addElement(varAssignment);
                }
            }
        }
    }

    @Override
    public void visit(FormalParameter node) {
        Expression parameterName = node.getParameterName();
        Expression parameterType = node.getParameterType();
        ScopeImpl scp = this.modelBuilder.getCurrentScope();
        if (scp instanceof FunctionScopeImpl) {
            FunctionScopeImpl fncScope = (FunctionScopeImpl)scp;
            if (parameterName instanceof Reference) {
                parameterName = ((Reference)parameterName).getExpression();
            }
            if (parameterName instanceof Variadic) {
                parameterName = ((Variadic)parameterName).getExpression();
            }
            if (parameterName instanceof Variable) {
                List<? extends ParameterElement> parameters = fncScope.getParameters();
                for (ParameterElement parameterElement : parameters) {
                    Set<TypeResolver> types = parameterElement.getTypes();
                    StringBuilder sb = new StringBuilder();
                    String typeName = null;
                    for (TypeResolver typeResolver : types) {
                        QualifiedName typeQualifiedName;
                        if (sb.length() > 0) {
                            sb.append("|");
                        }
                        if (!typeResolver.isResolved() || (typeQualifiedName = typeResolver.getTypeName(false)) == null) continue;
                        if (typeResolver.isNullableType()) {
                            sb.append("?");
                        }
                        sb.append(typeQualifiedName.toString());
                    }
                    if (sb.length() > 0) {
                        typeName = sb.toString();
                    }
                    VariableNameImpl var = this.createParameter(fncScope, parameterElement);
                    if (types.isEmpty() || var == null) continue;
                    VarAssignmentImpl varAssignment = var.createAssignment(fncScope, false, fncScope.getBlockRange(), parameterElement.getOffsetRange(), typeName);
                    var.addElement(varAssignment);
                }
                this.prepareType(parameterType, fncScope);
                this.prepareVariable((Variable)parameterName, fncScope);
            }
            super.visit(node);
        }
    }

    @Override
    public void visit(CatchClause node) {
        VariableNameImpl varNameImpl;
        Variable variable = node.getVariable();
        ScopeImpl scope = this.modelBuilder.getCurrentScope();
        List<Expression> classNames = node.getClassNames();
        if (variable != null && scope instanceof VariableNameFactory && (varNameImpl = this.createVariable((VariableNameFactory)((Object)scope), variable)) != null) {
            for (Expression className : classNames) {
                VarAssignmentImpl varAssignment = varNameImpl.createAssignment(scope, true, new OffsetRange(node.getStartOffset(), node.getEndOffset()), VariableNameImpl.toOffsetRange(variable), CodeUtils.extractQualifiedName(className));
                varAssignment.setCatchClause(true);
                varNameImpl.addElement(varAssignment);
            }
        }
        for (Expression className : classNames) {
            if (className instanceof NamespaceName) {
                this.occurencesBuilder.prepare((NamespaceName)className, (Scope)scope);
                continue;
            }
            this.occurencesBuilder.prepare(ASTNodeInfo.Kind.CLASS, className, (Scope)scope);
        }
        this.prepareVariable(variable, scope);
        this.scan(node.getBody());
    }

    @Override
    public void visit(ArrowFunctionDeclaration node) {
        ScopeImpl scope = this.modelBuilder.getCurrentScope();
        FunctionScopeImpl fncScope = FunctionScopeImpl.createElement((Scope)scope, node);
        this.modelBuilder.setCurrentScope(fncScope);
        this.scan(node.getAttributes());
        this.scan(node.getFormalParameters());
        this.isReturnType = true;
        this.scan(node.getReturnType());
        this.isReturnType = false;
        this.scan(node.getExpression());
        this.modelBuilder.reset();
    }

    @Override
    public void visit(LambdaFunctionDeclaration node) {
        ScopeImpl scope = this.modelBuilder.getCurrentScope();
        FunctionScopeImpl fncScope = FunctionScopeImpl.createElement((Scope)scope, node);
        this.scan(node.getAttributes());
        List<Expression> lexicalVariables = node.getLexicalVariables();
        this.isLexicalVariable = true;
        this.scan(lexicalVariables);
        this.isLexicalVariable = false;
        ArrayList<String> previousLexicalVariables = new ArrayList<String>();
        if (!this.currentLexicalVariables.isEmpty()) {
            previousLexicalVariables.addAll(this.currentLexicalVariables);
        }
        for (Expression expression : lexicalVariables) {
            Expression expr = expression;
            if (expr instanceof Reference) {
                expr = ((Reference)expr).getExpression();
            }
            if (!(expr instanceof Variable)) continue;
            Variable variable = (Variable)expr;
            this.currentLexicalVariables.add(CodeUtils.extractVariableName(variable));
            VariableNameImpl varNameImpl = this.createVariable(fncScope, variable);
            varNameImpl.setGloballyVisible(true);
        }
        this.modelBuilder.setCurrentScope(fncScope);
        this.scan(node.getFormalParameters());
        this.isReturnType = true;
        this.scan(node.getReturnType());
        this.isReturnType = false;
        Scope previousScopeHolder = null;
        if (this.previousScope != null) {
            previousScopeHolder = this.previousScope;
        }
        this.previousScope = scope;
        this.scan(node.getBody());
        this.previousScope = previousScopeHolder;
        this.currentLexicalVariables.clear();
        if (!previousLexicalVariables.isEmpty()) {
            this.currentLexicalVariables.addAll(previousLexicalVariables);
        }
        this.modelBuilder.reset();
    }

    @Override
    public void visit(FunctionDeclaration node) {
        Scope scope = this.modelBuilder.getCurrentScope();
        assert (scope instanceof FunctionScope || scope instanceof NamespaceScopeImpl);
        while (!(scope instanceof NamespaceScope)) {
            scope = scope.getInScope();
        }
        FunctionScopeImpl fncScope = ((NamespaceScopeImpl)scope).createElement(this.modelBuilder.getProgram(), node);
        this.modelBuilder.setCurrentScope(fncScope);
        this.occurencesBuilder.prepare(node, fncScope);
        this.markerBuilder.prepare(node, (Scope)fncScope);
        this.checkComments(node);
        this.scan(node.getAttributes());
        this.scan(node.getFormalParameters());
        this.scan(node.getReturnType());
        this.scan(node.getBody());
        this.modelBuilder.reset();
    }

    @Override
    public void visit(FunctionInvocation node) {
        Scalar scalar;
        Expression d;
        ScopeImpl scope = this.modelBuilder.getCurrentScope();
        Expression functionName = node.getFunctionName().getName();
        boolean isFunctionNameScaned = false;
        if (functionName instanceof Variable) {
            Variable variable = (Variable)functionName;
            this.scan(variable);
            isFunctionNameScaned = true;
        } else {
            NamespaceName namespaceName;
            QualifiedName qualifiedName;
            this.occurencesBuilder.prepare(node, (Scope)scope);
            if (functionName instanceof NamespaceName && !VariousUtils.isSpecialClassName((qualifiedName = QualifiedName.create(CodeUtils.extractQualifiedName(namespaceName = (NamespaceName)functionName))).toString()) && VariousUtils.isAliased(qualifiedName, namespaceName.getStartOffset(), scope)) {
                this.occurencesBuilder.prepare(namespaceName, (Scope)scope);
            }
        }
        ASTNodeInfo<FunctionInvocation> nodeInfo = ASTNodeInfo.create(node);
        String name = nodeInfo.getName();
        if ("define".equals(name) && (node.getParameters().size() == 2 || node.getParameters().size() == 3)) {
            Scalar scalar2;
            String value;
            Expression d2 = node.getParameters().get(0);
            if (d2 instanceof Scalar && ((Scalar)d2).getScalarType() == Scalar.Type.STRING && NavUtils.isQuoted(value = (scalar2 = (Scalar)d2).getStringValue())) {
                ASTNodeInfo<Scalar> scalarInfo = ASTNodeInfo.create(ASTNodeInfo.Kind.CONSTANT, scalar2);
                Expression parameterExpression = node.getParameters().get(1);
                String parameterValue = parameterExpression instanceof Scalar ? ((Scalar)parameterExpression).getStringValue() : null;
                ScalarConstantElementImpl constantImpl = this.modelBuilder.getCurrentNameSpace().createConstantElement(scalarInfo, parameterValue);
                this.occurencesBuilder.prepare(scalarInfo, (ConstantElement)constantImpl);
            }
        } else if ("constant".equals(name) && node.getParameters().size() == 1 && (d = node.getParameters().get(0)) instanceof Scalar && (scalar = (Scalar)d).getScalarType() == Scalar.Type.STRING && NavUtils.isQuoted(scalar.getStringValue())) {
            this.occurencesBuilder.prepare(ASTNodeInfo.Kind.CONSTANT, scalar, (Scope)this.fileScope);
        }
        if (isFunctionNameScaned) {
            this.scan(node.getParameters());
        } else {
            super.visit(node);
        }
    }

    @Override
    public void visit(StaticFieldAccess node) {
        ScopeImpl scope = this.modelBuilder.getCurrentScope();
        this.occurencesBuilder.prepare(node, (Scope)scope);
        Expression dispatcher = node.getDispatcher();
        if (dispatcher instanceof NamespaceName) {
            this.occurencesBuilder.prepare((NamespaceName)dispatcher, (Scope)scope);
        } else {
            this.scan(dispatcher);
        }
        Variable field = node.getField();
        if (field instanceof ArrayAccess) {
            ArrayAccess access = (ArrayAccess)field;
            this.scan(access.getDimension());
            VariableBase name = access.getName();
            while (name instanceof ArrayAccess) {
                ArrayAccess access1 = (ArrayAccess)name;
                this.scan(access1.getDimension());
                name = access1.getName();
            }
        }
    }

    @Override
    public void visit(PHPDocTypeTag node) {
        ScopeImpl currentScope;
        if (node.getKind().equals((Object)PHPDocTag.Type.MIXIN) && (currentScope = this.modelBuilder.getCurrentScope()) instanceof ClassScopeImpl) {
            ClassScopeImpl classScope = (ClassScopeImpl)currentScope;
            List<? extends PhpDocTypeTagInfo> tagInfos = PhpDocTypeTagInfo.create(node, classScope);
            LinkedHashSet<QualifiedName> names = new LinkedHashSet<QualifiedName>();
            tagInfos.stream().filter(tagInfo -> !tagInfo.getName().isEmpty()).map(tagInfo -> tagInfo.getTypeName()).filter(typeName -> typeName != null && !typeName.isEmpty()).map(typeName -> VariousUtils.qualifyTypeNames(typeName, node.getStartOffset(), classScope)).forEach(qualifiedTypeName -> names.add(QualifiedName.create(qualifiedTypeName)));
            if (!names.isEmpty()) {
                classScope.addFQMixinClassNames(names);
            }
        }
        this.occurencesBuilder.prepare(node, (Scope)this.modelBuilder.getCurrentScope());
        super.visit(node);
    }

    @Override
    public void visit(PHPDocVarTypeTag node) {
        ScopeImpl currentScope = this.modelBuilder.getCurrentScope();
        String defaultType = null;
        String fqType = null;
        if (ModelVisitor.isPropertyTag(node) && (defaultType = this.getDefaultType(node)) != null) {
            fqType = this.getFqName(defaultType, node, currentScope);
        }
        List<? extends PhpDocTypeTagInfo> tagInfos = PhpDocTypeTagInfo.create(node, currentScope);
        Iterator<? extends PhpDocTypeTagInfo> it = tagInfos.iterator();
        while (it.hasNext()) {
            PhpDocTypeTagInfo phpDocTypeTagInfo = it.next();
            if (phpDocTypeTagInfo.getKind().equals((Object)ASTNodeInfo.Kind.FIELD) && !phpDocTypeTagInfo.getName().isEmpty()) {
                if (!(currentScope instanceof ClassScope) && !(currentScope instanceof TraitScope) || it.hasNext()) continue;
                new FieldElementImpl((Scope)currentScope, defaultType, fqType, phpDocTypeTagInfo, true);
                continue;
            }
            if (!node.getKind().equals((Object)PHPDocTag.Type.GLOBAL) || !phpDocTypeTagInfo.getKind().equals((Object)ASTNodeInfo.Kind.VARIABLE)) continue;
            String typeName = phpDocTypeTagInfo.getTypeName();
            String varName = phpDocTypeTagInfo.getName();
            VariableScope variableScope = this.getVariableScope(node.getStartOffset());
            if (variableScope == null) continue;
            VariableNameImpl varN = this.findVariable((Scope)variableScope, varName);
            if (varN == null && variableScope instanceof VariableNameFactory) {
                VariableNameFactory factory = (VariableNameFactory)variableScope;
                OffsetRange nameRange = new OffsetRange(node.getStartOffset(), node.getEndOffset());
                varN = new VariableNameImpl((Scope)factory, varName, variableScope.getFile(), nameRange, true);
            }
            if (varN == null) continue;
            VarAssignmentImpl varAssignment = varN.createAssignment(variableScope, false, variableScope.getBlockRange(), varN.getNameRange(), typeName);
            varN.addElement(varAssignment);
        }
        this.occurencesBuilder.prepare(node, (Scope)currentScope);
        super.visit(node);
    }

    private static boolean isPropertyTag(PHPDocVarTypeTag node) {
        return node.getKind() == PHPDocTag.Type.PROPERTY || node.getKind() == PHPDocTag.Type.PROPERTY_READ || node.getKind() == PHPDocTag.Type.PROPERTY_WRITE || node.getKind() == PHPDocTag.Type.PARAM;
    }

    private String getDefaultType(PHPDocVarTypeTag node) {
        String[] values = node.getValue().trim().split(" ", 2);
        if (values[0].startsWith("$") || values.length < 2) {
            return null;
        }
        String defaultType = values[0].replace("[]", "");
        return defaultType;
    }

    private String getFqName(String defaultType, PHPDocVarTypeTag node, Scope currentScope) {
        int typeStart = 0;
        String fqType = null;
        StringBuilder fqNames = new StringBuilder();
        for (int i = 0; i < defaultType.length(); ++i) {
            String type;
            switch (defaultType.charAt(i)) {
                case '&': 
                case '(': 
                case ')': 
                case '?': 
                case '|': {
                    type = defaultType.substring(typeStart, i);
                    if (!type.isEmpty()) {
                        fqNames.append(VariousUtils.qualifyTypeNames(type, node.getStartOffset(), currentScope));
                    }
                    fqNames.append(defaultType.charAt(i));
                    typeStart = i + 1;
                    break;
                }
            }
            if (i != defaultType.length() - 1) continue;
            type = defaultType.substring(typeStart, defaultType.length());
            if (!type.isEmpty()) {
                fqNames.append(VariousUtils.qualifyTypeNames(type, node.getStartOffset(), currentScope));
            }
            fqType = fqNames.length() > 0 ? fqNames.toString() : null;
        }
        return fqType;
    }

    public FileScope getFileScope() {
        return this.fileScope;
    }

    public synchronized IndexScope getIndexScope() {
        if (this.indexScope == null) {
            this.indexScope = new IndexScopeImpl(this.info);
        }
        return this.indexScope;
    }

    @CheckForNull
    public CodeMarker getCodeMarker(int offset) {
        this.buildCodeMarks(offset);
        return this.findStrictCodeMarker((FileScopeImpl)this.getFileScope(), offset, null);
    }

    private void checkComments(ASTNode node) {
        block4: {
            Comment comment;
            block3: {
                Comment comment2 = comment = node instanceof Comment ? (Comment)node : Utils.getCommentForNode(this.modelBuilder.getProgram(), node);
                if (!(comment instanceof PHPDocBlock)) break block3;
                PHPDocBlock phpDoc = (PHPDocBlock)comment;
                for (PHPDocTag tag : phpDoc.getTags()) {
                    this.scan(tag);
                }
                break block4;
            }
            if (!(comment instanceof PHPVarComment)) break block4;
            PHPDocVarTypeTag typeTag = ((PHPVarComment)comment).getVariable();
            List<? extends PhpDocTypeTagInfo> tagInfos = PhpDocTypeTagInfo.create(typeTag, this.fileScope);
            for (PhpDocTypeTagInfo phpDocTypeTagInfo : tagInfos) {
                if (!phpDocTypeTagInfo.getKind().equals((Object)ASTNodeInfo.Kind.VARIABLE)) continue;
                String name = phpDocTypeTagInfo.getName();
                List<PhpDocTypeTagInfo> infos = this.varTypeComments.get(name);
                if (infos == null) {
                    infos = new ArrayList<PhpDocTypeTagInfo>();
                    this.varTypeComments.put(name, infos);
                }
                infos.add(phpDocTypeTagInfo);
            }
        }
    }

    private VariableNameImpl findVariable(Scope scope, String varName) {
        VariableNameImpl retval = null;
        if (varName != null) {
            Scope scopeToInspect;
            Map<String, VariableNameImpl> varnames = this.vars.get(scopeToInspect);
            for (scopeToInspect = scope; scopeToInspect != null && (varnames == null || (retval = varnames.get(varName)) == null); scopeToInspect = scopeToInspect.getInScope()) {
                varnames = this.vars.get(scopeToInspect);
            }
        }
        return retval;
    }

    private VariableNameImpl findVariable(Scope scope, VariableBase leftHandSide) {
        String varName = null;
        if (leftHandSide instanceof Variable) {
            varName = VariableNameImpl.toName((Variable)leftHandSide);
        }
        return varName != null ? this.findVariable(scope, varName) : null;
    }

    private VariableNameImpl createParameter(FunctionScopeImpl fncScope, ParameterElement parameter) {
        String name;
        VariableNameImpl varInstance;
        FunctionScopeImpl varContainer = fncScope;
        Map<String, VariableNameImpl> map = this.vars.get(varContainer);
        if (map == null) {
            map = new HashMap<String, VariableNameImpl>();
            this.vars.put(varContainer, map);
        }
        if ((varInstance = map.get(name = parameter.getName())) == null && ModelUtils.filter(varContainer.getDeclaredVariables(), name).isEmpty()) {
            varInstance = new VariableNameImpl((Scope)fncScope, name, fncScope.getFile(), parameter.getOffsetRange(), false);
            fncScope.addElement(varInstance);
            map.put(name, varInstance);
        }
        return varInstance;
    }

    private VariableNameImpl createVariable(VariableNameFactory varContainer, Variable node) {
        String name;
        VariableNameImpl retval;
        Map<String, VariableNameImpl> map = this.vars.get(varContainer);
        if (map == null) {
            map = new HashMap<String, VariableNameImpl>();
            this.vars.put(varContainer, map);
        }
        if ((retval = map.get(name = VariableNameImpl.toName(node))) == null && ModelUtils.filter(varContainer.getDeclaredVariables(), name).isEmpty()) {
            retval = varContainer.createElement(node);
            if (this.isLexicalVariable) {
                retval.setGloballyVisible(true);
            }
            map.put(name, retval);
        }
        return retval;
    }

    @CheckForNull
    private ASTNode findConditionalStatement(List<ASTNode> path) {
        for (ASTNode aSTNode : path) {
            if (aSTNode instanceof IfStatement) {
                return aSTNode;
            }
            if (aSTNode instanceof WhileStatement) {
                return aSTNode;
            }
            if (aSTNode instanceof DoStatement) {
                return aSTNode;
            }
            if (aSTNode instanceof ForEachStatement) {
                return aSTNode;
            }
            if (aSTNode instanceof ForStatement) {
                return aSTNode;
            }
            if (aSTNode instanceof CatchClause) {
                return aSTNode;
            }
            if (aSTNode instanceof SwitchStatement) {
                return aSTNode;
            }
            if (aSTNode instanceof TryStatement) {
                return aSTNode;
            }
            if (!(aSTNode instanceof InstanceOfExpression)) continue;
            return aSTNode;
        }
        return null;
    }

    private CodeMarker findStrictCodeMarker(FileScopeImpl scope, int offset, CodeMarker atOffset) {
        CodeMarker result = atOffset;
        List<? extends CodeMarker> markers = scope.getMarkers();
        for (CodeMarker codeMarker : markers) {
            assert (codeMarker != null);
            if (!codeMarker.containsInclusive(offset)) continue;
            result = codeMarker;
        }
        return result;
    }

    @CheckForNull
    public Occurence getOccurence(int offset) {
        if (this.occurencesBuilder != null) {
            return this.occurencesBuilder.build(this.fileScope, offset);
        }
        return null;
    }

    @CheckForNull
    public List<Occurence> getOccurence(ModelElement element) {
        if (this.occurencesBuilder != null) {
            return this.occurencesBuilder.build(this.fileScope, element);
        }
        return Collections.emptyList();
    }

    public ModelElement findDeclaration(PhpElement element) {
        int offset = element.getOffset();
        List<? extends ModelElement> elements = ModelUtils.getElements(this.getFileScope(), true);
        ModelElement possibleElement = null;
        OffsetRange nameOffsetRange = new OffsetRange(offset, offset + element.getName().length());
        for (ModelElement modelElement : elements) {
            if (!modelElement.getNameRange().overlaps(nameOffsetRange) || possibleElement != null && !ModelVisitor.contains(possibleElement.getNameRange(), modelElement.getNameRange())) continue;
            possibleElement = modelElement;
        }
        return possibleElement;
    }

    private static boolean contains(OffsetRange outer, OffsetRange inner) {
        return inner.getStart() >= outer.getStart() && inner.getEnd() <= outer.getEnd();
    }

    public VariableScope getNearestVariableScope(int offset) {
        return VariableScopeFinder.create().findNearestVarScope((FileScopeImpl)this.getFileScope(), offset, null);
    }

    public VariableScope getVariableScope(int offset) {
        return this.getVariableScope(offset, VariableScopeFinder.ScopeRangeAcceptor.BLOCK);
    }

    public VariableScope getVariableScope(int offset, VariableScopeFinder.ScopeRangeAcceptor scopeRangeAcceptor) {
        return VariableScopeFinder.create().find(this.getFileScope(), offset, scopeRangeAcceptor);
    }

    private void buildCodeMarks(int offset) {
        if (this.markerBuilder != null) {
            this.fileScope.clearMarkers();
            this.markerBuilder.build(this.fileScope, offset);
        }
    }

    private OffsetRange getBlockRange(Scope currentScope) {
        ASTNode conditionalNode = this.findConditionalStatement(this.getPath());
        return this.getBlockRange(conditionalNode, currentScope);
    }

    private OffsetRange getBlockRange(ASTNode conditionalNode, Scope currentScope) {
        OffsetRange scopeRange = conditionalNode != null ? new OffsetRange(conditionalNode.getStartOffset(), conditionalNode.getEndOffset()) : currentScope.getBlockRange();
        return scopeRange;
    }

    private void handleVarComments() {
        Set<String> varCommentNames = this.varTypeComments.keySet();
        for (String name : new HashSet<String>(varCommentNames)) {
            this.handleVarComment(name);
        }
    }

    private void handleVarComment(String name) {
        Parameters.notNull((CharSequence)"name", (Object)name);
        List<PhpDocTypeTagInfo> varComments = this.varTypeComments.get(name);
        if (varComments != null) {
            for (PhpDocTypeTagInfo phpDocTypeTagInfo : new ArrayList<PhpDocTypeTagInfo>(varComments)) {
                VariableScope varScope = this.getVariableScope(phpDocTypeTagInfo.getRange().getStart());
                if (varScope == null) continue;
                this.handleVarAssignment(name, varScope, phpDocTypeTagInfo);
            }
        }
    }

    private void handleVarAssignment(String name, VariableScope varScope, PhpDocTypeTagInfo phpDocTypeTagInfo) {
        VariableNameImpl varInstance = (VariableNameImpl)ModelUtils.getFirst(ModelUtils.filter(varScope.getDeclaredVariables(), name));
        if (varInstance == null) {
            varInstance = new VariableNameImpl((Scope)varScope, name, varScope.getFile(), phpDocTypeTagInfo.getRange(), varScope instanceof NamespaceScopeImpl);
        } else {
            varInstance.setTypeResolutionKind(VariableNameImpl.TypeResolutionKind.MERGE_ASSIGNMENTS);
        }
        ASTNode conditionalNode = this.findConditionalStatement(this.getPath());
        VarAssignmentImpl varAssignment = varInstance.createAssignment(varScope, conditionalNode != null, this.getBlockRange(varScope), phpDocTypeTagInfo.getRange(), phpDocTypeTagInfo.getTypeName());
        varInstance.addElement(varAssignment);
        this.occurencesBuilder.prepare(phpDocTypeTagInfo.getTypeTag(), (Scope)varScope);
    }

    private void processVarComment(String variableName, Scope variableScope) {
        Parameters.notNull((CharSequence)"variableName", (Object)variableName);
        Parameters.notNull((CharSequence)"variableScope", (Object)variableScope);
        List<PhpDocTypeTagInfo> varComments = this.varTypeComments.get(variableName);
        if (varComments != null) {
            for (PhpDocTypeTagInfo phpDocTypeTagInfo : new ArrayList<PhpDocTypeTagInfo>(varComments)) {
                VariableScope varScope = this.getVariableScope(phpDocTypeTagInfo.getRange().getStart());
                if (!variableScope.equals(varScope)) continue;
                this.handleVarAssignment(variableName, varScope, phpDocTypeTagInfo);
            }
        }
    }

    private void prepareVarComments(Program program) {
        List<Comment> comments = program.getComments();
        for (Comment comment : comments) {
            Comment.Type type = comment.getCommentType();
            if (!type.equals((Object)Comment.Type.TYPE_VARTYPE)) continue;
            this.checkComments(comment);
        }
    }

    private void prepareType(Expression type, Scope scope) {
        Expression namespaceName = type;
        if (namespaceName instanceof NullableType) {
            NullableType nullableType = (NullableType)namespaceName;
            if (nullableType.getType() instanceof NamespaceName) {
                namespaceName = (NamespaceName)nullableType.getType();
            }
        } else if (namespaceName instanceof UnionType) {
            UnionType unionType = (UnionType)namespaceName;
            unionType.getTypes().forEach(t -> this.prepareType((Expression)t, scope));
        } else if (namespaceName instanceof IntersectionType) {
            IntersectionType intersectionType = (IntersectionType)namespaceName;
            intersectionType.getTypes().forEach(t -> this.prepareType((Expression)t, scope));
        }
        if (namespaceName instanceof NamespaceName) {
            ASTNodeInfo.Kind[] kinds = new ASTNodeInfo.Kind[]{ASTNodeInfo.Kind.CLASS, ASTNodeInfo.Kind.IFACE, ASTNodeInfo.Kind.ENUM};
            this.occurencesBuilder.prepare(kinds, (NamespaceName)namespaceName, scope);
        }
    }

    void scanNoLazy(ASTNode node, Scope inScope) {
        ScopeImpl originalScope = this.modelBuilder.getCurrentScope();
        this.modelBuilder.prepareForScope(inScope);
        this.lazyScan = false;
        this.scan(node);
        this.modelBuilder.prepareForScope(originalScope);
    }

    private void processSingleUseStatement(UseStatement.Type type, @NullAllowed GroupUseStatementPart groupUseStatementPart, SingleUseStatementPart singleUseStatementPart) {
        UseStatement.Type realType;
        NamespaceName name;
        if (groupUseStatementPart == null) {
            name = singleUseStatementPart.getName();
            realType = type;
        } else {
            name = CodeUtils.compoundName(groupUseStatementPart, singleUseStatementPart, false);
            realType = singleUseStatementPart.getType();
            if (realType == null) {
                realType = type;
            }
        }
        ScopeImpl currentScope = this.modelBuilder.getCurrentScope();
        switch (realType) {
            case CONST: {
                this.occurencesBuilder.prepare(ASTNodeInfo.Kind.CONSTANT, (Expression)name, (Scope)currentScope);
                break;
            }
            case FUNCTION: {
                this.occurencesBuilder.prepare(ASTNodeInfo.Kind.FUNCTION, (Expression)name, (Scope)currentScope);
                break;
            }
            case TYPE: {
                this.occurencesBuilder.prepare(ASTNodeInfo.Kind.CLASS, (Expression)name, (Scope)currentScope);
                this.occurencesBuilder.prepare(ASTNodeInfo.Kind.IFACE, (Expression)name, (Scope)currentScope);
                this.occurencesBuilder.prepare(ASTNodeInfo.Kind.TRAIT, (Expression)name, (Scope)currentScope);
                this.occurencesBuilder.prepare(ASTNodeInfo.Kind.ENUM, (Expression)name, (Scope)currentScope);
                break;
            }
            default: {
                assert (false) : "Unknown type: " + (Object)((Object)realType);
                break;
            }
        }
        if (singleUseStatementPart.getAlias() != null) {
            this.occurencesBuilder.prepare(ASTNodeInfo.Kind.USE_ALIAS, singleUseStatementPart.getAlias(), (Scope)currentScope);
        }
    }

    private static final class AttributeParametersVisitor
    extends DefaultVisitor {
        private final Set<ASTNode> typeNameNodes = new HashSet<ASTNode>();

        private AttributeParametersVisitor() {
        }

        @Override
        public void visit(ClassInstanceCreation node) {
            if (!node.isAnonymous()) {
                this.typeNameNodes.add(node);
            }
            super.visit(node);
        }

        @Override
        public void visit(StaticConstantAccess node) {
            this.typeNameNodes.add(node);
            super.visit(node);
        }

        public boolean isGlobalConstant(NamespaceName namespaceName) {
            for (ASTNode typeNameNode : this.typeNameNodes) {
                if (typeNameNode.getStartOffset() > namespaceName.getStartOffset() || namespaceName.getEndOffset() > typeNameNode.getEndOffset()) continue;
                return false;
            }
            return true;
        }
    }

    private static final class AnonymousClassesVisitor
    extends DefaultVisitor {
        private final List<ClassInstanceCreation> anonymousClasses = new ArrayList<ClassInstanceCreation>();

        private AnonymousClassesVisitor() {
        }

        @Override
        public void visit(ClassInstanceCreation node) {
            if (node.isAnonymous()) {
                this.anonymousClasses.add(node);
                super.visit(node);
            }
        }

        public List<ClassInstanceCreation> getAnonymousClasses() {
            return Collections.unmodifiableList(this.anonymousClasses);
        }
    }
}

