/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.v2.features;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.filters.GenericFilter;
import org.netbeans.lib.profiler.filters.JavaTypeFilter;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.JExtendedSpinner;
import org.netbeans.lib.profiler.ui.swing.GrayLabel;
import org.netbeans.lib.profiler.ui.swing.SmallButton;
import org.netbeans.lib.profiler.ui.swing.TextArea;
import org.netbeans.modules.profiler.api.ProjectUtilities;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.api.java.SourceClassInfo;
import org.netbeans.modules.profiler.api.project.ProjectContentsSupport;
import org.netbeans.modules.profiler.v2.ProfilerSession;
import org.netbeans.modules.profiler.v2.features.Bundle;
import org.netbeans.modules.profiler.v2.features.FeatureMode;
import org.netbeans.modules.profiler.v2.impl.ClassMethodList;
import org.netbeans.modules.profiler.v2.impl.ClassMethodSelector;
import org.netbeans.modules.profiler.v2.impl.ProjectsSelector;
import org.netbeans.modules.profiler.v2.ui.SettingsPanel;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;

final class ObjectsFeatureModes {
    ObjectsFeatureModes() {
    }

    private static Component createStrut(JComponent c, int width, boolean before) {
        Insets i;
        Border b = c.getBorder();
        Insets insets = i = b != null ? b.getBorderInsets(c) : null;
        int w = i == null ? width : Math.max(width - (before ? i.left : i.right), 0);
        return Box.createHorizontalStrut(w);
    }

    static abstract class CustomClassesMode
    extends MemoryMode {
        private static final String LIFECYCLE_FLAG = "LIFECYCLE_FLAG";
        private static final String ALLOCATIONS_FLAG = "ALLOCATIONS_FLAG";
        private static final String LIMIT_ALLOCATIONS_FLAG = "LIMIT_ALLOCATIONS_FLAG";
        private static final String CLASSES_FLAG = "SELECTION_FLAG";
        private static final int MIN_ROWS = 1;
        private static final int MAX_ROWS = 15;
        private static final int DEFAULT_ROWS = 3;
        private static final int MIN_COLUMNS = 10;
        private static final int MAX_COLUMNS = 100;
        private static final int DEFAULT_COLUMNS = 40;
        private static final Integer LIMIT_ALLOCATIONS_DEFAULT = 10;
        private JComponent ui;
        private TextArea classesArea;
        private JCheckBox lifecycleCheckbox;
        private JCheckBox outgoingCheckbox;
        private JSpinner outgoingSpinner;

        CustomClassesMode() {
        }

        @Override
        String getID() {
            return "CustomMethodsMode";
        }

        @Override
        String getName() {
            return Bundle.ObjectsFeatureModes_definedClasses();
        }

        @Override
        void configureSettings(ProfilingSettings settings) {
            assert (SwingUtilities.isEventDispatchThread());
            super.configureSettings(settings);
            String filterValue = CustomClassesMode.getFlatValues(this.readFlag(CLASSES_FLAG, "").split("\\n"));
            settings.setInstrumentationFilter((GenericFilter)new JavaTypeFilter(filterValue, 10));
            boolean lifecycle = Boolean.parseBoolean(this.readFlag(LIFECYCLE_FLAG, Boolean.TRUE.toString()));
            settings.setProfilingType(lifecycle ? 4 : 2);
            boolean alloc = Boolean.parseBoolean(this.readFlag(ALLOCATIONS_FLAG, Boolean.TRUE.toString()));
            int limit = Integer.parseInt(this.readFlag(LIMIT_ALLOCATIONS_FLAG, LIMIT_ALLOCATIONS_DEFAULT.toString()));
            settings.setAllocStackTraceLimit(!alloc ? -10 : limit);
        }

        @Override
        void confirmSettings() {
            if (this.ui != null && this.classesArea != null) {
                assert (SwingUtilities.isEventDispatchThread());
                String classes = this.classesArea.showsHint() ? "" : this.classesArea.getText().trim();
                this.storeFlag(CLASSES_FLAG, classes.isEmpty() ? null : classes);
                this.storeFlag(LIFECYCLE_FLAG, this.lifecycleCheckbox.isSelected() ? null : Boolean.FALSE.toString());
                this.storeFlag(ALLOCATIONS_FLAG, this.outgoingCheckbox.isSelected() ? null : Boolean.FALSE.toString());
                String limit = ((Integer)this.outgoingSpinner.getValue()).toString();
                boolean deflimit = LIMIT_ALLOCATIONS_DEFAULT.equals(limit);
                this.storeFlag(LIMIT_ALLOCATIONS_FLAG, deflimit ? null : limit);
            }
        }

        @Override
        boolean pendingChanges() {
            if (this.ui != null) {
                int _limit;
                boolean _alloc;
                boolean _lifecycle;
                String classes;
                assert (SwingUtilities.isEventDispatchThread());
                String string = classes = this.classesArea.showsHint() ? "" : this.classesArea.getText().trim();
                if (!classes.equals(this.readFlag(CLASSES_FLAG, ""))) {
                    return true;
                }
                boolean lifecycle = this.lifecycleCheckbox.isSelected();
                if (lifecycle != (_lifecycle = Boolean.parseBoolean(this.readFlag(LIFECYCLE_FLAG, Boolean.TRUE.toString())))) {
                    return true;
                }
                boolean alloc = this.outgoingCheckbox.isSelected();
                if (alloc != (_alloc = Boolean.parseBoolean(this.readFlag(ALLOCATIONS_FLAG, Boolean.TRUE.toString())))) {
                    return true;
                }
                int limit = Integer.parseInt(this.readFlag(LIMIT_ALLOCATIONS_FLAG, LIMIT_ALLOCATIONS_DEFAULT.toString()));
                if (limit != (_limit = ((Integer)this.outgoingSpinner.getValue()).intValue())) {
                    return true;
                }
            }
            return false;
        }

        @Override
        boolean currentSettingsValid() {
            assert (SwingUtilities.isEventDispatchThread());
            return !(this.ui != null ? this.classesArea.showsHint() || this.classesArea.getText().trim().isEmpty() : this.readFlag(CLASSES_FLAG, "").isEmpty());
        }

        private static String getFlatValues(String[] values) {
            StringBuilder convertedValue = new StringBuilder();
            for (int i = 0; i < values.length; ++i) {
                String filterValue = values[i].trim();
                if (i != values.length - 1 && !filterValue.endsWith(",")) {
                    filterValue = filterValue + ",";
                }
                convertedValue.append(filterValue);
            }
            return convertedValue.toString();
        }

        @Override
        JComponent getUI() {
            if (this.ui == null) {
                JFormattedTextField field;
                JPanel p = new JPanel(new GridBagLayout());
                p.setOpaque(false);
                SettingsPanel classesPanel = new SettingsPanel();
                classesPanel.add(new JLabel(Bundle.ObjectsFeatureModes_classesLbl()));
                GridBagConstraints c = new GridBagConstraints();
                c.gridx = 0;
                c.gridy = 0;
                c.fill = 0;
                c.insets = new Insets(0, 0, 0, 5);
                c.anchor = 18;
                p.add((Component)classesPanel, c);
                final JScrollPane[] container = new JScrollPane[1];
                this.classesArea = new TextArea(this.readFlag(CLASSES_FLAG, "")){

                    protected void changed() {
                        this.settingsChanged();
                    }

                    protected boolean changeSize(boolean vertical, boolean direction) {
                        if (vertical) {
                            int rows = this.readRows();
                            rows = direction ? Math.min(rows + 1, 15) : Math.max(rows - 1, 1);
                            this.storeRows(rows);
                        } else {
                            int cols = this.readColumns();
                            cols = direction ? Math.min(cols + 3, 100) : Math.max(cols - 3, 10);
                            this.storeColumns(cols);
                        }
                        this.layoutImpl();
                        return true;
                    }

                    protected boolean resetSize() {
                        this.storeRows(3);
                        this.storeColumns(40);
                        this.layoutImpl();
                        return true;
                    }

                    private void layoutImpl() {
                        this.setRows(this.readRows());
                        this.setColumns(this.readColumns());
                        container[0].setPreferredSize(null);
                        container[0].setPreferredSize(container[0].getPreferredSize());
                        container[0].setMinimumSize(container[0].getPreferredSize());
                        JRootPane root = SwingUtilities.getRootPane(container[0]);
                        root.doLayout();
                        root.repaint();
                        this.setColumns(0);
                    }

                    protected void customizePopup(JPopupMenu popup) {
                        popup.addSeparator();
                        popup.add(this.createResizeMenu());
                    }

                    public Point getToolTipLocation(MouseEvent event) {
                        Container scroll = this.getParent().getParent();
                        return SwingUtilities.convertPoint(scroll, 0, scroll.getHeight(), (Component)((Object)this));
                    }
                };
                this.classesArea.setFont(new Font("Monospaced", 0, this.classesArea.getFont().getSize()));
                this.classesArea.setRows(this.readRows());
                this.classesArea.setColumns(this.readColumns());
                container[0] = new JScrollPane((Component)this.classesArea);
                container[0].setPreferredSize(container[0].getPreferredSize());
                container[0].setMinimumSize(container[0].getPreferredSize());
                this.classesArea.setColumns(0);
                this.classesArea.setHint(Bundle.ObjectsFeatureModes_classesHint());
                this.classesArea.setToolTipText(Bundle.ObjectsFeatureModes_classesTooltip());
                c = new GridBagConstraints();
                c.gridx = 1;
                c.gridy = 0;
                c.weightx = 1.0;
                c.weighty = 1.0;
                c.fill = 3;
                c.insets = new Insets(0, 0, 0, 5);
                c.anchor = 18;
                p.add((Component)container[0], c);
                SettingsPanel settingsPanel = new SettingsPanel();
                settingsPanel.add(Box.createHorizontalStrut(4));
                Component separator = Box.createHorizontalStrut(1);
                separator.setBackground(Color.GRAY);
                if (separator instanceof JComponent) {
                    ((JComponent)separator).setOpaque(true);
                }
                Dimension d = separator.getMaximumSize();
                d.height = 20;
                separator.setMaximumSize(d);
                settingsPanel.add(separator);
                boolean lifecycle = Boolean.parseBoolean(this.readFlag(LIFECYCLE_FLAG, Boolean.TRUE.toString()));
                this.lifecycleCheckbox = new JCheckBox(Bundle.ObjectsFeatureModes_recordLifecycle(), lifecycle){

                    @Override
                    protected void fireActionPerformed(ActionEvent e) {
                        super.fireActionPerformed(e);
                        this.settingsChanged();
                    }
                };
                this.lifecycleCheckbox.setToolTipText(Bundle.ObjectsFeatureModes_profileAllObjectsToolTip());
                this.lifecycleCheckbox.setOpaque(false);
                settingsPanel.add(ObjectsFeatureModes.createStrut(this.lifecycleCheckbox, 8, true));
                settingsPanel.add(this.lifecycleCheckbox);
                settingsPanel.add(ObjectsFeatureModes.createStrut(this.lifecycleCheckbox, 5, false));
                if (UIUtils.isOracleLookAndFeel()) {
                    p.add(Box.createHorizontalStrut(4));
                }
                GrayLabel unlimited = new GrayLabel(Bundle.ObjectsFeatureModes_lblUnlimited());
                GrayLabel noAllocs = new GrayLabel(Bundle.ObjectsFeatureModes_lblNoAllocations());
                boolean alloc = Boolean.parseBoolean(this.readFlag(ALLOCATIONS_FLAG, Boolean.TRUE.toString()));
                this.outgoingCheckbox = new JCheckBox(Bundle.ObjectsFeatureModes_limitAllocations(), alloc, (JLabel)unlimited, (JLabel)noAllocs){
                    final /* synthetic */ JLabel val$unlimited;
                    final /* synthetic */ JLabel val$noAllocs;
                    {
                        this.val$unlimited = jLabel;
                        this.val$noAllocs = jLabel2;
                        super(text, selected);
                    }

                    @Override
                    protected void fireActionPerformed(ActionEvent e) {
                        super.fireActionPerformed(e);
                        boolean selected = this.isSelected();
                        this.val$unlimited.setVisible(!selected);
                        outgoingSpinner.setVisible(selected);
                        this.val$noAllocs.setVisible(selected && (Integer)outgoingSpinner.getValue() == 0);
                        this.settingsChanged();
                    }
                };
                this.outgoingCheckbox.setToolTipText(Bundle.ObjectsFeatureModes_collectFullStacksToolTip());
                this.outgoingCheckbox.setOpaque(false);
                settingsPanel.add(this.outgoingCheckbox);
                settingsPanel.add(ObjectsFeatureModes.createStrut(this.outgoingCheckbox, 5, false));
                if (UIUtils.isOracleLookAndFeel()) {
                    settingsPanel.add(Box.createHorizontalStrut(4));
                }
                unlimited.setVisible(!this.outgoingCheckbox.isSelected());
                settingsPanel.add((Component)unlimited);
                int limit = Integer.parseInt(this.readFlag(LIMIT_ALLOCATIONS_FLAG, LIMIT_ALLOCATIONS_DEFAULT.toString()));
                this.outgoingSpinner = new JExtendedSpinner(new SpinnerNumberModel(Math.abs(limit), 0, 99, 1)){

                    public Dimension getPreferredSize() {
                        return this.getMinimumSize();
                    }

                    public Dimension getMaximumSize() {
                        return this.getMinimumSize();
                    }

                    protected void fireStateChanged() {
                        this.settingsChanged();
                        super.fireStateChanged();
                    }
                };
                this.outgoingSpinner.setToolTipText(Bundle.ObjectsFeatureModes_limitAllocationsDepthToolTip());
                JComponent editor = this.outgoingSpinner.getEditor();
                JFormattedTextField jFormattedTextField = field = editor instanceof JSpinner.DefaultEditor ? ((JSpinner.DefaultEditor)editor).getTextField() : null;
                if (field != null) {
                    field.getDocument().addDocumentListener(new DocumentListener(){
                        final /* synthetic */ JLabel val$noAllocs;
                        {
                            this.val$noAllocs = jLabel;
                        }

                        @Override
                        public void insertUpdate(DocumentEvent e) {
                            this.change();
                        }

                        @Override
                        public void removeUpdate(DocumentEvent e) {
                            this.change();
                        }

                        @Override
                        public void changedUpdate(DocumentEvent e) {
                            this.change();
                        }

                        private void change() {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    val$noAllocs.setVisible(outgoingSpinner.isVisible() && (Integer)outgoingSpinner.getValue() == 0);
                                }
                            });
                        }
                    });
                }
                this.outgoingSpinner.setVisible(this.outgoingCheckbox.isSelected());
                settingsPanel.add(this.outgoingSpinner);
                settingsPanel.add(Box.createHorizontalStrut(5));
                noAllocs.setVisible(this.outgoingSpinner.isVisible() && (Integer)this.outgoingSpinner.getValue() == 0);
                settingsPanel.add((Component)noAllocs);
                c = new GridBagConstraints();
                c.gridx = 2;
                c.gridy = 0;
                c.fill = 0;
                c.insets = new Insets(0, 0, 0, 0);
                c.anchor = 18;
                p.add((Component)settingsPanel, c);
                this.ui = p;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        this.settingsChanged();
                    }
                });
            }
            return this.ui;
        }

        private int readRows() {
            return NbPreferences.forModule(ObjectsFeatureModes.class).getInt("ObjectsFeatureModes.rows", 3);
        }

        private void storeRows(int rows) {
            NbPreferences.forModule(ObjectsFeatureModes.class).putInt("ObjectsFeatureModes.rows", rows);
        }

        private int readColumns() {
            return NbPreferences.forModule(ObjectsFeatureModes.class).getInt("ObjectsFeatureModes.columns", 40);
        }

        private void storeColumns(int columns) {
            NbPreferences.forModule(ObjectsFeatureModes.class).putInt("ObjectsFeatureModes.columns", columns);
        }
    }

    static abstract class SelectedClassesMode
    extends MemoryMode {
        private static final String LIFECYCLE_FLAG = "LIFECYCLE_FLAG";
        private static final String ALLOCATIONS_FLAG = "ALLOCATIONS_FLAG";
        private static final String LIMIT_ALLOCATIONS_FLAG = "LIMIT_ALLOCATIONS_FLAG";
        private static final String SELECTION_FLAG = "SELECTION_FLAG";
        private static final Integer LIMIT_ALLOCATIONS_DEFAULT = 10;
        private FeatureMode.Selection selection;
        private JComponent ui;
        private JPanel selectionContent;
        private JPanel noSelectionContent;
        private JCheckBox lifecycleCheckbox;
        private JButton addSelectionButton;
        private JButton editSelectionLink;
        private JCheckBox outgoingCheckbox;
        private JSpinner outgoingSpinner;

        SelectedClassesMode() {
        }

        abstract void selectionChanging();

        abstract void selectionChanged();

        abstract ProfilerSession getSession();

        abstract void selectForProfiling(Collection<SourceClassInfo> var1);

        @Override
        String getID() {
            return "SelectedClassesMode";
        }

        @Override
        String getName() {
            return Bundle.ObjectsFeatureModes_selectedClasses();
        }

        @Override
        void configureSettings(ProfilingSettings settings) {
            assert (SwingUtilities.isEventDispatchThread());
            super.configureSettings(settings);
            boolean lifecycle = Boolean.parseBoolean(this.readFlag(LIFECYCLE_FLAG, Boolean.TRUE.toString()));
            settings.setProfilingType(lifecycle ? 4 : 2);
            boolean alloc = Boolean.parseBoolean(this.readFlag(ALLOCATIONS_FLAG, Boolean.TRUE.toString()));
            int limit = Integer.parseInt(this.readFlag(LIMIT_ALLOCATIONS_FLAG, LIMIT_ALLOCATIONS_DEFAULT.toString()));
            settings.setAllocStackTraceLimit(!alloc ? -10 : limit);
            StringBuilder b = new StringBuilder();
            HashSet<ClientUtils.SourceCodeSelection> _sel = this.getSelection();
            ClientUtils.SourceCodeSelection[] classes = _sel.toArray(new ClientUtils.SourceCodeSelection[0]);
            for (int i = 0; i < classes.length; ++i) {
                b.append(classes[i].getClassName());
                if (i >= classes.length - 1) continue;
                b.append(", ");
            }
            JavaTypeFilter ff = new JavaTypeFilter(b.toString(), 10);
            settings.setInstrumentationFilter((GenericFilter)ff);
        }

        @Override
        void confirmSettings() {
            if (this.ui != null) {
                assert (SwingUtilities.isEventDispatchThread());
                this.storeFlag(LIFECYCLE_FLAG, this.lifecycleCheckbox.isSelected() ? null : Boolean.FALSE.toString());
                this.storeFlag(ALLOCATIONS_FLAG, this.outgoingCheckbox.isSelected() ? null : Boolean.FALSE.toString());
                String limit = ((Integer)this.outgoingSpinner.getValue()).toString();
                boolean deflimit = LIMIT_ALLOCATIONS_DEFAULT.equals(limit);
                this.storeFlag(LIMIT_ALLOCATIONS_FLAG, deflimit ? null : limit);
                this.saveSelection();
            }
        }

        @Override
        boolean pendingChanges() {
            if (this.ui != null) {
                int _limit;
                boolean _alloc;
                boolean _lifecycle;
                assert (SwingUtilities.isEventDispatchThread());
                boolean lifecycle = this.lifecycleCheckbox.isSelected();
                if (lifecycle != (_lifecycle = Boolean.parseBoolean(this.readFlag(LIFECYCLE_FLAG, Boolean.TRUE.toString())))) {
                    return true;
                }
                boolean alloc = this.outgoingCheckbox.isSelected();
                if (alloc != (_alloc = Boolean.parseBoolean(this.readFlag(ALLOCATIONS_FLAG, Boolean.TRUE.toString())))) {
                    return true;
                }
                int limit = Integer.parseInt(this.readFlag(LIMIT_ALLOCATIONS_FLAG, LIMIT_ALLOCATIONS_DEFAULT.toString()));
                if (limit != (_limit = ((Integer)this.outgoingSpinner.getValue()).intValue())) {
                    return true;
                }
                if (!this.initSelection(false).equals(this.getSelection())) {
                    return true;
                }
            }
            return false;
        }

        @Override
        boolean currentSettingsValid() {
            assert (SwingUtilities.isEventDispatchThread());
            return !this.getSelection().isEmpty();
        }

        HashSet<ClientUtils.SourceCodeSelection> getSelection() {
            if (this.selection == null) {
                this.selection = this.initSelection(true);
            }
            return this.selection;
        }

        private FeatureMode.Selection initSelection(boolean events) {
            FeatureMode.Selection sel = new FeatureMode.Selection(){

                @Override
                protected void changing() {
                    this.selectionChanging();
                }

                @Override
                protected void changed() {
                    this.selectionChanged();
                    this.updateSelectionCustomizer();
                }
            };
            sel.disableEvents();
            String _sel = this.readFlag(SELECTION_FLAG, null);
            if (_sel != null) {
                for (String s : _sel.split(" ")) {
                    sel.add(ClientUtils.stringToSelection((String)s));
                }
            }
            if (events) {
                sel.enableEvents();
            }
            return sel;
        }

        private void saveSelection() {
            if (this.selection != null) {
                StringBuilder b = new StringBuilder();
                for (ClientUtils.SourceCodeSelection sel : this.selection) {
                    b.append(ClientUtils.selectionToString((ClientUtils.SourceCodeSelection)sel));
                    b.append(" ");
                }
                String sel = b.toString();
                this.storeFlag(SELECTION_FLAG, sel.isEmpty() ? null : sel);
            }
        }

        @Override
        JComponent getUI() {
            if (this.ui == null) {
                JFormattedTextField field;
                this.ui = new SettingsPanel();
                this.selectionContent = new SettingsPanel();
                this.editSelectionLink = new JButton(){

                    @Override
                    public void setText(String text) {
                        super.setText(Bundle.ObjectsFeatureModes_editLink(text));
                    }

                    @Override
                    protected void fireActionPerformed(ActionEvent e) {
                        ClassMethodList.showClasses(this.getSession(), selection, ui);
                    }

                    @Override
                    public Dimension getMinimumSize() {
                        return this.getPreferredSize();
                    }

                    @Override
                    public Dimension getMaximumSize() {
                        return this.getPreferredSize();
                    }
                };
                this.editSelectionLink.setContentAreaFilled(false);
                this.editSelectionLink.setBorderPainted(true);
                this.editSelectionLink.setMargin(new Insets(0, 0, 0, 0));
                this.editSelectionLink.setBorder(BorderFactory.createEmptyBorder());
                this.editSelectionLink.setCursor(Cursor.getPredefinedCursor(12));
                this.selectionContent.add(this.editSelectionLink);
                this.selectionContent.add(Box.createHorizontalStrut(8));
                Component separator = Box.createHorizontalStrut(1);
                separator.setBackground(Color.GRAY);
                if (separator instanceof JComponent) {
                    ((JComponent)separator).setOpaque(true);
                }
                Dimension d = separator.getMaximumSize();
                d.height = 20;
                separator.setMaximumSize(d);
                this.selectionContent.add(separator);
                boolean lifecycle = Boolean.parseBoolean(this.readFlag(LIFECYCLE_FLAG, Boolean.TRUE.toString()));
                this.lifecycleCheckbox = new JCheckBox(Bundle.ObjectsFeatureModes_recordLifecycle(), lifecycle){

                    @Override
                    protected void fireActionPerformed(ActionEvent e) {
                        super.fireActionPerformed(e);
                        this.settingsChanged();
                    }
                };
                this.lifecycleCheckbox.setToolTipText(Bundle.ObjectsFeatureModes_profileAllObjectsToolTip());
                this.lifecycleCheckbox.setOpaque(false);
                this.selectionContent.add(ObjectsFeatureModes.createStrut(this.lifecycleCheckbox, 8, true));
                this.selectionContent.add(this.lifecycleCheckbox);
                this.selectionContent.add(ObjectsFeatureModes.createStrut(this.lifecycleCheckbox, 5, false));
                if (UIUtils.isOracleLookAndFeel()) {
                    this.selectionContent.add(Box.createHorizontalStrut(4));
                }
                GrayLabel unlimited = new GrayLabel(Bundle.ObjectsFeatureModes_lblUnlimited());
                GrayLabel noAllocs = new GrayLabel(Bundle.ObjectsFeatureModes_lblNoAllocations());
                boolean alloc = Boolean.parseBoolean(this.readFlag(ALLOCATIONS_FLAG, Boolean.TRUE.toString()));
                this.outgoingCheckbox = new JCheckBox(Bundle.ObjectsFeatureModes_limitAllocations(), alloc, (JLabel)unlimited, (JLabel)noAllocs){
                    final /* synthetic */ JLabel val$unlimited;
                    final /* synthetic */ JLabel val$noAllocs;
                    {
                        this.val$unlimited = jLabel;
                        this.val$noAllocs = jLabel2;
                        super(text, selected);
                    }

                    @Override
                    protected void fireActionPerformed(ActionEvent e) {
                        super.fireActionPerformed(e);
                        boolean selected = this.isSelected();
                        this.val$unlimited.setVisible(!selected);
                        outgoingSpinner.setVisible(selected);
                        this.val$noAllocs.setVisible(selected && (Integer)outgoingSpinner.getValue() == 0);
                        this.settingsChanged();
                    }
                };
                this.outgoingCheckbox.setToolTipText(Bundle.ObjectsFeatureModes_collectFullStacksToolTip());
                this.outgoingCheckbox.setOpaque(false);
                this.selectionContent.add(this.outgoingCheckbox);
                this.selectionContent.add(ObjectsFeatureModes.createStrut(this.outgoingCheckbox, 5, false));
                if (UIUtils.isOracleLookAndFeel()) {
                    this.selectionContent.add(Box.createHorizontalStrut(4));
                }
                unlimited.setVisible(!this.outgoingCheckbox.isSelected());
                this.selectionContent.add((Component)unlimited);
                int limit = Integer.parseInt(this.readFlag(LIMIT_ALLOCATIONS_FLAG, LIMIT_ALLOCATIONS_DEFAULT.toString()));
                this.outgoingSpinner = new JExtendedSpinner(new SpinnerNumberModel(Math.abs(limit), 0, 99, 1)){

                    public Dimension getPreferredSize() {
                        return this.getMinimumSize();
                    }

                    public Dimension getMaximumSize() {
                        return this.getMinimumSize();
                    }

                    protected void fireStateChanged() {
                        this.settingsChanged();
                        super.fireStateChanged();
                    }
                };
                this.outgoingSpinner.setToolTipText(Bundle.ObjectsFeatureModes_limitAllocationsDepthToolTip());
                JComponent editor = this.outgoingSpinner.getEditor();
                JFormattedTextField jFormattedTextField = field = editor instanceof JSpinner.DefaultEditor ? ((JSpinner.DefaultEditor)editor).getTextField() : null;
                if (field != null) {
                    field.getDocument().addDocumentListener(new DocumentListener(){
                        final /* synthetic */ JLabel val$noAllocs;
                        {
                            this.val$noAllocs = jLabel;
                        }

                        @Override
                        public void insertUpdate(DocumentEvent e) {
                            this.change();
                        }

                        @Override
                        public void removeUpdate(DocumentEvent e) {
                            this.change();
                        }

                        @Override
                        public void changedUpdate(DocumentEvent e) {
                            this.change();
                        }

                        private void change() {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    val$noAllocs.setVisible(outgoingSpinner.isVisible() && (Integer)outgoingSpinner.getValue() == 0);
                                }
                            });
                        }
                    });
                }
                this.outgoingSpinner.setVisible(this.outgoingCheckbox.isSelected());
                this.selectionContent.add(this.outgoingSpinner);
                this.selectionContent.add(Box.createHorizontalStrut(5));
                noAllocs.setVisible(this.outgoingSpinner.isVisible() && (Integer)this.outgoingSpinner.getValue() == 0);
                this.selectionContent.add((Component)noAllocs);
                this.noSelectionContent = new SettingsPanel();
                GrayLabel noSelectionHint = new GrayLabel(Bundle.ObjectsFeatureModes_noClassSelected());
                noSelectionHint.setEnabled(false);
                this.noSelectionContent.add((Component)noSelectionHint);
                this.noSelectionContent.add(Box.createHorizontalStrut(5));
                String iconMask = "LanguageIcons.Class";
                Image baseIcon = Icons.getImage((String)iconMask);
                Image addBadge = Icons.getImage((String)"GeneralIcons.BadgeAdd");
                Image addImage = ImageUtilities.mergeImages((Image)baseIcon, (Image)addBadge, (int)0, (int)0);
                this.addSelectionButton = new SmallButton(ImageUtilities.image2Icon((Image)addImage)){

                    protected void fireActionPerformed(ActionEvent e) {
                        this.selectForProfiling(ClassMethodSelector.selectClasses(this.getSession()));
                    }

                    public Dimension getMinimumSize() {
                        return this.getPreferredSize();
                    }

                    public Dimension getMaximumSize() {
                        return this.getPreferredSize();
                    }
                };
                this.addSelectionButton.setToolTipText(Bundle.ObjectsFeatureModes_addClass());
                this.noSelectionContent.add(this.addSelectionButton);
                this.updateSelectionCustomizer();
            }
            return this.ui;
        }

        private void updateSelectionCustomizer() {
            if (this.ui != null) {
                JPanel content;
                int count = this.getSelection().size();
                JPanel jPanel = content = count == 0 ? this.noSelectionContent : this.selectionContent;
                if (this.ui.getComponentCount() > 0 && content == this.ui.getComponent(0)) {
                    content = null;
                }
                if (count > 0) {
                    this.editSelectionLink.setText(count == 1 ? Bundle.ObjectsFeatureModes_oneClassSelected() : Bundle.ObjectsFeatureModes_multipleClassesSelected(count));
                }
                if (content != null) {
                    this.ui.removeAll();
                    this.ui.add(content);
                    this.ui.doLayout();
                    this.ui.repaint();
                }
            }
        }
    }

    static abstract class ProjectClassesMode
    extends SampledMemoryMode {
        private final Collection<Lookup.Provider> selectedProjects = new HashSet<Lookup.Provider>();
        private static final String PROJECTS_FLAG = "PROJECTS_FLAG";
        private JComponent ui;
        private JButton editProjectLink;

        abstract Lookup.Provider getProject();

        ProjectClassesMode() {
            Collection<File> files = this.createFilesFromStorage();
            if (files.isEmpty()) {
                this.selectedProjects.add(this.getProject());
            } else {
                for (File file : files) {
                    Lookup.Provider project;
                    if (!file.exists()) continue;
                    FileObject fo = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
                    Lookup.Provider provider = project = fo == null ? null : ProjectUtilities.getProject((FileObject)fo);
                    if (fo == null) continue;
                    this.selectedProjects.add(project);
                }
                this.verifySelectedProjects(false);
            }
        }

        @Override
        String getID() {
            return "ProjectClassesMode";
        }

        @Override
        String getName() {
            return Bundle.ObjectsFeatureModes_projectClasses();
        }

        @Override
        void configureSettings(ProfilingSettings settings) {
            super.configureSettings(settings);
            StringBuilder filter = new StringBuilder();
            for (Lookup.Provider project : this.selectedProjects) {
                ProjectContentsSupport pcs = ProjectContentsSupport.get((Lookup.Provider)project);
                filter.append(pcs.getInstrumentationFilter(false));
                filter.append(" ");
                pcs.reset();
            }
            String s = filter.toString().replace(". ", ".* ").replace(".,", ".*,").trim();
            JavaTypeFilter f = new JavaTypeFilter(s, 10);
            settings.setInstrumentationFilter((GenericFilter)f);
        }

        @Override
        void confirmSettings() {
            if (this.ui != null) {
                assert (SwingUtilities.isEventDispatchThread());
                this.saveSelection();
            }
        }

        @Override
        boolean pendingChanges() {
            if (this.ui != null) {
                assert (SwingUtilities.isEventDispatchThread());
                if (!this.filesEquals(this.createFilesFromSelection(), this.createFilesFromStorage())) {
                    return true;
                }
            }
            return false;
        }

        @Override
        boolean currentSettingsValid() {
            assert (SwingUtilities.isEventDispatchThread());
            return !this.selectedProjects.isEmpty();
        }

        private void saveSelection() {
            Collection<File> files = this.createFilesFromSelection();
            if (files.isEmpty()) {
                this.storeFlag(PROJECTS_FLAG, null);
            } else {
                StringBuilder sb = new StringBuilder();
                for (File file : files) {
                    try {
                        sb.append(file.getCanonicalPath());
                    }
                    catch (IOException ex) {
                        sb.append(file.getAbsolutePath());
                    }
                    sb.append(File.pathSeparatorChar);
                }
                this.storeFlag(PROJECTS_FLAG, sb.toString());
            }
        }

        private Collection<File> createFilesFromStorage() {
            HashSet<File> files = new HashSet<File>();
            String s = this.readFlag(PROJECTS_FLAG, null);
            if (s != null) {
                String[] sa;
                for (String _s : sa = s.split(File.pathSeparator)) {
                    files.add(new File(_s));
                }
            }
            return files;
        }

        private Collection<File> createFilesFromSelection() {
            HashSet<File> files = new HashSet<File>();
            if (this.selectedProjects.size() > 1 || !this.selectedProjects.contains(this.getProject())) {
                for (Lookup.Provider project : this.selectedProjects) {
                    files.add(FileUtil.toFile((FileObject)ProjectUtilities.getProjectDirectory((Lookup.Provider)project)));
                }
            }
            return files;
        }

        private boolean filesEquals(Collection<File> files1, Collection<File> files2) {
            if (files1.size() != files2.size()) {
                return false;
            }
            for (File file1 : files1) {
                if (files2.contains(file1)) continue;
                return false;
            }
            return true;
        }

        private void verifySelectedProjects(boolean refreshLink) {
            if (this.selectedProjects.size() == 1 && this.selectedProjects.contains(this.getProject())) {
                return;
            }
            List<Lookup.Provider> projects = Arrays.asList(ProjectUtilities.getOpenedProjects());
            Iterator<Lookup.Provider> iterator = this.selectedProjects.iterator();
            while (iterator.hasNext()) {
                if (projects.contains(iterator.next())) continue;
                iterator.remove();
            }
            if (this.selectedProjects.isEmpty()) {
                this.selectedProjects.add(this.getProject());
            }
            if (refreshLink) {
                this.refreshProjectsLink();
            }
        }

        @Override
        JComponent getUI() {
            if (this.ui == null) {
                final ChangeListener projectsListener = new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent e) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                this.verifySelectedProjects(true);
                            }
                        });
                    }
                };
                this.ui = new SettingsPanel(){

                    @Override
                    public void addNotify() {
                        super.addNotify();
                        ProjectUtilities.addOpenProjectsListener((ChangeListener)projectsListener);
                    }

                    @Override
                    public void removeNotify() {
                        ProjectUtilities.removeOpenProjectsListener((ChangeListener)projectsListener);
                        super.removeNotify();
                    }
                };
                this.editProjectLink = new JButton(){

                    @Override
                    public void setText(String text) {
                        super.setText(Bundle.MethodsFeatureModes_editLink(text));
                    }

                    @Override
                    protected void fireActionPerformed(ActionEvent e) {
                        this.performEditProject();
                    }

                    @Override
                    public Dimension getMinimumSize() {
                        return this.getPreferredSize();
                    }

                    @Override
                    public Dimension getMaximumSize() {
                        return this.getPreferredSize();
                    }
                };
                this.editProjectLink.setContentAreaFilled(false);
                this.editProjectLink.setBorderPainted(true);
                this.editProjectLink.setMargin(new Insets(0, 0, 0, 0));
                this.editProjectLink.setBorder(BorderFactory.createEmptyBorder());
                this.editProjectLink.setCursor(Cursor.getPredefinedCursor(12));
                this.refreshProjectsLink();
                this.ui.add(this.editProjectLink);
            }
            return this.ui;
        }

        private void performEditProject() {
            new ProjectsSelector(this.selectedProjects){

                @Override
                protected void selectionChanged(Collection<Lookup.Provider> selected) {
                    selectedProjects.clear();
                    selectedProjects.addAll(selected);
                    this.refreshProjectsLink();
                    this.settingsChanged();
                }
            }.show(this.ui);
        }

        private void refreshProjectsLink() {
            if (this.editProjectLink == null) {
                return;
            }
            if (this.selectedProjects.size() == 1) {
                this.editProjectLink.setText(Bundle.MethodsFeatureModes_selectedProject(ProjectUtilities.getDisplayName((Lookup.Provider)this.selectedProjects.iterator().next())));
            } else {
                this.editProjectLink.setText(Bundle.MethodsFeatureModes_selectedProjects(this.selectedProjects.size()));
            }
        }
    }

    static abstract class AllClassesMode
    extends SampledMemoryMode {
        AllClassesMode() {
        }

        @Override
        String getID() {
            return "AllClassesMode";
        }

        @Override
        String getName() {
            return Bundle.ObjectsFeatureModes_allClasses();
        }

        @Override
        void configureSettings(ProfilingSettings settings) {
            super.configureSettings(settings);
            settings.setInstrumentationFilter((GenericFilter)new JavaTypeFilter());
        }
    }

    private static abstract class SampledMemoryMode
    extends MemoryMode {
        private SampledMemoryMode() {
        }

        @Override
        void configureSettings(ProfilingSettings settings) {
            super.configureSettings(settings);
            settings.setProfilingType(128);
        }

        @Override
        void confirmSettings() {
        }

        @Override
        boolean pendingChanges() {
            return false;
        }

        @Override
        boolean currentSettingsValid() {
            return true;
        }

        @Override
        JComponent getUI() {
            return null;
        }
    }

    private static abstract class MemoryMode
    extends FeatureMode {
        private MemoryMode() {
        }

        @Override
        void configureSettings(ProfilingSettings settings) {
        }
    }
}

