/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xdm.visitor;

import java.util.List;
import org.netbeans.modules.xml.xdm.nodes.Attribute;
import org.netbeans.modules.xml.xdm.nodes.Document;
import org.netbeans.modules.xml.xdm.nodes.Element;
import org.netbeans.modules.xml.xdm.nodes.Node;
import org.netbeans.modules.xml.xdm.nodes.NodeImpl;
import org.netbeans.modules.xml.xdm.nodes.Text;
import org.netbeans.modules.xml.xdm.nodes.Token;
import org.netbeans.modules.xml.xdm.nodes.TokenType;
import org.netbeans.modules.xml.xdm.visitor.XMLNodeVisitor;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class EndPositionFinderVisitor
implements XMLNodeVisitor {
    int position = 0;
    Node node;
    boolean found;

    public int findPosition(Node rootNode, Node node) {
        this.reset();
        this.node = node;
        rootNode.accept(this);
        return this.position;
    }

    public void reset() {
        this.position = 0;
        this.found = false;
    }

    @Override
    public void visit(Document doc) {
        this.position += this.getLengthOfTokens(doc);
        NodeList nodes = doc.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node n = (Node)nodes.item(i);
            n.accept(this);
            if (!this.found) continue;
            return;
        }
    }

    @Override
    public void visit(Element e) {
        this.position += this.getElementStartTokenLength(e, true);
        NamedNodeMap attrs = e.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node attr = (Node)attrs.item(i);
            attr.accept(this);
            if (!this.found) continue;
            return;
        }
        this.position += this.getStartTagWhiteSpaceTokensLength(e);
        ++this.position;
        NodeList children = e.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node n = (Node)children.item(i);
            n.accept(this);
            if (!this.found) continue;
            return;
        }
        this.position += this.getElementStartTokenLength(e, false);
        this.position += this.getEndTagWhiteSpaceTokensLength(e);
        ++this.position;
        if (e.getId() == this.node.getId()) {
            this.found = true;
        }
    }

    @Override
    public void visit(Text txt) {
        int txtLen = this.getLength(txt);
        if (txtLen > 0) {
            this.position += txtLen;
        }
        if (txt.getId() == this.node.getId()) {
            this.found = true;
        }
    }

    @Override
    public void visit(Attribute attr) {
        this.position += this.getLengthOfTokens(attr);
        if (attr.getId() == this.node.getId()) {
            this.found = true;
        }
    }

    private int getLength(Text n) {
        int len = 0;
        for (Token token : n.getTokens()) {
            len += token.getValue().length();
        }
        return len;
    }

    private int getElementStartTokenLength(Element element, boolean beginTag) {
        String value = "";
        List<Token> tokens = element.getTokens();
        for (Token token : tokens) {
            if (token.getType() != TokenType.TOKEN_ELEMENT_START_TAG) continue;
            String tokenValue = token.getValue();
            if (beginTag) {
                if (tokenValue.startsWith("</")) continue;
                value = tokenValue;
                continue;
            }
            if (!tokenValue.startsWith("</")) continue;
            value = tokenValue;
        }
        return value.length();
    }

    private int getStartTagWhiteSpaceTokensLength(NodeImpl node) {
        StringBuilder buf = new StringBuilder();
        List<Token> tokens = node.getTokens();
        for (Token token : tokens) {
            if (token.getType() == TokenType.TOKEN_ELEMENT_END_TAG) break;
            if (token.getType() != TokenType.TOKEN_WHITESPACE) continue;
            buf.append(token.getValue());
        }
        return buf.toString().length();
    }

    private int getEndTagWhiteSpaceTokensLength(NodeImpl node) {
        StringBuilder buf = new StringBuilder();
        List<Token> tokens = node.getTokens();
        boolean counting = false;
        for (Token token : tokens) {
            if (token.getType() == TokenType.TOKEN_ELEMENT_START_TAG && token.getValue().startsWith("</")) {
                counting = true;
            }
            if (!counting || token.getType() != TokenType.TOKEN_WHITESPACE) continue;
            buf.append(token.getValue());
        }
        return buf.toString().length();
    }

    private int getLeadingWhiteSpaces(Attribute attr) {
        Token firstToken = attr.getTokens().get(0);
        if (firstToken.getType() == TokenType.TOKEN_WHITESPACE) {
            return firstToken.getValue().length();
        }
        return 0;
    }

    private int getLengthOfTokens(NodeImpl node) {
        StringBuilder buf = new StringBuilder();
        List<Token> tokens = node.getTokens();
        for (Token token : tokens) {
            buf.append(token.getValue());
        }
        return buf.length();
    }
}

