/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.core.model.UpdateDhcpDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateDhcpOptionsRequest
extends BmcRequest<UpdateDhcpDetails> {
    private String dhcpId;
    private UpdateDhcpDetails updateDhcpDetails;
    private String ifMatch;

    public String getDhcpId() {
        return this.dhcpId;
    }

    public UpdateDhcpDetails getUpdateDhcpDetails() {
        return this.updateDhcpDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public UpdateDhcpDetails getBody$() {
        return this.updateDhcpDetails;
    }

    public Builder toBuilder() {
        return new Builder().dhcpId(this.dhcpId).updateDhcpDetails(this.updateDhcpDetails).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",dhcpId=").append(String.valueOf(this.dhcpId));
        sb.append(",updateDhcpDetails=").append(String.valueOf((Object)this.updateDhcpDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateDhcpOptionsRequest)) {
            return false;
        }
        UpdateDhcpOptionsRequest other = (UpdateDhcpOptionsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.dhcpId, other.dhcpId) && Objects.equals((Object)this.updateDhcpDetails, (Object)other.updateDhcpDetails) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.dhcpId == null ? 43 : this.dhcpId.hashCode());
        result = result * 59 + (this.updateDhcpDetails == null ? 43 : this.updateDhcpDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateDhcpOptionsRequest, UpdateDhcpDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String dhcpId = null;
        private UpdateDhcpDetails updateDhcpDetails = null;
        private String ifMatch = null;

        public Builder dhcpId(String dhcpId) {
            this.dhcpId = dhcpId;
            return this;
        }

        public Builder updateDhcpDetails(UpdateDhcpDetails updateDhcpDetails) {
            this.updateDhcpDetails = updateDhcpDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateDhcpOptionsRequest o) {
            this.dhcpId(o.getDhcpId());
            this.updateDhcpDetails(o.getUpdateDhcpDetails());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateDhcpOptionsRequest build() {
            UpdateDhcpOptionsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateDhcpDetails body) {
            this.updateDhcpDetails(body);
            return this;
        }

        public UpdateDhcpOptionsRequest buildWithoutInvocationCallback() {
            UpdateDhcpOptionsRequest request = new UpdateDhcpOptionsRequest();
            request.dhcpId = this.dhcpId;
            request.updateDhcpDetails = this.updateDhcpDetails;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

