/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.editor.parser;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.text.StyledDocument;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.lexer.Language;
import org.netbeans.modules.javascript2.editor.Utils;
import org.netbeans.modules.javascript2.editor.parser.JsErrorManager;
import org.netbeans.modules.javascript2.editor.parser.JsonParserResult;
import org.netbeans.modules.javascript2.editor.parser.SanitizingParser;
import org.netbeans.modules.javascript2.json.api.JsonOptionsQuery;
import org.netbeans.modules.javascript2.json.parser.JsonLexer;
import org.netbeans.modules.javascript2.lexer.api.JsTokenId;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.spi.lexer.MutableTextInput;
import org.netbeans.spi.lexer.TokenHierarchyControl;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.NbDocument;
import org.openide.util.Pair;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public class JsonParser
extends SanitizingParser<JsonParserResult>
implements PropertyChangeListener {
    private static final RequestProcessor LEXER_RP = new RequestProcessor(JsonParser.class);
    private final AtomicReference<Pair<FileObject, JsonOptionsQuery.Result>> options = new AtomicReference();
    private final Boolean enforcedAllowComments;

    public JsonParser() {
        this((Boolean)null);
    }

    JsonParser(Boolean enforcedAllowComments) {
        super((Language<JsTokenId>)JsTokenId.jsonLanguage());
        this.enforcedAllowComments = enforcedAllowComments;
    }

    @Override
    protected String getDefaultScriptName() {
        return "json.json";
    }

    @Override
    protected JsonParserResult parseSource(SanitizingParser.Context ctx, JsErrorManager errorManager) throws Exception {
        boolean allowComments;
        Snapshot snapshot = ctx.getSnapshot();
        String text = ctx.getSource();
        FileObject fo = snapshot.getSource().getFileObject();
        if (this.enforcedAllowComments != null) {
            allowComments = this.enforcedAllowComments;
        } else if (fo != null) {
            JsonOptionsQuery.Result opts = Optional.ofNullable(this.options.get()).map(p -> (JsonOptionsQuery.Result)p.second()).orElse(null);
            if (opts == null && this.options.compareAndSet(null, (Pair<FileObject, JsonOptionsQuery.Result>)Pair.of((Object)fo, (Object)(opts = JsonOptionsQuery.getOptions((FileObject)fo))))) {
                opts.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)opts));
            }
            allowComments = opts.isCommentSupported();
        } else {
            allowComments = false;
        }
        JsonLexer lex = new JsonLexer((CharStream)new ANTLRInputStream(text), allowComments);
        lex.removeErrorListeners();
        lex.addErrorListener((ANTLRErrorListener)errorManager);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lex);
        org.netbeans.modules.javascript2.json.parser.JsonParser parser = new org.netbeans.modules.javascript2.json.parser.JsonParser((TokenStream)tokens);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)errorManager);
        return new JsonParserResult(snapshot, parser.json());
    }

    @Override
    @NonNull
    protected JsonParserResult createErrorResult(Snapshot snapshot) {
        return new JsonParserResult(snapshot, null);
    }

    @Override
    protected String getMimeType() {
        return "text/x-json";
    }

    @Override
    protected SanitizingParser.Sanitize getSanitizeStrategy() {
        return SanitizingParser.Sanitize.NEVER;
    }

    @Override
    public void propertyChange(@NonNull PropertyChangeEvent evt) {
        if ("commentSupported".equals(evt.getPropertyName())) {
            this.fireChange();
            Optional<FileObject> maybeFile = Optional.ofNullable(this.options.get()).map(p -> (FileObject)p.first());
            maybeFile.map(fo -> {
                try {
                    return (EditorCookie)DataObject.find((FileObject)fo).getLookup().lookup(EditorCookie.class);
                }
                catch (DataObjectNotFoundException e) {
                    return null;
                }
            }).map(ec -> ec.getDocument()).ifPresent(doc -> Optional.ofNullable((MutableTextInput)doc.getProperty(MutableTextInput.class)).ifPresent(mti -> {
                TokenHierarchyControl control = mti.tokenHierarchyControl();
                LEXER_RP.execute(() -> NbDocument.runAtomic((StyledDocument)doc, () -> control.rebuild()));
            }));
            Utils.refreshTaskListIndex(maybeFile.orElse(null));
        }
    }
}

