/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.CloseButton;
import org.netbeans.lib.profiler.ui.swing.EditableHistoryCombo;
import org.netbeans.lib.profiler.ui.swing.InvisibleToolbar;
import org.netbeans.lib.profiler.ui.swing.ProfilerTable;
import org.netbeans.lib.profiler.ui.swing.ProfilerTreeTable;
import org.netbeans.modules.profiler.api.ActionsSupport;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.spi.ActionsSupportProvider;

public final class SearchUtils {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.swing.Bundle");
    public static final String ACTION_FIND = messages.getString("SearchUtils_ActionFind");
    private static final String MSG_NODATA = messages.getString("SearchUtils_MsgNoData");
    private static final String MSG_NOTFOUND = messages.getString("SearchUtils_MsgNotFound");
    private static final String SIDEBAR_CAPTION = messages.getString("SearchUtils_SidebarCaption");
    private static final String BTN_PREVIOUS = messages.getString("SearchUtils_BtnPrevious");
    private static final String BTN_PREVIOUS_TOOLTIP = messages.getString("SearchUtils_BtnPreviousTooltip");
    private static final String BTN_NEXT = messages.getString("SearchUtils_BtnNext");
    private static final String BTN_NEXT_TOOLTIP = messages.getString("SearchUtils_BtnNextTooltip");
    private static final String BTN_MATCH_CASE_TOOLTIP = messages.getString("SearchUtils_BtnMatchCaseTooltip");
    private static final String BTN_CLOSE_TOOLTIP = messages.getString("SearchUtils_BtnCloseTooltip");
    public static final String FIND_ACTION_KEY = "find-action-key";
    public static final String FIND_NEXT_ACTION_KEY = "find-next-action-key";
    public static final String FIND_PREV_ACTION_KEY = "find-prev-action-key";
    public static final String FIND_SEL_ACTION_KEY = "find-sel-action-key";
    private static final String LAST_FIND_TEXT = "last-find-text";
    private static final String LAST_FIND_MATCH_CASE = "last-find-match-case";
    private static final String FIND_TREE_HELPER = "find-tree-helper";

    public static boolean findString(ProfilerTable table, String text) {
        return SearchUtils.findString(table, text, true, true);
    }

    public static boolean findString(ProfilerTable table, String text, boolean matchCase, boolean next) {
        boolean fromSelection;
        int rowCount = table.getRowCount();
        ProfilerTreeTable treeTable = null;
        if (rowCount == 0) {
            ProfilerDialogs.displayWarning((String)MSG_NODATA, (String)ACTION_FIND, null);
            return false;
        }
        if (rowCount == 1) {
            if (!(table instanceof ProfilerTreeTable)) {
                return false;
            }
            treeTable = (ProfilerTreeTable)table;
            TreeNode node = treeTable.getValueForRow(0);
            if (node == null || node.isLeaf()) {
                return false;
            }
        }
        if (treeTable != null || table instanceof ProfilerTreeTable) {
            if (treeTable == null) {
                treeTable = (ProfilerTreeTable)table;
            }
            return SearchUtils.findString(treeTable, text, matchCase, next, null);
        }
        table.putClientProperty(LAST_FIND_TEXT, text);
        table.putClientProperty(LAST_FIND_MATCH_CASE, matchCase);
        if (!matchCase) {
            text = text.toLowerCase();
        }
        int mainColumn = table.convertColumnIndexToView(table.getMainColumn());
        int selectedRow = table.getSelectedRow();
        boolean bl = fromSelection = selectedRow != -1;
        selectedRow = !fromSelection ? (next ? 0 : rowCount - 1) : (next ? table.getNextRow(selectedRow) : table.getPreviousRow(selectedRow));
        int searchSteps = fromSelection ? rowCount - 1 : rowCount;
        for (int i = 0; i < searchSteps; ++i) {
            String value = table.getStringValue(selectedRow, mainColumn);
            if (!matchCase) {
                value = value.toLowerCase();
            }
            if (value.contains(text)) {
                table.selectRow(selectedRow, true);
                return true;
            }
            selectedRow = next ? table.getNextRow(selectedRow) : table.getPreviousRow(selectedRow);
        }
        ProfilerDialogs.displayInfo((String)MSG_NOTFOUND, (String)ACTION_FIND, null);
        return false;
    }

    public static boolean findString(ProfilerTreeTable treeTable, String text, boolean matchCase, boolean next, TreeHelper helper) {
        treeTable.putClientProperty(LAST_FIND_TEXT, text);
        treeTable.putClientProperty(LAST_FIND_MATCH_CASE, matchCase);
        if (!matchCase) {
            text = text.toLowerCase();
        }
        int mainColumn = treeTable.convertColumnIndexToView(treeTable.getMainColumn());
        TreePath selectedPath = treeTable.getSelectionPath();
        if (selectedPath == null) {
            selectedPath = treeTable.getRootPath();
        }
        boolean firstPath = true;
        TreePath startPath = null;
        int nodeType = helper == null ? 10 : helper.getNodeType(selectedPath);
        do {
            selectedPath = next ? treeTable.getNextPath(selectedPath, TreeHelper.isDown(nodeType)) : treeTable.getPreviousPath(selectedPath, TreeHelper.isDown(nodeType));
            TreeNode node = (TreeNode)selectedPath.getLastPathComponent();
            if (helper != null) {
                nodeType = helper.getNodeType(node);
            }
            if (TreeHelper.isSearch(nodeType)) {
                String nodeValue = treeTable.getStringValue(node, mainColumn);
                if (!matchCase) {
                    nodeValue = nodeValue.toLowerCase();
                }
                if (nodeValue.contains(text)) {
                    treeTable.selectPath(selectedPath, true);
                    return true;
                }
            }
            if (startPath == null) {
                startPath = selectedPath;
                continue;
            }
            if (!firstPath) continue;
            firstPath = false;
        } while (firstPath || !selectedPath.equals(startPath));
        ProfilerDialogs.displayInfo((String)MSG_NOTFOUND, (String)ACTION_FIND, null);
        return false;
    }

    public static void enableSearchActions(final ProfilerTable table) {
        ActionMap actionMap = table.getActionMap();
        InputMap inputMap = table.getInputMap();
        AbstractAction nextAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Object text = table.getClientProperty(SearchUtils.LAST_FIND_TEXT);
                        Object matchCase = table.getClientProperty(SearchUtils.LAST_FIND_MATCH_CASE);
                        if (text != null && matchCase != null) {
                            TreeHelper helper = (TreeHelper)table.getClientProperty(SearchUtils.FIND_TREE_HELPER);
                            if (helper == null) {
                                SearchUtils.findString(table, text.toString(), Boolean.TRUE == matchCase, true);
                            } else {
                                SearchUtils.findString((ProfilerTreeTable)table, text.toString(), Boolean.TRUE == matchCase, true, helper);
                            }
                        }
                    }
                });
            }
        };
        ActionsSupport.registerAction((String)FIND_NEXT_ACTION_KEY, (Action)nextAction, (ActionMap)actionMap, (InputMap)inputMap);
        AbstractAction prevAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Object text = table.getClientProperty(SearchUtils.LAST_FIND_TEXT);
                        Object matchCase = table.getClientProperty(SearchUtils.LAST_FIND_MATCH_CASE);
                        if (text != null && matchCase != null) {
                            TreeHelper helper = (TreeHelper)table.getClientProperty(SearchUtils.FIND_TREE_HELPER);
                            if (helper == null) {
                                SearchUtils.findString(table, text.toString(), Boolean.TRUE == matchCase, false);
                            } else {
                                SearchUtils.findString((ProfilerTreeTable)table, text.toString(), Boolean.TRUE == matchCase, false, helper);
                            }
                        }
                    }
                });
            }
        };
        ActionsSupport.registerAction((String)FIND_PREV_ACTION_KEY, (Action)prevAction, (ActionMap)actionMap, (InputMap)inputMap);
        AbstractAction selAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        int selectedRow = table.getSelectedRow();
                        if (selectedRow == -1) {
                            return;
                        }
                        int mainColumn = table.convertColumnIndexToView(table.getMainColumn());
                        TreeHelper helper = (TreeHelper)table.getClientProperty(SearchUtils.FIND_TREE_HELPER);
                        if (helper == null) {
                            SearchUtils.findString(table, table.getStringValue(selectedRow, mainColumn), true, true);
                        } else {
                            SearchUtils.findString((ProfilerTreeTable)table, table.getStringValue(selectedRow, mainColumn), true, true, helper);
                        }
                    }
                });
            }
        };
        ActionsSupport.registerAction((String)FIND_SEL_ACTION_KEY, (Action)selAction, (ActionMap)actionMap, (InputMap)inputMap);
    }

    public static JComponent createSearchPanel(ProfilerTable table) {
        return SearchUtils.createSearchPanel(table, null);
    }

    public static JComponent createSearchPanel(ProfilerTable table, Component[] options) {
        return SearchUtils.createSearchPanelImpl(table, null, options);
    }

    public static JComponent createSearchPanel(ProfilerTreeTable table, TreeHelper helper, Component[] options) {
        return SearchUtils.createSearchPanelImpl(table, helper, options);
    }

    private static JComponent createSearchPanelImpl(final ProfilerTable table, final TreeHelper helper, Component[] options) {
        InvisibleToolbar toolbar = new InvisibleToolbar();
        if (UIUtils.isWindowsModernLookAndFeel()) {
            toolbar.setBorder(BorderFactory.createEmptyBorder(2, 2, 1, 2));
        } else if (!UIUtils.isNimbusLookAndFeel() && !UIUtils.isAquaLookAndFeel()) {
            toolbar.setBorder(BorderFactory.createEmptyBorder(1, 2, 1, 2));
        }
        toolbar.add(Box.createHorizontalStrut(6));
        toolbar.add(new JLabel(SIDEBAR_CAPTION));
        toolbar.add(Box.createHorizontalStrut(3));
        final EditableHistoryCombo combo = new EditableHistoryCombo();
        final JTextComponent textC = combo.getTextComponent();
        JPanel comboContainer = new JPanel(new BorderLayout());
        comboContainer.add((Component)combo, "Center");
        comboContainer.setMinimumSize(combo.getMinimumSize());
        comboContainer.setPreferredSize(combo.getPreferredSize());
        comboContainer.setMaximumSize(combo.getMaximumSize());
        toolbar.add(comboContainer);
        toolbar.add(Box.createHorizontalStrut(5));
        KeyStroke escKey = KeyStroke.getKeyStroke(27, 0);
        KeyStroke prevKey = KeyStroke.getKeyStroke(10, 1);
        KeyStroke nextKey = KeyStroke.getKeyStroke(10, 0);
        final JToggleButton matchCase = new JToggleButton(Icons.getIcon((String)"GeneralIcons.MatchCase"));
        matchCase.setToolTipText(BTN_MATCH_CASE_TOOLTIP);
        final JButton prev = new JButton(BTN_PREVIOUS, Icons.getIcon((String)"GeneralIcons.FindPrevious")){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                super.fireActionPerformed(e);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        String search = SearchUtils.getSearchString(combo);
                        if (search == null || search.isEmpty()) {
                            return;
                        }
                        if (helper == null) {
                            if (SearchUtils.findString(table, search, matchCase.isSelected(), false)) {
                                combo.addItem(search);
                            }
                        } else if (SearchUtils.findString((ProfilerTreeTable)table, search, matchCase.isSelected(), false, helper)) {
                            combo.addItem(search);
                        }
                    }
                });
            }
        };
        prev.putClientProperty("JButton.buttonType", "segmented");
        prev.putClientProperty("JButton.segmentPosition", "first");
        String prevAccelerator = ActionsSupport.keyAcceleratorString((KeyStroke)prevKey);
        prev.setToolTipText(MessageFormat.format(BTN_PREVIOUS_TOOLTIP, prevAccelerator));
        prev.setEnabled(false);
        toolbar.add(prev);
        if (!UIUtils.isAquaLookAndFeel()) {
            toolbar.add(Box.createHorizontalStrut(2));
        }
        final JButton next = new JButton(BTN_NEXT, Icons.getIcon((String)"GeneralIcons.FindNext")){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                super.fireActionPerformed(e);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        String search = SearchUtils.getSearchString(combo);
                        if (search == null || search.isEmpty()) {
                            return;
                        }
                        if (helper == null) {
                            if (SearchUtils.findString(table, search, matchCase.isSelected(), true)) {
                                combo.addItem(search);
                            }
                        } else if (SearchUtils.findString((ProfilerTreeTable)table, search, matchCase.isSelected(), true, helper)) {
                            combo.addItem(search);
                        }
                    }
                });
            }
        };
        next.putClientProperty("JButton.buttonType", "segmented");
        next.putClientProperty("JButton.segmentPosition", "last");
        String nextAccelerator = ActionsSupport.keyAcceleratorString((KeyStroke)nextKey);
        next.setToolTipText(MessageFormat.format(BTN_NEXT_TOOLTIP, nextAccelerator));
        next.setEnabled(false);
        toolbar.add(next);
        toolbar.add(Box.createHorizontalStrut(2));
        ((JToolBar)toolbar).addSeparator();
        toolbar.add(Box.createHorizontalStrut(1));
        toolbar.add(matchCase);
        if (options != null) {
            for (Component option : options) {
                toolbar.add(option);
            }
        }
        toolbar.add(Box.createHorizontalStrut(2));
        combo.setOnTextChangeHandler(new Runnable(){

            @Override
            public void run() {
                boolean enable = !combo.getText().trim().isEmpty();
                prev.setEnabled(enable);
                next.setEnabled(enable);
            }
        });
        final JPanel panel = new JPanel(new BorderLayout()){

            @Override
            public void setVisible(boolean visible) {
                super.setVisible(visible);
                if (!visible) {
                    table.requestFocusInWindow();
                }
            }

            @Override
            public boolean requestFocusInWindow() {
                if (textC != null) {
                    textC.selectAll();
                }
                return combo.requestFocusInWindow();
            }
        };
        panel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, UIManager.getColor("controlShadow")));
        panel.add((Component)toolbar, "Center");
        final Runnable hider = new Runnable(){

            @Override
            public void run() {
                panel.setVisible(false);
            }
        };
        JButton closeButton = CloseButton.create(hider);
        String escAccelerator = ActionsSupport.keyAcceleratorString((KeyStroke)escKey);
        closeButton.setToolTipText(MessageFormat.format(BTN_CLOSE_TOOLTIP, escAccelerator));
        panel.add((Component)closeButton, "East");
        String HIDE = "hide-action";
        InputMap inputMap = panel.getInputMap(1);
        AbstractAction hiderAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                hider.run();
            }
        };
        panel.getActionMap().put(HIDE, hiderAction);
        inputMap.put(escKey, HIDE);
        if (textC != null) {
            inputMap = textC.getInputMap();
            ActionMap actionMap = textC.getActionMap();
            String NEXT = "search-next-action";
            AbstractAction nextAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (combo.isPopupVisible()) {
                        combo.hidePopup();
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (next.isEnabled()) {
                                next.doClick();
                            }
                        }
                    });
                }
            };
            actionMap.put(NEXT, nextAction);
            inputMap.put(nextKey, NEXT);
            KeyStroke nextKey2 = ActionsSupport.registerAction((String)FIND_NEXT_ACTION_KEY, (Action)nextAction, (ActionMap)actionMap, (InputMap)inputMap);
            String nextAccelerator2 = ActionsSupport.keyAcceleratorString((KeyStroke)nextKey2);
            if (nextAccelerator2 != null) {
                next.setToolTipText(MessageFormat.format(BTN_NEXT_TOOLTIP, nextAccelerator + ", " + nextAccelerator2));
            }
            String PREV = "search-prev-action";
            AbstractAction prevAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (combo.isPopupVisible()) {
                        combo.hidePopup();
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (next.isEnabled()) {
                                prev.doClick();
                            }
                        }
                    });
                }
            };
            actionMap.put(PREV, prevAction);
            inputMap.put(prevKey, PREV);
            KeyStroke prevKey2 = ActionsSupport.registerAction((String)FIND_PREV_ACTION_KEY, (Action)prevAction, (ActionMap)actionMap, (InputMap)inputMap);
            String prevAccelerator2 = ActionsSupport.keyAcceleratorString((KeyStroke)prevKey2);
            if (prevAccelerator2 != null) {
                prev.setToolTipText(MessageFormat.format(BTN_PREVIOUS_TOOLTIP, prevAccelerator + ", " + prevAccelerator2));
            }
        }
        if (helper != null) {
            table.putClientProperty(FIND_TREE_HELPER, helper);
        }
        return panel;
    }

    private static String getSearchString(EditableHistoryCombo combo) {
        String search = combo.getText();
        return search == null ? null : search.trim();
    }

    private SearchUtils() {
    }

    public static abstract class TreeHelper {
        public static final int NODE_SEARCH_DOWN = 10;
        public static final int NODE_SEARCH_NEXT = 11;
        public static final int NODE_SKIP_DOWN = 100;
        public static final int NODE_SKIP_NEXT = 101;

        public abstract int getNodeType(TreeNode var1);

        int getNodeType(TreePath path) {
            return this.getNodeType((TreeNode)path.getLastPathComponent());
        }

        static boolean isSearch(int type) {
            return type < 100;
        }

        static boolean isDown(int type) {
            return (type & 1) == 0;
        }
    }

    private static interface Support {

        public static final class SearchActionProvider
        extends ActionsSupportProvider {
            public KeyStroke registerAction(String actionKey, Action action, ActionMap actionMap, InputMap inputMap) {
                KeyStroke ks = null;
                if (SearchUtils.FIND_ACTION_KEY.equals(actionKey)) {
                    ks = KeyStroke.getKeyStroke(71, 2);
                } else if (SearchUtils.FIND_NEXT_ACTION_KEY.equals(actionKey)) {
                    ks = KeyStroke.getKeyStroke(114, 0);
                } else if (SearchUtils.FIND_PREV_ACTION_KEY.equals(actionKey)) {
                    ks = KeyStroke.getKeyStroke(114, 1);
                } else if (SearchUtils.FIND_SEL_ACTION_KEY.equals(actionKey)) {
                    ks = KeyStroke.getKeyStroke(114, 2);
                }
                if (ks != null) {
                    actionMap.put(actionKey, action);
                    inputMap.put(ks, actionKey);
                }
                return ks;
            }
        }
    }
}

