/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.spi.support.CancelSupport;
import org.netbeans.modules.php.api.PhpVersion;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.AnonymousObjectVariable;
import org.netbeans.modules.php.editor.parser.astnodes.ArrayCreation;
import org.netbeans.modules.php.editor.parser.astnodes.DereferencedArrayAccess;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.FieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.FormalParameter;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.LambdaFunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.MethodDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.MethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.ReflectionVariable;
import org.netbeans.modules.php.editor.parser.astnodes.Scalar;
import org.netbeans.modules.php.editor.parser.astnodes.StaticMethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.TraitDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.UseTraitStatement;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.netbeans.modules.php.editor.verification.UnhandledErrorRule;
import org.netbeans.modules.php.editor.verification.VerificationError;
import org.openide.filesystems.FileObject;

public class PHP54UnhandledError
extends UnhandledErrorRule {
    @Override
    public void invoke(PHPRuleContext context, List<Error> errors) {
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        if (phpParseResult.getProgram() == null) {
            return;
        }
        FileObject fileObject = phpParseResult.getSnapshot().getSource().getFileObject();
        if (fileObject != null && PHP54UnhandledError.appliesTo(fileObject)) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            CheckVisitor checkVisitor = new CheckVisitor(fileObject);
            phpParseResult.getProgram().accept(checkVisitor);
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            errors.addAll(checkVisitor.getErrors());
        }
    }

    public static boolean appliesTo(FileObject fileObject) {
        return CodeUtils.isPhpVersionLessThan(fileObject, PhpVersion.PHP_54);
    }

    public String getDisplayName() {
        return Bundle.PHP54VersionErrorHintDispName();
    }

    private static class CheckVisitor
    extends DefaultVisitor {
        private static final String BINARY_PREFIX = "0b";
        private final List<VerificationError> errors = new ArrayList<VerificationError>();
        private final FileObject fileObject;
        private boolean checkAnonymousObjectVariable;

        public CheckVisitor(FileObject fileObject) {
            this.fileObject = fileObject;
        }

        public Collection<VerificationError> getErrors() {
            return Collections.unmodifiableCollection(this.errors);
        }

        @Override
        public void visit(TraitDeclaration node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            Identifier name = node.getName();
            if (name != null) {
                this.createError(name);
            } else {
                this.createError(node);
            }
        }

        @Override
        public void visit(UseTraitStatement node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.createError(node);
        }

        @Override
        public void visit(MethodInvocation node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.checkAnonymousObjectVariable = true;
            super.visit(node);
            this.checkAnonymousObjectVariable = false;
        }

        @Override
        public void visit(FieldAccess node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.checkAnonymousObjectVariable = true;
            super.visit(node);
            this.checkAnonymousObjectVariable = false;
        }

        @Override
        public void visit(AnonymousObjectVariable node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            if (this.checkAnonymousObjectVariable) {
                this.createError(node);
            }
        }

        @Override
        public void visit(DereferencedArrayAccess node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.createError(node);
        }

        @Override
        public void visit(Scalar node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            if (node.getScalarType().equals((Object)Scalar.Type.REAL) && node.getStringValue().startsWith(BINARY_PREFIX)) {
                this.createError(node);
            }
            if (node.getScalarType().equals((Object)Scalar.Type.SYSTEM) && "__TRAIT__".equals(node.getStringValue())) {
                this.createError(node);
            }
        }

        @Override
        public void visit(StaticMethodInvocation node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            Expression name = node.getMethod().getFunctionName().getName();
            if (name instanceof ReflectionVariable) {
                this.createError(name);
            }
        }

        @Override
        public void visit(LambdaFunctionDeclaration node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            if (node.isStatic()) {
                this.createError(node);
            } else {
                this.checkCallableType(node.getFormalParameters());
            }
        }

        @Override
        public void visit(ArrayCreation node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            ArrayCreation.Type type = node.getType();
            if (type == ArrayCreation.Type.NEW) {
                this.createError(node);
            } else {
                super.visit(node);
            }
        }

        @Override
        public void visit(FunctionDeclaration node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            if (!this.checkCallableType(node.getFormalParameters())) {
                super.visit(node);
            }
        }

        @Override
        public void visit(MethodDeclaration node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            if (!this.checkCallableType(node.getFunction().getFormalParameters())) {
                super.visit(node);
            }
        }

        private boolean checkCallableType(List<FormalParameter> formalParameters) {
            for (FormalParameter formalParameter : formalParameters) {
                String typeName = CodeUtils.extractUnqualifiedTypeName(formalParameter);
                if (!"callable".equals(typeName)) continue;
                this.createError(formalParameter);
                return true;
            }
            return false;
        }

        private void createError(int startOffset, int endOffset) {
            PHP54VersionError error = new PHP54VersionError(this.fileObject, startOffset, endOffset);
            this.errors.add(error);
        }

        private void createError(ASTNode node) {
            this.createError(node.getStartOffset(), node.getEndOffset());
            super.visit(node);
        }
    }

    private static final class PHP54VersionError
    extends VerificationError {
        private static final String KEY = "Php.Version.54";

        private PHP54VersionError(FileObject fileObject, int startOffset, int endOffset) {
            super(fileObject, startOffset, endOffset);
        }

        public String getDisplayName() {
            return Bundle.CheckPHP54VerDisp();
        }

        public String getDescription() {
            return Bundle.CheckPHP54VerDesc();
        }

        public String getKey() {
            return KEY;
        }
    }
}

