/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.micronaut.symbol;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.indexing.Context;
import org.netbeans.modules.parsing.spi.indexing.EmbeddingIndexer;
import org.netbeans.modules.parsing.spi.indexing.EmbeddingIndexerFactory;
import org.netbeans.modules.parsing.spi.indexing.Indexable;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Pair;
import org.openide.util.WeakListeners;

public final class MicronautSymbolFinder
extends EmbeddingIndexer
implements PropertyChangeListener {
    public static final String NAME = "mn";
    public static final int VERSION = 1;
    public static final MicronautSymbolFinder INSTANCE = new MicronautSymbolFinder();
    public static final String[] META_ANNOTATIONS = new String[]{"io.micronaut.http.annotation.HttpMethodMapping", "io.micronaut.context.annotation.Bean", "jakarta.inject.Qualifier", "jakarta.inject.Scope"};
    private final Map<Project, Boolean> map = new WeakHashMap<Project, Boolean>();

    protected void index(Indexable indexable, Parser.Result parserResult, Context context) {
        CompilationController cc = CompilationController.get((Parser.Result)parserResult);
        if (this.initialize(cc)) {
            try {
                if (cc.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED).compareTo((Enum)JavaSource.Phase.ELEMENTS_RESOLVED) >= 0) {
                    this.store(context.getIndexFolder(), indexable.getURL(), indexable.getRelativePath(), MicronautSymbolFinder.scan(cc, false));
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        MicronautSymbolFinder micronautSymbolFinder = this;
        synchronized (micronautSymbolFinder) {
            this.map.clear();
        }
    }

    private synchronized boolean initialize(CompilationController cc) {
        Project p = FileOwnerQuery.getOwner((FileObject)cc.getFileObject());
        if (p == null) {
            return false;
        }
        Boolean ret = this.map.get(p);
        if (ret == null) {
            ClassPath cp = ClassPath.getClassPath((FileObject)p.getProjectDirectory(), (String)"classpath/compile");
            cp.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)cp));
            ret = cp.findResource("io/micronaut/http/annotation/HttpMethodMapping.class") != null;
            this.map.put(p, ret);
        }
        return ret;
    }

    public static List<SymbolLocation> scan(final CompilationController cc, final boolean selectEndpointAnnotation) {
        final ArrayList<SymbolLocation> ret = new ArrayList<SymbolLocation>();
        final SourcePositions sp = cc.getTrees().getSourcePositions();
        TreePathScanner<Void, String> scanner = new TreePathScanner<Void, String>(){

            @Override
            public Void visitClass(ClassTree node, String path) {
                Pair metaAnnotated;
                TreePath treePath = this.getCurrentPath();
                Element cls = cc.getTrees().getElement(treePath);
                if (cls != null && (metaAnnotated = MicronautSymbolFinder.isMetaAnnotated(cls)) != null) {
                    Element annEl = ((AnnotationMirror)metaAnnotated.first()).getAnnotationType().asElement();
                    if ("io.micronaut.http.annotation.Controller".contentEquals(((TypeElement)annEl).getQualifiedName())) {
                        path = "";
                        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : ((AnnotationMirror)metaAnnotated.first()).getElementValues().entrySet()) {
                            if (!"value".contentEquals(entry.getKey().getSimpleName())) continue;
                            path = (String)entry.getValue().getValue();
                        }
                    }
                    String name = "@+ '" + MicronautSymbolFinder.getBeanName(node.getSimpleName().toString()) + "' (@" + annEl.getSimpleName() + (metaAnnotated.second() != null ? " <: @" + ((AnnotationMirror)metaAnnotated.second()).getAnnotationType().asElement().getSimpleName() : "") + ") " + node.getSimpleName();
                    int[] span = cc.getTreeUtilities().findNameSpan(node);
                    ret.add(new SymbolLocation(name, (int)sp.getStartPosition(treePath.getCompilationUnit(), node), (int)sp.getEndPosition(treePath.getCompilationUnit(), node), span[0], span[1]));
                }
                return (Void)super.visitClass(node, path);
            }

            @Override
            public Void visitMethod(MethodTree node, String path) {
                if (path != null) {
                    TreePath treePath = this.getCurrentPath();
                    MthIterator it = new MthIterator(cc.getTrees().getElement(treePath), cc.getElements(), cc.getTypes());
                    while (it.hasNext()) {
                        ExecutableElement ee = it.next();
                        for (AnnotationMirror annotationMirror : ee.getAnnotationMirrors()) {
                            String method = MicronautSymbolFinder.getEndpointMethod((TypeElement)annotationMirror.getAnnotationType().asElement());
                            if (method == null) continue;
                            ArrayList<String> ids = new ArrayList<String>();
                            Map<? extends ExecutableElement, ? extends AnnotationValue> values = annotationMirror.getElementValues();
                            if (values.isEmpty()) {
                                ids.add("/");
                            } else {
                                for (Map.Entry<ExecutableElement, AnnotationValue> entry : values.entrySet()) {
                                    if ("value".contentEquals(entry.getKey().getSimpleName()) || "uri".contentEquals(entry.getKey().getSimpleName())) {
                                        ids.add((String)entry.getValue().getValue());
                                        continue;
                                    }
                                    if (!"uris".contentEquals(entry.getKey().getSimpleName())) continue;
                                    for (AnnotationValue av : (List)entry.getValue().getValue()) {
                                        ids.add((String)av.getValue());
                                    }
                                }
                            }
                            for (Map.Entry<ExecutableElement, AnnotationValue> entry : ids) {
                                Tree tree;
                                String name = '@' + path + entry + " -- " + method;
                                int[] span = cc.getTreeUtilities().findNameSpan(node);
                                if (selectEndpointAnnotation && (tree = cc.getTrees().getTree(ee, annotationMirror)) != null) {
                                    span = new int[]{(int)sp.getStartPosition(treePath.getCompilationUnit(), tree), (int)sp.getEndPosition(treePath.getCompilationUnit(), tree)};
                                }
                                ret.add(new SymbolLocation(name, (int)sp.getStartPosition(treePath.getCompilationUnit(), node), (int)sp.getEndPosition(treePath.getCompilationUnit(), node), span[0], span[1]));
                            }
                            return null;
                        }
                    }
                }
                return null;
            }
        };
        scanner.scan(cc.getCompilationUnit(), null);
        return ret;
    }

    private void store(FileObject indexFolder, URL url, String resourceName, List<SymbolLocation> symbols) {
        File cacheRoot = FileUtil.toFile((FileObject)indexFolder);
        File output = new File(cacheRoot, resourceName + ".mn");
        if (symbols.isEmpty()) {
            if (output.exists()) {
                output.delete();
            }
        } else {
            output.getParentFile().mkdirs();
            try (PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(output), StandardCharsets.UTF_8));){
                pw.print("url: ");
                pw.println(url.toString());
                for (SymbolLocation symbol : symbols) {
                    pw.print("symbol: ");
                    pw.print(symbol.name);
                    pw.print(':');
                    pw.print(symbol.selectionStart);
                    pw.print('-');
                    pw.println(symbol.selectionEnd);
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private static Pair<AnnotationMirror, AnnotationMirror> isMetaAnnotated(Element el) {
        for (AnnotationMirror annotationMirror : el.getAnnotationMirrors()) {
            Element annEl = annotationMirror.getAnnotationType().asElement();
            Name name = ((TypeElement)annEl).getQualifiedName();
            String annotation = MicronautSymbolFinder.check(name);
            if (annotation != null) {
                return Pair.of((Object)annotationMirror, null);
            }
            for (AnnotationMirror annotationMirror2 : annEl.getAnnotationMirrors()) {
                Element metaAnnEl = annotationMirror2.getAnnotationType().asElement();
                String metaAnnotation = MicronautSymbolFinder.check(((TypeElement)metaAnnEl).getQualifiedName());
                if (metaAnnotation == null) continue;
                return Pair.of((Object)annotationMirror, (Object)annotationMirror2);
            }
        }
        return null;
    }

    private static String check(Name name) {
        for (String ann : META_ANNOTATIONS) {
            if (!ann.contentEquals(name)) continue;
            return ann;
        }
        return null;
    }

    private static String getEndpointMethod(TypeElement te) {
        for (AnnotationMirror annotationMirror : te.getAnnotationMirrors()) {
            Element el = annotationMirror.getAnnotationType().asElement();
            if (!"io.micronaut.http.annotation.HttpMethodMapping".contentEquals(((TypeElement)el).getQualifiedName())) continue;
            return te.getSimpleName().toString().toUpperCase();
        }
        return null;
    }

    public static String getBeanName(String typeName) {
        if (typeName.length() > 0 && Character.isUpperCase(typeName.charAt(0)) && (typeName.length() == 1 || !Character.isUpperCase(typeName.charAt(1)))) {
            typeName = Character.toLowerCase(typeName.charAt(0)) + typeName.substring(1);
        }
        return typeName;
    }

    public static class SymbolLocation {
        private final String name;
        private final int start;
        private final int end;
        private final int selectionStart;
        private final int selectionEnd;

        private SymbolLocation(String name, int start, int end, int selectionStart, int selectionEnd) {
            this.name = name;
            this.start = start;
            this.end = end;
            this.selectionStart = selectionStart;
            this.selectionEnd = selectionEnd;
        }

        public String getName() {
            return this.name;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public int getSelectionStart() {
            return this.selectionStart;
        }

        public int getSelectionEnd() {
            return this.selectionEnd;
        }
    }

    private static class MthIterator
    implements Iterator<ExecutableElement> {
        private final ExecutableElement ee;
        private final Elements elements;
        private final Types types;
        private boolean createIt = false;
        private Iterator<ExecutableElement> it = null;

        private MthIterator(Element e, Elements elements, Types types) {
            this.ee = e != null && e.getKind() == ElementKind.METHOD ? (ExecutableElement)e : null;
            this.elements = elements;
            this.types = types;
        }

        @Override
        public boolean hasNext() {
            if (this.ee == null) {
                return false;
            }
            if (this.it == null) {
                if (!this.createIt) {
                    return true;
                }
                ArrayList<ExecutableElement> overriden = new ArrayList<ExecutableElement>();
                this.collectOverriden(this.ee, this.ee.getEnclosingElement(), overriden);
                this.it = overriden.iterator();
            }
            return this.it.hasNext();
        }

        @Override
        public ExecutableElement next() {
            if (this.it == null) {
                this.createIt = true;
                return this.ee;
            }
            return this.it.next();
        }

        private void collectOverriden(ExecutableElement orig, Element el, List<ExecutableElement> overriden) {
            for (TypeMirror typeMirror : this.types.directSupertypes(el.asType())) {
                if (typeMirror.getKind() != TypeKind.DECLARED) continue;
                Element se = ((DeclaredType)typeMirror).asElement();
                overriden.addAll(ElementFilter.methodsIn(se.getEnclosedElements()).stream().filter(me -> orig.getSimpleName().contentEquals(me.getSimpleName()) && this.elements.overrides(orig, (ExecutableElement)me, (TypeElement)el)).collect(Collectors.toList()));
                this.collectOverriden(orig, se, overriden);
            }
        }
    }

    public static class Factory
    extends EmbeddingIndexerFactory {
        public EmbeddingIndexer createIndexer(Indexable indexable, Snapshot snapshot) {
            return INSTANCE;
        }

        public void filesDeleted(Iterable<? extends Indexable> deleted, Context context) {
            File cacheRoot = FileUtil.toFile((FileObject)context.getIndexFolder());
            for (Indexable indexable : deleted) {
                File output = new File(cacheRoot, indexable.getRelativePath() + ".mn");
                if (!output.exists()) continue;
                output.delete();
            }
        }

        public void filesDirty(Iterable<? extends Indexable> dirty, Context context) {
        }

        public String getIndexerName() {
            return MicronautSymbolFinder.NAME;
        }

        public int getIndexVersion() {
            return 1;
        }
    }
}

