/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.vault;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.keymanagement.KmsVaultClient;
import com.oracle.bmc.keymanagement.requests.ListVaultsRequest;
import java.util.stream.Collectors;
import org.netbeans.modules.cloud.oracle.ChildrenProvider;
import org.netbeans.modules.cloud.oracle.NodeProvider;
import org.netbeans.modules.cloud.oracle.OCIManager;
import org.netbeans.modules.cloud.oracle.OCINode;
import org.netbeans.modules.cloud.oracle.compartment.CompartmentItem;
import org.netbeans.modules.cloud.oracle.items.OCID;
import org.netbeans.modules.cloud.oracle.vault.VaultItem;

public class VaultNode
extends OCINode {
    private static final String VAULT_ICON = "org/netbeans/modules/cloud/oracle/resources/vault.svg";

    public VaultNode(VaultItem vault) {
        super(vault);
        this.setName(vault.getName());
        this.setDisplayName(vault.getName());
        this.setIconBaseWithExtension(VAULT_ICON);
        this.setShortDescription(vault.getDescription());
    }

    public static NodeProvider<VaultItem> createNode() {
        return VaultNode::new;
    }

    public static ChildrenProvider<CompartmentItem, VaultItem> getVaults() {
        return compartmentId -> {
            KmsVaultClient client = KmsVaultClient.builder().build((AbstractAuthenticationDetailsProvider)OCIManager.getDefault().getActiveProfile().getConfigProvider());
            ListVaultsRequest listVaultsRequest = ListVaultsRequest.builder().compartmentId(compartmentId.getKey().getValue()).limit(Integer.valueOf(88)).build();
            return client.listVaults(listVaultsRequest).getItems().stream().map(d -> new VaultItem(OCID.of(d.getId(), "Vault"), d.getDisplayName(), d.getCompartmentId(), d.getManagementEndpoint())).collect(Collectors.toList());
        };
    }
}

