/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.symfony;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.spi.phpmodule.ImportantFilesImplementation;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;

public final class ConfigurationFiles
extends FileChangeAdapter
implements ImportantFilesImplementation {
    private static final String CONFIG_DIRECTORY = "config";
    private static final Set<String> CONFIG_FILE_EXTENSIONS = new HashSet<String>();
    private final PhpModule phpModule;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private FileObject sourceDirectory = null;

    ConfigurationFiles(PhpModule phpModule) {
        assert (phpModule != null);
        this.phpModule = phpModule;
    }

    public Collection<ImportantFilesImplementation.FileInfo> getFiles() {
        FileObject sourceDir = this.getSourceDirectory();
        if (sourceDir == null) {
            return Collections.emptyList();
        }
        ArrayList<ImportantFilesImplementation.FileInfo> files = new ArrayList<ImportantFilesImplementation.FileInfo>();
        FileObject configDir = sourceDir.getFileObject(CONFIG_DIRECTORY);
        if (configDir != null && configDir.isFolder() && configDir.isValid()) {
            List<FileObject> fileObjects = this.getConfigFilesRecursively(configDir);
            fileObjects.sort(new Comparator<FileObject>(){

                @Override
                public int compare(FileObject o1, FileObject o2) {
                    String ext2;
                    boolean phpFile1 = FileUtils.isPhpFile((FileObject)o1);
                    boolean phpFile2 = FileUtils.isPhpFile((FileObject)o2);
                    if (phpFile1 && phpFile2) {
                        return o1.getNameExt().compareTo(o2.getNameExt());
                    }
                    if (phpFile1) {
                        return 1;
                    }
                    if (phpFile2) {
                        return -1;
                    }
                    String ext1 = o1.getExt();
                    if (ext1.equals(ext2 = o2.getExt())) {
                        return o1.getNameExt().compareToIgnoreCase(o2.getNameExt());
                    }
                    return ext1.compareToIgnoreCase(ext2);
                }
            });
            for (FileObject fo : fileObjects) {
                files.add(new ImportantFilesImplementation.FileInfo(fo));
            }
        }
        return files;
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    private void fireChange() {
        this.changeSupport.fireChange();
    }

    @CheckForNull
    private synchronized FileObject getSourceDirectory() {
        if (this.sourceDirectory == null) {
            this.sourceDirectory = this.phpModule.getSourceDirectory();
            if (this.sourceDirectory != null) {
                File sources = FileUtil.toFile((FileObject)this.sourceDirectory);
                this.addListener(new File(sources, CONFIG_DIRECTORY));
            }
        }
        return this.sourceDirectory;
    }

    private List<FileObject> getConfigFilesRecursively(FileObject parent) {
        ArrayList<FileObject> result = new ArrayList<FileObject>();
        for (FileObject child : parent.getChildren()) {
            if (!VisibilityQuery.getDefault().isVisible(child)) continue;
            if (child.isData() && (CONFIG_FILE_EXTENSIONS.contains(child.getExt().toLowerCase()) || FileUtils.isPhpFile((FileObject)child))) {
                result.add(child);
                continue;
            }
            if (!child.isFolder()) continue;
            result.addAll(this.getConfigFilesRecursively(child));
        }
        return result;
    }

    private void addListener(File path) {
        block2: {
            try {
                FileUtil.addRecursiveListener((FileChangeListener)this, (File)path);
            }
            catch (IllegalArgumentException ex) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError(path);
            }
        }
    }

    public void fileRenamed(FileRenameEvent fe) {
        this.fireChange();
    }

    public void fileDeleted(FileEvent fe) {
        this.fireChange();
    }

    public void fileDataCreated(FileEvent fe) {
        this.fireChange();
    }

    public void fileFolderCreated(FileEvent fe) {
        this.fireChange();
    }

    static {
        CONFIG_FILE_EXTENSIONS.add("ini");
        CONFIG_FILE_EXTENSIONS.add("yml");
    }
}

