/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.identity.model.UpdateStateDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateUserStateRequest
extends BmcRequest<UpdateStateDetails> {
    private String userId;
    private UpdateStateDetails updateStateDetails;
    private String ifMatch;

    public String getUserId() {
        return this.userId;
    }

    public UpdateStateDetails getUpdateStateDetails() {
        return this.updateStateDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public UpdateStateDetails getBody$() {
        return this.updateStateDetails;
    }

    public Builder toBuilder() {
        return new Builder().userId(this.userId).updateStateDetails(this.updateStateDetails).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",userId=").append(String.valueOf(this.userId));
        sb.append(",updateStateDetails=").append(String.valueOf((Object)this.updateStateDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateUserStateRequest)) {
            return false;
        }
        UpdateUserStateRequest other = (UpdateUserStateRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.userId, other.userId) && Objects.equals((Object)this.updateStateDetails, (Object)other.updateStateDetails) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.userId == null ? 43 : this.userId.hashCode());
        result = result * 59 + (this.updateStateDetails == null ? 43 : this.updateStateDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateUserStateRequest, UpdateStateDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String userId = null;
        private UpdateStateDetails updateStateDetails = null;
        private String ifMatch = null;

        public Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public Builder updateStateDetails(UpdateStateDetails updateStateDetails) {
            this.updateStateDetails = updateStateDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateUserStateRequest o) {
            this.userId(o.getUserId());
            this.updateStateDetails(o.getUpdateStateDetails());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateUserStateRequest build() {
            UpdateUserStateRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateStateDetails body) {
            this.updateStateDetails(body);
            return this;
        }

        public UpdateUserStateRequest buildWithoutInvocationCallback() {
            UpdateUserStateRequest request = new UpdateUserStateRequest();
            request.userId = this.userId;
            request.updateStateDetails = this.updateStateDetails;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

