/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.identity.model.UpdateAuthTokenDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateAuthTokenRequest
extends BmcRequest<UpdateAuthTokenDetails> {
    private String userId;
    private String authTokenId;
    private UpdateAuthTokenDetails updateAuthTokenDetails;
    private String ifMatch;

    public String getUserId() {
        return this.userId;
    }

    public String getAuthTokenId() {
        return this.authTokenId;
    }

    public UpdateAuthTokenDetails getUpdateAuthTokenDetails() {
        return this.updateAuthTokenDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public UpdateAuthTokenDetails getBody$() {
        return this.updateAuthTokenDetails;
    }

    public Builder toBuilder() {
        return new Builder().userId(this.userId).authTokenId(this.authTokenId).updateAuthTokenDetails(this.updateAuthTokenDetails).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",userId=").append(String.valueOf(this.userId));
        sb.append(",authTokenId=").append(String.valueOf(this.authTokenId));
        sb.append(",updateAuthTokenDetails=").append(String.valueOf((Object)this.updateAuthTokenDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateAuthTokenRequest)) {
            return false;
        }
        UpdateAuthTokenRequest other = (UpdateAuthTokenRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.userId, other.userId) && Objects.equals(this.authTokenId, other.authTokenId) && Objects.equals((Object)this.updateAuthTokenDetails, (Object)other.updateAuthTokenDetails) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.userId == null ? 43 : this.userId.hashCode());
        result = result * 59 + (this.authTokenId == null ? 43 : this.authTokenId.hashCode());
        result = result * 59 + (this.updateAuthTokenDetails == null ? 43 : this.updateAuthTokenDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateAuthTokenRequest, UpdateAuthTokenDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String userId = null;
        private String authTokenId = null;
        private UpdateAuthTokenDetails updateAuthTokenDetails = null;
        private String ifMatch = null;

        public Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public Builder authTokenId(String authTokenId) {
            this.authTokenId = authTokenId;
            return this;
        }

        public Builder updateAuthTokenDetails(UpdateAuthTokenDetails updateAuthTokenDetails) {
            this.updateAuthTokenDetails = updateAuthTokenDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateAuthTokenRequest o) {
            this.userId(o.getUserId());
            this.authTokenId(o.getAuthTokenId());
            this.updateAuthTokenDetails(o.getUpdateAuthTokenDetails());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateAuthTokenRequest build() {
            UpdateAuthTokenRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateAuthTokenDetails body) {
            this.updateAuthTokenDetails(body);
            return this;
        }

        public UpdateAuthTokenRequest buildWithoutInvocationCallback() {
            UpdateAuthTokenRequest request = new UpdateAuthTokenRequest();
            request.userId = this.userId;
            request.authTokenId = this.authTokenId;
            request.updateAuthTokenDetails = this.updateAuthTokenDetails;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

