/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.push;

import java.awt.EventQueue;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitRemoteConfig;
import org.netbeans.libs.git.GitRevisionInfo;
import org.netbeans.libs.git.GitTag;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.client.GitClient;
import org.netbeans.modules.git.client.GitProgressSupport;
import org.netbeans.modules.git.ui.push.PushMapping;
import org.netbeans.modules.git.ui.repository.RepositoryInfo;
import org.netbeans.modules.git.ui.selectors.ItemSelector;
import org.netbeans.modules.git.ui.wizards.AbstractWizardPanel;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;

public class PushBranchesStep
extends AbstractWizardPanel
implements WizardDescriptor.FinishablePanel<WizardDescriptor>,
ChangeListener {
    private final File repository;
    private final ItemSelector<PushMapping> localObjects;
    private boolean lastPanel;

    public PushBranchesStep(File repository) {
        this.repository = repository;
        this.localObjects = new ItemSelector(NbBundle.getMessage(PushBranchesStep.class, (String)"PushBranchesPanel.jLabel1.text"));
        this.localObjects.addChangeListener(this);
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                PushBranchesStep.this.validateBeforeNext();
            }
        });
        this.getJComponent().setName(NbBundle.getMessage(PushBranchesStep.class, (String)"LBL_PushBranches.localBranches"));
    }

    @Override
    protected final boolean validateBeforeNext() {
        this.setValid(true, null);
        if (this.localObjects.getSelectedBranches().isEmpty()) {
            this.setValid(false, new AbstractWizardPanel.Message(NbBundle.getMessage(PushBranchesStep.class, (String)"MSG_PushBranchesPanel.errorNoBranchSelected"), false));
        } else if (this.isDeleteUpdateConflict(this.localObjects.getSelectedBranches())) {
            this.setValid(false, new AbstractWizardPanel.Message(NbBundle.getMessage(PushBranchesStep.class, (String)"MSG_PushBranchesPanel.errorMixedSeletion"), false));
        } else {
            String msgDeletedBranches = PushBranchesStep.getDestructiveActionMessage(this.localObjects.getSelectedBranches());
            if (msgDeletedBranches != null) {
                this.setValid(true, new AbstractWizardPanel.Message(msgDeletedBranches, true));
            }
        }
        return this.isValid();
    }

    @Override
    protected final JComponent getJComponent() {
        return this.localObjects.getPanel();
    }

    @Override
    public HelpCtx getHelp() {
        return new HelpCtx(PushBranchesStep.class);
    }

    public void fillRemoteBranches(final GitRemoteConfig cfg, final Map<String, GitBranch> branches, final Map<String, String> tags) {
        this.fillLocalObjects(Collections.emptyList());
        new GitProgressSupport.NoOutputLogging(){

            @Override
            protected void perform() {
                GitClient client;
                HashMap<String, GitBranch> localBranches = new HashMap<String, GitBranch>();
                HashMap<String, GitTag> localTags = new HashMap<String, GitTag>();
                RepositoryInfo info = RepositoryInfo.getInstance(PushBranchesStep.this.repository);
                info.refresh();
                localBranches.putAll(info.getBranches());
                localTags.putAll(info.getTags());
                final ArrayList<PushMapping> l = new ArrayList<PushMapping>(branches.size());
                try {
                    client = this.getClient();
                }
                catch (GitException ex) {
                    client = null;
                }
                for (GitBranch branch : localBranches.values()) {
                    String idRemote;
                    String idLocal;
                    boolean updateNeeded;
                    if (branch.getName() == "(no branch)" || branch.isRemote()) continue;
                    GitBranch remoteBranch = (GitBranch)branches.get(branch.getName());
                    boolean conflicted = false;
                    boolean bl = updateNeeded = remoteBranch != null && !remoteBranch.getId().equals(branch.getId());
                    if (client != null && remoteBranch != null && !(idLocal = branch.getId()).equals(idRemote = remoteBranch.getId())) {
                        try {
                            GitRevisionInfo rev = client.getCommonAncestor(new String[]{idLocal, idRemote}, this.getProgressMonitor());
                            boolean bl2 = conflicted = rev == null || !idRemote.equals(rev.getRevision()) && !idLocal.equals(rev.getRevision());
                            if (!conflicted && idLocal.equals(rev.getRevision())) {
                                updateNeeded = false;
                            }
                        }
                        catch (GitException.MissingObjectException ex) {
                            if (idRemote.equals(ex.getObjectName())) {
                                conflicted = true;
                            } else {
                                Logger.getLogger(PushBranchesStep.class.getName()).log(Level.INFO, idLocal + ", " + idRemote, ex);
                            }
                        }
                        catch (GitException ex) {
                            Logger.getLogger(PushBranchesStep.class.getName()).log(Level.INFO, idLocal + ", " + idRemote, ex);
                        }
                    }
                    boolean preselected = !conflicted && updateNeeded;
                    l.add(new PushMapping.PushBranchMapping(remoteBranch == null ? null : remoteBranch.getName(), remoteBranch == null ? null : remoteBranch.getId(), branch, conflicted, preselected, updateNeeded));
                }
                if (cfg != null) {
                    for (GitBranch branch : branches.values()) {
                        String branchName = cfg.getRemoteName() + "/" + branch.getName();
                        GitBranch local = (GitBranch)localBranches.get(branchName);
                        if (local != null && local.isRemote()) continue;
                        l.add(new PushMapping.PushBranchMapping(branch.getName(), branch.getId(), false));
                    }
                }
                for (Object tag : localTags.values()) {
                    String repoTagId = (String)tags.get(tag.getTagName());
                    if (tag.getTagId().equals(repoTagId)) continue;
                    l.add(new PushMapping.PushTagMapping((GitTag)tag, repoTagId == null ? null : tag.getTagName()));
                }
                for (Object tag : tags.keySet()) {
                    GitTag localTag = (GitTag)localTags.get(tag);
                    if (localTag != null) continue;
                    l.add(new PushMapping.PushTagMapping((String)tag));
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PushBranchesStep.this.fillLocalObjects(l);
                    }
                });
            }
        }.start(Git.getInstance().getRequestProcessor(this.repository), this.repository, NbBundle.getMessage(PushBranchesStep.class, (String)"MSG_PushBranchesPanel.loadingLocalBranches"));
    }

    private void fillLocalObjects(List<PushMapping> mappings) {
        this.localObjects.setBranches(mappings);
        this.validateBeforeNext();
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        this.validateBeforeNext();
    }

    public boolean isFinishPanel() {
        return this.lastPanel;
    }

    void setAsLastPanel(boolean isLastPanel) {
        this.lastPanel = isLastPanel;
    }

    Collection<PushMapping> getSelectedMappings() {
        return this.localObjects.getSelectedBranches();
    }

    private static String getDestructiveActionMessage(List<PushMapping> selectedObjects) {
        StringBuilder sb = new StringBuilder(100);
        for (PushMapping m : selectedObjects) {
            if (!m.isDestructive()) continue;
            sb.append(m.getInfoMessage()).append("<br>");
        }
        if (sb.length() == 0) {
            return null;
        }
        sb.delete(sb.length() - 4, sb.length());
        return sb.toString();
    }

    private boolean isDeleteUpdateConflict(List<PushMapping> selectedObjects) {
        HashSet<String> toDelete = new HashSet<String>(selectedObjects.size());
        HashSet<String> toUpdate = new HashSet<String>(selectedObjects.size());
        for (PushMapping m : selectedObjects) {
            if (m.isDestructive() && m.getLocalName() != null) {
                toDelete.add(m.getRemoteName());
                continue;
            }
            toUpdate.add(m.getRemoteName());
        }
        toDelete.retainAll(toUpdate);
        return !toDelete.isEmpty();
    }
}

