/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl.timeline;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import org.netbeans.lib.profiler.charts.ChartContext;
import org.netbeans.lib.profiler.charts.swing.Utils;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.TimelineChart;

final class VerticalTimelineLayout
implements LayoutManager2 {
    private final TimelineChart chart;

    VerticalTimelineLayout(TimelineChart chart) {
        this.chart = chart;
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    @Override
    public Dimension maximumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Dimension dim = new Dimension(0, Utils.checkedInt((double)this.chart.getChartContext().getViewHeight()));
        for (int i = 0; i < parent.getComponentCount(); ++i) {
            dim.width = Math.max(dim.width, parent.getComponent((int)i).getPreferredSize().width);
        }
        return dim;
    }

    @Override
    public void layoutContainer(Container parent) {
        int width = parent.getWidth();
        for (int i = 0; i < parent.getComponentCount(); ++i) {
            ChartContext context = this.chart.getRow(i).getContext();
            parent.getComponent(i).setBounds(0, Utils.checkedInt((double)(context.getViewportOffsetY() + this.chart.getOffsetY())), width, context.getViewportHeight());
        }
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container target) {
    }
}

