/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.comp;

import com.sun.tools.javac.code.Directive;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.resources.CompilerProperties;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Pair;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class ThisEscapeAnalyzer
extends TreeScanner {
    private final Names names;
    private final Symtab syms;
    private final Types types;
    private final Log log;
    private Lint lint;
    private final Map<Symbol, MethodInfo> methodMap = new LinkedHashMap<Symbol, MethodInfo>();
    private final Set<Symbol> suppressed = new HashSet<Symbol>();
    private JCTree.JCClassDecl targetClass;
    private final ArrayList<JCDiagnostic.DiagnosticPosition[]> warningList = new ArrayList();
    private JCTree.JCClassDecl methodClass;
    private final ArrayDeque<JCDiagnostic.DiagnosticPosition> callStack = new ArrayDeque();
    private final Set<Pair<JCTree.JCMethodDecl, RefSet<Ref>>> invocations = new HashSet<Pair<JCTree.JCMethodDecl, RefSet<Ref>>>();
    private JCDiagnostic.DiagnosticPosition[] pendingWarning;
    private int depth = -1;
    private RefSet<Ref> refs;

    ThisEscapeAnalyzer(Names names, Symtab syms, Types types, Log log, Lint lint) {
        this.names = names;
        this.syms = syms;
        this.types = types;
        this.log = log;
        this.lint = lint;
    }

    public void analyzeTree(Env<AttrContext> env) {
        Assert.check(this.checkInvariants(false, false));
        Assert.check(this.methodMap.isEmpty());
        if (!this.lint.isEnabled(Lint.LintCategory.THIS_ESCAPE)) {
            return;
        }
        final Set exportedPackages = Optional.ofNullable(env.toplevel.modle).filter(mod -> mod != this.syms.noModule).filter(mod -> mod != this.syms.unnamedModule).map(mod -> mod.exports.stream().map(Directive.ExportsDirective::getPackage).collect(Collectors.toSet())).orElse(null);
        final HashSet classSyms = new HashSet();
        new TreeScanner(){

            @Override
            public void visitClassDef(JCTree.JCClassDecl tree) {
                classSyms.add(tree.sym);
                super.visitClassDef(tree);
            }
        }.scan(env.tree);
        new TreeScanner(){
            private Lint lint;
            private JCTree.JCClassDecl currentClass;
            private boolean nonPublicOuter;
            {
                this.lint = ThisEscapeAnalyzer.this.lint;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void visitClassDef(JCTree.JCClassDecl tree) {
                JCTree.JCClassDecl currentClassPrev = this.currentClass;
                boolean nonPublicOuterPrev = this.nonPublicOuter;
                Lint lintPrev = this.lint;
                this.lint = this.lint.augment(tree.sym);
                try {
                    this.currentClass = tree;
                    this.nonPublicOuter |= tree.sym.isAnonymous();
                    this.nonPublicOuter |= (tree.mods.flags & 1L) == 0L;
                    super.visitClassDef(tree);
                }
                finally {
                    this.currentClass = currentClassPrev;
                    this.nonPublicOuter = nonPublicOuterPrev;
                    this.lint = lintPrev;
                }
            }

            @Override
            public void visitVarDef(JCTree.JCVariableDecl tree) {
                Lint lintPrev = this.lint;
                this.lint = this.lint.augment(tree.sym);
                try {
                    if (tree.sym.owner.kind == Kinds.Kind.TYP && !this.lint.isEnabled(Lint.LintCategory.THIS_ESCAPE)) {
                        ThisEscapeAnalyzer.this.suppressed.add(tree.sym);
                    }
                    super.visitVarDef(tree);
                }
                finally {
                    this.lint = lintPrev;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void visitMethodDef(JCTree.JCMethodDecl tree) {
                Lint lintPrev = this.lint;
                this.lint = this.lint.augment(tree.sym);
                try {
                    boolean extendable;
                    if (TreeInfo.isConstructor(tree) && !this.lint.isEnabled(Lint.LintCategory.THIS_ESCAPE)) {
                        ThisEscapeAnalyzer.this.suppressed.add(tree.sym);
                    }
                    boolean analyzable = (extendable = this.currentClassIsExternallyExtendable()) && TreeInfo.isConstructor(tree) && (tree.sym.flags() & 5L) != 0L && !ThisEscapeAnalyzer.this.suppressed.contains(tree.sym);
                    boolean invokable = !extendable || TreeInfo.isConstructor(tree) || (tree.mods.flags & 0x1AL) != 0L;
                    ThisEscapeAnalyzer.this.methodMap.put(tree.sym, new MethodInfo(this.currentClass, tree, analyzable, invokable));
                    super.visitMethodDef(tree);
                }
                finally {
                    this.lint = lintPrev;
                }
            }

            private boolean currentClassIsExternallyExtendable() {
                return !this.currentClass.sym.isFinal() && this.currentClass.sym.isPublic() && (exportedPackages == null || exportedPackages.contains(this.currentClass.sym.packge())) && !this.currentClass.sym.isSealed() && !this.currentClass.sym.isDirectlyOrIndirectlyLocal() && !this.nonPublicOuter;
            }
        }.scan(env.tree);
        this.methodMap.values().stream().filter(MethodInfo::analyzable).map(MethodInfo::declaringClass).distinct().forEach(klass -> {
            List<JCTree> defs = klass.defs;
            while (defs.nonEmpty()) {
                if ((TreeInfo.flags((JCTree)defs.head) & 8L) == 0L) {
                    Object patt0$temp = defs.head;
                    if (patt0$temp instanceof JCTree.JCVariableDecl) {
                        JCTree.JCVariableDecl vardef = (JCTree.JCVariableDecl)patt0$temp;
                        this.visitTopLevel((JCTree.JCClassDecl)klass, () -> {
                            this.scan(vardef);
                            this.copyPendingWarning();
                        });
                    } else {
                        Object patt1$temp = defs.head;
                        if (patt1$temp instanceof JCTree.JCBlock) {
                            JCTree.JCBlock block = (JCTree.JCBlock)patt1$temp;
                            this.visitTopLevel((JCTree.JCClassDecl)klass, () -> this.analyzeStatements(block.stats));
                        }
                    }
                }
                defs = defs.tail;
            }
        });
        this.methodMap.values().stream().filter(MethodInfo::analyzable).forEach(methodInfo -> this.visitTopLevel(methodInfo.declaringClass(), () -> this.analyzeStatements(methodInfo.declaration().body.stats)));
        BiPredicate<JCDiagnostic.DiagnosticPosition[], JCDiagnostic.DiagnosticPosition[]> extendsAsPrefix = (warning1, warning2) -> {
            if (((JCDiagnostic.DiagnosticPosition[])warning2).length < ((JCDiagnostic.DiagnosticPosition[])warning1).length) {
                return false;
            }
            for (int index = 0; index < ((JCDiagnostic.DiagnosticPosition[])warning1).length; ++index) {
                if (warning2[index].getPreferredPosition() == warning1[index].getPreferredPosition()) continue;
                return false;
            }
            return true;
        };
        Comparator ordering = (warning1, warning2) -> {
            int index1 = 0;
            int index2 = 0;
            while (true) {
                int posn2;
                boolean end2;
                boolean end1 = index1 >= ((JCDiagnostic.DiagnosticPosition[])warning1).length;
                boolean bl = end2 = index2 >= ((JCDiagnostic.DiagnosticPosition[])warning2).length;
                if (end1 && end2) {
                    return 0;
                }
                if (end1) {
                    return -1;
                }
                if (end2) {
                    return 1;
                }
                int posn1 = warning1[index1].getPreferredPosition();
                int diff = Integer.compare(posn1, posn2 = warning2[index2].getPreferredPosition());
                if (diff != 0) {
                    return diff;
                }
                ++index1;
                ++index2;
            }
        };
        this.warningList.sort(ordering);
        JCDiagnostic.DiagnosticPosition[] previous = null;
        for (JCDiagnostic.DiagnosticPosition[] warning : this.warningList) {
            if (previous != null && extendsAsPrefix.test(previous, warning)) continue;
            previous = warning;
            JCDiagnostic.Warning key = CompilerProperties.Warnings.PossibleThisEscape;
            int remain = warning.length;
            do {
                JCDiagnostic.DiagnosticPosition pos = warning[--remain];
                this.log.warning(Lint.LintCategory.THIS_ESCAPE, pos, key);
                key = CompilerProperties.Warnings.PossibleThisEscapeLocation;
            } while (remain > 0);
        }
        this.warningList.clear();
    }

    private void analyzeStatements(List<JCTree.JCStatement> stats) {
        for (JCTree.JCStatement stat : stats) {
            this.scan(stat);
            if (!this.copyPendingWarning()) continue;
            break;
        }
    }

    @Override
    public void scan(JCTree tree) {
        boolean referenceExpressionNode;
        if (tree == null || tree.type == Type.stuckType) {
            return;
        }
        Assert.check(this.checkInvariants(true, false));
        switch (tree.getTag()) {
            case SWITCH_EXPRESSION: 
            case CONDEXPR: 
            case YIELD: 
            case APPLY: 
            case NEWCLASS: 
            case NEWARRAY: 
            case LAMBDA: 
            case PARENS: 
            case ASSIGN: 
            case TYPECAST: 
            case INDEXED: 
            case SELECT: 
            case REFERENCE: 
            case IDENT: 
            case NULLCHK: 
            case LETEXPR: {
                referenceExpressionNode = true;
                break;
            }
            default: {
                referenceExpressionNode = false;
            }
        }
        super.scan(tree);
        Assert.check(this.checkInvariants(true, referenceExpressionNode));
    }

    @Override
    public void visitClassDef(JCTree.JCClassDecl tree) {
    }

    @Override
    public void visitVarDef(JCTree.JCVariableDecl tree) {
        if (this.suppressed.contains(tree.sym)) {
            return;
        }
        this.scan(tree.init);
        if (this.isParamOrVar(tree.sym)) {
            this.refs.replaceExprs(this.depth, direct -> new VarRef(tree.sym, (boolean)direct));
        } else {
            this.refs.discardExprs(this.depth);
        }
    }

    @Override
    public void visitMethodDef(JCTree.JCMethodDecl tree) {
        Assert.check(false);
    }

    @Override
    public void visitApply(JCTree.JCMethodInvocation invoke) {
        Symbol sym = TreeInfo.symbolFor(invoke.meth);
        this.scan(invoke.meth);
        boolean direct = this.refs.remove(ExprRef.direct(this.depth));
        boolean indirect = this.refs.remove(ExprRef.indirect(this.depth));
        RefSet receiverRefs = RefSet.newEmpty();
        if (sym != null && !sym.isStatic()) {
            if (direct) {
                receiverRefs.add(ThisRef.direct());
            }
            if (indirect) {
                receiverRefs.add(ThisRef.indirect());
            }
        }
        if (TreeInfo.name(invoke.meth) == this.names._super) {
            return;
        }
        this.invoke(invoke, sym, invoke.args, receiverRefs);
    }

    private void invoke(JCTree site, Symbol sym, List<JCTree.JCExpression> args, RefSet<?> receiverRefs) {
        if (this.suppressed.contains(sym)) {
            return;
        }
        if (sym != null && sym.owner.kind == Kinds.Kind.TYP && sym.owner.type.tsym == this.syms.objectType.tsym && sym.isFinal()) {
            return;
        }
        MethodInfo methodInfo = this.methodMap.get(sym);
        if (methodInfo != null && methodInfo.invokable()) {
            this.invokeInvokable(site, args, receiverRefs, methodInfo);
        } else {
            this.invokeUnknown(site, args, receiverRefs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeInvokable(JCTree site, List<JCTree.JCExpression> args, RefSet<?> receiverRefs, MethodInfo methodInfo) {
        Assert.check(methodInfo.invokable());
        JCTree.JCMethodDecl method = methodInfo.declaration();
        RefSet paramRefs = RefSet.newEmpty();
        List<JCTree.JCVariableDecl> params = method.params;
        while (args.nonEmpty() && params.nonEmpty()) {
            Symbol.VarSymbol sym = ((JCTree.JCVariableDecl)params.head).sym;
            this.scan((JCTree)args.head);
            this.refs.removeExprs(this.depth, direct -> paramRefs.add(new VarRef(sym, (boolean)direct)));
            args = args.tail;
            params = params.tail;
        }
        JCTree.JCClassDecl methodClassPrev = this.methodClass;
        this.methodClass = methodInfo.declaringClass();
        RefSet<Ref> refsPrev = this.refs;
        this.refs = RefSet.newEmpty();
        int depthPrev = this.depth;
        this.depth = 0;
        this.callStack.push(site);
        try {
            this.refs.addAll(receiverRefs);
            this.refs.addAll(paramRefs);
            if (this.refs.isEmpty()) {
                return;
            }
            Pair<JCTree.JCMethodDecl, Object> invocation = Pair.of(methodInfo.declaration, this.refs.clone());
            if (!this.invocations.add(invocation)) {
                return;
            }
            try {
                this.scan(method.body);
            }
            finally {
                this.invocations.remove(invocation);
            }
            this.refs.mapInto(refsPrev, ReturnRef.class, direct -> new ExprRef(depthPrev, (boolean)direct));
        }
        finally {
            this.callStack.pop();
            this.depth = depthPrev;
            this.refs = refsPrev;
            this.methodClass = methodClassPrev;
        }
    }

    private void invokeUnknown(JCTree invoke, List<JCTree.JCExpression> args, RefSet<?> receiverRefs) {
        if (!receiverRefs.isEmpty()) {
            this.leakAt(invoke);
        }
        for (JCTree.JCExpression arg : args) {
            this.scan(arg);
            if (!this.refs.discardExprs(this.depth)) continue;
            this.leakAt(arg);
        }
    }

    @Override
    public void visitNewClass(JCTree.JCNewClass tree) {
        MethodInfo methodInfo = this.methodMap.get(tree.constructor);
        if (methodInfo != null && methodInfo.invokable()) {
            this.invokeInvokable(tree, tree.args, this.outerThisRefs(tree.encl, tree.clazz.type), methodInfo);
        } else {
            this.invokeUnknown(tree, tree.args, this.outerThisRefs(tree.encl, tree.clazz.type));
        }
    }

    private RefSet<OuterRef> outerThisRefs(JCTree.JCExpression explicitOuterThis, Type type) {
        RefSet<OuterRef> outerRefs = RefSet.newEmpty();
        if (explicitOuterThis != null) {
            this.scan(explicitOuterThis);
            this.refs.removeExprs(this.depth, direct -> outerRefs.add(new OuterRef((boolean)direct)));
        } else if (type.tsym != this.methodClass.sym && type.tsym.isEnclosedBy(this.methodClass.sym)) {
            this.refs.mapInto(outerRefs, ThisRef.class, OuterRef::new);
        }
        return outerRefs;
    }

    @Override
    public void visitBlock(JCTree.JCBlock tree) {
        this.visitScoped(false, () -> super.visitBlock(tree));
        Assert.check(this.checkInvariants(true, false));
    }

    @Override
    public void visitDoLoop(JCTree.JCDoWhileLoop tree) {
        this.visitLooped(tree, x$0 -> super.visitDoLoop((JCTree.JCDoWhileLoop)x$0));
    }

    @Override
    public void visitWhileLoop(JCTree.JCWhileLoop tree) {
        this.visitLooped(tree, x$0 -> super.visitWhileLoop((JCTree.JCWhileLoop)x$0));
    }

    @Override
    public void visitForLoop(JCTree.JCForLoop tree) {
        this.visitLooped(tree, x$0 -> super.visitForLoop((JCTree.JCForLoop)x$0));
    }

    @Override
    public void visitForeachLoop(JCTree.JCEnhancedForLoop tree) {
        this.visitLooped(tree, foreach -> {
            this.scan(foreach.expr);
            this.refs.discardExprs(this.depth);
            this.scan(foreach.body);
        });
    }

    @Override
    public void visitSwitch(JCTree.JCSwitch tree) {
        this.visitScoped(false, () -> {
            this.scan(tree.selector);
            this.refs.discardExprs(this.depth);
            this.scan(tree.cases);
        });
    }

    @Override
    public void visitSwitchExpression(JCTree.JCSwitchExpression tree) {
        this.visitScoped(true, () -> {
            this.scan(tree.selector);
            this.refs.discardExprs(this.depth);
            RefSet combinedRefs = new RefSet();
            List<JCTree.JCCase> cases = tree.cases;
            while (cases.nonEmpty()) {
                this.scan(((JCTree.JCCase)cases.head).stats);
                this.refs.replace(YieldRef.class, direct -> new ExprRef(this.depth, (boolean)direct));
                combinedRefs.addAll(this.refs.removeExprs(this.depth));
                cases = cases.tail;
            }
            this.refs.addAll(combinedRefs);
        });
    }

    @Override
    public void visitCase(JCTree.JCCase tree) {
        this.scan(tree.stats);
    }

    @Override
    public void visitYield(JCTree.JCYield tree) {
        this.scan(tree.value);
        this.refs.replaceExprs(this.depth, YieldRef::new);
    }

    @Override
    public void visitLetExpr(JCTree.LetExpr tree) {
        this.visitScoped(true, () -> super.visitLetExpr(tree));
    }

    @Override
    public void visitReturn(JCTree.JCReturn tree) {
        this.scan(tree.expr);
        this.refs.replaceExprs(this.depth, ReturnRef::new);
    }

    @Override
    public void visitLambda(JCTree.JCLambda lambda) {
        this.visitDeferred(() -> this.visitScoped(false, () -> {
            this.scan(lambda.body);
            this.refs.discardExprs(this.depth);
        }));
    }

    @Override
    public void visitAssign(JCTree.JCAssign tree) {
        this.scan(tree.lhs);
        this.refs.discardExprs(this.depth);
        this.scan(tree.rhs);
        Symbol.VarSymbol sym = (Symbol.VarSymbol)TreeInfo.symbolFor(tree.lhs);
        if (this.isParamOrVar(sym)) {
            this.refs.replaceExprs(this.depth, direct -> new VarRef(sym, (boolean)direct));
        } else {
            this.refs.discardExprs(this.depth);
        }
    }

    @Override
    public void visitIndexed(JCTree.JCArrayAccess tree) {
        this.scan(tree.indexed);
        this.refs.remove(ExprRef.direct(this.depth));
        boolean indirectRef = this.refs.remove(ExprRef.indirect(this.depth));
        this.scan(tree.index);
        this.refs.discardExprs(this.depth);
        if (indirectRef) {
            this.refs.add(ExprRef.direct(this.depth));
            this.refs.add(ExprRef.indirect(this.depth));
        }
    }

    @Override
    public void visitSelect(JCTree.JCFieldAccess tree) {
        this.scan(tree.selected);
        boolean selectedDirectRef = this.refs.remove(ExprRef.direct(this.depth));
        boolean selectedIndirectRef = this.refs.remove(ExprRef.indirect(this.depth));
        Type.ClassType currentClassType = (Type.ClassType)this.methodClass.sym.type;
        if (this.isExplicitThisReference(this.types, currentClassType, tree)) {
            this.refs.mapInto(this.refs, ThisRef.class, direct -> new ExprRef(this.depth, (boolean)direct));
            return;
        }
        Type selectedType = this.types.erasure(tree.selected.type);
        if (selectedType.hasTag(TypeTag.CLASS)) {
            Symbol.ClassSymbol currentClassSym = (Symbol.ClassSymbol)currentClassType.tsym;
            Symbol.ClassSymbol selectedTypeSym = (Symbol.ClassSymbol)selectedType.tsym;
            if (tree.name == this.names._this && selectedTypeSym != currentClassSym && currentClassSym.isEnclosedBy(selectedTypeSym)) {
                this.refs.mapInto(this.refs, OuterRef.class, direct -> new ExprRef(this.depth, (boolean)direct));
                return;
            }
        }
        Symbol sym = tree.sym;
        if (sym.kind == Kinds.Kind.MTH) {
            if ((sym.flags() & 8L) == 0L) {
                if (selectedDirectRef) {
                    this.refs.add(ExprRef.direct(this.depth));
                }
                if (selectedIndirectRef) {
                    this.refs.add(ExprRef.indirect(this.depth));
                }
            }
            return;
        }
    }

    @Override
    public void visitReference(JCTree.JCMemberReference tree) {
        if (tree.type.isErroneous()) {
            return;
        }
        this.scan(tree.expr);
        boolean direct = this.refs.remove(ExprRef.direct(this.depth));
        boolean indirect = this.refs.remove(ExprRef.indirect(this.depth));
        RefSet receiverRefs = RefSet.newEmpty();
        switch (tree.kind) {
            case UNBOUND: 
            case STATIC: 
            case TOPLEVEL: 
            case ARRAY_CTOR: {
                return;
            }
            case SUPER: {
                this.refs.mapInto(receiverRefs, ThisRef.class, ThisRef::new);
                break;
            }
            case BOUND: {
                if (direct) {
                    receiverRefs.add(ThisRef.direct());
                }
                if (!indirect) break;
                receiverRefs.add(ThisRef.indirect());
                break;
            }
            case IMPLICIT_INNER: {
                receiverRefs.addAll(this.outerThisRefs(null, tree.expr.type));
                break;
            }
            default: {
                throw new RuntimeException("non-exhaustive?");
            }
        }
        this.visitDeferred(() -> this.invoke(tree, (Symbol.MethodSymbol)tree.sym, List.nil(), receiverRefs));
    }

    @Override
    public void visitIdent(JCTree.JCIdent tree) {
        if (tree.name == this.names._this || tree.name == this.names._super) {
            this.refs.mapInto(this.refs, ThisRef.class, direct -> new ExprRef(this.depth, (boolean)direct));
            return;
        }
        if (this.isParamOrVar(tree.sym)) {
            Symbol.VarSymbol sym = (Symbol.VarSymbol)tree.sym;
            if (this.refs.contains(VarRef.direct(sym))) {
                this.refs.add(ExprRef.direct(this.depth));
            }
            if (this.refs.contains(VarRef.indirect(sym))) {
                this.refs.add(ExprRef.indirect(this.depth));
            }
            return;
        }
        if (tree.sym.kind == Kinds.Kind.MTH && (tree.sym.flags() & 8L) == 0L) {
            Symbol.MethodSymbol sym = (Symbol.MethodSymbol)tree.sym;
            Symbol.ClassSymbol methodClassSym = this.methodClass.sym;
            if (methodClassSym.isSubClass(sym.owner, this.types)) {
                this.refs.mapInto(this.refs, ThisRef.class, direct -> new ExprRef(this.depth, (boolean)direct));
                return;
            }
            if (methodClassSym.isEnclosedBy((Symbol.ClassSymbol)sym.owner)) {
                this.refs.mapInto(this.refs, OuterRef.class, direct -> new ExprRef(this.depth, (boolean)direct));
                return;
            }
            return;
        }
    }

    @Override
    public void visitSynchronized(JCTree.JCSynchronized tree) {
        this.scan(tree.lock);
        this.refs.discardExprs(this.depth);
        this.scan(tree.body);
    }

    @Override
    public void visitConditional(JCTree.JCConditional tree) {
        this.scan(tree.cond);
        this.refs.discardExprs(this.depth);
        RefSet combinedRefs = new RefSet();
        this.scan(tree.truepart);
        combinedRefs.addAll(this.refs.removeExprs(this.depth));
        this.scan(tree.falsepart);
        combinedRefs.addAll(this.refs.removeExprs(this.depth));
        this.refs.addAll(combinedRefs);
    }

    @Override
    public void visitIf(JCTree.JCIf tree) {
        this.scan(tree.cond);
        this.refs.discardExprs(this.depth);
        this.scan(tree.thenpart);
        this.scan(tree.elsepart);
    }

    @Override
    public void visitExec(JCTree.JCExpressionStatement tree) {
        this.scan(tree.expr);
        this.refs.discardExprs(this.depth);
    }

    @Override
    public void visitThrow(JCTree.JCThrow tree) {
        this.scan(tree.expr);
        if (this.refs.discardExprs(this.depth)) {
            this.leakAt(tree);
        }
    }

    @Override
    public void visitAssert(JCTree.JCAssert tree) {
        this.scan(tree.cond);
        this.refs.discardExprs(this.depth);
        this.scan(tree.detail);
        this.refs.discardExprs(this.depth);
    }

    @Override
    public void visitNewArray(JCTree.JCNewArray tree) {
        boolean ref = false;
        if (tree.elems != null) {
            List<JCTree.JCExpression> elems = tree.elems;
            while (elems.nonEmpty()) {
                this.scan((JCTree)elems.head);
                ref |= this.refs.discardExprs(this.depth);
                elems = elems.tail;
            }
        }
        if (ref) {
            this.refs.add(ExprRef.indirect(this.depth));
        }
    }

    @Override
    public void visitTypeCast(JCTree.JCTypeCast tree) {
        this.scan(tree.expr);
    }

    @Override
    public void visitConstantCaseLabel(JCTree.JCConstantCaseLabel tree) {
    }

    @Override
    public void visitPatternCaseLabel(JCTree.JCPatternCaseLabel tree) {
    }

    @Override
    public void visitRecordPattern(JCTree.JCRecordPattern that) {
    }

    @Override
    public void visitTypeTest(JCTree.JCInstanceOf tree) {
        this.scan(tree.expr);
        this.refs.discardExprs(this.depth);
    }

    @Override
    public void visitTypeArray(JCTree.JCArrayTypeTree tree) {
    }

    @Override
    public void visitTypeApply(JCTree.JCTypeApply tree) {
    }

    @Override
    public void visitTypeUnion(JCTree.JCTypeUnion tree) {
    }

    @Override
    public void visitTypeIntersection(JCTree.JCTypeIntersection tree) {
    }

    @Override
    public void visitTypeParameter(JCTree.JCTypeParameter tree) {
    }

    @Override
    public void visitWildcard(JCTree.JCWildcard tree) {
    }

    @Override
    public void visitTypeBoundKind(JCTree.TypeBoundKind that) {
    }

    @Override
    public void visitModifiers(JCTree.JCModifiers tree) {
    }

    @Override
    public void visitAnnotation(JCTree.JCAnnotation tree) {
    }

    @Override
    public void visitAnnotatedType(JCTree.JCAnnotatedType tree) {
    }

    @Override
    public void visitAssignop(JCTree.JCAssignOp tree) {
        this.scan(tree.lhs);
        this.refs.discardExprs(this.depth);
        this.scan(tree.rhs);
        this.refs.discardExprs(this.depth);
    }

    @Override
    public void visitUnary(JCTree.JCUnary tree) {
        this.scan(tree.arg);
        this.refs.discardExprs(this.depth);
    }

    @Override
    public void visitBinary(JCTree.JCBinary tree) {
        this.scan(tree.lhs);
        this.refs.discardExprs(this.depth);
        this.scan(tree.rhs);
        this.refs.discardExprs(this.depth);
    }

    private void visitTopLevel(JCTree.JCClassDecl klass, Runnable action) {
        Assert.check(this.targetClass == null);
        Assert.check(this.methodClass == null);
        Assert.check(this.depth == -1);
        Assert.check(this.refs == null);
        this.targetClass = klass;
        this.methodClass = klass;
        try {
            this.refs = RefSet.newEmpty();
            this.refs.add(ThisRef.direct());
            this.visitScoped(false, action);
            Assert.check(this.depth == -1);
        }
        catch (Throwable throwable) {
            Assert.check(this.depth == -1);
            this.methodClass = null;
            this.targetClass = null;
            this.refs = null;
            throw throwable;
        }
        this.methodClass = null;
        this.targetClass = null;
        this.refs = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends JCTree> void visitDeferred(Runnable recurse) {
        boolean deferredCodeLeaks;
        JCDiagnostic.DiagnosticPosition[] pendingWarningPrev = this.pendingWarning;
        this.pendingWarning = null;
        Object refsPrev = this.refs.clone();
        try {
            recurse.run();
            deferredCodeLeaks = this.pendingWarning != null;
        }
        finally {
            this.refs = refsPrev;
            this.pendingWarning = pendingWarningPrev;
        }
        if (deferredCodeLeaks) {
            this.refs.add(ExprRef.indirect(this.depth));
        }
    }

    private <T extends JCTree> void visitLooped(T tree, Consumer<T> visitor) {
        this.visitScoped(false, () -> {
            Object prevRefs;
            do {
                prevRefs = this.refs.clone();
                visitor.accept(tree);
            } while (!this.refs.equals(prevRefs));
        });
    }

    private void visitScoped(boolean promote, Runnable action) {
        this.pushScope();
        try {
            Assert.check(this.checkInvariants(true, false));
            action.run();
            Assert.check(this.checkInvariants(true, promote));
            if (promote) {
                Assert.check(this.depth > 0);
                this.refs.removeExprs(this.depth, direct -> this.refs.add(new ExprRef(this.depth - 1, (boolean)direct)));
            }
        }
        finally {
            this.popScope();
        }
    }

    private void pushScope() {
        ++this.depth;
    }

    private void popScope() {
        Assert.check(this.depth >= 0);
        --this.depth;
        this.refs.removeIf(ref -> ref.getDepth() > this.depth);
    }

    private void leakAt(JCTree tree) {
        if (this.pendingWarning != null) {
            return;
        }
        this.callStack.push(tree.pos());
        this.pendingWarning = this.callStack.toArray(new JCDiagnostic.DiagnosticPosition[0]);
        this.callStack.pop();
    }

    private boolean copyPendingWarning() {
        if (this.pendingWarning == null) {
            return false;
        }
        this.warningList.add(this.pendingWarning);
        this.pendingWarning = null;
        return true;
    }

    private boolean isParamOrVar(Symbol sym) {
        return sym != null && sym.kind == Kinds.Kind.VAR && (sym.owner.kind == Kinds.Kind.MTH || sym.owner.kind == Kinds.Kind.VAR);
    }

    private boolean isExplicitThisReference(Types types, Type.ClassType currentClass, JCTree tree) {
        switch (tree.getTag()) {
            case PARENS: {
                return this.isExplicitThisReference(types, currentClass, TreeInfo.skipParens(tree));
            }
            case IDENT: {
                JCTree.JCIdent ident = (JCTree.JCIdent)tree;
                Names names = ident.name.table.names;
                return ident.name == names._this;
            }
            case SELECT: {
                JCTree.JCFieldAccess select = (JCTree.JCFieldAccess)tree;
                Type selectedType = types.erasure(select.selected.type);
                if (!selectedType.hasTag(TypeTag.CLASS)) {
                    return false;
                }
                Symbol.ClassSymbol currentClassSym = (Symbol.ClassSymbol)((Type.ClassType)types.erasure((Type)currentClass)).tsym;
                Symbol.ClassSymbol selectedClassSym = (Symbol.ClassSymbol)((Type.ClassType)selectedType).tsym;
                Names names = select.name.table.names;
                return currentClassSym.isSubClass(selectedClassSym, types) && (select.name == names._super || select.name == names._this && (currentClassSym == selectedClassSym || !currentClassSym.isEnclosedBy(selectedClassSym)));
            }
        }
        return false;
    }

    private boolean isAnalyzing() {
        return this.targetClass != null;
    }

    private boolean checkInvariants(boolean analyzing, boolean allowExpr) {
        Assert.check(analyzing == this.isAnalyzing());
        if (this.isAnalyzing()) {
            Assert.check(this.methodClass != null);
            Assert.check(this.targetClass != null);
            Assert.check(this.refs != null);
            Assert.check(this.depth >= 0);
            Assert.check(this.refs.stream().noneMatch(ref -> ref.getDepth() > this.depth));
            Assert.check(allowExpr || !this.refs.contains(ExprRef.direct(this.depth)));
            Assert.check(allowExpr || !this.refs.contains(ExprRef.indirect(this.depth)));
        } else {
            Assert.check(this.targetClass == null);
            Assert.check(this.refs == null);
            Assert.check(this.depth == -1);
            Assert.check(this.callStack.isEmpty());
            Assert.check(this.pendingWarning == null);
            Assert.check(this.invocations.isEmpty());
        }
        return true;
    }

    private static class RefSet<T extends Ref>
    extends HashSet<T> {
        private RefSet() {
        }

        public static <T extends Ref> RefSet<T> newEmpty() {
            return new RefSet<T>();
        }

        public boolean discardExprs(int depth) {
            return this.remove(ExprRef.direct(depth)) | this.remove(ExprRef.indirect(depth));
        }

        public RefSet<ExprRef> removeExprs(int depth) {
            return Stream.of(ExprRef.direct(depth), ExprRef.indirect(depth)).filter(this::remove).collect(Collectors.toCollection(RefSet::new));
        }

        public void removeExprs(int depth, Consumer<? super Boolean> handler) {
            Stream.of(ExprRef.direct(depth), ExprRef.indirect(depth)).filter(this::remove).map(Ref::isDirect).forEach(handler);
        }

        public void replace(Class<? extends Ref> type, Function<Boolean, ? extends T> mapper) {
            List oldRefs = this.stream().filter(type::isInstance).collect(List.collector());
            this.removeAll(oldRefs);
            oldRefs.stream().map(Ref::isDirect).map(mapper).forEach(this::add);
        }

        public void replaceExprs(int depth, Function<Boolean, ? extends T> mapper) {
            this.removeExprs(depth, direct -> this.add((Ref)mapper.apply((Boolean)direct)));
        }

        public <S extends Ref> void mapInto(RefSet<S> dest, Class<? extends Ref> type, Function<Boolean, ? extends S> mapper) {
            List newRefs = this.stream().filter(type::isInstance).map(Ref::isDirect).map(mapper).collect(List.collector());
            dest.addAll(newRefs);
        }

        @Override
        public RefSet<T> clone() {
            return (RefSet)super.clone();
        }
    }

    private static class ExprRef
    extends Ref {
        ExprRef(int depth, boolean direct) {
            super(depth, direct);
        }

        public static ExprRef direct(int depth) {
            return new ExprRef(depth, true);
        }

        public static ExprRef indirect(int depth) {
            return new ExprRef(depth, false);
        }
    }

    private static class ThisRef
    extends Ref {
        ThisRef(boolean direct) {
            super(0, direct);
        }

        public static ThisRef direct() {
            return new ThisRef(true);
        }

        public static ThisRef indirect() {
            return new ThisRef(false);
        }
    }

    private static final class MethodInfo {
        private final JCTree.JCClassDecl declaringClass;
        private final JCTree.JCMethodDecl declaration;
        private final boolean analyzable;
        private final boolean invokable;

        private MethodInfo(JCTree.JCClassDecl declaringClass, JCTree.JCMethodDecl declaration, boolean analyzable, boolean invokable) {
            this.declaringClass = declaringClass;
            this.declaration = declaration;
            this.analyzable = analyzable;
            this.invokable = invokable;
        }

        public final String toString() {
            return "MethodInfo[" + "declaringClass=" + Objects.toString(this.declaringClass) + ", declaration=" + Objects.toString(this.declaration) + ", analyzable=" + Boolean.toString(this.analyzable) + ", invokable=" + Boolean.toString(this.invokable) + "]";
        }

        public final int hashCode() {
            return 31 * (31 * (31 * (31 * 0 + Objects.hashCode(this.declaringClass)) + Objects.hashCode(this.declaration)) + Boolean.hashCode(this.analyzable)) + Boolean.hashCode(this.invokable);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean equals(Object o) {
            if (!(o instanceof MethodInfo)) return false;
            MethodInfo methodInfo = (MethodInfo)o;
            if (this.invokable != methodInfo.invokable) return false;
            if (this.analyzable != methodInfo.analyzable) return false;
            if (!Objects.equals(this.declaration, methodInfo.declaration)) return false;
            if (!Objects.equals(this.declaringClass, methodInfo.declaringClass)) return false;
            return true;
        }

        public JCTree.JCClassDecl declaringClass() {
            return this.declaringClass;
        }

        public JCTree.JCMethodDecl declaration() {
            return this.declaration;
        }

        public boolean analyzable() {
            return this.analyzable;
        }

        public boolean invokable() {
            return this.invokable;
        }
    }

    private static class ReturnRef
    extends Ref {
        ReturnRef(boolean direct) {
            super(0, direct);
        }
    }

    private static class OuterRef
    extends Ref {
        OuterRef(boolean direct) {
            super(0, direct);
        }
    }

    private static class VarRef
    extends Ref {
        private final Symbol.VarSymbol sym;

        VarRef(Symbol.VarSymbol sym, boolean direct) {
            super(0, direct);
            this.sym = sym;
        }

        public Symbol.VarSymbol getSymbol() {
            return this.sym;
        }

        public static VarRef direct(Symbol.VarSymbol sym) {
            return new VarRef(sym, true);
        }

        public static VarRef indirect(Symbol.VarSymbol sym) {
            return new VarRef(sym, false);
        }

        @Override
        public int hashCode() {
            return super.hashCode() ^ Objects.hashCode(this.sym);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            VarRef that = (VarRef)obj;
            return Objects.equals(this.sym, that.sym);
        }

        @Override
        protected void addProperties(ArrayList<String> properties) {
            super.addProperties(properties);
            properties.add("sym=" + this.sym);
        }
    }

    private static abstract class Ref {
        private final int depth;
        private final boolean direct;

        Ref(int depth, boolean direct) {
            this.depth = depth;
            this.direct = direct;
        }

        public int getDepth() {
            return this.depth;
        }

        public boolean isDirect() {
            return this.direct;
        }

        public int hashCode() {
            return this.getClass().hashCode() ^ Integer.hashCode(this.depth) ^ Boolean.hashCode(this.direct);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Ref that = (Ref)obj;
            return this.depth == that.depth && this.direct == that.direct;
        }

        public String toString() {
            ArrayList<String> properties = new ArrayList<String>();
            this.addProperties(properties);
            return this.getClass().getSimpleName() + "[" + properties.stream().collect(Collectors.joining(",")) + "]";
        }

        protected void addProperties(ArrayList<String> properties) {
            properties.add("depth=" + this.depth);
            properties.add(this.direct ? "direct" : "indirect");
        }
    }

    private static class YieldRef
    extends Ref {
        YieldRef(boolean direct) {
            super(0, direct);
        }
    }
}

