/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.comp;

import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.DeferredLintHandler;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeAnnotationPosition;
import com.sun.tools.javac.code.TypeMetadata;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Check;
import com.sun.tools.javac.comp.ConstFold;
import com.sun.tools.javac.comp.Enter;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.MemberEnter;
import com.sun.tools.javac.comp.Resolve;
import com.sun.tools.javac.comp.TypeEnvs;
import com.sun.tools.javac.resources.CompilerProperties;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Pair;
import com.sun.tools.javac.util.Warner;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.tools.JavaFileObject;

public class Annotate {
    protected static final Context.Key<Annotate> annotateKey = new Context.Key();
    private final Attr attr;
    private final Check chk;
    private final ConstFold cfolder;
    private final DeferredLintHandler deferredLintHandler;
    private final Enter enter;
    private final Lint lint;
    private final Log log;
    private final Names names;
    private final Resolve resolve;
    private final TreeMaker make;
    private final Symtab syms;
    private final TypeEnvs typeEnvs;
    private final Types types;
    private final Attribute theUnfinishedDefaultValue;
    private final String sourceName;
    private int blockCount = 0;
    private ListBuffer<Runnable> q = new ListBuffer();
    private ListBuffer<Runnable> validateQ = new ListBuffer();
    private int flushCount = 0;
    ListBuffer<Runnable> typesQ = new ListBuffer();
    ListBuffer<Runnable> afterTypesQ = new ListBuffer();
    private AnnotationTypeCompleter theSourceCompleter = new AnnotationTypeCompleter(){

        @Override
        public void complete(Symbol.ClassSymbol sym) throws Symbol.CompletionFailure {
            Env<AttrContext> context = Annotate.this.typeEnvs.get(sym);
            Annotate.this.attributeAnnotationType(context);
        }
    };

    public static Annotate instance(Context context) {
        Annotate instance = context.get(annotateKey);
        if (instance == null) {
            instance = new Annotate(context);
        }
        return instance;
    }

    protected Annotate(Context context) {
        context.put(annotateKey, this);
        this.attr = Attr.instance(context);
        this.chk = Check.instance(context);
        this.cfolder = ConstFold.instance(context);
        this.deferredLintHandler = DeferredLintHandler.instance(context);
        this.enter = Enter.instance(context);
        this.log = Log.instance(context);
        this.lint = Lint.instance(context);
        this.make = TreeMaker.instance(context);
        this.names = Names.instance(context);
        this.resolve = Resolve.instance(context);
        this.syms = Symtab.instance(context);
        this.typeEnvs = TypeEnvs.instance(context);
        this.types = Types.instance(context);
        this.theUnfinishedDefaultValue = new Attribute.Error(this.syms.errType);
        Source source = Source.instance(context);
        this.sourceName = source.name;
        this.blockCount = 1;
    }

    public void blockAnnotations() {
        ++this.blockCount;
    }

    public void unblockAnnotations() {
        --this.blockCount;
        if (this.blockCount == 0) {
            this.flush();
        }
    }

    public void unblockAnnotationsNoFlush() {
        --this.blockCount;
    }

    public boolean annotationsBlocked() {
        return this.blockCount > 0;
    }

    public void enterDone() {
        this.unblockAnnotations();
    }

    public List<Attribute.TypeCompound> fromAnnotations(List<JCTree.JCAnnotation> annotations) {
        if (annotations.isEmpty()) {
            return List.nil();
        }
        ListBuffer<Attribute.TypeCompound> buf = new ListBuffer<Attribute.TypeCompound>();
        for (JCTree.JCAnnotation anno : annotations) {
            Assert.checkNonNull(anno.attribute);
            buf.append((Attribute.TypeCompound)anno.attribute);
        }
        return buf.toList();
    }

    public void normal(Runnable r) {
        this.q.append(r);
    }

    public void validate(Runnable a) {
        this.validateQ.append(a);
    }

    public void flush() {
        if (this.annotationsBlocked()) {
            return;
        }
        if (this.isFlushing()) {
            return;
        }
        this.startFlushing();
        try {
            while (this.q.nonEmpty()) {
                this.q.next().run();
            }
            while (this.typesQ.nonEmpty()) {
                this.typesQ.next().run();
            }
            while (this.afterTypesQ.nonEmpty()) {
                this.afterTypesQ.next().run();
            }
            while (this.validateQ.nonEmpty()) {
                this.validateQ.next().run();
            }
        }
        finally {
            this.doneFlushing();
        }
    }

    private boolean isFlushing() {
        return this.flushCount > 0;
    }

    private void startFlushing() {
        ++this.flushCount;
    }

    private void doneFlushing() {
        --this.flushCount;
    }

    public void typeAnnotation(Runnable a) {
        this.typesQ.append(a);
    }

    public void afterTypes(Runnable a) {
        this.afterTypesQ.append(a);
    }

    public void annotateLater(List<JCTree.JCAnnotation> annotations, Env<AttrContext> localEnv, Symbol s, JCDiagnostic.DiagnosticPosition deferPos) {
        if (annotations.isEmpty()) {
            return;
        }
        s.resetAnnotations();
        this.normal(() -> {
            Assert.check(s.kind == Kinds.Kind.PCK || s.annotationsPendingCompletion());
            JavaFileObject prev = this.log.useSource(localEnv.toplevel.sourcefile);
            JCDiagnostic.DiagnosticPosition prevLintPos = deferPos != null ? this.deferredLintHandler.setPos(deferPos) : this.deferredLintHandler.immediate();
            Lint prevLint = deferPos != null ? null : this.chk.setLint(this.lint);
            try {
                if (s.hasAnnotations() && annotations.nonEmpty()) {
                    this.log.error(((JCTree.JCAnnotation)annotations.head).pos, CompilerProperties.Errors.AlreadyAnnotated(Kinds.kindName(s), s));
                }
                Assert.checkNonNull(s, "Symbol argument to actualEnterAnnotations is null");
                this.annotateNow(s, annotations, localEnv, false, false);
            }
            finally {
                if (prevLint != null) {
                    this.chk.setLint(prevLint);
                }
                this.deferredLintHandler.setPos(prevLintPos);
                this.log.useSource(prev);
            }
        });
        this.validate(() -> {
            JavaFileObject prev = this.log.useSource(localEnv.toplevel.sourcefile);
            try {
                this.chk.validateAnnotations(annotations, TreeInfo.declarationFor(s, localEnv.tree), s);
            }
            finally {
                this.log.useSource(prev);
            }
        });
    }

    public void annotateDefaultValueLater(JCTree.JCExpression defaultValue, Env<AttrContext> localEnv, Symbol.MethodSymbol m, JCDiagnostic.DiagnosticPosition deferPos) {
        this.normal(() -> {
            JavaFileObject prev = this.log.useSource(localEnv.toplevel.sourcefile);
            JCDiagnostic.DiagnosticPosition prevLintPos = this.deferredLintHandler.setPos(deferPos);
            try {
                this.enterDefaultValue(defaultValue, localEnv, m);
            }
            finally {
                this.deferredLintHandler.setPos(prevLintPos);
                this.log.useSource(prev);
            }
        });
        this.validate(() -> {
            JavaFileObject prev = this.log.useSource(localEnv.toplevel.sourcefile);
            try {
                this.chk.validateAnnotationTree(defaultValue);
            }
            finally {
                this.log.useSource(prev);
            }
        });
    }

    private void enterDefaultValue(JCTree.JCExpression defaultValue, Env<AttrContext> localEnv, Symbol.MethodSymbol m) {
        m.defaultValue = this.attributeAnnotationValue(m.type.getReturnType(), defaultValue, localEnv);
    }

    private <T extends Attribute.Compound> void annotateNow(Symbol toAnnotate, List<JCTree.JCAnnotation> withAnnotations, Env<AttrContext> env, boolean typeAnnotations, boolean isTypeParam) {
        List<Attribute.Compound> attrs;
        LinkedHashMap annotated = new LinkedHashMap();
        HashMap<Attribute.Compound, JCDiagnostic.DiagnosticPosition> pos = new HashMap<Attribute.Compound, JCDiagnostic.DiagnosticPosition>();
        List<JCTree.JCAnnotation> al = withAnnotations;
        while (!al.isEmpty()) {
            Attribute.Compound tmp;
            JCTree.JCAnnotation a = (JCTree.JCAnnotation)al.head;
            Attribute.Compound c = typeAnnotations ? (tmp = this.attributeTypeAnnotation(a, this.syms.annotationType, env)) : (tmp = this.attributeAnnotation(a, this.syms.annotationType, env));
            Assert.checkNonNull(c, "Failed to create annotation");
            if (a.type.isErroneous() || a.type.tsym.isAnnotationType()) {
                if (annotated.containsKey(a.type.tsym)) {
                    ListBuffer<Attribute.TypeCompound> l = (ListBuffer<Attribute.TypeCompound>)annotated.get(a.type.tsym);
                    l = l.append((Attribute.TypeCompound)c);
                    annotated.put(a.type.tsym, l);
                    pos.put(c, a.pos());
                } else {
                    annotated.put(a.type.tsym, ListBuffer.of(c));
                    pos.put(c, a.pos());
                }
            }
            if (!c.type.isErroneous() && (toAnnotate.kind == Kinds.Kind.MDL || toAnnotate.owner.kind != Kinds.Kind.MTH) && this.types.isSameType(c.type, this.syms.deprecatedType)) {
                toAnnotate.flags_field |= 0x40000000020000L;
                if (this.isAttributeTrue(c.member(this.names.forRemoval))) {
                    toAnnotate.flags_field |= 0x80000000000000L;
                }
            }
            if (!c.type.isErroneous() && this.types.isSameType(c.type, this.syms.previewFeatureType)) {
                toAnnotate.flags_field |= 0x100000000000000L;
                if (this.isAttributeTrue(c.member(this.names.reflective))) {
                    toAnnotate.flags_field |= 0x400000000000000L;
                }
            }
            if (!c.type.isErroneous() && toAnnotate.kind == Kinds.Kind.TYP && this.types.isSameType(c.type, this.syms.valueBasedType)) {
                toAnnotate.flags_field |= 0x20000000000000L;
            }
            if (!c.type.isErroneous() && this.types.isSameType(c.type, this.syms.restrictedType)) {
                toAnnotate.flags_field |= 0x4000000000000000L;
            }
            al = al.tail;
        }
        List<Object> buf = List.nil();
        for (ListBuffer lb : annotated.values()) {
            if (lb.size() == 1) {
                buf = buf.prepend((Attribute.Compound)lb.first());
                continue;
            }
            AnnotationContext ctx = new AnnotationContext(env, annotated, pos, typeAnnotations);
            Object res = this.makeContainerAnnotation(lb.toList(), ctx, toAnnotate, isTypeParam);
            if (res == null) continue;
            buf = buf.prepend(res);
        }
        if (typeAnnotations) {
            attrs = buf.reverse();
            toAnnotate.appendUniqueTypeAttributes(attrs);
        } else {
            attrs = buf.reverse();
            toAnnotate.resetAnnotations();
            toAnnotate.setDeclarationAttributes(attrs);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isAttributeTrue(Attribute attr) {
        if (!(attr instanceof Attribute.Constant)) return false;
        Attribute.Constant constant = (Attribute.Constant)attr;
        if (constant.type != this.syms.booleanType) return false;
        if ((Integer)constant.value == 0) return false;
        return true;
    }

    public Attribute.Compound attributeAnnotation(JCTree.JCAnnotation tree, Type expectedAnnotationType, Env<AttrContext> env) {
        Attribute.Compound ac;
        if (tree.attribute != null && tree.type != null) {
            return tree.attribute;
        }
        List<Pair<Symbol.MethodSymbol, Attribute>> elems = this.attributeAnnotationValues(tree, expectedAnnotationType, env);
        tree.attribute = ac = new Attribute.Compound(tree.type, elems);
        return tree.attribute;
    }

    public Attribute.TypeCompound attributeTypeAnnotation(JCTree.JCAnnotation a, Type expectedAnnotationType, Env<AttrContext> env) {
        Attribute.Compound compound;
        if (a.attribute == null || a.type == null || !((compound = a.attribute) instanceof Attribute.TypeCompound)) {
            List<Pair<Symbol.MethodSymbol, Attribute>> elems = this.attributeAnnotationValues(a, expectedAnnotationType, env);
            Attribute.TypeCompound tc = new Attribute.TypeCompound(a.type, elems, TypeAnnotationPosition.unknown);
            a.attribute = tc;
            return tc;
        }
        Attribute.TypeCompound typeCompound = (Attribute.TypeCompound)compound;
        return typeCompound;
    }

    private List<Pair<Symbol.MethodSymbol, Attribute>> attributeAnnotationValues(JCTree.JCAnnotation a, Type expected, Env<AttrContext> env) {
        Type at = a.annotationType.type != null ? a.annotationType.type : this.attr.attribType(a.annotationType, env);
        a.type = this.chk.checkType(a.annotationType.pos(), at, expected);
        boolean isError = a.type.isErroneous();
        if (!a.type.tsym.isAnnotationType() && !isError) {
            this.log.error(a.annotationType.pos(), CompilerProperties.Errors.NotAnnotationType(a.type));
            isError = true;
        }
        List<JCTree.JCExpression> args = a.args;
        boolean elidedValue = false;
        if (args.length() == 1 && !((JCTree.JCExpression)args.head).hasTag(JCTree.Tag.ASSIGN)) {
            args.head = this.make.at(((JCTree.JCExpression)args.head).pos).Assign(this.make.Ident(this.names.value), (JCTree.JCExpression)args.head);
            elidedValue = true;
        }
        ListBuffer<Pair<Symbol.MethodSymbol, Attribute>> buf = new ListBuffer<Pair<Symbol.MethodSymbol, Attribute>>();
        List<JCTree.JCExpression> tl = args;
        while (tl.nonEmpty()) {
            Pair<Symbol.MethodSymbol, Attribute> p = this.attributeAnnotationNameValuePair((JCTree.JCExpression)tl.head, a.type, isError, env, elidedValue);
            if (p != null && !((Symbol.MethodSymbol)p.fst).type.isErroneous()) {
                buf.append(p);
            }
            tl = tl.tail;
        }
        return buf.toList();
    }

    private Pair<Symbol.MethodSymbol, Attribute> attributeAnnotationNameValuePair(JCTree.JCExpression nameValuePair, Type thisAnnotationType, boolean badAnnotation, Env<AttrContext> env, boolean elidedValue) {
        Symbol method;
        if (!nameValuePair.hasTag(JCTree.Tag.ASSIGN)) {
            this.log.error(nameValuePair.pos(), CompilerProperties.Errors.AnnotationValueMustBeNameValue);
            nameValuePair.type = this.syms.errType;
            this.attributeAnnotationValue(nameValuePair.type, nameValuePair, env);
            return null;
        }
        JCTree.JCAssign assign = (JCTree.JCAssign)nameValuePair;
        if (!assign.lhs.hasTag(JCTree.Tag.IDENT)) {
            this.log.error(nameValuePair.pos(), CompilerProperties.Errors.AnnotationValueMustBeNameValue);
            nameValuePair.type = this.syms.errType;
            this.attributeAnnotationValue(nameValuePair.type, nameValuePair, env);
            return null;
        }
        JCTree.JCIdent left = (JCTree.JCIdent)assign.lhs;
        left.sym = method = this.resolve.resolveQualifiedMethod(elidedValue ? assign.rhs.pos() : left.pos(), env, thisAnnotationType, left.name, List.nil(), null);
        left.type = method.type;
        this.chk.checkDeprecated(left, ((AttrContext)env.info).scope.owner, method);
        if (method.owner != thisAnnotationType.tsym && !badAnnotation) {
            this.log.error(left.pos(), CompilerProperties.Errors.NoAnnotationMember(left.name, thisAnnotationType));
        }
        Type resultType = method.type.getReturnType();
        Attribute value = this.attributeAnnotationValue(resultType, assign.rhs, env);
        nameValuePair.type = resultType;
        return method.type.isErroneous() ? null : new Pair<Symbol.MethodSymbol, Attribute>((Symbol.MethodSymbol)method, value);
    }

    private Attribute attributeAnnotationValue(Type expectedElementType, JCTree.JCExpression tree, Env<AttrContext> env) {
        try {
            expectedElementType.tsym.complete();
        }
        catch (Symbol.CompletionFailure e) {
            this.log.error(tree.pos(), CompilerProperties.Errors.CantResolve(Kinds.kindName(e.sym), e.sym.getQualifiedName(), null, null));
            expectedElementType = this.syms.errType;
        }
        if (expectedElementType.hasTag(TypeTag.ARRAY)) {
            return this.getAnnotationArrayValue(expectedElementType, tree, env);
        }
        if (tree.hasTag(JCTree.Tag.NEWARRAY)) {
            if (!expectedElementType.isErroneous()) {
                this.log.error(tree.pos(), CompilerProperties.Errors.AnnotationValueNotAllowableType);
            }
            JCTree.JCNewArray na = (JCTree.JCNewArray)tree;
            if (na.elemtype != null) {
                this.log.error(na.elemtype.pos(), CompilerProperties.Errors.NewNotAllowedInAnnotation);
            }
            List<JCTree.JCExpression> l = na.elems;
            while (l.nonEmpty()) {
                this.attributeAnnotationValue(this.syms.errType, (JCTree.JCExpression)l.head, env);
                l = l.tail;
            }
            return new Attribute.Error(this.syms.errType);
        }
        if (expectedElementType.tsym.isAnnotationType()) {
            if (tree.hasTag(JCTree.Tag.ANNOTATION)) {
                return this.attributeAnnotation((JCTree.JCAnnotation)tree, expectedElementType, env);
            }
            this.log.error(tree.pos(), CompilerProperties.Errors.AnnotationValueMustBeAnnotation);
            expectedElementType = this.syms.errType;
        }
        if (tree.hasTag(JCTree.Tag.ANNOTATION)) {
            if (!expectedElementType.isErroneous()) {
                this.log.error(tree.pos(), CompilerProperties.Errors.AnnotationNotValidForType(expectedElementType));
            }
            this.attributeAnnotation((JCTree.JCAnnotation)tree, this.syms.errType, env);
            return new Attribute.Error(((JCTree.JCAnnotation)tree).annotationType.type);
        }
        MemberEnter.InitTreeVisitor initTreeVisitor = new MemberEnter.InitTreeVisitor(){

            @Override
            public void visitTypeIdent(JCTree.JCPrimitiveTypeTree that) {
            }

            @Override
            public void visitTypeArray(JCTree.JCArrayTypeTree that) {
            }
        };
        tree.accept(initTreeVisitor);
        if (!initTreeVisitor.result) {
            this.log.error(tree.pos(), CompilerProperties.Errors.ExpressionNotAllowableAsAnnotationValue);
            return new Attribute.Error(this.syms.errType);
        }
        if (expectedElementType.isPrimitive() || this.types.isSameType(expectedElementType, this.syms.stringType) && !expectedElementType.hasTag(TypeTag.ERROR)) {
            return this.getAnnotationPrimitiveValue(expectedElementType, tree, env);
        }
        if (expectedElementType.tsym == this.syms.classType.tsym) {
            return this.getAnnotationClassValue(expectedElementType, tree, env);
        }
        if (expectedElementType.hasTag(TypeTag.CLASS) && (expectedElementType.tsym.flags() & 0x4000L) != 0L) {
            return this.getAnnotationEnumValue(expectedElementType, tree, env);
        }
        if (!expectedElementType.isErroneous()) {
            this.log.error(tree.pos(), CompilerProperties.Errors.AnnotationValueNotAllowableType);
        }
        return new Attribute.Error(this.attr.attribExpr(tree, env, expectedElementType));
    }

    private Attribute getAnnotationEnumValue(Type expectedElementType, JCTree.JCExpression tree, Env<AttrContext> env) {
        Type result = this.attr.attribTree(tree, env, this.annotationValueInfo(expectedElementType));
        Symbol sym = TreeInfo.symbol(tree);
        if (sym == null || TreeInfo.nonstaticSelect(tree) || sym.kind != Kinds.Kind.VAR || (sym.flags() & 0x4000L) == 0L) {
            this.log.error(tree.pos(), CompilerProperties.Errors.EnumAnnotationMustBeEnumConstant);
            return new Attribute.Error(result.getOriginalType());
        }
        Symbol.VarSymbol enumerator = (Symbol.VarSymbol)sym;
        return new Attribute.Enum(expectedElementType, enumerator);
    }

    private Attribute getAnnotationClassValue(Type expectedElementType, JCTree.JCExpression tree, Env<AttrContext> env) {
        Type result = this.attr.attribTree(tree, env, this.annotationValueInfo(expectedElementType));
        if (result.isErroneous()) {
            if (TreeInfo.name(tree) == this.names._class && ((JCTree.JCFieldAccess)tree).selected.type.isErroneous()) {
                Name n = ((JCTree.JCFieldAccess)tree).selected.type.tsym.flatName();
                return new Attribute.UnresolvedClass(expectedElementType, this.types.createErrorType(n, this.syms.unknownSymbol, this.syms.classType));
            }
            return new Attribute.Error(result.getOriginalType());
        }
        if (TreeInfo.name(tree) != this.names._class) {
            this.log.error(tree.pos(), CompilerProperties.Errors.AnnotationValueMustBeClassLiteral);
            return new Attribute.Error(this.syms.errType);
        }
        return new Attribute.Class(this.types, ((JCTree.JCFieldAccess)tree).selected.type);
    }

    private Attribute getAnnotationPrimitiveValue(Type expectedElementType, JCTree.JCExpression tree, Env<AttrContext> env) {
        Type result = this.attr.attribTree(tree, env, this.annotationValueInfo(expectedElementType));
        if (result.isErroneous()) {
            return new Attribute.Error(result.getOriginalType());
        }
        if (result.constValue() == null) {
            this.log.error(tree.pos(), CompilerProperties.Errors.AttributeValueMustBeConstant);
            return new Attribute.Error(expectedElementType);
        }
        if (tree.type != null && tree.type.tsym != null) {
            this.queueScanTreeAndTypeAnnotate(tree, env, tree.type.tsym, tree.pos());
        }
        result = this.cfolder.coerce(result, expectedElementType);
        return new Attribute.Constant(expectedElementType, result.constValue());
    }

    private Attr.ResultInfo annotationValueInfo(Type pt) {
        return this.attr.unknownExprInfo.dup(pt, new AnnotationValueContext(this.attr.unknownExprInfo.checkContext));
    }

    private Attribute getAnnotationArrayValue(Type expectedElementType, JCTree.JCExpression tree, Env<AttrContext> env) {
        if (!tree.hasTag(JCTree.Tag.NEWARRAY)) {
            tree = this.make.at(tree.pos).NewArray(null, List.nil(), List.of(tree));
        }
        JCTree.JCNewArray na = (JCTree.JCNewArray)tree;
        List<JCTree.JCExpression> elems = na.elems;
        if (na.elemtype != null) {
            this.log.error(na.elemtype.pos(), CompilerProperties.Errors.NewNotAllowedInAnnotation);
            if (elems == null) {
                elems = List.nil();
            }
        }
        ListBuffer<Attribute> buf = new ListBuffer<Attribute>();
        List<JCTree.JCExpression> l = elems;
        while (l.nonEmpty()) {
            buf.append(this.attributeAnnotationValue(this.types.elemtype(expectedElementType), (JCTree.JCExpression)l.head, env));
            l = l.tail;
        }
        na.type = expectedElementType;
        return new Attribute.Array(expectedElementType, buf.toArray(new Attribute[buf.length()]));
    }

    private <T extends Attribute.Compound> T processRepeatedAnnotations(List<T> annotations, AnnotationContext<T> ctx, Symbol on, boolean isTypeParam) {
        Attribute.Compound firstOccurrence = (Attribute.Compound)annotations.head;
        List<Attribute> repeated = List.nil();
        Type origAnnoType = null;
        Type.ArrayType arrayOfOrigAnnoType = null;
        Type targetContainerType = null;
        Symbol.MethodSymbol containerValueSymbol = null;
        Assert.check(!annotations.isEmpty() && !annotations.tail.isEmpty());
        int count = 0;
        List<Object> al = annotations;
        while (!al.isEmpty()) {
            Assert.check(++count > 1 || !al.tail.isEmpty());
            Attribute.Compound currentAnno = (Attribute.Compound)al.head;
            origAnnoType = currentAnno.type;
            if (arrayOfOrigAnnoType == null) {
                arrayOfOrigAnnoType = this.types.makeArrayType(origAnnoType);
            }
            boolean reportError = count > 1;
            Type currentContainerType = this.getContainingType(currentAnno, ctx.pos.get(currentAnno), reportError);
            if (currentContainerType != null) {
                Assert.check(targetContainerType == null || currentContainerType == targetContainerType);
                targetContainerType = currentContainerType;
                containerValueSymbol = this.validateContainer(targetContainerType, origAnnoType, ctx.pos.get(currentAnno));
                if (containerValueSymbol != null) {
                    repeated = repeated.prepend(currentAnno);
                }
            }
            al = al.tail;
        }
        if (!repeated.isEmpty() && targetContainerType == null) {
            this.log.error(ctx.pos.get(annotations.head), CompilerProperties.Errors.DuplicateAnnotationInvalidRepeated(origAnnoType));
            return null;
        }
        if (!repeated.isEmpty()) {
            boolean isRecordMember;
            repeated = repeated.reverse();
            JCDiagnostic.DiagnosticPosition pos = ctx.pos.get(firstOccurrence);
            TreeMaker m = this.make.at(pos);
            Pair<Object, Attribute.Array> p = new Pair<Object, Attribute.Array>(containerValueSymbol, new Attribute.Array((Type)arrayOfOrigAnnoType, repeated));
            if (ctx.isTypeCompound) {
                Attribute.TypeCompound at = new Attribute.TypeCompound(targetContainerType, List.of(p), ((Attribute.TypeCompound)annotations.head).position);
                JCTree.JCAnnotation annoTree = m.TypeAnnotation(at);
                if (!this.chk.validateAnnotationDeferErrors(annoTree)) {
                    this.log.error(annoTree.pos(), CompilerProperties.Errors.DuplicateAnnotationInvalidRepeated(origAnnoType));
                }
                if (!this.chk.isTypeAnnotation(annoTree, isTypeParam)) {
                    this.log.error(pos, isTypeParam ? CompilerProperties.Errors.InvalidRepeatableAnnotationNotApplicable(targetContainerType, on) : CompilerProperties.Errors.InvalidRepeatableAnnotationNotApplicableInContext(targetContainerType));
                }
                at.setSynthesized(true);
                Attribute.TypeCompound x = at;
                return (T)x;
            }
            Attribute.Compound c = new Attribute.Compound(targetContainerType, List.of(p));
            JCTree.JCAnnotation annoTree = m.Annotation(c);
            boolean bl = isRecordMember = (on.flags_field & 0x2000000000000000L) != 0L || on.enclClass() != null && on.enclClass().isRecord();
            if (!this.chk.annotationApplicable(annoTree, on) && (!isRecordMember || isRecordMember && (on.flags_field & 0x1000000L) == 0L)) {
                this.log.error(annoTree.pos(), CompilerProperties.Errors.InvalidRepeatableAnnotationNotApplicable(targetContainerType, on));
            }
            if (!this.chk.validateAnnotationDeferErrors(annoTree)) {
                this.log.error(annoTree.pos(), CompilerProperties.Errors.DuplicateAnnotationInvalidRepeated(origAnnoType));
            }
            c = this.attributeAnnotation(annoTree, targetContainerType, ctx.env);
            c.setSynthesized(true);
            Attribute.Compound x = c;
            return (T)x;
        }
        return null;
    }

    private Type getContainingType(Attribute.Compound currentAnno, JCDiagnostic.DiagnosticPosition pos, boolean reportError) {
        Type origAnnoType = currentAnno.type;
        Symbol.TypeSymbol origAnnoDecl = origAnnoType.tsym;
        Attribute.Compound ca = origAnnoDecl.getAnnotationTypeMetadata().getRepeatable();
        if (ca == null) {
            if (reportError) {
                this.log.error(pos, CompilerProperties.Errors.DuplicateAnnotationMissingContainer(origAnnoType));
            }
            return null;
        }
        return this.filterSame(this.extractContainingType(ca, pos, origAnnoDecl), origAnnoType);
    }

    private Type filterSame(Type t, Type s) {
        if (t == null || s == null) {
            return t;
        }
        return this.types.isSameType(t, s) ? null : t;
    }

    private Type extractContainingType(Attribute.Compound ca, JCDiagnostic.DiagnosticPosition pos, Symbol.TypeSymbol annoDecl) {
        if (ca.values.isEmpty()) {
            this.log.error(pos, CompilerProperties.Errors.InvalidRepeatableAnnotation(annoDecl));
            return null;
        }
        Pair p = (Pair)ca.values.head;
        Name name = ((Symbol.MethodSymbol)p.fst).name;
        if (name != this.names.value) {
            this.log.error(pos, CompilerProperties.Errors.InvalidRepeatableAnnotation(annoDecl));
            return null;
        }
        Object b = p.snd;
        if (!(b instanceof Attribute.Class)) {
            this.log.error(pos, CompilerProperties.Errors.InvalidRepeatableAnnotation(annoDecl));
            return null;
        }
        Attribute.Class attributeClass = (Attribute.Class)b;
        return attributeClass.getValue();
    }

    private Symbol.MethodSymbol validateContainer(Type targetContainerType, Type originalAnnoType, JCDiagnostic.DiagnosticPosition pos) {
        Symbol.MethodSymbol containerValueSymbol = null;
        boolean fatalError = false;
        Scope.WriteableScope scope = targetContainerType.tsym.members();
        int nr_value_elems = 0;
        boolean error = false;
        for (Symbol elm : scope.getSymbolsByName(this.names.value)) {
            if (++nr_value_elems == 1 && elm.kind == Kinds.Kind.MTH) {
                containerValueSymbol = (Symbol.MethodSymbol)elm;
                continue;
            }
            error = true;
        }
        if (error) {
            this.log.error(pos, CompilerProperties.Errors.InvalidRepeatableAnnotationMultipleValues(targetContainerType, nr_value_elems));
            return null;
        }
        if (nr_value_elems == 0) {
            this.log.error(pos, CompilerProperties.Errors.InvalidRepeatableAnnotationNoValue(targetContainerType));
            return null;
        }
        if (containerValueSymbol.kind != Kinds.Kind.MTH) {
            this.log.error(pos, CompilerProperties.Errors.InvalidRepeatableAnnotationInvalidValue(targetContainerType));
            fatalError = true;
        }
        Type valueRetType = containerValueSymbol.type.getReturnType();
        Type.ArrayType expectedType = this.types.makeArrayType(originalAnnoType);
        if (!this.types.isArray(valueRetType) || !this.types.isSameType(expectedType, valueRetType)) {
            this.log.error(pos, CompilerProperties.Errors.InvalidRepeatableAnnotationValueReturn(targetContainerType, valueRetType, (Type)expectedType));
            fatalError = true;
        }
        return fatalError ? null : containerValueSymbol;
    }

    private <T extends Attribute.Compound> T makeContainerAnnotation(List<T> toBeReplaced, AnnotationContext<T> ctx, Symbol sym, boolean isTypeParam) {
        ListBuffer manualContainer;
        T validRepeated = this.processRepeatedAnnotations(toBeReplaced, ctx, sym, isTypeParam);
        if (validRepeated != null && (manualContainer = ctx.annotated.get(((Attribute.Compound)validRepeated).type.tsym)) != null) {
            this.log.error(ctx.pos.get(manualContainer.first()), CompilerProperties.Errors.InvalidRepeatableAnnotationRepeatedAndContainerPresent(((Attribute.Compound)manualContainer.first()).type.tsym));
        }
        return validRepeated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enterTypeAnnotations(List<JCTree.JCAnnotation> annotations, Env<AttrContext> env, Symbol s, JCDiagnostic.DiagnosticPosition deferPos, boolean isTypeParam) {
        Assert.checkNonNull(s, "Symbol argument to actualEnterTypeAnnotations is nul/");
        JavaFileObject prev = this.log.useSource(env.toplevel.sourcefile);
        JCDiagnostic.DiagnosticPosition prevLintPos = null;
        if (deferPos != null) {
            prevLintPos = this.deferredLintHandler.setPos(deferPos);
        }
        try {
            this.annotateNow(s, annotations, env, true, isTypeParam);
        }
        finally {
            if (prevLintPos != null) {
                this.deferredLintHandler.setPos(prevLintPos);
            }
            this.log.useSource(prev);
        }
    }

    public void queueScanTreeAndTypeAnnotate(JCTree tree, Env<AttrContext> env, Symbol sym, JCDiagnostic.DiagnosticPosition deferPos) {
        Assert.checkNonNull(sym);
        this.normal(() -> tree.accept(new TypeAnnotate(env, sym, deferPos)));
    }

    public void annotateTypeSecondStage(JCTree tree, List<JCTree.JCAnnotation> annotations, Type storeAt) {
        this.typeAnnotation(() -> {
            List<Attribute.TypeCompound> compounds = this.fromAnnotations(annotations);
            Assert.check(annotations.size() == compounds.size());
            TypeMetadata.Annotations metadata = storeAt.getMetadata(TypeMetadata.Annotations.class);
            Assert.checkNonNull(metadata);
            Assert.check(metadata.annotationBuffer().isEmpty());
            metadata.annotationBuffer().appendList(compounds);
        });
    }

    public void annotateTypeParameterSecondStage(JCTree tree, List<JCTree.JCAnnotation> annotations) {
        this.typeAnnotation(() -> {
            List<Attribute.TypeCompound> compounds = this.fromAnnotations(annotations);
            Assert.check(annotations.size() == compounds.size());
        });
    }

    public AnnotationTypeCompleter annotationTypeSourceCompleter() {
        return this.theSourceCompleter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void attributeAnnotationType(Env<AttrContext> env) {
        Assert.check(((JCTree.JCClassDecl)env.tree).sym.isAnnotationType(), "Trying to annotation type complete a non-annotation type");
        JavaFileObject prev = this.log.useSource(env.toplevel.sourcefile);
        try {
            JCTree.JCClassDecl tree = (JCTree.JCClassDecl)env.tree;
            AnnotationTypeVisitor v = new AnnotationTypeVisitor(this.attr, this.chk, this.syms, this.typeEnvs);
            v.scanAnnotationType(tree);
            tree.sym.getAnnotationTypeMetadata().setRepeatable(v.repeatable);
            tree.sym.getAnnotationTypeMetadata().setTarget(v.target);
        }
        finally {
            this.log.useSource(prev);
        }
    }

    public Attribute unfinishedDefaultValue() {
        return this.theUnfinishedDefaultValue;
    }

    public void newRound() {
        this.blockCount = 1;
    }

    public Queues setQueues(Queues nue) {
        Queues stored = new Queues(this.q, this.validateQ, this.typesQ, this.afterTypesQ);
        this.q = nue.q;
        this.typesQ = nue.typesQ;
        this.afterTypesQ = nue.afterTypesQ;
        this.validateQ = nue.validateQ;
        return stored;
    }

    public static interface AnnotationTypeCompleter {
        public void complete(Symbol.ClassSymbol var1) throws Symbol.CompletionFailure;
    }

    private class AnnotationContext<T extends Attribute.Compound> {
        public final Env<AttrContext> env;
        public final Map<Symbol.TypeSymbol, ListBuffer<T>> annotated;
        public final Map<T, JCDiagnostic.DiagnosticPosition> pos;
        public final boolean isTypeCompound;

        public AnnotationContext(Env<AttrContext> env, Map<Symbol.TypeSymbol, ListBuffer<T>> annotated, Map<T, JCDiagnostic.DiagnosticPosition> pos, boolean isTypeCompound) {
            Assert.checkNonNull(env);
            Assert.checkNonNull(annotated);
            Assert.checkNonNull(pos);
            this.env = env;
            this.annotated = annotated;
            this.pos = pos;
            this.isTypeCompound = isTypeCompound;
        }
    }

    class AnnotationValueContext
    extends Check.NestedCheckContext {
        AnnotationValueContext(Check.CheckContext enclosingContext) {
            super(enclosingContext);
        }

        @Override
        public boolean compatible(Type found, Type req, Warner warn) {
            return found.hasTag(TypeTag.NONE) || super.compatible(found, req, warn);
        }
    }

    public static class AnnotationTypeMetadata {
        final Symbol.ClassSymbol metaDataFor;
        private Attribute.Compound target;
        private Attribute.Compound repeatable;
        private AnnotationTypeCompleter annotationTypeCompleter;
        private static final AnnotationTypeMetadata NOT_AN_ANNOTATION_TYPE = new AnnotationTypeMetadata(null, null){

            @Override
            public void complete() {
            }

            @Override
            public String toString() {
                return "Not an annotation type";
            }

            @Override
            public Set<Symbol.MethodSymbol> getAnnotationElements() {
                return new LinkedHashSet<Symbol.MethodSymbol>(0);
            }

            @Override
            public Set<Symbol.MethodSymbol> getAnnotationElementsWithDefault() {
                return new LinkedHashSet<Symbol.MethodSymbol>(0);
            }

            @Override
            public boolean isMetadataForAnnotationType() {
                return false;
            }

            @Override
            public Attribute.Compound getTarget() {
                return null;
            }

            @Override
            public Attribute.Compound getRepeatable() {
                return null;
            }
        };

        public AnnotationTypeMetadata(Symbol.ClassSymbol metaDataFor, AnnotationTypeCompleter annotationTypeCompleter) {
            this.metaDataFor = metaDataFor;
            this.annotationTypeCompleter = annotationTypeCompleter;
        }

        private void init() {
            while (!this.metaDataFor.isCompleted()) {
                this.metaDataFor.complete();
            }
            if (this.annotationTypeCompleter != null) {
                AnnotationTypeCompleter c = this.annotationTypeCompleter;
                this.annotationTypeCompleter = null;
                c.complete(this.metaDataFor);
            }
        }

        public void complete() {
            this.init();
        }

        public Attribute.Compound getRepeatable() {
            this.init();
            return this.repeatable;
        }

        public void setRepeatable(Attribute.Compound repeatable) {
            Assert.checkNull(this.repeatable);
            this.repeatable = repeatable;
        }

        public Attribute.Compound getTarget() {
            this.init();
            return this.target;
        }

        public void setTarget(Attribute.Compound target) {
            Assert.checkNull(this.target);
            this.target = target;
        }

        public Set<Symbol.MethodSymbol> getAnnotationElements() {
            this.init();
            LinkedHashSet<Symbol.MethodSymbol> members = new LinkedHashSet<Symbol.MethodSymbol>();
            Scope.WriteableScope s = this.metaDataFor.members();
            Iterable<Symbol> ss = s.getSymbols(Scope.LookupKind.NON_RECURSIVE);
            for (Symbol sym : ss) {
                if (sym.kind != Kinds.Kind.MTH || sym.name == sym.name.table.names.clinit || (sym.flags() & 0x1000L) != 0L) continue;
                members.add((Symbol.MethodSymbol)sym);
            }
            return members;
        }

        public Set<Symbol.MethodSymbol> getAnnotationElementsWithDefault() {
            this.init();
            Set<Symbol.MethodSymbol> members = this.getAnnotationElements();
            LinkedHashSet<Symbol.MethodSymbol> res = new LinkedHashSet<Symbol.MethodSymbol>();
            for (Symbol.MethodSymbol m : members) {
                if (m.defaultValue == null) continue;
                res.add(m);
            }
            return res;
        }

        public String toString() {
            return "Annotation type for: " + this.metaDataFor;
        }

        public boolean isMetadataForAnnotationType() {
            return true;
        }

        public static AnnotationTypeMetadata notAnAnnotationType() {
            return NOT_AN_ANNOTATION_TYPE;
        }
    }

    public class AnnotationTypeVisitor
    extends TreeScanner {
        private Env<AttrContext> env;
        private final Attr attr;
        private final Check check;
        private final Symtab tab;
        private final TypeEnvs typeEnvs;
        private Attribute.Compound target;
        private Attribute.Compound repeatable;

        public AnnotationTypeVisitor(Attr attr, Check check, Symtab tab, TypeEnvs typeEnvs) {
            this.attr = attr;
            this.check = check;
            this.tab = tab;
            this.typeEnvs = typeEnvs;
        }

        public Attribute.Compound getRepeatable() {
            return this.repeatable;
        }

        public Attribute.Compound getTarget() {
            return this.target;
        }

        public void scanAnnotationType(JCTree.JCClassDecl decl) {
            this.visitClassDef(decl);
        }

        @Override
        public void visitClassDef(JCTree.JCClassDecl tree) {
            Env<AttrContext> prevEnv = this.env;
            this.env = this.typeEnvs.get(tree.sym);
            try {
                this.scan(tree.mods);
            }
            finally {
                this.env = prevEnv;
            }
        }

        @Override
        public void visitAnnotation(JCTree.JCAnnotation tree) {
            Type t = tree.annotationType.type;
            if (t == null) {
                t = this.attr.attribType(tree.annotationType, this.env);
                tree.annotationType.type = t = this.check.checkType(tree.annotationType.pos(), t, this.tab.annotationType);
            }
            if (t == this.tab.annotationTargetType) {
                this.target = Annotate.this.attributeAnnotation(tree, this.tab.annotationTargetType, this.env);
            } else if (t == this.tab.repeatableType) {
                this.repeatable = Annotate.this.attributeAnnotation(tree, this.tab.repeatableType, this.env);
            }
        }
    }

    static class Queues {
        private final ListBuffer<Runnable> q;
        private final ListBuffer<Runnable> validateQ;
        private final ListBuffer<Runnable> typesQ;
        private final ListBuffer<Runnable> afterTypesQ;

        public Queues() {
            this(new ListBuffer<Runnable>(), new ListBuffer<Runnable>(), new ListBuffer<Runnable>(), new ListBuffer<Runnable>());
        }

        public Queues(ListBuffer<Runnable> q, ListBuffer<Runnable> validateQ, ListBuffer<Runnable> typesQ, ListBuffer<Runnable> afterTypesQ) {
            this.q = q;
            this.validateQ = validateQ;
            this.typesQ = typesQ;
            this.afterTypesQ = afterTypesQ;
        }
    }

    private class TypeAnnotate
    extends TreeScanner {
        private final Env<AttrContext> env;
        private final Symbol sym;
        private JCDiagnostic.DiagnosticPosition deferPos;

        public TypeAnnotate(Env<AttrContext> env, Symbol sym, JCDiagnostic.DiagnosticPosition deferPos) {
            this.env = env;
            this.sym = sym;
            this.deferPos = deferPos;
        }

        @Override
        public void visitAnnotatedType(JCTree.JCAnnotatedType tree) {
            Annotate.this.enterTypeAnnotations(tree.annotations, this.env, this.sym, this.deferPos, false);
            this.scan(tree.underlyingType);
        }

        @Override
        public void visitTypeParameter(JCTree.JCTypeParameter tree) {
            Annotate.this.enterTypeAnnotations(tree.annotations, this.env, this.sym, this.deferPos, true);
            this.scan(tree.bounds);
        }

        @Override
        public void visitNewArray(JCTree.JCNewArray tree) {
            Annotate.this.enterTypeAnnotations(tree.annotations, this.env, this.sym, this.deferPos, false);
            for (List<JCTree.JCAnnotation> dimAnnos : tree.dimAnnotations) {
                Annotate.this.enterTypeAnnotations(dimAnnos, this.env, this.sym, this.deferPos, false);
            }
            this.scan(tree.elemtype);
            this.scan(tree.elems);
        }

        @Override
        public void visitMethodDef(JCTree.JCMethodDecl tree) {
            this.scan(tree.mods);
            this.scan(tree.restype);
            this.scan(tree.typarams);
            this.scan(tree.recvparam);
            this.scan(tree.params);
            this.scan(tree.thrown);
            this.scan(tree.defaultValue);
        }

        @Override
        public void visitVarDef(JCTree.JCVariableDecl tree) {
            JCDiagnostic.DiagnosticPosition prevPos = this.deferPos;
            this.deferPos = tree.pos();
            try {
                if (this.sym != null && this.sym.kind == Kinds.Kind.VAR) {
                    this.scan(tree.mods);
                    this.scan(tree.vartype);
                }
                this.scan(tree.init);
            }
            finally {
                this.deferPos = prevPos;
            }
        }

        @Override
        public void visitBindingPattern(JCTree.JCBindingPattern tree) {
        }

        @Override
        public void visitClassDef(JCTree.JCClassDecl tree) {
        }

        @Override
        public void visitNewClass(JCTree.JCNewClass tree) {
            this.scan(tree.encl);
            this.scan(tree.typeargs);
            if (tree.def == null) {
                this.scan(tree.clazz);
            }
            this.scan(tree.args);
        }
    }
}

