/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.nodejs.exec;

import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.base.input.InputProcessor;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.api.project.Project;
import org.netbeans.modules.javascript.nodejs.exec.Bundle;
import org.netbeans.modules.javascript.nodejs.exec.NodeProcesses;
import org.netbeans.modules.javascript.nodejs.file.PackageJson;
import org.netbeans.modules.javascript.nodejs.options.NodeJsOptions;
import org.netbeans.modules.javascript.nodejs.options.NodeJsOptionsValidator;
import org.netbeans.modules.javascript.nodejs.util.FileUtils;
import org.netbeans.modules.javascript.nodejs.util.NodeJsUtils;
import org.netbeans.modules.javascript.nodejs.util.StringUtils;
import org.netbeans.modules.web.common.api.ValidationResult;
import org.netbeans.modules.web.common.ui.api.ExternalExecutable;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;
import org.openide.windows.InputOutput;

public class NpmExecutable {
    private static final Logger LOGGER = Logger.getLogger(NpmExecutable.class.getName());
    public static final String NPM_NAME = Utilities.isWindows() ? "npm.cmd" : "npm";
    public static final String SAVE_PARAM = "--save";
    public static final String SAVE_DEV_PARAM = "--save-dev";
    public static final String SAVE_OPTIONAL_PARAM = "--save-optional";
    private static final String INSTALL_PARAM = "install";
    private static final String UNINSTALL_PARAM = "uninstall";
    private static final String RUN_SCRIPT_PARAM = "run-script";
    protected final Project project;
    protected final String npmPath;

    NpmExecutable(String npmPath, @NullAllowed Project project) {
        assert (npmPath != null);
        this.npmPath = npmPath;
        this.project = project;
    }

    @CheckForNull
    public static NpmExecutable getDefault(@NullAllowed Project project, boolean showOptions) {
        ValidationResult result = new NodeJsOptionsValidator().validateNpm().getResult();
        if (NpmExecutable.validateResult(result) != null) {
            if (showOptions) {
                OptionsDisplayer.getDefault().open("Html5/NodeJs");
            }
            return null;
        }
        return NpmExecutable.createExecutable(NodeJsOptions.getInstance().getNpm(), project);
    }

    private static NpmExecutable createExecutable(String npm, Project project) {
        if (Utilities.isMac()) {
            return new MacNpmExecutable(npm, project);
        }
        return new NpmExecutable(npm, project);
    }

    public String getExecutable() {
        return new ExternalExecutable(this.npmPath).getExecutable();
    }

    String getCommand() {
        return this.npmPath;
    }

    @CheckForNull
    public Future<Integer> runScript(String ... args) {
        assert (!EventQueue.isDispatchThread());
        assert (args.length > 0);
        assert (this.project != null);
        String script = args[0];
        this.stopRunningScript(script);
        String projectName = NodeJsUtils.getProjectDisplayName(this.project);
        AtomicReference<Future<Integer>> taskRef = new AtomicReference<Future<Integer>>();
        Future task = this.getExecutable(Bundle.NpmExecutable_run_script(projectName)).additionalParameters(this.getRunScriptParams(args)).run(this.getDescriptor(taskRef));
        taskRef.set(task);
        assert (task != null) : this.npmPath;
        this.setRunningScript(script, taskRef);
        return task;
    }

    @CheckForNull
    public Future<Integer> install(String ... args) {
        assert (!EventQueue.isDispatchThread());
        assert (this.project != null);
        String projectName = NodeJsUtils.getProjectDisplayName(this.project);
        Future task = this.getExecutable(Bundle.NpmExecutable_install(projectName)).additionalParameters(this.getInstallParams(args)).run(this.getDescriptor());
        assert (task != null) : this.npmPath;
        return task;
    }

    @CheckForNull
    public Future<Integer> uninstall(String ... args) {
        assert (!EventQueue.isDispatchThread());
        assert (this.project != null);
        String projectName = NodeJsUtils.getProjectDisplayName(this.project);
        Future task = this.getExecutable(Bundle.NpmExecutable_uninstall(projectName)).additionalParameters(this.getUninstallParams(args)).run(this.getDescriptor());
        assert (task != null) : this.npmPath;
        return task;
    }

    @CheckForNull
    public JSONObject view(String packageName) {
        ArrayList<String> params = new ArrayList<String>();
        params.add("view");
        params.add("--json");
        params.add(packageName);
        JSONObject info = null;
        try {
            StringBuilderInputProcessorFactory factory = new StringBuilderInputProcessorFactory();
            Integer exitCode = this.getExecutable("npm view").additionalParameters(this.getParams(params)).redirectErrorStream(false).runAndWait(NpmExecutable.getSilentDescriptor(), (ExecutionDescriptor.InputProcessorFactory2)factory, "");
            String result = factory.getResult();
            if (exitCode != null && exitCode == 0) {
                info = (JSONObject)new JSONParser().parse(result);
            }
        }
        catch (ExecutionException | ParseException ex) {
            LOGGER.log(Level.INFO, null, ex);
        }
        return info;
    }

    @CheckForNull
    public JSONObject list(int depth) {
        ArrayList<String> params = new ArrayList<String>();
        params.add("list");
        params.add("--json");
        params.add("--depth=" + depth);
        JSONObject info = null;
        try {
            StringBuilderInputProcessorFactory factory = new StringBuilderInputProcessorFactory();
            this.getExecutable("npm list").additionalParameters(this.getParams(params)).redirectErrorStream(false).runAndWait(NpmExecutable.getSilentDescriptor(), (ExecutionDescriptor.InputProcessorFactory2)factory, "");
            String result = factory.getResult();
            info = (JSONObject)new JSONParser().parse(result);
        }
        catch (ExecutionException | ParseException ex) {
            LOGGER.log(Level.INFO, null, ex);
        }
        return info;
    }

    @CheckForNull
    public String search(String searchTerm) {
        ArrayList<String> params = new ArrayList<String>();
        params.add("search");
        params.add("--long");
        params.add("--parseable");
        params.add(searchTerm);
        String result = null;
        StringBuilderInputProcessorFactory factory = new StringBuilderInputProcessorFactory();
        try {
            Integer exitCode = this.getExecutable("npm search").additionalParameters(this.getParams(params)).redirectErrorStream(false).runAndWait(NpmExecutable.getSilentDescriptor(), (ExecutionDescriptor.InputProcessorFactory2)factory, "");
            result = factory.getResult();
            if (result.length() == 0 && exitCode != null && exitCode != 0) {
                result = null;
            }
        }
        catch (ExecutionException ex) {
            LOGGER.log(Level.INFO, null, ex);
        }
        return result;
    }

    private ExternalExecutable getExecutable(String title) {
        assert (title != null);
        return new ExternalExecutable(this.getCommand()).workDir(this.getWorkDir()).displayName(title).optionsPath("Html5/NodeJs").noOutput(false);
    }

    private ExecutionDescriptor getDescriptor() {
        return this.getDescriptor(null);
    }

    private ExecutionDescriptor getDescriptor(final @NullAllowed AtomicReference<Future<Integer>> taskRef) {
        assert (this.project != null);
        ExecutionDescriptor descriptor = ExternalExecutable.DEFAULT_EXECUTION_DESCRIPTOR.showSuspended(true).optionsPath("Html5/NodeJs").outLineBased(true).errLineBased(true);
        if (taskRef != null) {
            descriptor = descriptor.rerunCallback(new ExecutionDescriptor.RerunCallback(){

                public void performed(Future<Integer> task) {
                    taskRef.set(task);
                }
            });
        }
        return descriptor;
    }

    private static ExecutionDescriptor getSilentDescriptor() {
        return new ExecutionDescriptor().inputOutput(InputOutput.NULL).inputVisible(false).frontWindow(false).showProgress(false).charset(StandardCharsets.UTF_8);
    }

    private File getWorkDir() {
        if (this.project == null) {
            return FileUtils.TMP_DIR;
        }
        PackageJson packageJson = new PackageJson(this.project.getProjectDirectory());
        if (packageJson.exists()) {
            return new File(packageJson.getPath()).getParentFile();
        }
        File sourceRoot = NodeJsUtils.getSourceRoot(this.project);
        if (sourceRoot != null) {
            return sourceRoot;
        }
        File workDir = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
        assert (workDir != null) : this.project.getProjectDirectory();
        return workDir;
    }

    private List<String> getRunScriptParams(String ... args) {
        ArrayList<String> params = new ArrayList<String>(args.length + 1);
        params.add(RUN_SCRIPT_PARAM);
        params.addAll(this.getArgsParams(args));
        return this.getParams(params);
    }

    private List<String> getInstallParams(String ... args) {
        ArrayList<String> params = new ArrayList<String>(args.length + 1);
        params.add(INSTALL_PARAM);
        params.addAll(this.getArgsParams(args));
        return this.getParams(params);
    }

    private List<String> getUninstallParams(String ... args) {
        ArrayList<String> params = new ArrayList<String>(args.length + 1);
        params.add(UNINSTALL_PARAM);
        params.addAll(this.getArgsParams(args));
        return this.getParams(params);
    }

    private List<String> getArgsParams(String[] args) {
        return Arrays.asList(args);
    }

    List<String> getParams(List<String> params) {
        assert (params != null);
        return params;
    }

    private void stopRunningScript(String script) {
        NodeProcesses.RunInfo npmScript = NodeProcesses.forProject(this.project).getNpmScript(script);
        if (!npmScript.isRunning()) {
            return;
        }
        assert (npmScript.isRunning()) : script;
        npmScript.stop();
    }

    private void setRunningScript(String script, AtomicReference<Future<Integer>> taskRef) {
        NodeProcesses.forProject(this.project).setNpmScript(script, NodeProcesses.RunInfo.run(taskRef));
    }

    @CheckForNull
    private static String validateResult(ValidationResult result) {
        if (result.isFaultless()) {
            return null;
        }
        if (result.hasErrors()) {
            return ((ValidationResult.Message)result.getErrors().get(0)).getMessage();
        }
        return ((ValidationResult.Message)result.getWarnings().get(0)).getMessage();
    }

    private static final class MacNpmExecutable
    extends NpmExecutable {
        private static final String BASH_COMMAND = "/bin/bash -lc";

        MacNpmExecutable(String npmPath, Project project) {
            super(npmPath, project);
        }

        @Override
        String getCommand() {
            return BASH_COMMAND;
        }

        @Override
        List<String> getParams(List<String> params) {
            StringBuilder sb = new StringBuilder(200);
            sb.append("\"");
            sb.append(this.npmPath);
            sb.append("\" \"");
            sb.append(StringUtils.implode(super.getParams(params), "\" \""));
            sb.append("\"");
            return Collections.singletonList(sb.toString());
        }
    }

    private static final class StringBuilderInputProcessorFactory
    implements ExecutionDescriptor.InputProcessorFactory2 {
        private final StringBuilder result = new StringBuilder();

        private StringBuilderInputProcessorFactory() {
        }

        public InputProcessor newInputProcessor(InputProcessor defaultProcessor) {
            return new InputProcessor(){

                public void processInput(char[] chars) throws IOException {
                    result.append(chars);
                }

                public void reset() throws IOException {
                    result.setLength(0);
                }

                public void close() throws IOException {
                }
            };
        }

        String getResult() {
            return this.result.toString();
        }
    }
}

