/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.problems;

import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.api.execute.RunUtils;
import org.netbeans.modules.maven.execute.BeanRunConfig;
import org.netbeans.modules.maven.execute.MavenProxySupport;
import org.netbeans.modules.maven.options.MavenSettings;
import org.netbeans.modules.maven.problems.Bundle;
import org.netbeans.modules.maven.problems.MavenModelProblemsProvider;
import org.netbeans.spi.project.ui.ProjectProblemResolver;
import org.netbeans.spi.project.ui.ProjectProblemsProvider;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;

public class SanityBuildAction
implements ProjectProblemResolver {
    private static final Logger LOG = Logger.getLogger(SanityBuildAction.class.getName());
    private final Project nbproject;
    private final Supplier<Boolean> checkSupplier;
    private volatile CompletableFuture<ProjectProblemsProvider.Result> pendingResult;

    public SanityBuildAction(Project nbproject, Supplier<Boolean> checkSupplier) {
        this.nbproject = nbproject;
        this.checkSupplier = checkSupplier;
    }

    public SanityBuildAction(Project nbproject, Supplier<Boolean> checkSupplier, Future<ProjectProblemsProvider.Result> otherResult) {
        this.nbproject = nbproject;
        this.checkSupplier = checkSupplier;
    }

    public Future<ProjectProblemsProvider.Result> getPendingResult() {
        return this.pendingResult;
    }

    public CompletableFuture<ProjectProblemsProvider.Result> resolve() {
        return this.resolve(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<ProjectProblemsProvider.Result> resolve(final Lookup context) {
        CompletableFuture<ProjectProblemsProvider.Result> pr = this.pendingResult;
        if (pr != null && !pr.isDone()) {
            LOG.log(Level.FINE, "SanityBuild.resolve returns: {0}", this.pendingResult);
            return this.pendingResult;
        }
        final CompletableFuture<ProjectProblemsProvider.Result> publicResult = new CompletableFuture<ProjectProblemsProvider.Result>();
        Runnable toRet = new Runnable(){

            @Override
            public void run() {
                ProjectProblemsProvider.Result r;
                if (!((Boolean)SanityBuildAction.this.checkSupplier.get()).booleanValue() && (r = ProjectProblemsProvider.Result.create((ProjectProblemsProvider.Status)ProjectProblemsProvider.Status.RESOLVED, (String)Bundle.ACT_start_validate())) != null) {
                    LOG.log(Level.FINE, "Project {0} is OK before sanity build action.", SanityBuildAction.this.nbproject);
                    publicResult.complete(r);
                    return;
                }
                try {
                    LOG.log(Level.FINE, "Configuring sanity build");
                    BeanRunConfig config = new BeanRunConfig();
                    if (context != null) {
                        config.setActionContext(context);
                    }
                    config.setExecutionDirectory(FileUtil.toFile((FileObject)SanityBuildAction.this.nbproject.getProjectDirectory()));
                    NbMavenProject mavenPrj = (NbMavenProject)SanityBuildAction.this.nbproject.getLookup().lookup(NbMavenProject.class);
                    MavenProject loaded = NbMavenProject.getPartialProject(mavenPrj.getMavenProject());
                    String goals = mavenPrj != null && mavenPrj.getMavenProject().getVersion() != null && mavenPrj.getMavenProject().getVersion().endsWith("SNAPSHOT") ? NbPreferences.forModule(MavenSettings.class).get("primingBuild.snapshot.goals", "install") : NbPreferences.forModule(MavenSettings.class).get("primingBuild.regular.goals", "package");
                    config.setGoals(Arrays.asList("--fail-at-end", goals));
                    config.setReactorStyle(RunConfig.ReactorStyle.ALSO_MAKE);
                    config.setProperty("skipTests", "true");
                    config.setProject(SanityBuildAction.this.nbproject);
                    String label = Bundle.build_label(SanityBuildAction.this.nbproject.getProjectDirectory().getNameExt());
                    config.setExecutionName(label);
                    config.setTaskDisplayName(label);
                    MavenProxySupport mps = (MavenProxySupport)SanityBuildAction.this.nbproject.getLookup().lookup(MavenProxySupport.class);
                    if (mps != null) {
                        try {
                            MavenProxySupport.ProxyResult res = mps.checkProxySettings().get();
                            if (res.getStatus() == MavenProxySupport.Status.ABORT) {
                                ProjectProblemsProvider.Result r2 = ProjectProblemsProvider.Result.create((ProjectProblemsProvider.Status)ProjectProblemsProvider.Status.UNRESOLVED, (String)Bundle.ERR_SanityBuildCancalled());
                                publicResult.complete(r2);
                                return;
                            }
                        }
                        catch (ExecutionException ex) {
                            ProjectProblemsProvider.Result r3 = ProjectProblemsProvider.Result.create((ProjectProblemsProvider.Status)ProjectProblemsProvider.Status.UNRESOLVED, (String)Bundle.ERR_ProxyUpdateFailed(ex.getLocalizedMessage()));
                            publicResult.complete(r3);
                            return;
                        }
                        catch (InterruptedException ex) {
                            ProjectProblemsProvider.Result r4 = ProjectProblemsProvider.Result.create((ProjectProblemsProvider.Status)ProjectProblemsProvider.Status.UNRESOLVED, (String)Bundle.ERR_SanityBuildCancalled());
                            publicResult.complete(r4);
                            return;
                        }
                    }
                    long t = System.currentTimeMillis();
                    LOG.log(Level.FINE, "Executing sanity build: goals = {0}, properties = {1}", new Object[]{config.getGoals(), config.getProperties()});
                    ExecutorTask et = RunUtils.run(config);
                    if (et != null) {
                        et.waitFinished();
                        ProjectProblemsProvider.Result r5 = ProjectProblemsProvider.Result.create((ProjectProblemsProvider.Status)ProjectProblemsProvider.Status.RESOLVED, (String)Bundle.ACT_start_validate());
                        LOG.log(Level.FINE, "Sanity build of {0} finished, took {1} ms.", new Object[]{SanityBuildAction.this.nbproject, System.currentTimeMillis() - t});
                        publicResult.complete(r5);
                    }
                }
                catch (Error | RuntimeException e) {
                    LOG.log(Level.FINE, "Sanity build failed", e);
                    publicResult.completeExceptionally(e);
                    throw e;
                }
            }
        };
        SanityBuildAction sanityBuildAction = this;
        synchronized (sanityBuildAction) {
            if (this.pendingResult != pr) {
                return this.pendingResult;
            }
            this.pendingResult = publicResult;
        }
        ((NbMavenProjectImpl)this.nbproject).scheduleProjectOperation(MavenModelProblemsProvider.RP, toRet, 0);
        return publicResult;
    }

    public int hashCode() {
        int hash = SanityBuildAction.class.hashCode();
        hash = 67 * hash + (this.nbproject != null ? this.nbproject.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SanityBuildAction other = (SanityBuildAction)obj;
        return this.nbproject == other.nbproject || this.nbproject != null && this.nbproject.equals(other.nbproject);
    }
}

