/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor.el;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.web.el.spi.ELPlugin;
import org.netbeans.modules.web.el.spi.Function;
import org.netbeans.modules.web.el.spi.ImplicitObject;
import org.netbeans.modules.web.el.spi.ImplicitObjectType;
import org.netbeans.modules.web.el.spi.ResolverContext;
import org.netbeans.modules.web.el.spi.ResourceBundle;
import org.netbeans.modules.web.jsf.api.editor.JSFResourceBundlesProvider;
import org.netbeans.modules.web.jsf.editor.JsfUtils;
import org.netbeans.modules.web.jsf.editor.facelets.DefaultFaceletLibraries;
import org.netbeans.modules.web.jsf.editor.facelets.FaceletsLibraryDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class FaceletsELPlugin
extends ELPlugin {
    private static final String PLUGIN_NAME = "JSF Facelets EL Plugin";
    private Collection<ImplicitObject> implObjects;
    private Collection<ImplicitObject> implObjectsJakarta;

    public String getName() {
        return PLUGIN_NAME;
    }

    public Collection<String> getMimeTypes() {
        return Collections.singletonList("text/xhtml");
    }

    public synchronized Collection<ImplicitObject> getImplicitObjects(FileObject file) {
        ClassPath cp;
        boolean jakartaVariant;
        if (!this.getMimeTypes().contains(file.getMIMEType())) {
            return Collections.emptyList();
        }
        if (this.implObjects == null) {
            ArrayList<ImplicitObject> implObjectsBuilder = new ArrayList<ImplicitObject>(9);
            implObjectsBuilder.addAll(FaceletsELPlugin.getScopeObjects());
            implObjectsBuilder.add(new JsfImplicitObject("facesContext", "javax.faces.context.FacesContext", ImplicitObjectType.OBJECT_TYPE));
            implObjectsBuilder.add(new JsfImplicitObject("application", "javax.servlet.ServletContext", ImplicitObjectType.OBJECT_TYPE));
            implObjectsBuilder.add(new JsfImplicitObject("component", "javax.faces.component.UIComponent", ImplicitObjectType.OBJECT_TYPE));
            implObjectsBuilder.add(new JsfImplicitObject("flash", "javax.faces.context.Flash", ImplicitObjectType.OBJECT_TYPE));
            implObjectsBuilder.add(new JsfImplicitObject("resource", "javax.faces.application.ResourceHandler", ImplicitObjectType.OBJECT_TYPE));
            implObjectsBuilder.add(new JsfImplicitObject("session", "javax.servlet.http.HttpSession", ImplicitObjectType.OBJECT_TYPE));
            implObjectsBuilder.add(new JsfImplicitObject("view", "javax.faces.component.UIViewRoot", ImplicitObjectType.OBJECT_TYPE));
            implObjectsBuilder.add(new JsfImplicitObject("cookie", "java.util.Map", ImplicitObjectType.MAP_TYPE));
            implObjectsBuilder.add(new JsfImplicitObject("cc", "javax.faces.component.UIComponent", ImplicitObjectType.RAW));
            implObjectsBuilder.add(new JsfImplicitObject("request", "javax.servlet.http.HttpServletRequest", ImplicitObjectType.OBJECT_TYPE));
            implObjectsBuilder.add(new JsfImplicitObject("header", "java.util.Map", ImplicitObjectType.MAP_TYPE));
            implObjectsBuilder.add(new JsfImplicitObject("headerValues", "java.util.Map", ImplicitObjectType.MAP_TYPE));
            implObjectsBuilder.add(new JsfImplicitObject("initParam", "java.util.Map", ImplicitObjectType.MAP_TYPE));
            implObjectsBuilder.add(new JsfImplicitObject("param", "java.util.Map", ImplicitObjectType.MAP_TYPE));
            implObjectsBuilder.add(new JsfImplicitObject("paramValues", "java.util.Map", ImplicitObjectType.MAP_TYPE));
            this.implObjects = Collections.unmodifiableCollection(implObjectsBuilder);
            ArrayList<ImplicitObject> implObjectsJakartaBuilder = new ArrayList<ImplicitObject>(9);
            implObjectsJakartaBuilder.addAll(FaceletsELPlugin.getScopeObjects());
            implObjectsJakartaBuilder.add(new JsfImplicitObject("facesContext", "jakarta.faces.context.FacesContext", ImplicitObjectType.OBJECT_TYPE));
            implObjectsJakartaBuilder.add(new JsfImplicitObject("application", "jakarta.servlet.ServletContext", ImplicitObjectType.OBJECT_TYPE));
            implObjectsJakartaBuilder.add(new JsfImplicitObject("component", "jakarta.faces.component.UIComponent", ImplicitObjectType.OBJECT_TYPE));
            implObjectsJakartaBuilder.add(new JsfImplicitObject("flash", "jakarta.faces.context.Flash", ImplicitObjectType.OBJECT_TYPE));
            implObjectsJakartaBuilder.add(new JsfImplicitObject("resource", "jakarta.faces.application.ResourceHandler", ImplicitObjectType.OBJECT_TYPE));
            implObjectsJakartaBuilder.add(new JsfImplicitObject("session", "jakarta.servlet.http.HttpSession", ImplicitObjectType.OBJECT_TYPE));
            implObjectsJakartaBuilder.add(new JsfImplicitObject("view", "jakarta.faces.component.UIViewRoot", ImplicitObjectType.OBJECT_TYPE));
            implObjectsJakartaBuilder.add(new JsfImplicitObject("cookie", "java.util.Map", ImplicitObjectType.MAP_TYPE));
            implObjectsJakartaBuilder.add(new JsfImplicitObject("cc", "jakarta.faces.component.UIComponent", ImplicitObjectType.RAW));
            implObjectsJakartaBuilder.add(new JsfImplicitObject("request", "jakarta.servlet.http.HttpServletRequest", ImplicitObjectType.OBJECT_TYPE));
            implObjectsJakartaBuilder.add(new JsfImplicitObject("header", "java.util.Map", ImplicitObjectType.MAP_TYPE));
            implObjectsJakartaBuilder.add(new JsfImplicitObject("headerValues", "java.util.Map", ImplicitObjectType.MAP_TYPE));
            implObjectsJakartaBuilder.add(new JsfImplicitObject("initParam", "java.util.Map", ImplicitObjectType.MAP_TYPE));
            implObjectsJakartaBuilder.add(new JsfImplicitObject("param", "java.util.Map", ImplicitObjectType.MAP_TYPE));
            implObjectsJakartaBuilder.add(new JsfImplicitObject("paramValues", "java.util.Map", ImplicitObjectType.MAP_TYPE));
            this.implObjectsJakarta = Collections.unmodifiableCollection(implObjectsJakartaBuilder);
        }
        boolean bl = jakartaVariant = (cp = ClassPath.getClassPath((FileObject)file, (String)"classpath/compile")) != null && cp.findResource("jakarta/servlet/http/HttpServlet.class") != null;
        if (jakartaVariant) {
            return this.implObjectsJakarta;
        }
        return this.implObjects;
    }

    public List<ResourceBundle> getResourceBundles(FileObject file, ResolverContext context) {
        Project project = FileOwnerQuery.getOwner((FileObject)file);
        if (project == null) {
            return Collections.emptyList();
        }
        if (context.getContent(FaceletsELPlugin.class.getName()) == null) {
            context.setContent(FaceletsELPlugin.class.getName(), (Object)JSFResourceBundlesProvider.getResourceBundles((Project)project));
        }
        return (List)context.getContent(FaceletsELPlugin.class.getName());
    }

    private static Collection<ImplicitObject> getScopeObjects() {
        ArrayList<ImplicitObject> result = new ArrayList<ImplicitObject>(5);
        result.add(new JsfImplicitObject("sessionScope", "java.util.Map", ImplicitObjectType.SCOPE_TYPE));
        result.add(new JsfImplicitObject("applicationScope", "java.util.Map", ImplicitObjectType.SCOPE_TYPE));
        result.add(new JsfImplicitObject("requestScope", "java.util.Map", ImplicitObjectType.SCOPE_TYPE));
        result.add(new JsfImplicitObject("viewScope", "java.util.Map", ImplicitObjectType.SCOPE_TYPE));
        result.add(new JsfImplicitObject("flowScope", "java.util.Map", ImplicitObjectType.SCOPE_TYPE));
        return result;
    }

    public List<Function> getFunctions(FileObject file) {
        ArrayList<Function> functions = new ArrayList<Function>();
        final HashMap namespaces = new HashMap();
        try {
            Source source = Source.create((FileObject)file);
            ParserManager.parse(Collections.singletonList(source), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    Parser.Result parseResult = JsfUtils.getEmbeddedParserResult(resultIterator, "text/html");
                    if (parseResult instanceof HtmlParserResult) {
                        namespaces.putAll(((HtmlParserResult)parseResult).getNamespaces());
                    }
                }
            });
        }
        catch (ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        Map<String, FaceletsLibraryDescriptor> librariesDescriptors = DefaultFaceletLibraries.getInstance().getLibrariesDescriptors();
        for (Map.Entry<String, FaceletsLibraryDescriptor> entry : librariesDescriptors.entrySet()) {
            String currentPrefix = (String)namespaces.get(entry.getKey());
            if (currentPrefix == null) continue;
            functions.addAll(FaceletsELPlugin.getFunctionsFromDescriptor(entry.getValue(), currentPrefix));
        }
        return functions;
    }

    private static List<Function> getFunctionsFromDescriptor(FaceletsLibraryDescriptor descriptor, String prefix) {
        ArrayList<Function> functions = new ArrayList<Function>();
        for (Map.Entry<String, org.netbeans.modules.web.jsfapi.api.Function> entry : descriptor.getFunctions().entrySet()) {
            org.netbeans.modules.web.jsfapi.api.Function function = entry.getValue();
            functions.add(new Function(prefix + ":" + function.getName(), FaceletsELPlugin.getReturnTypeForSignature(function.getSignature()), FaceletsELPlugin.getParametersForSignature(function.getSignature()), function.getDescription()));
        }
        return functions;
    }

    private static String getReturnTypeForSignature(String signature) {
        String returnType = signature.substring(0, signature.indexOf(" "));
        return FaceletsELPlugin.getSimpleNameForType(returnType.trim());
    }

    private static List<String> getParametersForSignature(String signature) {
        ArrayList<String> params = new ArrayList<String>();
        String paramString = signature.substring(signature.indexOf("(") + 1, signature.indexOf(")"));
        for (String param : paramString.split(",")) {
            params.add(FaceletsELPlugin.getSimpleNameForType(param.trim()));
        }
        return params;
    }

    private static String getSimpleNameForType(String fqn) {
        return fqn.substring(fqn.lastIndexOf(".") + 1);
    }

    private static class JsfImplicitObject
    implements ImplicitObject {
        private final String name;
        private final String clazz;
        private final ImplicitObjectType type;

        public JsfImplicitObject(String name, String clazz, ImplicitObjectType type) {
            this.name = name;
            this.clazz = clazz;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public ImplicitObjectType getType() {
            return this.type;
        }

        public String getClazz() {
            return this.clazz;
        }
    }
}

