/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.composer.ui.options;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.php.api.validation.ValidationResult;
import org.netbeans.modules.php.composer.options.ComposerOptions;
import org.netbeans.modules.php.composer.options.ComposerOptionsValidator;
import org.netbeans.modules.php.composer.ui.options.ComposerOptionsPanel;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;

public class ComposerOptionsPanelController
extends OptionsPanelController
implements ChangeListener {
    static final String ID = "Composer";
    public static final String OPTIONS_SUBPATH = "FrameworksAndTools/Composer";
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private ComposerOptionsPanel composerOptionsPanel = null;
    private volatile boolean changed = false;
    private boolean firstOpening = true;

    public static String getOptionsPath() {
        return "org-netbeans-modules-php-project-ui-options-PHPOptionsCategory/FrameworksAndTools/Composer";
    }

    public void update() {
        if (this.firstOpening || !this.isChanged()) {
            this.firstOpening = false;
            this.composerOptionsPanel.setComposerPath(this.getOptions().getComposerPath());
            this.composerOptionsPanel.setVendor(this.getOptions().getVendor());
            this.composerOptionsPanel.setAuthorName(this.getOptions().getAuthorName());
            this.composerOptionsPanel.setAuthorEmail(this.getOptions().getAuthorEmail());
            this.composerOptionsPanel.setIgnoreVendor(this.getOptions().isIgnoreVendor());
        }
        this.changed = false;
    }

    public void applyChanges() {
        this.getOptions().setComposerPath(this.composerOptionsPanel.getComposerPath());
        this.getOptions().setVendor(this.composerOptionsPanel.getVendor());
        this.getOptions().setAuthorName(this.composerOptionsPanel.getAuthorName());
        this.getOptions().setAuthorEmail(this.composerOptionsPanel.getAuthorEmail());
        this.getOptions().setIgnoreVendor(this.composerOptionsPanel.isIgnoreVendor());
        this.changed = false;
    }

    public void cancel() {
        if (this.isChanged()) {
            this.composerOptionsPanel.setComposerPath(this.getOptions().getComposerPath());
            this.composerOptionsPanel.setVendor(this.getOptions().getVendor());
            this.composerOptionsPanel.setAuthorName(this.getOptions().getAuthorName());
            this.composerOptionsPanel.setAuthorEmail(this.getOptions().getAuthorEmail());
            this.composerOptionsPanel.setIgnoreVendor(this.getOptions().isIgnoreVendor());
        }
    }

    public boolean isValid() {
        ValidationResult result = new ComposerOptionsValidator().validate(this.composerOptionsPanel.getComposerPath(), this.composerOptionsPanel.getVendor(), this.composerOptionsPanel.getAuthorName(), this.composerOptionsPanel.getAuthorEmail()).getResult();
        if (result.hasErrors()) {
            this.composerOptionsPanel.setError(((ValidationResult.Message)result.getErrors().get(0)).getMessage());
            return false;
        }
        if (result.hasWarnings()) {
            this.composerOptionsPanel.setWarning(((ValidationResult.Message)result.getWarnings().get(0)).getMessage());
            return true;
        }
        this.composerOptionsPanel.setError(" ");
        return true;
    }

    public boolean isChanged() {
        String saved = this.getOptions().getComposerPath();
        String current = this.composerOptionsPanel.getComposerPath().trim();
        if (saved == null ? !current.isEmpty() : !saved.equals(current)) {
            return true;
        }
        saved = this.getOptions().getVendor();
        current = this.composerOptionsPanel.getVendor().trim();
        if (saved == null ? !current.isEmpty() : !saved.equals(current)) {
            return true;
        }
        saved = this.getOptions().getAuthorName();
        current = this.composerOptionsPanel.getAuthorName().trim();
        if (saved == null ? !current.isEmpty() : !saved.equals(current)) {
            return true;
        }
        saved = this.getOptions().getAuthorEmail();
        current = this.composerOptionsPanel.getAuthorEmail().trim();
        if (saved == null ? !current.isEmpty() : !saved.equals(current)) {
            return true;
        }
        return this.getOptions().isIgnoreVendor() != this.composerOptionsPanel.isIgnoreVendor();
    }

    public JComponent getComponent(Lookup masterLookup) {
        if (this.composerOptionsPanel == null) {
            this.composerOptionsPanel = new ComposerOptionsPanel();
            this.composerOptionsPanel.addChangeListener(this);
        }
        return this.composerOptionsPanel;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.php.composer.ui.options.Options");
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (!this.changed) {
            this.changed = true;
            this.propertyChangeSupport.firePropertyChange("changed", false, true);
        }
        this.propertyChangeSupport.firePropertyChange("valid", null, null);
    }

    private ComposerOptions getOptions() {
        return ComposerOptions.getInstance();
    }
}

