/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.search.Query;
import org.apache.maven.index.ArtifactInfoFilter;
import org.apache.maven.index.ArtifactInfoPostprocessor;
import org.apache.maven.index.MatchHighlightRequest;
import org.apache.maven.index.context.IndexingContext;

public class AbstractSearchRequest {
    public static final int UNDEFINED = -1;
    private Query query;
    private List<IndexingContext> contexts;
    private int count;
    private ArtifactInfoFilter artifactInfoFilter;
    private ArtifactInfoPostprocessor artifactInfoPostprocessor;
    private List<MatchHighlightRequest> matchHighlightRequests;
    private boolean luceneExplain = false;

    public AbstractSearchRequest(Query query) {
        this(query, null);
    }

    public AbstractSearchRequest(Query query, List<IndexingContext> contexts) {
        this.query = query;
        if (contexts != null) {
            this.getContexts().addAll(contexts);
        }
        this.count = -1;
    }

    public Query getQuery() {
        return this.query;
    }

    public void setQuery(Query query) {
        this.query = query;
    }

    public List<IndexingContext> getContexts() {
        if (this.contexts == null) {
            this.contexts = new ArrayList<IndexingContext>();
        }
        return this.contexts;
    }

    public void setContexts(List<IndexingContext> contexts) {
        this.contexts = contexts;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        if (-1 != count && count < 1) {
            throw new IllegalArgumentException("Count cannot be less than 1!");
        }
        this.count = count;
    }

    @Deprecated
    public boolean isHitLimited() {
        return false;
    }

    @Deprecated
    public int getResultHitLimit() {
        return -1;
    }

    @Deprecated
    public void setResultHitLimit(int resultHitLimit) {
    }

    public ArtifactInfoFilter getArtifactInfoFilter() {
        return this.artifactInfoFilter;
    }

    public void setArtifactInfoFilter(ArtifactInfoFilter artifactInfoFilter) {
        this.artifactInfoFilter = artifactInfoFilter;
    }

    public ArtifactInfoPostprocessor getArtifactInfoPostprocessor() {
        return this.artifactInfoPostprocessor;
    }

    public void setArtifactInfoPostprocessor(ArtifactInfoPostprocessor artifactInfoPostprocessor) {
        this.artifactInfoPostprocessor = artifactInfoPostprocessor;
    }

    public List<MatchHighlightRequest> getMatchHighlightRequests() {
        if (this.matchHighlightRequests == null) {
            this.matchHighlightRequests = new ArrayList<MatchHighlightRequest>();
        }
        return this.matchHighlightRequests;
    }

    public void setMatchHighlightRequests(List<MatchHighlightRequest> matchHighlightRequests) {
        this.matchHighlightRequests = matchHighlightRequests;
    }

    public boolean isLuceneExplain() {
        return this.luceneExplain;
    }

    public void setLuceneExplain(boolean luceneExplain) {
        this.luceneExplain = luceneExplain;
    }
}

