/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.terminalemulator;

import org.netbeans.lib.terminalemulator.Attr;
import org.netbeans.lib.terminalemulator.MyFontMetrics;
import org.netbeans.lib.terminalemulator.Term;

final class Line {
    public int glyph_glyph;
    public int glyph_rendition;
    private char[] buf;
    private int[] attr;
    private int capacity;
    private int length;
    private int glyphId;
    private int backgroundColor;
    private boolean wrapped;
    private boolean about_to_wrap;

    public Line() {
        this.reset();
    }

    public void reset() {
        this.length = 0;
        this.capacity = 32;
        this.buf = new char[this.capacity];
        this.attr = null;
        this.glyphId = 0;
        this.backgroundColor = 0;
        this.wrapped = false;
        this.about_to_wrap = false;
    }

    public void reset(Term term, int end, int eraseAttr) {
        this.reset();
        this.clearToEndFrom(term, 0, end, eraseAttr);
    }

    public int capacity() {
        return this.capacity;
    }

    public int length() {
        return this.length;
    }

    public boolean hasAttributes() {
        return this.attr != null;
    }

    public void setGlyphId(int glyphId) {
        this.glyphId = glyphId;
    }

    public int getGlyphId() {
        return this.glyphId;
    }

    public void setBackgroundColor(int bgColor) {
        this.backgroundColor = bgColor;
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setWrapped(boolean wrapped) {
        this.wrapped = wrapped;
    }

    public boolean isWrapped() {
        return this.wrapped;
    }

    public boolean setAboutToWrap(boolean about_to_wrap) {
        boolean old_about_to_wrap = about_to_wrap;
        this.about_to_wrap = about_to_wrap;
        return old_about_to_wrap;
    }

    public boolean isAboutToWrap() {
        return this.about_to_wrap;
    }

    private boolean haveAttributes(int a) {
        if (this.attr == null && a != 0) {
            this.attr = new int[this.capacity];
        }
        return this.attr != null;
    }

    public void accumulateInto(int bcol, int ecol, StringBuffer buf) {
        buf.append(this.buf, bcol, ecol - bcol + 1);
    }

    public char charAt(int col) {
        return this.buf[col];
    }

    private void charAtPut(int col, char c) {
        this.buf[col] = c;
    }

    public String toString() {
        assert (false);
        return new String(this.buf);
    }

    public char[] getChars(char[] array) {
        System.arraycopy(this.buf, 0, array, 0, this.length);
        return array;
    }

    public int[] attrArray() {
        return this.attr;
    }

    public byte width(MyFontMetrics metrics, int at) {
        if (at >= this.capacity) {
            return 1;
        }
        return (byte)metrics.wcwidth(this.charAt(at));
    }

    public int cellToBuf(MyFontMetrics metrics, int target_col) {
        if (metrics.isMultiCell()) {
            byte w;
            int bc = 0;
            int vc = 0;
            while (vc + (w = this.width(metrics, bc)) - 1 < target_col) {
                vc += w;
                ++bc;
            }
            return bc;
        }
        return target_col;
    }

    public int bufToCell(MyFontMetrics metrics, int target_col) {
        if (metrics.isMultiCell()) {
            int vc = 0;
            for (int bc = 0; bc < target_col; ++bc) {
                vc += this.width(metrics, bc);
            }
            return vc;
        }
        return target_col;
    }

    public StringBuffer stringBuffer() {
        StringBuffer sb = new StringBuffer(this.length);
        return sb.append(this.buf, 0, this.length);
    }

    private void ensureCapacity(Term term, int min_capacity) {
        term.noteColumn(this, min_capacity);
        if (min_capacity <= this.capacity) {
            return;
        }
        int new_capacity = (this.length + 1) * 2;
        if (new_capacity < 0) {
            new_capacity = Integer.MAX_VALUE;
        } else if (min_capacity > new_capacity) {
            new_capacity = min_capacity;
        }
        char[] new_buf = new char[new_capacity];
        System.arraycopy(this.buf, 0, new_buf, 0, this.length);
        this.buf = new_buf;
        if (this.attr != null) {
            int[] new_attr = new int[new_capacity];
            System.arraycopy(this.attr, 0, new_attr, 0, this.length);
            this.attr = new_attr;
        }
        this.capacity = new_capacity;
    }

    private void fillGap(int col, int eraseAttr) {
        int cx;
        for (cx = this.length; cx < col; ++cx) {
            this.charAtPut(cx, ' ');
        }
        if (this.haveAttributes(eraseAttr)) {
            for (cx = this.length; cx < col; ++cx) {
                this.attr[col] = eraseAttr;
            }
        }
    }

    public void insertCharAt(Term term, char c, int column, int a) {
        int new_length = this.length + 1;
        if (column >= this.length) {
            new_length = column + 1;
            this.ensureCapacity(term, new_length);
            this.fillGap(column, 0);
        } else {
            this.ensureCapacity(term, new_length);
            System.arraycopy(this.buf, column, this.buf, column + 1, this.length - column);
            if (this.haveAttributes(a)) {
                System.arraycopy(this.attr, column, this.attr, column + 1, this.length - column);
            }
        }
        term.checkForMultiCell(c);
        this.charAtPut(column, c);
        if (this.haveAttributes(a)) {
            this.attr[column] = a;
        }
        this.length = new_length;
    }

    public void setCharAt(Term term, char c, int column, int a, int eraseAttr) {
        if (column >= this.length) {
            this.ensureCapacity(term, column + 1);
            this.fillGap(column, eraseAttr);
            this.length = column + 1;
        }
        term.checkForMultiCell(c);
        if (column < 0) {
            throw new IllegalArgumentException(String.format("column=%d; buf_length=%d; buf_capacity=%d", column, this.length, this.capacity));
        }
        this.charAtPut(column, c);
        if (this.haveAttributes(a)) {
            this.attr[column] = a;
        }
    }

    public void deleteCharAt(int column) {
        if (column < 0 || column >= this.length) {
            return;
        }
        System.arraycopy(this.buf, column + 1, this.buf, column, this.length - column - 1);
        this.charAtPut(this.length - 1, '\u0000');
        if (this.attr != null) {
            System.arraycopy(this.attr, column + 1, this.attr, column, this.length - column - 1);
            this.attr[this.length - 1] = 0;
        }
        --this.length;
    }

    public void clearToEndFrom(Term term, int from, int end, int eraseAttr) {
        int cx;
        this.ensureCapacity(term, end + 1);
        this.fillGap(end, eraseAttr);
        for (cx = from; cx <= end; ++cx) {
            this.charAtPut(cx, ' ');
        }
        if (this.haveAttributes(eraseAttr)) {
            for (cx = from; cx <= end; ++cx) {
                this.attr[cx] = eraseAttr;
            }
        }
        this.length = end + 1;
    }

    public void clearTo(Term term, int col, int eraseAttr) {
        int cx;
        this.ensureCapacity(term, col + 1);
        this.fillGap(col, eraseAttr);
        for (cx = 0; cx <= col; ++cx) {
            this.charAtPut(cx, ' ');
        }
        if (this.haveAttributes(eraseAttr)) {
            for (cx = 0; cx <= col; ++cx) {
                this.attr[cx] = eraseAttr;
            }
        }
        if (this.length < col + 1) {
            this.length = col + 1;
        }
    }

    public void clearFromTo(Term term, int from, int to, int eraseAttr) {
        int cx;
        if (from > to) {
            return;
        }
        this.ensureCapacity(term, to + 1);
        this.fillGap(to, eraseAttr);
        for (cx = from; cx <= to; ++cx) {
            this.charAtPut(cx, ' ');
        }
        if (this.haveAttributes(eraseAttr)) {
            for (cx = from; cx <= to; ++cx) {
                this.attr[cx] = eraseAttr;
            }
        }
        if (this.length < to + 1) {
            this.length = to + 1;
        }
    }

    public String text(int bcol, int ecol) {
        String newline = "";
        if (this.length == 0) {
            return "\n";
        }
        if (ecol >= this.length) {
            ecol = this.length - 1;
            newline = "\n";
            if (bcol >= this.length) {
                bcol = this.length - 1;
            }
        }
        int count = ecol - bcol + 1;
        if (bcol < 0 || count < 0) {
            throw new IllegalArgumentException(String.format("offset=%d; count=%d; buf_length=%d; buf_capacity=%d", bcol, count, this.length, this.capacity));
        }
        return new String(this.buf, bcol, count) + newline;
    }

    public void setCharacterAttribute(int bcol, int ecol, int value, boolean on) {
        if (!this.haveAttributes(value)) {
            return;
        }
        try {
            if (on) {
                for (int c = bcol; c <= ecol; ++c) {
                    this.attr[c] = Attr.setAttribute(this.attr[c], value);
                }
            } else {
                for (int c = bcol; c <= ecol; ++c) {
                    this.attr[c] = Attr.unsetAttribute(this.attr[c], value);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException x) {
            System.out.printf("bcol %d  ecol %d  capacity %d  length %d buf %d  attr %d", bcol, ecol, this.capacity, this.length, this.buf.length, this.attr.length);
            throw x;
        }
    }
}

