/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.terminal.nb;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.lib.terminalemulator.LineDiscipline;
import org.netbeans.lib.terminalemulator.Term;
import org.netbeans.lib.terminalemulator.TermStream;
import org.netbeans.lib.terminalemulator.support.TermOptions;
import org.netbeans.modules.terminal.nb.Bundle;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.ColorComboBox;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public final class TermOptionsPanel
extends JPanel {
    private final Term term;
    private final PropertyChangeListener propertyListener = e -> this.refreshView();
    private boolean inApplyingModel;
    private TermOptions termOptions;
    private boolean changingSelectByWordText = false;
    private JCheckBox altSendsEscapeCheckBox;
    private ColorComboBox backgroundComboBox;
    private JLabel backgroundLabel;
    private JCheckBox clickToTypeCheckBox;
    private JLabel descriptionLabel;
    private JButton fontButton;
    private JLabel fontLabel;
    private JLabel fontSizeLabel;
    private JSpinner fontSizeSpinner;
    private JTextField fontText;
    private ColorComboBox foregroundComboBox;
    private JLabel foregroundLabel;
    private JLabel historySizeLabel;
    private JSpinner historySizeSpinner;
    private JCheckBox ignoreKeymapCheckBox;
    private JCheckBox lineWrapCheckBox;
    private JLabel previewLabel;
    private JPanel previewPanel;
    private JButton restoreButton;
    private JCheckBox scrollOnInputCheckBox;
    private JCheckBox scrollOnOutputCheckBox;
    private JLabel selectByWordLabel;
    private JTextField selectByWordTextField;
    private ColorComboBox selectionComboBox;
    private JLabel selectionLabel;
    private JLabel tabSizeLabel;
    private JSpinner tabSizeSpinner;

    public TermOptionsPanel() {
        this.initComponents();
        this.initCustomComponents();
        this.term = new Term();
        String line1String = Bundle.MSG_Hello() + "\r\n";
        char[] line1 = line1String.toCharArray();
        this.term.putChars(line1, 0, line1.length);
        this.term.pushStream((TermStream)new LineDiscipline());
        this.term.setRowsColumns(7, 60);
        this.term.setClickToType(true);
        this.previewPanel.add((Component)this.term, "Center");
    }

    private void initCustomComponents() {
        this.selectByWordTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.textChangeActionPerformed();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.textChangeActionPerformed();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            private void textChangeActionPerformed() {
                if (TermOptionsPanel.this.inApplyingModel) {
                    return;
                }
                TermOptionsPanel.this.changingSelectByWordText = true;
                String delimiters = TermOptionsPanel.this.selectByWordTextField.getText();
                TermOptionsPanel.this.termOptions.setSelectByWordDelimiters(delimiters);
                TermOptionsPanel.this.changingSelectByWordText = false;
            }
        });
    }

    private void initComponents() {
        this.descriptionLabel = new JLabel();
        this.restoreButton = new JButton();
        this.fontLabel = new JLabel();
        this.fontText = new JTextField();
        this.fontButton = new JButton();
        this.fontSizeLabel = new JLabel();
        this.fontSizeSpinner = new JSpinner();
        this.foregroundLabel = new JLabel();
        this.foregroundComboBox = new ColorComboBox();
        this.backgroundLabel = new JLabel();
        this.backgroundComboBox = new ColorComboBox();
        this.selectionLabel = new JLabel();
        this.selectionComboBox = new ColorComboBox();
        this.historySizeLabel = new JLabel();
        this.historySizeSpinner = new JSpinner();
        this.tabSizeLabel = new JLabel();
        this.tabSizeSpinner = new JSpinner();
        this.selectByWordLabel = new JLabel();
        this.selectByWordTextField = new JTextField();
        this.clickToTypeCheckBox = new JCheckBox();
        this.ignoreKeymapCheckBox = new JCheckBox();
        this.lineWrapCheckBox = new JCheckBox();
        this.scrollOnInputCheckBox = new JCheckBox();
        this.scrollOnOutputCheckBox = new JCheckBox();
        this.previewLabel = new JLabel();
        this.previewPanel = new JPanel();
        this.altSendsEscapeCheckBox = new JCheckBox();
        Mnemonics.setLocalizedText((JLabel)this.descriptionLabel, (String)NbBundle.getMessage(TermOptionsPanel.class, (String)"TermOptionsPanel.descriptionLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.restoreButton, (String)NbBundle.getMessage(TermOptionsPanel.class, (String)"TermOptionsPanel.restoreButton.text"));
        this.restoreButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TermOptionsPanel.this.restoreButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.fontLabel, (String)NbBundle.getMessage(TermOptionsPanel.class, (String)"TermOptionsPanel.fontLabel.text"));
        this.fontText.setEditable(false);
        this.fontText.setText(NbBundle.getMessage(TermOptionsPanel.class, (String)"TermOptionsPanel.fontText.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.fontButton, (String)NbBundle.getMessage(TermOptionsPanel.class, (String)"TermOptionsPanel.fontButton.text"));
        this.fontButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TermOptionsPanel.this.fontButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.fontSizeLabel, (String)NbBundle.getMessage(TermOptionsPanel.class, (String)"TermOptionsPanel.fontSizeLabel.text"));
        this.fontSizeSpinner.setModel(new SpinnerNumberModel(12, 8, 48, 1));
        this.fontSizeSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                TermOptionsPanel.this.fontSizeSpinnerStateChanged(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.foregroundLabel, (String)NbBundle.getMessage(TermOptionsPanel.class, (String)"TermOptionsPanel.foregroundLabel.text"));
        this.foregroundComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TermOptionsPanel.this.foregroundComboBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.backgroundLabel, (String)NbBundle.getMessage(TermOptionsPanel.class, (String)"TermOptionsPanel.backgroundLabel.text"));
        this.backgroundComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TermOptionsPanel.this.backgroundComboBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.selectionLabel, (String)NbBundle.getMessage(TermOptionsPanel.class, (String)"TermOptionsPanel.selectionLabel.text"));
        this.selectionComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TermOptionsPanel.this.selectionComboBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.historySizeLabel, (String)NbBundle.getMessage(TermOptionsPanel.class, (String)"TermOptionsPanel.historySizeLabel.text"));
        this.historySizeSpinner.setModel(new SpinnerNumberModel(5000, 0, 50000, 1));
        this.historySizeSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                TermOptionsPanel.this.historySizeSpinnerStateChanged(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.tabSizeLabel, (String)NbBundle.getMessage(TermOptionsPanel.class, (String)"TermOptionsPanel.tabSizeLabel.text"));
        this.tabSizeSpinner.setModel(new SpinnerNumberModel(8, 1, 16, 1));
        this.tabSizeSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                TermOptionsPanel.this.tabSizeSpinnerStateChanged(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.selectByWordLabel, (String)NbBundle.getMessage(TermOptionsPanel.class, (String)"TermOptionsPanel.selectByWordLabel.text"));
        this.selectByWordTextField.setText(NbBundle.getMessage(TermOptionsPanel.class, (String)"TermOptionsPanel.selectByWordTextField.text"));
        this.clickToTypeCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.clickToTypeCheckBox, (String)NbBundle.getMessage(TermOptionsPanel.class, (String)"TermOptionsPanel.clickToTypeCheckBox.text"));
        this.clickToTypeCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TermOptionsPanel.this.clickToTypeCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.ignoreKeymapCheckBox, (String)NbBundle.getMessage(TermOptionsPanel.class, (String)"TermOptionsPanel.ignoreKeymapCheckBox.text"));
        this.ignoreKeymapCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TermOptionsPanel.this.ignoreKeymapCheckBoxActionPerformed(evt);
            }
        });
        this.lineWrapCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.lineWrapCheckBox, (String)NbBundle.getMessage(TermOptionsPanel.class, (String)"TermOptionsPanel.lineWrapCheckBox.text"));
        this.lineWrapCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TermOptionsPanel.this.lineWrapCheckBoxActionPerformed(evt);
            }
        });
        this.scrollOnInputCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.scrollOnInputCheckBox, (String)NbBundle.getMessage(TermOptionsPanel.class, (String)"TermOptionsPanel.scrollOnInputCheckBox.text"));
        this.scrollOnInputCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TermOptionsPanel.this.scrollOnInputCheckBoxActionPerformed(evt);
            }
        });
        this.scrollOnOutputCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.scrollOnOutputCheckBox, (String)NbBundle.getMessage(TermOptionsPanel.class, (String)"TermOptionsPanel.scrollOnOutputCheckBox.text"));
        this.scrollOnOutputCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TermOptionsPanel.this.scrollOnOutputCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.previewLabel, (String)NbBundle.getMessage(TermOptionsPanel.class, (String)"TermOptionsPanel.previewLabel.text"));
        this.previewPanel.setBorder(BorderFactory.createBevelBorder(1));
        this.previewPanel.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.altSendsEscapeCheckBox, (String)NbBundle.getMessage(TermOptionsPanel.class, (String)"TermOptionsPanel.altSendsEscapeCheckBox.text"));
        this.altSendsEscapeCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TermOptionsPanel.this.altSendsEscapeCheckBoxActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fontLabel).addComponent(this.fontSizeLabel).addComponent(this.foregroundLabel).addComponent(this.backgroundLabel).addComponent(this.selectionLabel).addComponent(this.historySizeLabel).addComponent(this.descriptionLabel)).addGap(16, 16, 16).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent((Component)this.foregroundComboBox, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent((Component)this.backgroundComboBox, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent((Component)this.selectionComboBox, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.selectByWordTextField, GroupLayout.Alignment.LEADING).addComponent(this.fontText, GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.fontSizeSpinner, GroupLayout.Alignment.LEADING, -2, 103, -2).addComponent(this.historySizeSpinner, GroupLayout.Alignment.LEADING, -2, 103, -2).addComponent(this.tabSizeSpinner, GroupLayout.Alignment.LEADING, -2, 103, -2)).addGap(0, 0, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.restoreButton, -1, -1, Short.MAX_VALUE).addComponent(this.fontButton, -1, -1, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tabSizeLabel).addComponent(this.previewLabel).addComponent(this.selectByWordLabel)).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollOnInputCheckBox).addComponent(this.clickToTypeCheckBox)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lineWrapCheckBox).addComponent(this.scrollOnOutputCheckBox)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ignoreKeymapCheckBox).addComponent(this.altSendsEscapeCheckBox)).addContainerGap(-1, Short.MAX_VALUE)).addComponent(this.previewPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.restoreButton).addComponent(this.descriptionLabel, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fontLabel).addComponent(this.fontButton).addComponent(this.fontText, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fontSizeLabel).addComponent(this.fontSizeSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.foregroundLabel).addComponent((Component)this.foregroundComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.backgroundLabel).addComponent((Component)this.backgroundComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.selectionLabel).addComponent((Component)this.selectionComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.historySizeLabel).addComponent(this.historySizeSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tabSizeLabel).addComponent(this.tabSizeSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.selectByWordLabel).addComponent(this.selectByWordTextField, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.clickToTypeCheckBox).addComponent(this.lineWrapCheckBox).addComponent(this.ignoreKeymapCheckBox, -2, 23, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.scrollOnInputCheckBox).addComponent(this.scrollOnOutputCheckBox).addComponent(this.altSendsEscapeCheckBox)).addGap(18, 18, 18).addComponent(this.previewLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.previewPanel, -1, 67, Short.MAX_VALUE).addContainerGap()));
    }

    private void fontSizeSpinnerStateChanged(ChangeEvent evt) {
        if (this.inApplyingModel) {
            return;
        }
        Object fontSizeObj = this.fontSizeSpinner.getValue();
        if (fontSizeObj instanceof Integer) {
            int fontSize = (Integer)fontSizeObj;
            this.termOptions.setFontSize(fontSize);
        }
    }

    private void historySizeSpinnerStateChanged(ChangeEvent evt) {
        if (this.inApplyingModel) {
            return;
        }
        Object historySizeObj = this.historySizeSpinner.getValue();
        if (historySizeObj instanceof Integer) {
            int historySize = (Integer)historySizeObj;
            this.termOptions.setHistorySize(historySize);
        }
    }

    private void tabSizeSpinnerStateChanged(ChangeEvent evt) {
        if (this.inApplyingModel) {
            return;
        }
        Object tabSizeObj = this.tabSizeSpinner.getValue();
        if (tabSizeObj instanceof Integer) {
            int tabSize = (Integer)tabSizeObj;
            this.termOptions.setTabSize(tabSize);
        }
    }

    private void fontButtonActionPerformed(ActionEvent evt) {
        PropertyEditor pe = PropertyEditorManager.findEditor(Font.class);
        if (pe != null) {
            pe.setValue(this.termOptions.getFont());
            DialogDescriptor dd = new DialogDescriptor((Object)pe.getCustomEditor(), Bundle.FontChooser_title());
            String defaultFontString = Bundle.FontChooser_defaultFont_label();
            dd.setOptions(new Object[]{DialogDescriptor.OK_OPTION, defaultFontString, DialogDescriptor.CANCEL_OPTION});
            Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
            dialog.setSize(460, 380);
            dialog.setVisible(true);
            if (dd.getValue() == DialogDescriptor.OK_OPTION) {
                Font f = (Font)pe.getValue();
                this.termOptions.setFont(f);
                this.applyTermOptions();
            } else if (dd.getValue() == defaultFontString) {
                Font controlFont = UIManager.getFont("controlFont");
                int fontSize = controlFont == null ? 12 : controlFont.getSize();
                this.termOptions.setFont(new Font("monospaced", 0, fontSize));
            }
        }
    }

    private void restoreButtonActionPerformed(ActionEvent evt) {
        this.termOptions.resetToDefault();
    }

    private void clickToTypeCheckBoxActionPerformed(ActionEvent evt) {
        if (this.inApplyingModel) {
            return;
        }
        this.termOptions.setClickToType(this.clickToTypeCheckBox.isSelected());
    }

    private void scrollOnInputCheckBoxActionPerformed(ActionEvent evt) {
        if (this.inApplyingModel) {
            return;
        }
        this.termOptions.setScrollOnInput(this.scrollOnInputCheckBox.isSelected());
    }

    private void scrollOnOutputCheckBoxActionPerformed(ActionEvent evt) {
        if (this.inApplyingModel) {
            return;
        }
        this.termOptions.setScrollOnOutput(this.scrollOnOutputCheckBox.isSelected());
    }

    private void lineWrapCheckBoxActionPerformed(ActionEvent evt) {
        if (this.inApplyingModel) {
            return;
        }
        this.termOptions.setLineWrap(this.lineWrapCheckBox.isSelected());
    }

    private void ignoreKeymapCheckBoxActionPerformed(ActionEvent evt) {
        if (this.inApplyingModel) {
            return;
        }
        this.termOptions.setIgnoreKeymap(this.ignoreKeymapCheckBox.isSelected());
    }

    private void foregroundComboBoxActionPerformed(ActionEvent evt) {
        if (this.inApplyingModel) {
            return;
        }
        Color c = this.foregroundComboBox.getSelectedColor();
        if (c != null) {
            this.termOptions.setForeground(c);
        }
    }

    private void backgroundComboBoxActionPerformed(ActionEvent evt) {
        if (this.inApplyingModel) {
            return;
        }
        Color c = this.backgroundComboBox.getSelectedColor();
        if (c != null) {
            this.termOptions.setBackground(c);
        }
    }

    private void selectionComboBoxActionPerformed(ActionEvent evt) {
        if (this.inApplyingModel) {
            return;
        }
        Color c = this.selectionComboBox.getSelectedColor();
        if (c != null) {
            this.termOptions.setSelectionBackground(c);
        }
    }

    private void altSendsEscapeCheckBoxActionPerformed(ActionEvent evt) {
        if (this.inApplyingModel) {
            return;
        }
        this.termOptions.setAltSendsEscape(this.altSendsEscapeCheckBox.isSelected());
    }

    public void setTermOptions(TermOptions termOptions) {
        if (this.termOptions != null) {
            this.termOptions.removePropertyChangeListener(this.propertyListener);
        }
        this.termOptions = termOptions;
        if (this.termOptions != null) {
            this.termOptions.addPropertyChangeListener(this.propertyListener);
        }
        this.refreshView();
    }

    private void applyTermOptions() {
        this.inApplyingModel = true;
        try {
            this.fontSizeSpinner.setValue(this.termOptions.getFontSize());
            this.fontText.setText(this.termOptions.getFont().getFamily() + " " + this.termOptions.getFont().getSize());
            this.foregroundComboBox.setSelectedColor(this.termOptions.getForeground());
            this.backgroundComboBox.setSelectedColor(this.termOptions.getBackground());
            this.selectionComboBox.setSelectedColor(this.termOptions.getSelectionBackground());
            this.historySizeSpinner.setValue(this.termOptions.getHistorySize());
            this.tabSizeSpinner.setValue(this.termOptions.getTabSize());
            if (!this.changingSelectByWordText) {
                this.selectByWordTextField.setText(this.termOptions.getSelectByWordDelimiters());
            }
            this.clickToTypeCheckBox.setSelected(this.termOptions.getClickToType());
            this.scrollOnInputCheckBox.setSelected(this.termOptions.getScrollOnInput());
            this.scrollOnOutputCheckBox.setSelected(this.termOptions.getScrollOnOutput());
            this.lineWrapCheckBox.setSelected(this.termOptions.getLineWrap());
            this.ignoreKeymapCheckBox.setSelected(this.termOptions.getIgnoreKeymap());
            this.altSendsEscapeCheckBox.setSelected(this.termOptions.getAltSendsEscape());
        }
        finally {
            this.inApplyingModel = false;
        }
    }

    private void refreshView() {
        if (this.termOptions != null) {
            this.termOptions.removePropertyChangeListener(this.propertyListener);
        }
        try {
            this.applyTermOptions();
        }
        finally {
            if (this.termOptions != null) {
                this.termOptions.addPropertyChangeListener(this.propertyListener);
            }
        }
        this.previewTermOptions();
    }

    private void previewTermOptions() {
        if (this.term == null) {
            return;
        }
        this.term.setFixedFont(true);
        this.term.setFont(this.termOptions.getFont());
        this.term.setBackground(this.termOptions.getBackground());
        this.term.setForeground(this.termOptions.getForeground());
        this.term.setHighlightColor(this.termOptions.getSelectionBackground());
        this.term.setHistorySize(this.termOptions.getHistorySize());
        this.term.setTabSize(this.termOptions.getTabSize());
        this.term.setSelectByWordDelimiters(this.termOptions.getSelectByWordDelimiters());
        this.term.setClickToType(this.termOptions.getClickToType());
        this.term.setScrollOnInput(this.termOptions.getScrollOnInput());
        this.term.setScrollOnOutput(this.termOptions.getScrollOnOutput());
        this.term.setHorizontallyScrollable(!this.termOptions.getLineWrap());
        this.term.setAltSendsEscape(this.termOptions.getAltSendsEscape());
        this.term.setRowsColumns(7, 60);
        this.patchSizes();
    }

    private void patchSizes() {
        this.term.invalidate();
        this.previewPanel.validate();
        this.previewPanel.invalidate();
        this.validate();
        this.invalidate();
    }
}

