/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.universe;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.core.startup.layers.LayerCacheManager;
import org.netbeans.modules.apisupport.project.api.ManifestManager;
import org.netbeans.modules.apisupport.project.spi.LayerUtil;
import org.netbeans.modules.apisupport.project.universe.Bundle;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.modules.Places;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class PlatformLayersCacheManager {
    static final String CACHE_PATH = "nbplfsc";
    private static final Map<File, PLFSCache> loadedCaches = new HashMap<File, PLFSCache>();
    private static File cacheLocation;
    private static Map<File, Integer> cacheIndex;
    private static boolean anyModified;
    private static final String CACHE_FILE_FMT = "cache%04d.ser";
    private static Logger LOGGER;
    private static RequestProcessor RP;
    static RequestProcessor.Task storeTask;
    private static final String[] MODULE_DIRS;

    private static void resetCacheLocation() {
        cacheLocation = Places.getCacheSubdirectory((String)CACHE_PATH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File findCacheFile(File clusterDir) throws IOException {
        Integer index;
        if (cacheIndex == null) {
            cacheIndex = new LinkedHashMap<File, Integer>();
            try (ObjectInputStream ois = null;){
                File indexF = new File(cacheLocation, "index.ser");
                if (indexF.exists()) {
                    ois = new ObjectInputStream(new FileInputStream(indexF));
                    int version = ois.readInt();
                    assert (version == 1);
                    int count = ois.readInt();
                    for (int c = 0; c < count; ++c) {
                        String clusterPath = (String)ois.readObject();
                        Date lastAccess = (Date)ois.readObject();
                        File cd = new File(clusterPath);
                        if (!cd.isDirectory()) continue;
                        cacheIndex.put(cd, c);
                    }
                }
            }
        }
        if ((index = cacheIndex.get(clusterDir)) == null) {
            return null;
        }
        File cf = new File(cacheLocation, String.format(CACHE_FILE_FMT, (int)index));
        return cf.exists() ? cf : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void reset() {
        Map<File, PLFSCache> map = loadedCaches;
        synchronized (map) {
            loadedCaches.clear();
            cacheIndex = null;
            PlatformLayersCacheManager.resetCacheLocation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<FileSystem> getCache(File[] clusters, FileFilter filter) throws IOException {
        ArrayList<FileSystem> entries = new ArrayList<FileSystem>();
        LOGGER.fine("getCache for clusters: " + Arrays.toString(clusters) + (filter != null ? ", FILTERED" : ""));
        Map<File, PLFSCache> map = loadedCaches;
        synchronized (map) {
            try (ProgressHandle handle = ProgressHandle.createHandle((String)Bundle.MSG_scanning_layers());){
                handle.start(clusters.length + 1);
                int c = 0;
                for (File cl : clusters) {
                    File[] jars;
                    assert (cl.isDirectory());
                    boolean mustUpdate = true;
                    PLFSCache oc = loadedCaches.get(cl);
                    if (oc == null) {
                        oc = PlatformLayersCacheManager.loadCache(cl);
                        if (oc == null) {
                            oc = PlatformLayersCacheManager.fillCache(cl);
                            cacheIndex.put(cl, cacheIndex.size());
                            mustUpdate = false;
                        }
                        loadedCaches.put(new File(cl.getAbsolutePath()), oc);
                    }
                    handle.progress(c++);
                    for (File jar : jars = PlatformLayersCacheManager.getClusterJars(cl)) {
                        if (filter != null && !filter.accept(jar)) continue;
                        PLFSCacheEntry entry = oc.getEntry(jar);
                        if (entry == null) {
                            entry = new PLFSCacheEntry(jar, 0L, 0L, false, false, null, null);
                            oc.add(entry);
                        }
                        if (entry.ignored) continue;
                        if (mustUpdate && !entry.checkUpToDate()) {
                            PlatformLayersCacheManager.refreshEntry(oc, entry);
                            LOGGER.log(Level.FINE, "Loading of layer cache for cluster " + cl + " failed due to modifications in " + jar);
                        }
                        assert (entry.checkUpToDate()) : "entry not up-to-date even immediately after refresh()";
                        if (entry.isMasked()) {
                            entries.add(0, entry.getFS());
                            continue;
                        }
                        entries.add(entry.getFS());
                    }
                }
                PlatformLayersCacheManager.storeCaches();
                handle.progress(c++);
            }
        }
        return entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static File findOriginatingJar(FileSystem fs) {
        Parameters.notNull((CharSequence)"fs", (Object)fs);
        Map<File, PLFSCache> map = loadedCaches;
        synchronized (map) {
            for (PLFSCache cache : loadedCaches.values()) {
                for (PLFSCacheEntry entry : cache.allEntries.values()) {
                    if (!fs.equals(entry.getFS())) continue;
                    return entry.getJar();
                }
            }
        }
        return null;
    }

    private static void refreshEntry(PLFSCache oc, PLFSCacheEntry ce) throws IOException {
        List urll;
        assert (!ce.checkUpToDate()) : "refresh() called on up-to-date entry";
        if (ce.upToDate) {
            return;
        }
        File jarFile = ce.getJar();
        if (!jarFile.exists()) {
            oc.remove(ce);
            ce.removed = true;
            ce.updateValues(oc);
        }
        if ((urll = LayerUtil.layersOf((File)jarFile)).isEmpty()) {
            ce.ignored = true;
            ce.updateValues(oc);
            return;
        }
        LayerCacheManager man = LayerCacheManager.manager((boolean)true);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        man.store(null, urll, (OutputStream)os);
        byte[] buf = os.toByteArray();
        ce.fs = man.load(null, ByteBuffer.wrap(buf).order(ByteOrder.LITTLE_ENDIAN));
        PLFSCacheEntry.access$1302(ce, buf);
        ce.ignored = false;
        ce.updateValues(oc);
        ce.masked = false;
        Enumeration e = ce.fs.getRoot().getChildren(true);
        while (e.hasMoreElements()) {
            FileObject f = (FileObject)e.nextElement();
            if (!f.getNameExt().endsWith("_hidden")) continue;
            ce.masked = true;
            break;
        }
    }

    private static void storeCaches() {
        if (!anyModified) {
            LOGGER.fine("Nothing to store");
            return;
        }
        if (storeTask == null) {
            storeTask = RP.create(new Runnable(){

                @Override
                public void run() {
                    PlatformLayersCacheManager.doStoreCaches();
                }
            });
        }
        LOGGER.fine("Will store caches");
        storeTask.schedule(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doStoreCaches() {
        Map<File, PLFSCache> map = loadedCaches;
        synchronized (map) {
            LOGGER.fine("Storing caches in background");
            ObjectOutputStream oos = null;
            File indexF = null;
            try {
                try {
                    indexF = new File(cacheLocation, "index.ser");
                    oos = new ObjectOutputStream(new FileOutputStream(indexF));
                    oos.writeInt(1);
                    oos.writeInt(cacheIndex.size());
                    Date now = Calendar.getInstance().getTime();
                    int c = 0;
                    for (File clusterDir : cacheIndex.keySet()) {
                        oos.writeObject(clusterDir.getAbsolutePath());
                        oos.writeObject(now);
                        PLFSCache cache = loadedCaches.get(clusterDir);
                        if (cache != null && cache.isModified()) {
                            File cf = new File(cacheLocation, String.format(CACHE_FILE_FMT, c));
                            PlatformLayersCacheManager.storeCache(cache, cf);
                        }
                        ++c;
                    }
                    LOGGER.fine("Stored " + c + " modified caches");
                }
                finally {
                    if (oos != null) {
                        oos.close();
                    }
                }
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, "Saving platform layers cache index into " + indexF + " failed with exception: " + ex.getLocalizedMessage(), ex);
            }
            anyModified = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void storeCache(PLFSCache cache, File cf) {
        ObjectOutputStream oos = null;
        try {
            try {
                oos = new ObjectOutputStream(new FileOutputStream(cf));
                oos.writeInt(1);
                oos.writeInt(cache.getEntries().size());
                for (PLFSCacheEntry ce : cache.getEntries().values()) {
                    File jar = ce.getJar();
                    oos.writeObject(jar.getName());
                    oos.writeLong(jar.length());
                    oos.writeLong(jar.lastModified());
                    oos.writeBoolean(ce.ignored);
                    if (ce.ignored) continue;
                    oos.writeBoolean(ce.isMasked());
                    oos.writeInt(ce.bytes.length);
                    oos.write(ce.bytes);
                }
            }
            finally {
                if (oos != null) {
                    oos.close();
                }
            }
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, "Saving platform layers cache file " + cf + " failed with exception: " + ex.getLocalizedMessage(), ex);
        }
        cache.modified = false;
    }

    private static File[] getClusterJars(File clusterDir) {
        ArrayList<File> allJars = new ArrayList<File>();
        for (String mds : MODULE_DIRS) {
            File modulesDir = new File(clusterDir, mds);
            if (!modulesDir.isDirectory()) continue;
            allJars.addAll(Arrays.asList(modulesDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".jar");
                }
            })));
        }
        return allJars.toArray(new File[0]);
    }

    private static PLFSCache fillCache(File clusterDir) throws IOException {
        File[] jars = PlatformLayersCacheManager.getClusterJars(clusterDir);
        PLFSCache cache = new PLFSCache();
        cache.modified = true;
        anyModified = true;
        LayerCacheManager man = LayerCacheManager.manager((boolean)true);
        block2: for (File jar : jars) {
            ManifestManager mm = ManifestManager.getInstanceFromJAR((File)jar, (boolean)true);
            for (String tok : mm.getRequiredTokens()) {
                if (!tok.startsWith("org.openide.modules.os.")) continue;
                cache.add(new PLFSCacheEntry(jar, jar.length(), jar.lastModified(), true, false, null, null));
                continue block2;
            }
            String layer = mm.getLayer();
            String generatedLayer = mm.getGeneratedLayer();
            if (layer == null && generatedLayer == null) {
                cache.add(new PLFSCacheEntry(jar, jar.length(), jar.lastModified(), true, false, null, null));
                continue;
            }
            ArrayList<URL> urll = new ArrayList<URL>(2);
            try {
                URI juri = Utilities.toURI((File)jar);
                if (layer != null) {
                    urll.add(new URL("jar:" + juri + "!/" + layer));
                }
                if (generatedLayer != null) {
                    urll.add(new URL("jar:" + juri + "!/" + generatedLayer));
                }
            }
            catch (MalformedURLException e) {
                throw (IOException)new IOException(e.toString()).initCause(e);
            }
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            man.store(null, urll, (OutputStream)os);
            byte[] bytes = os.toByteArray();
            FileSystem fs = man.load(null, ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN));
            Enumeration e = fs.getRoot().getChildren(true);
            boolean isMasked = false;
            while (e.hasMoreElements()) {
                FileObject f = (FileObject)e.nextElement();
                if (!f.getNameExt().endsWith("_hidden")) continue;
                isMasked = true;
                break;
            }
            PLFSCacheEntry ce = new PLFSCacheEntry(jar, jar.length(), jar.lastModified(), false, isMasked, fs, bytes);
            cache.add(ce);
        }
        LOGGER.fine("Cache for cluster " + clusterDir + " successfully created.");
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static PLFSCache loadCache(File clusterDir) {
        PLFSCache cache = new PLFSCache();
        LayerCacheManager man = LayerCacheManager.manager((boolean)true);
        try {
            File cacheFile = PlatformLayersCacheManager.findCacheFile(clusterDir);
            if (cacheFile == null) {
                return null;
            }
            try (FileInputStream fis = null;){
                File[] moduleDirs = new File[MODULE_DIRS.length];
                for (int i = 0; i < moduleDirs.length; ++i) {
                    moduleDirs[i] = new File(clusterDir, MODULE_DIRS[i]);
                }
                fis = new FileInputStream(cacheFile);
                ObjectInputStream ois = new ObjectInputStream(fis);
                int version = ois.readInt();
                assert (version == 1);
                int count = ois.readInt();
                for (int c = 0; c < count; ++c) {
                    File dir;
                    String jarName = (String)ois.readObject();
                    File jarFile = null;
                    File[] fileArray = moduleDirs;
                    int n = fileArray.length;
                    for (int i = 0; i < n && !(jarFile = new File(dir = fileArray[i], jarName)).exists(); ++i) {
                    }
                    long jarSize = ois.readLong();
                    long jarTS = ois.readLong();
                    boolean isIgnored = ois.readBoolean();
                    boolean isMasked = false;
                    FileSystem fs = null;
                    byte[] bytes = null;
                    if (!isIgnored) {
                        isMasked = ois.readBoolean();
                        int binFSSize = ois.readInt();
                        bytes = new byte[binFSSize];
                        ois.readFully(bytes, 0, binFSSize);
                        fs = man.load(null, ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN));
                    }
                    cache.add(new PLFSCacheEntry(jarFile, jarSize, jarTS, isIgnored, isMasked, fs, bytes));
                }
            }
            LOGGER.fine("Cache for cluster " + clusterDir + " successfully loaded from cache file " + cacheFile);
            return cache;
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, "IOException during loading project layers cache (for cluster " + clusterDir + "): " + ex.toString());
            return null;
        }
    }

    static {
        LOGGER = Logger.getLogger(PlatformLayersCacheManager.class.getName());
        PlatformLayersCacheManager.resetCacheLocation();
        RP = new RequestProcessor(PlatformLayersCacheManager.class.getName(), 1);
        MODULE_DIRS = new String[]{"modules", "lib", "core"};
    }

    static class PLFSCache {
        private Map<File, PLFSCacheEntry> allEntries = new HashMap<File, PLFSCacheEntry>();
        private boolean modified;

        PLFSCache() {
        }

        private void add(PLFSCacheEntry entry) {
            this.allEntries.put(entry.getJar(), entry);
        }

        private Map<File, PLFSCacheEntry> getEntries() {
            return Collections.unmodifiableMap(this.allEntries);
        }

        private PLFSCacheEntry getEntry(File jar) {
            return this.allEntries.get(jar);
        }

        private boolean isModified() {
            return this.modified;
        }

        private void remove(PLFSCacheEntry ce) {
            this.allEntries.remove(ce.getJar());
        }
    }

    static class PLFSCacheEntry {
        private File jarFile;
        private long jarSize;
        private FileSystem fs;
        private boolean masked;
        private long jarTS;
        private boolean upToDate;
        private boolean ignored;
        private byte[] bytes;
        private boolean removed;

        private PLFSCacheEntry(File jarFile, long jarSize, long jarTS, boolean ignored, boolean masked, FileSystem fs, byte[] bytes) {
            this.jarFile = jarFile;
            this.jarSize = jarSize;
            this.jarTS = jarTS;
            this.masked = masked;
            this.ignored = ignored;
            this.fs = fs;
            this.bytes = bytes;
        }

        boolean checkUpToDate() {
            this.upToDate = this.jarFile.exists() && this.jarFile.length() == this.jarSize && this.jarFile.lastModified() == this.jarTS;
            return this.upToDate;
        }

        FileSystem getFS() {
            return this.fs;
        }

        File getJar() {
            return this.jarFile;
        }

        private boolean isMasked() {
            return this.masked;
        }

        private void updateValues(PLFSCache oc) {
            this.jarSize = this.jarFile.length();
            this.jarTS = this.jarFile.lastModified();
            oc.modified = true;
            anyModified = true;
        }

        static /* synthetic */ byte[] access$1302(PLFSCacheEntry x0, byte[] x1) {
            x0.bytes = x1;
            return x1;
        }
    }
}

