/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.manager.ui;

import java.net.URLClassLoader;
import java.util.ArrayList;
import javax.swing.tree.DefaultMutableTreeNode;
import org.netbeans.modules.websvc.manager.ui.AbstractParameterTreeNode;
import org.netbeans.modules.websvc.manager.ui.NodeHelper;
import org.netbeans.modules.websvc.manager.ui.ParameterTreeNode;
import org.netbeans.modules.websvc.manager.ui.ReflectionHelper;
import org.netbeans.modules.websvc.manager.ui.TypeNodeData;
import org.openide.ErrorManager;

public class ArrayTypeTreeNode
extends AbstractParameterTreeNode {
    private URLClassLoader urlClassLoader;

    public ArrayTypeTreeNode(Object userObject, URLClassLoader inClassLoader) {
        super(userObject);
        this.urlClassLoader = inClassLoader;
    }

    @Override
    public void updateValueFromChildren(TypeNodeData inData) {
        TypeNodeData data = (TypeNodeData)this.getUserObject();
        ArrayList<Object> newList = new ArrayList<Object>();
        for (int ii = 0; ii < this.getChildCount(); ++ii) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)this.getChildAt(ii);
            TypeNodeData childData = (TypeNodeData)childNode.getUserObject();
            if (null == childData.getTypeValue()) continue;
            newList.add(childData.getTypeValue());
        }
        Object[] arr = newList.toArray();
        data.setTypeValue(arr);
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)this.getParent();
        if (parentNode instanceof ParameterTreeNode) {
            ((ParameterTreeNode)((Object)parentNode)).updateValueFromChildren(data);
        }
    }

    @Override
    public void updateChildren() {
        TypeNodeData thisData = (TypeNodeData)this.getUserObject();
        Object arrayObj = thisData.getTypeValue();
        this.removeAllChildren();
        try {
            String genericType = thisData.getGenericType();
            int arrayLength = ReflectionHelper.getArrayLength(arrayObj);
            for (int i = 0; i < arrayLength; ++i) {
                Object entry = ReflectionHelper.getArrayValue(arrayObj, i);
                TypeNodeData entryData = ReflectionHelper.createTypeData(genericType, "[" + i + "]", entry);
                DefaultMutableTreeNode entryNode = NodeHelper.getInstance().createNodeFromData(entryData);
                this.add(entryNode);
            }
        }
        catch (Exception ex) {
            Throwable cause = ex.getCause();
            ErrorManager.getDefault().notify(cause);
            ErrorManager.getDefault().log(this.getClass().getName() + ": Error using reflection on array: " + thisData.getRealTypeName() + "WebServiceReflectionException=" + cause);
        }
    }
}

