/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.backward_codecs.lucene92;

import java.io.IOException;
import org.apache.lucene.backward_codecs.lucene92.Lucene92HnswVectorsReader;
import org.apache.lucene.codecs.lucene90.IndexedDISI;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.RandomAccessInput;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.hnsw.RandomAccessVectorValues;
import org.apache.lucene.util.packed.DirectMonotonicReader;

abstract class OffHeapFloatVectorValues
extends FloatVectorValues
implements RandomAccessVectorValues<float[]> {
    protected final int dimension;
    protected final int size;
    protected final IndexInput slice;
    protected final int byteSize;
    protected int lastOrd = -1;
    protected final float[] value;

    OffHeapFloatVectorValues(int dimension, int size, IndexInput slice) {
        this.dimension = dimension;
        this.size = size;
        this.slice = slice;
        this.byteSize = 4 * dimension;
        this.value = new float[dimension];
    }

    public int dimension() {
        return this.dimension;
    }

    public int size() {
        return this.size;
    }

    public float[] vectorValue(int targetOrd) throws IOException {
        if (this.lastOrd == targetOrd) {
            return this.value;
        }
        this.slice.seek((long)targetOrd * (long)this.byteSize);
        this.slice.readFloats(this.value, 0, this.value.length);
        this.lastOrd = targetOrd;
        return this.value;
    }

    static OffHeapFloatVectorValues load(Lucene92HnswVectorsReader.FieldEntry fieldEntry, IndexInput vectorData) throws IOException {
        if (fieldEntry.docsWithFieldOffset == -2L) {
            return new EmptyOffHeapVectorValues(fieldEntry.dimension);
        }
        IndexInput bytesSlice = vectorData.slice("vector-data", fieldEntry.vectorDataOffset, fieldEntry.vectorDataLength);
        if (fieldEntry.docsWithFieldOffset == -1L) {
            return new DenseOffHeapVectorValues(fieldEntry.dimension, fieldEntry.size, bytesSlice);
        }
        return new SparseOffHeapVectorValues(fieldEntry, vectorData, bytesSlice);
    }

    private static class EmptyOffHeapVectorValues
    extends OffHeapFloatVectorValues {
        private int doc = -1;

        public EmptyOffHeapVectorValues(int dimension) {
            super(dimension, 0, null);
        }

        @Override
        public int dimension() {
            return super.dimension();
        }

        @Override
        public int size() {
            return 0;
        }

        public float[] vectorValue() throws IOException {
            throw new UnsupportedOperationException();
        }

        public int docID() {
            return this.doc;
        }

        public int nextDoc() throws IOException {
            return this.advance(this.doc + 1);
        }

        public int advance(int target) throws IOException {
            this.doc = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }

        public RandomAccessVectorValues<float[]> copy() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public float[] vectorValue(int targetOrd) throws IOException {
            throw new UnsupportedOperationException();
        }

        public int ordToDoc(int ord) {
            throw new UnsupportedOperationException();
        }

        public Bits getAcceptOrds(Bits acceptDocs) {
            return null;
        }
    }

    static class DenseOffHeapVectorValues
    extends OffHeapFloatVectorValues {
        private int doc = -1;

        public DenseOffHeapVectorValues(int dimension, int size, IndexInput slice) {
            super(dimension, size, slice);
        }

        public float[] vectorValue() throws IOException {
            return this.vectorValue(this.doc);
        }

        public int docID() {
            return this.doc;
        }

        public int nextDoc() throws IOException {
            return this.advance(this.doc + 1);
        }

        public int advance(int target) throws IOException {
            assert (this.docID() < target);
            if (target >= this.size) {
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            this.doc = target;
            return this.doc;
        }

        public RandomAccessVectorValues<float[]> copy() throws IOException {
            return new DenseOffHeapVectorValues(this.dimension, this.size, this.slice.clone());
        }

        public Bits getAcceptOrds(Bits acceptDocs) {
            return acceptDocs;
        }
    }

    private static class SparseOffHeapVectorValues
    extends OffHeapFloatVectorValues {
        private final DirectMonotonicReader ordToDoc;
        private final IndexedDISI disi;
        private final IndexInput dataIn;
        private final Lucene92HnswVectorsReader.FieldEntry fieldEntry;

        public SparseOffHeapVectorValues(Lucene92HnswVectorsReader.FieldEntry fieldEntry, IndexInput dataIn, IndexInput slice) throws IOException {
            super(fieldEntry.dimension, fieldEntry.size, slice);
            this.fieldEntry = fieldEntry;
            RandomAccessInput addressesData = dataIn.randomAccessSlice(fieldEntry.addressesOffset, fieldEntry.addressesLength);
            this.dataIn = dataIn;
            this.ordToDoc = DirectMonotonicReader.getInstance((DirectMonotonicReader.Meta)fieldEntry.meta, (RandomAccessInput)addressesData);
            this.disi = new IndexedDISI(dataIn, fieldEntry.docsWithFieldOffset, fieldEntry.docsWithFieldLength, (int)fieldEntry.jumpTableEntryCount, fieldEntry.denseRankPower, (long)fieldEntry.size);
        }

        public float[] vectorValue() throws IOException {
            return this.vectorValue(this.disi.index());
        }

        public int docID() {
            return this.disi.docID();
        }

        public int nextDoc() throws IOException {
            return this.disi.nextDoc();
        }

        public int advance(int target) throws IOException {
            assert (this.docID() < target);
            return this.disi.advance(target);
        }

        public RandomAccessVectorValues<float[]> copy() throws IOException {
            return new SparseOffHeapVectorValues(this.fieldEntry, this.dataIn, this.slice.clone());
        }

        public int ordToDoc(int ord) {
            return (int)this.ordToDoc.get((long)ord);
        }

        public Bits getAcceptOrds(final Bits acceptDocs) {
            if (acceptDocs == null) {
                return null;
            }
            return new Bits(){

                public boolean get(int index) {
                    return acceptDocs.get(this.ordToDoc(index));
                }

                public int length() {
                    return size;
                }
            };
        }
    }
}

