/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.debugging;

import java.io.IOError;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.eclipse.lsp4j.debug.services.IDebugProtocolClient;
import org.netbeans.modules.java.lsp.server.LspSession;
import org.netbeans.modules.java.lsp.server.debugging.NBConfigurationSemaphore;
import org.netbeans.modules.java.lsp.server.debugging.NbSourceProvider;
import org.netbeans.modules.java.lsp.server.debugging.NbThreads;
import org.netbeans.modules.java.lsp.server.debugging.breakpoints.BreakpointsManager;
import org.netbeans.modules.java.lsp.server.debugging.launch.NbDebugSession;
import org.netbeans.modules.java.lsp.server.progress.LspInternalHandle;
import org.netbeans.modules.progress.spi.InternalHandle;
import org.openide.util.Pair;

public final class DebugAdapterContext {
    private final LspSession lspSession;
    private IDebugProtocolClient client;
    private NbDebugSession debugSession;
    private boolean clientLinesStartAt1 = true;
    private boolean clientColumnsStartAt1 = true;
    private final boolean debuggerLinesStartAt1 = true;
    private boolean clientPathsAreUri = false;
    private final boolean debuggerPathsAreUri = true;
    private boolean supportsRunInTerminalRequest = false;
    private boolean isAttached = false;
    private String[] sourcePaths;
    private Charset debuggeeEncoding;
    private boolean isVmStopOnEntry = false;
    private boolean isDebugMode = true;
    private InternalHandle processExecutorHandle;
    private Supplier<Writer> inputSinkProvider;
    private final AtomicInteger lastSourceReferenceId = new AtomicInteger(0);
    private final Map<Integer, Pair<URI, String>> sourcesById = new ConcurrentHashMap<Integer, Pair<URI, String>>();
    private final Map<URI, Integer> sourceReferences = new ConcurrentHashMap<URI, Integer>();
    private final NBConfigurationSemaphore configurationSemaphore = new NBConfigurationSemaphore();
    private final NbSourceProvider sourceProvider = new NbSourceProvider(this);
    private final NbThreads threadsProvider = new NbThreads();
    private final BreakpointsManager breakpointManager = new BreakpointsManager(this.threadsProvider);

    DebugAdapterContext(LspSession lspSession) {
        this.lspSession = lspSession;
    }

    public LspSession getLspSession() {
        return this.lspSession;
    }

    public IDebugProtocolClient getClient() {
        return this.client;
    }

    void setClient(IDebugProtocolClient client) {
        this.client = client;
    }

    public NbDebugSession getDebugSession() {
        return this.debugSession;
    }

    public void setDebugSession(NbDebugSession session) {
        this.debugSession = session;
    }

    void setClientLinesStartAt1(Boolean clientLinesStartAt1) {
        if (clientLinesStartAt1 != null) {
            this.clientLinesStartAt1 = clientLinesStartAt1;
        }
    }

    void setClientColumnsStartAt1(Boolean clientColumnsStartAt1) {
        if (clientColumnsStartAt1 != null) {
            this.clientColumnsStartAt1 = clientColumnsStartAt1;
        }
    }

    public int getClientLine(int debuggerLine) {
        if (this.clientLinesStartAt1) {
            return debuggerLine;
        }
        if (this.clientLinesStartAt1) {
            return debuggerLine + 1;
        }
        return debuggerLine - 1;
    }

    public int getDebuggerLine(int clientLine) {
        if (this.clientLinesStartAt1) {
            return clientLine;
        }
        return clientLine + 1;
    }

    void setClientPathsAreUri(boolean clientPathsAreUri) {
        this.clientPathsAreUri = clientPathsAreUri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requestProcessTermination() {
        InternalHandle ih;
        DebugAdapterContext debugAdapterContext = this;
        synchronized (debugAdapterContext) {
            ih = this.processExecutorHandle;
        }
        if (ih != null) {
            ((LspInternalHandle)ih).forceRequestCancel();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProcessExecutorHandle(InternalHandle h) {
        DebugAdapterContext debugAdapterContext = this;
        synchronized (debugAdapterContext) {
            this.processExecutorHandle = h;
        }
    }

    public String getClientPath(String debuggerPath) {
        if (this.clientPathsAreUri) {
            return debuggerPath;
        }
        if (this.clientPathsAreUri) {
            return DebugAdapterContext.toURI(debuggerPath);
        }
        return DebugAdapterContext.toPath(debuggerPath);
    }

    public String getDebuggerPath(String clientPath) {
        if (this.clientPathsAreUri) {
            return clientPath;
        }
        return DebugAdapterContext.toURI(clientPath);
    }

    private static String toPath(String uri) {
        try {
            return Paths.get(new URI(uri)).toString();
        }
        catch (IllegalArgumentException | SecurityException | URISyntaxException | FileSystemNotFoundException e) {
            return null;
        }
    }

    private static String toURI(String path) {
        try {
            return Paths.get(path, new String[0]).toUri().toString();
        }
        catch (IOError | SecurityException | InvalidPathException e) {
            return null;
        }
    }

    public boolean isSupportsRunInTerminalRequest() {
        return this.supportsRunInTerminalRequest;
    }

    public void setSupportsRunInTerminalRequest(Boolean supportsRunInTerminalRequest) {
        if (supportsRunInTerminalRequest != null) {
            this.supportsRunInTerminalRequest = supportsRunInTerminalRequest;
        }
    }

    public boolean isAttached() {
        return this.isAttached;
    }

    public void setAttached(boolean isAttached) {
        this.isAttached = isAttached;
    }

    public String[] getSourcePaths() {
        return this.sourcePaths;
    }

    public void setSourcePaths(String[] sourcePaths) {
        this.sourcePaths = sourcePaths;
    }

    public URI getSourceUri(int sourceReference) {
        Pair<URI, String> sourceInfo = this.sourcesById.get(sourceReference);
        if (sourceInfo != null) {
            return (URI)sourceInfo.first();
        }
        return null;
    }

    public String getSourceMimeType(int sourceReference) {
        Pair<URI, String> sourceInfo = this.sourcesById.get(sourceReference);
        if (sourceInfo != null) {
            return (String)sourceInfo.second();
        }
        return null;
    }

    public int createSourceReference(URI uri, String mimeType) {
        int id = this.sourceReferences.computeIfAbsent(uri, u -> this.lastSourceReferenceId.incrementAndGet());
        this.sourcesById.put(id, (Pair<URI, String>)Pair.of((Object)uri, (Object)mimeType));
        return id;
    }

    public void setDebuggeeEncoding(Charset encoding) {
        this.debuggeeEncoding = encoding;
    }

    public Charset getDebuggeeEncoding() {
        return this.debuggeeEncoding;
    }

    public boolean isVmStopOnEntry() {
        return this.isVmStopOnEntry;
    }

    public void setVmStopOnEntry(Boolean stopOnEntry) {
        if (stopOnEntry != null) {
            this.isVmStopOnEntry = stopOnEntry;
        }
    }

    public boolean isDebugMode() {
        return this.isDebugMode;
    }

    public void setDebugMode(boolean mode) {
        this.isDebugMode = mode;
    }

    public NBConfigurationSemaphore getConfigurationSemaphore() {
        return this.configurationSemaphore;
    }

    public NbSourceProvider getSourceProvider() {
        return this.sourceProvider;
    }

    public NbThreads getThreadsProvider() {
        return this.threadsProvider;
    }

    public BreakpointsManager getBreakpointManager() {
        return this.breakpointManager;
    }

    public Writer getInputSink() {
        return this.inputSinkProvider == null ? null : this.inputSinkProvider.get();
    }

    public void setInputSinkProvider(Supplier<Writer> inputSinkProvider) {
        this.inputSinkProvider = inputSinkProvider;
    }
}

