/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http.client.jersey;

import com.oracle.bmc.http.client.HttpClientBuilder;
import com.oracle.bmc.http.client.HttpProvider;
import com.oracle.bmc.http.client.Serializer;
import com.oracle.bmc.http.client.jersey.JerseyHttpClientBuilder;
import com.oracle.bmc.serialization.jackson.JacksonSerializer;
import javax.ws.rs.client.Client;

public class JerseyHttpProvider
implements HttpProvider {
    private static final String SUN_NET_HTTP_ALLOW_RESTRICTED_HEADERS = "sun.net.http.allowRestrictedHeaders";
    private static final JerseyHttpProvider INSTANCE = new JerseyHttpProvider();
    static final boolean isApacheDependencyPresent = JerseyHttpProvider.checkForApacheDependencies() && !JerseyHttpProvider.jerseyDefaultConnectorEnabled();

    public static JerseyHttpProvider getInstance() {
        return INSTANCE;
    }

    public HttpClientBuilder newBuilder() {
        return new JerseyHttpClientBuilder();
    }

    public Serializer getSerializer() {
        return JacksonSerializer.getDefaultSerializer();
    }

    private static boolean checkForApacheDependencies() {
        try {
            Class.forName("org.apache.http.client.config.RequestConfig");
            Class.forName("org.glassfish.jersey.apache.connector.ApacheConnector");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static boolean jerseyDefaultConnectorEnabled() {
        String trimmedValue;
        String jerseyDefaultConnectorEnabledString = System.getenv("OCI_JAVASDK_JERSEY_CLIENT_DEFAULT_CONNECTOR_ENABLED");
        return jerseyDefaultConnectorEnabledString != null && !jerseyDefaultConnectorEnabledString.isEmpty() && "true".equalsIgnoreCase(trimmedValue = jerseyDefaultConnectorEnabledString.trim());
    }

    private static void setAllowRestrictedHeadersProperty(String previousValue) {
        if (previousValue != null && !Boolean.valueOf(previousValue).booleanValue()) {
            throw new IllegalStateException("Property sun.net.http.allowRestrictedHeaders was explicitly set to " + previousValue + "; the OCI SDK needs to set this property to true. Failing...");
        }
        System.setProperty(SUN_NET_HTTP_ALLOW_RESTRICTED_HEADERS, "true");
    }

    static {
        Client.class.getName();
        if (!isApacheDependencyPresent) {
            JerseyHttpProvider.setAllowRestrictedHeadersProperty(System.getProperty(SUN_NET_HTTP_ALLOW_RESTRICTED_HEADERS));
        }
    }
}

