/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.keymanagement.model.ExternalKeyReferenceDetails;
import com.oracle.bmc.keymanagement.model.KeyReplicaDetails;
import com.oracle.bmc.keymanagement.model.KeyShape;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Key
extends ExplicitlySetBmcModel {
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="currentKeyVersion")
    private final String currentKeyVersion;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="keyShape")
    private final KeyShape keyShape;
    @JsonProperty(value="protectionMode")
    private final ProtectionMode protectionMode;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeOfDeletion")
    private final Date timeOfDeletion;
    @JsonProperty(value="vaultId")
    private final String vaultId;
    @JsonProperty(value="restoredFromKeyId")
    private final String restoredFromKeyId;
    @JsonProperty(value="replicaDetails")
    private final KeyReplicaDetails replicaDetails;
    @JsonProperty(value="isPrimary")
    private final Boolean isPrimary;
    @JsonProperty(value="externalKeyReferenceDetails")
    private final ExternalKeyReferenceDetails externalKeyReferenceDetails;

    @Deprecated
    @ConstructorProperties(value={"compartmentId", "currentKeyVersion", "definedTags", "displayName", "freeformTags", "id", "keyShape", "protectionMode", "lifecycleState", "timeCreated", "timeOfDeletion", "vaultId", "restoredFromKeyId", "replicaDetails", "isPrimary", "externalKeyReferenceDetails"})
    public Key(String compartmentId, String currentKeyVersion, Map<String, Map<String, Object>> definedTags, String displayName, Map<String, String> freeformTags, String id, KeyShape keyShape, ProtectionMode protectionMode, LifecycleState lifecycleState, Date timeCreated, Date timeOfDeletion, String vaultId, String restoredFromKeyId, KeyReplicaDetails replicaDetails, Boolean isPrimary, ExternalKeyReferenceDetails externalKeyReferenceDetails) {
        this.compartmentId = compartmentId;
        this.currentKeyVersion = currentKeyVersion;
        this.definedTags = definedTags;
        this.displayName = displayName;
        this.freeformTags = freeformTags;
        this.id = id;
        this.keyShape = keyShape;
        this.protectionMode = protectionMode;
        this.lifecycleState = lifecycleState;
        this.timeCreated = timeCreated;
        this.timeOfDeletion = timeOfDeletion;
        this.vaultId = vaultId;
        this.restoredFromKeyId = restoredFromKeyId;
        this.replicaDetails = replicaDetails;
        this.isPrimary = isPrimary;
        this.externalKeyReferenceDetails = externalKeyReferenceDetails;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getCurrentKeyVersion() {
        return this.currentKeyVersion;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public String getId() {
        return this.id;
    }

    public KeyShape getKeyShape() {
        return this.keyShape;
    }

    public ProtectionMode getProtectionMode() {
        return this.protectionMode;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeOfDeletion() {
        return this.timeOfDeletion;
    }

    public String getVaultId() {
        return this.vaultId;
    }

    public String getRestoredFromKeyId() {
        return this.restoredFromKeyId;
    }

    public KeyReplicaDetails getReplicaDetails() {
        return this.replicaDetails;
    }

    public Boolean getIsPrimary() {
        return this.isPrimary;
    }

    public ExternalKeyReferenceDetails getExternalKeyReferenceDetails() {
        return this.externalKeyReferenceDetails;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Key(");
        sb.append("super=").append(super.toString());
        sb.append("compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", currentKeyVersion=").append(String.valueOf(this.currentKeyVersion));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", id=").append(String.valueOf(this.id));
        sb.append(", keyShape=").append(String.valueOf((Object)this.keyShape));
        sb.append(", protectionMode=").append(String.valueOf((Object)this.protectionMode));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeOfDeletion=").append(String.valueOf(this.timeOfDeletion));
        sb.append(", vaultId=").append(String.valueOf(this.vaultId));
        sb.append(", restoredFromKeyId=").append(String.valueOf(this.restoredFromKeyId));
        sb.append(", replicaDetails=").append(String.valueOf((Object)this.replicaDetails));
        sb.append(", isPrimary=").append(String.valueOf(this.isPrimary));
        sb.append(", externalKeyReferenceDetails=").append(String.valueOf((Object)this.externalKeyReferenceDetails));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Key)) {
            return false;
        }
        Key other = (Key)((Object)o);
        return Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.currentKeyVersion, other.currentKeyVersion) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.id, other.id) && Objects.equals((Object)this.keyShape, (Object)other.keyShape) && Objects.equals((Object)this.protectionMode, (Object)other.protectionMode) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeOfDeletion, other.timeOfDeletion) && Objects.equals(this.vaultId, other.vaultId) && Objects.equals(this.restoredFromKeyId, other.restoredFromKeyId) && Objects.equals((Object)this.replicaDetails, (Object)other.replicaDetails) && Objects.equals(this.isPrimary, other.isPrimary) && Objects.equals((Object)this.externalKeyReferenceDetails, (Object)other.externalKeyReferenceDetails) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.currentKeyVersion == null ? 43 : this.currentKeyVersion.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.keyShape == null ? 43 : this.keyShape.hashCode());
        result = result * 59 + (this.protectionMode == null ? 43 : this.protectionMode.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeOfDeletion == null ? 43 : this.timeOfDeletion.hashCode());
        result = result * 59 + (this.vaultId == null ? 43 : this.vaultId.hashCode());
        result = result * 59 + (this.restoredFromKeyId == null ? 43 : this.restoredFromKeyId.hashCode());
        result = result * 59 + (this.replicaDetails == null ? 43 : this.replicaDetails.hashCode());
        result = result * 59 + (this.isPrimary == null ? 43 : this.isPrimary.hashCode());
        result = result * 59 + (this.externalKeyReferenceDetails == null ? 43 : this.externalKeyReferenceDetails.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LifecycleState implements BmcEnum
    {
        Creating("CREATING"),
        Enabling("ENABLING"),
        Enabled("ENABLED"),
        Disabling("DISABLING"),
        Disabled("DISABLED"),
        Deleting("DELETING"),
        Deleted("DELETED"),
        PendingDeletion("PENDING_DELETION"),
        SchedulingDeletion("SCHEDULING_DELETION"),
        CancellingDeletion("CANCELLING_DELETION"),
        Updating("UPDATING"),
        BackupInProgress("BACKUP_IN_PROGRESS"),
        Restoring("RESTORING"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ProtectionMode implements BmcEnum
    {
        Hsm("HSM"),
        Software("SOFTWARE"),
        External("EXTERNAL"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ProtectionMode> map;

        private ProtectionMode(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ProtectionMode create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ProtectionMode', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ProtectionMode.class);
            map = new HashMap<String, ProtectionMode>();
            for (ProtectionMode v : ProtectionMode.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="currentKeyVersion")
        private String currentKeyVersion;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="keyShape")
        private KeyShape keyShape;
        @JsonProperty(value="protectionMode")
        private ProtectionMode protectionMode;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeOfDeletion")
        private Date timeOfDeletion;
        @JsonProperty(value="vaultId")
        private String vaultId;
        @JsonProperty(value="restoredFromKeyId")
        private String restoredFromKeyId;
        @JsonProperty(value="replicaDetails")
        private KeyReplicaDetails replicaDetails;
        @JsonProperty(value="isPrimary")
        private Boolean isPrimary;
        @JsonProperty(value="externalKeyReferenceDetails")
        private ExternalKeyReferenceDetails externalKeyReferenceDetails;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder currentKeyVersion(String currentKeyVersion) {
            this.currentKeyVersion = currentKeyVersion;
            this.__explicitlySet__.add("currentKeyVersion");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder keyShape(KeyShape keyShape) {
            this.keyShape = keyShape;
            this.__explicitlySet__.add("keyShape");
            return this;
        }

        public Builder protectionMode(ProtectionMode protectionMode) {
            this.protectionMode = protectionMode;
            this.__explicitlySet__.add("protectionMode");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeOfDeletion(Date timeOfDeletion) {
            this.timeOfDeletion = timeOfDeletion;
            this.__explicitlySet__.add("timeOfDeletion");
            return this;
        }

        public Builder vaultId(String vaultId) {
            this.vaultId = vaultId;
            this.__explicitlySet__.add("vaultId");
            return this;
        }

        public Builder restoredFromKeyId(String restoredFromKeyId) {
            this.restoredFromKeyId = restoredFromKeyId;
            this.__explicitlySet__.add("restoredFromKeyId");
            return this;
        }

        public Builder replicaDetails(KeyReplicaDetails replicaDetails) {
            this.replicaDetails = replicaDetails;
            this.__explicitlySet__.add("replicaDetails");
            return this;
        }

        public Builder isPrimary(Boolean isPrimary) {
            this.isPrimary = isPrimary;
            this.__explicitlySet__.add("isPrimary");
            return this;
        }

        public Builder externalKeyReferenceDetails(ExternalKeyReferenceDetails externalKeyReferenceDetails) {
            this.externalKeyReferenceDetails = externalKeyReferenceDetails;
            this.__explicitlySet__.add("externalKeyReferenceDetails");
            return this;
        }

        public Key build() {
            Key model = new Key(this.compartmentId, this.currentKeyVersion, this.definedTags, this.displayName, this.freeformTags, this.id, this.keyShape, this.protectionMode, this.lifecycleState, this.timeCreated, this.timeOfDeletion, this.vaultId, this.restoredFromKeyId, this.replicaDetails, this.isPrimary, this.externalKeyReferenceDetails);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Key model) {
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("currentKeyVersion")) {
                this.currentKeyVersion(model.getCurrentKeyVersion());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("keyShape")) {
                this.keyShape(model.getKeyShape());
            }
            if (model.wasPropertyExplicitlySet("protectionMode")) {
                this.protectionMode(model.getProtectionMode());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeOfDeletion")) {
                this.timeOfDeletion(model.getTimeOfDeletion());
            }
            if (model.wasPropertyExplicitlySet("vaultId")) {
                this.vaultId(model.getVaultId());
            }
            if (model.wasPropertyExplicitlySet("restoredFromKeyId")) {
                this.restoredFromKeyId(model.getRestoredFromKeyId());
            }
            if (model.wasPropertyExplicitlySet("replicaDetails")) {
                this.replicaDetails(model.getReplicaDetails());
            }
            if (model.wasPropertyExplicitlySet("isPrimary")) {
                this.isPrimary(model.getIsPrimary());
            }
            if (model.wasPropertyExplicitlySet("externalKeyReferenceDetails")) {
                this.externalKeyReferenceDetails(model.getExternalKeyReferenceDetails());
            }
            return this;
        }
    }
}

