/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.portlet.multipart;

import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.PortletContext;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUpload;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.portlet.PortletFileUpload;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.web.multipart.MaxUploadSizeExceededException;
import org.springframework.web.multipart.MultipartException;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.commons.CommonsFileUploadSupport;
import org.springframework.web.portlet.context.PortletContextAware;
import org.springframework.web.portlet.multipart.DefaultMultipartActionRequest;
import org.springframework.web.portlet.multipart.MultipartActionRequest;
import org.springframework.web.portlet.multipart.PortletMultipartResolver;
import org.springframework.web.portlet.util.PortletUtils;

public class CommonsPortletMultipartResolver
extends CommonsFileUploadSupport
implements PortletMultipartResolver,
PortletContextAware {
    private boolean resolveLazily = false;

    public CommonsPortletMultipartResolver() {
    }

    public CommonsPortletMultipartResolver(PortletContext portletContext) {
        this();
        this.setPortletContext(portletContext);
    }

    public void setResolveLazily(boolean resolveLazily) {
        this.resolveLazily = resolveLazily;
    }

    protected FileUpload newFileUpload(FileItemFactory fileItemFactory) {
        return new PortletFileUpload(fileItemFactory);
    }

    public void setPortletContext(PortletContext portletContext) {
        if (!this.isUploadTempDirSpecified()) {
            this.getFileItemFactory().setRepository(PortletUtils.getTempDir(portletContext));
        }
    }

    public boolean isMultipart(ActionRequest request) {
        return request != null && PortletFileUpload.isMultipartContent((ActionRequest)request);
    }

    public MultipartActionRequest resolveMultipart(final ActionRequest request) throws MultipartException {
        Assert.notNull((Object)request, (String)"Request must not be null");
        if (this.resolveLazily) {
            return new DefaultMultipartActionRequest(request){

                protected void initializeMultipart() {
                    CommonsFileUploadSupport.MultipartParsingResult parsingResult = CommonsPortletMultipartResolver.this.parseRequest(request);
                    this.setMultipartFiles((MultiValueMap<String, MultipartFile>)parsingResult.getMultipartFiles());
                    this.setMultipartParameters(parsingResult.getMultipartParameters());
                    this.setMultipartParameterContentTypes(parsingResult.getMultipartParameterContentTypes());
                }
            };
        }
        CommonsFileUploadSupport.MultipartParsingResult parsingResult = this.parseRequest(request);
        return new DefaultMultipartActionRequest(request, (MultiValueMap<String, MultipartFile>)parsingResult.getMultipartFiles(), parsingResult.getMultipartParameters(), parsingResult.getMultipartParameterContentTypes());
    }

    protected CommonsFileUploadSupport.MultipartParsingResult parseRequest(ActionRequest request) throws MultipartException {
        String encoding = this.determineEncoding(request);
        FileUpload fileUpload = this.prepareFileUpload(encoding);
        try {
            List fileItems = ((PortletFileUpload)fileUpload).parseRequest(request);
            return this.parseFileItems(fileItems, encoding);
        }
        catch (FileUploadBase.SizeLimitExceededException ex) {
            throw new MaxUploadSizeExceededException(fileUpload.getSizeMax(), (Throwable)ex);
        }
        catch (FileUploadException ex) {
            throw new MultipartException("Could not parse multipart portlet request", (Throwable)ex);
        }
    }

    protected String determineEncoding(ActionRequest request) {
        String encoding = request.getCharacterEncoding();
        if (encoding == null) {
            encoding = this.getDefaultEncoding();
        }
        return encoding;
    }

    public void cleanupMultipart(MultipartActionRequest request) {
        if (request != null) {
            try {
                this.cleanupFileItems(request.getMultiFileMap());
            }
            catch (Throwable ex) {
                this.logger.warn((Object)"Failed to perform multipart cleanup for portlet request", ex);
            }
        }
    }
}

