/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.el.refactoring;

import java.io.IOException;
import java.lang.ref.WeakReference;
import org.netbeans.modules.csl.spi.support.ModificationResult;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.openide.filesystems.FileObject;
import org.openide.text.PositionBounds;
import org.openide.text.PositionRef;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public class DiffElement
extends SimpleRefactoringElementImplementation {
    private PositionBounds bounds;
    private String displayText;
    private FileObject parentFile;
    private ModificationResult.Difference diff;
    private ModificationResult modification;
    private WeakReference<String> newFileContent;

    public DiffElement(ModificationResult.Difference diff, PositionBounds bounds, FileObject parentFile, ModificationResult modification) {
        this.bounds = bounds;
        this.displayText = diff.getDescription();
        this.parentFile = parentFile;
        this.diff = diff;
        this.modification = modification;
    }

    public String getDisplayText() {
        return this.displayText;
    }

    public Lookup getLookup() {
        return Lookups.fixed((Object[])new Object[]{this.diff});
    }

    public void setEnabled(boolean enabled) {
        this.diff.exclude(!enabled);
        this.newFileContent = null;
        super.setEnabled(enabled);
    }

    public PositionBounds getPosition() {
        return this.bounds;
    }

    public String getText() {
        return this.displayText;
    }

    public void performChange() {
    }

    public FileObject getParentFile() {
        return this.parentFile;
    }

    protected String getNewFileContent() {
        String result;
        if (this.newFileContent != null && (result = (String)this.newFileContent.get()) != null) {
            return result;
        }
        try {
            result = this.modification.getResultingSource(this.parentFile);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
        this.newFileContent = new WeakReference<String>(result);
        return result;
    }

    public static DiffElement create(ModificationResult.Difference diff, FileObject fileObject, ModificationResult modification) {
        PositionRef start = diff.getStartPosition();
        PositionRef end = diff.getEndPosition();
        Object doc = null;
        PositionBounds bounds = new PositionBounds(start, end);
        return new DiffElement(diff, bounds, fileObject, modification);
    }
}

