/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bsf.engines.javascript;

import java.rmi.RemoteException;
import java.util.Vector;
import org.apache.bsf.BSFDeclaredBean;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.apache.bsf.engines.javascript.DocumentCell;
import org.apache.bsf.engines.javascript.FnOrScript;
import org.apache.bsf.engines.javascript.RhinoEngineDebugger;
import org.apache.bsf.util.BSFDebugManagerImpl;
import org.apache.bsf.util.BSFEngineImpl;
import org.apache.bsf.util.BSFFunctions;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.WrappedException;
import org.mozilla.javascript.Wrapper;
import org.mozilla.javascript.debug.DebuggableEngine;
import org.mozilla.javascript.debug.Debugger;

public class JavaScriptEngine
extends BSFEngineImpl {
    private Scriptable global;
    private RhinoEngineDebugger m_rhinoDbg;

    public void disconnectedDebuggerNotify() {
        this.m_rhinoDbg.disconnectedDebuggerNotify();
    }

    BSFDebugManagerImpl getDebugManager() {
        return this.dbgmgr;
    }

    public void placeBreakpointAtLine(int n, String string, int n2) throws BSFException {
        this.m_rhinoDbg.placeBreakpointAtLine(n, string, n2);
    }

    public void placeBreakpointAtOffset(int n, String string, int n2) throws BSFException {
        this.m_rhinoDbg.placeBreakpointAtOffset(n, string, n2);
    }

    public void removeBreakpoint(String string, int n) throws BSFException {
        this.m_rhinoDbg.removeBreakpoint(string, n);
    }

    public void setEntryExit(String string, boolean bl) throws BSFException {
        this.m_rhinoDbg.setEntryExit(string, bl);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object call(Object object, String string, Object[] objectArray) throws BSFException {
        Object object2 = null;
        try {
            block7: {
                try {
                    Context context = Context.enter();
                    Object object3 = this.global.get(string, this.global);
                    if (object3 == Scriptable.NOT_FOUND) {
                        throw new JavaScriptException((Object)("function " + string + " not found."));
                    }
                    if (this.dbgmgr != null) {
                        context.setGeneratingDebug(true);
                        context.setGeneratingSource(true);
                        context.setOptimizationLevel(-1);
                        DebuggableEngine debuggableEngine = context.getDebuggableEngine();
                        debuggableEngine.setDebugger((Debugger)this.m_rhinoDbg);
                        object2 = ScriptRuntime.call((Context)context, (Object)object3, (Object)this.global, (Object[])objectArray, null);
                    } else {
                        context.setOptimizationLevel(-1);
                        context.setGeneratingDebug(false);
                        context.setGeneratingSource(false);
                        context.setOptimizationLevel(0);
                        DebuggableEngine debuggableEngine = context.getDebuggableEngine();
                        debuggableEngine.setDebugger(null);
                        object2 = ScriptRuntime.call((Context)context, (Object)object3, (Object)this.global, (Object[])objectArray, null);
                    }
                    if (!(object2 instanceof Wrapper)) break block7;
                    object2 = ((Wrapper)object2).unwrap();
                }
                catch (Throwable throwable) {
                    this.handleError(throwable);
                    Object var9_11 = null;
                    Context.exit();
                    return object2;
                }
            }
            Object var9_10 = null;
            Context.exit();
            return object2;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            Context.exit();
            throw throwable;
        }
    }

    public void declareBean(BSFDeclaredBean bSFDeclaredBean) throws BSFException {
        Scriptable scriptable = Context.toObject((Object)bSFDeclaredBean.bean, (Scriptable)this.global);
        this.global.put(bSFDeclaredBean.name, this.global, (Object)scriptable);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object eval(String string, int n, int n2, Object object) throws BSFException {
        String string2 = object.toString();
        Object object2 = null;
        try {
            block7: {
                try {
                    Context context = Context.enter();
                    DocumentCell documentCell = this.m_rhinoDbg.loadDocumentNotify(string);
                    FnOrScript fnOrScript = documentCell.registerFnOrScriptLines(string2, n, n2);
                    this.m_rhinoDbg.setCompilingFnOrScript(fnOrScript);
                    if (this.dbgmgr != null) {
                        context.setGeneratingDebug(true);
                        context.setGeneratingSource(true);
                        context.setOptimizationLevel(-1);
                        DebuggableEngine debuggableEngine = context.getDebuggableEngine();
                        debuggableEngine.setDebugger((Debugger)this.m_rhinoDbg);
                        if (!debuggableEngine.getBreakNextLine()) {
                            debuggableEngine.setBreakNextLine(documentCell.getEntryExit());
                        }
                        fnOrScript.compile(context, this.global);
                        this.m_rhinoDbg.setCompilingFnOrScript(null);
                        Script script = fnOrScript.getScript();
                        object2 = script != null ? script.exec(context, this.global) : null;
                    } else {
                        context.setOptimizationLevel(-1);
                        context.setGeneratingDebug(false);
                        context.setGeneratingSource(false);
                        context.setOptimizationLevel(0);
                        DebuggableEngine debuggableEngine = context.getDebuggableEngine();
                        debuggableEngine.setDebugger(null);
                        object2 = context.evaluateString(this.global, string2, string, n, null);
                    }
                    if (!(object2 instanceof NativeJavaObject)) break block7;
                    object2 = ((NativeJavaObject)object2).unwrap();
                }
                catch (Throwable throwable) {
                    this.handleError(throwable);
                    Object var14_14 = null;
                    Context.exit();
                    return object2;
                }
            }
            Object var14_13 = null;
            Context.exit();
            return object2;
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            Context.exit();
            throw throwable;
        }
    }

    public Object getSpecificDebuggingInterface() {
        if (this.m_rhinoDbg != null) {
            return this.m_rhinoDbg.getDebugInterface();
        }
        return null;
    }

    private void handleError(Throwable throwable) throws BSFException {
        if (throwable instanceof WrappedException) {
            throwable = (Throwable)((WrappedException)throwable).unwrap();
        }
        String string = null;
        Throwable throwable2 = throwable;
        if (throwable instanceof JavaScriptException) {
            string = throwable.getLocalizedMessage();
            Object object = ((JavaScriptException)throwable).getValue();
            if (object instanceof Throwable) {
                throwable2 = (Throwable)object;
            }
        } else if (throwable instanceof EvaluatorException || throwable instanceof SecurityException) {
            string = throwable.getLocalizedMessage();
        } else if (throwable instanceof RuntimeException) {
            string = "Internal Error: " + throwable.toString();
        } else if (throwable instanceof StackOverflowError) {
            string = "Stack Overflow";
        }
        if (string == null) {
            string = throwable.toString();
        }
        if (throwable instanceof Error && !(throwable instanceof StackOverflowError)) {
            throw (Error)throwable;
        }
        throw new BSFException(BSFException.REASON_OTHER_ERROR, "JavaScript Error: " + string, throwable2);
    }

    public void initialize(BSFManager bSFManager, String string, Vector vector) throws BSFException {
        try {
            this.m_rhinoDbg = new RhinoEngineDebugger(this);
        }
        catch (RemoteException remoteException) {
            this.m_rhinoDbg = null;
        }
        super.initialize(bSFManager, string, vector);
        try {
            Context context = Context.enter();
            this.global = new ImporterTopLevel(context);
            Scriptable scriptable = Context.toObject((Object)new BSFFunctions(bSFManager, this), (Scriptable)this.global);
            this.global.put("bsf", this.global, (Object)scriptable);
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                this.declareBean((BSFDeclaredBean)vector.elementAt(n2));
                ++n2;
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            Context.exit();
            throw throwable;
        }
    }

    public void undeclareBean(BSFDeclaredBean bSFDeclaredBean) throws BSFException {
        this.global.delete(bSFDeclaredBean.name);
    }
}

