/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;

public class InnerPanelSupport {
    private static final String PROP_BULK_ENABLE = InnerPanelSupport.class.getName() + ".BulkEnable";

    public static List<Component> getAllComponents(JComponent parent) {
        ArrayList<Component> result = new ArrayList<Component>(5);
        result.addAll(Arrays.asList(parent.getComponents()));
        for (int index = 0; index < result.size(); ++index) {
            Component c = (Component)result.get(index);
            if (!(c instanceof Container)) continue;
            result.addAll(Arrays.asList(((Container)c).getComponents()));
        }
        return result;
    }

    public static void enablePanel(JPanel panel, boolean enable) {
        panel.setEnabled(enable);
        List<Component> contents = InnerPanelSupport.getAllComponents(panel);
        List<Component> enabled = new ArrayList(contents.size() / 2);
        if (enable) {
            ArrayList<Runnable> reCheck = new ArrayList<Runnable>(3);
            enabled = (List)panel.getClientProperty(PROP_BULK_ENABLE);
            if (enabled == null) {
                return;
            }
            for (int i = enabled.size() - 1; i >= 0; --i) {
                Component component = (Component)enabled.get(i);
                component.setEnabled(true);
                if (!(component instanceof JPanel) || !(component instanceof Runnable)) continue;
                reCheck.add((Runnable)((Object)component));
            }
            for (Runnable runnable : reCheck) {
                runnable.run();
            }
            panel.setEnabled(enable);
            if (panel instanceof Runnable) {
                ((Runnable)((Object)panel)).run();
            }
        } else {
            for (Component c : contents) {
                if (!c.isEnabled() || !c.isVisible()) continue;
                enabled.add(c);
                c.setEnabled(false);
                if (c instanceof JList) {
                    ((JList)c).setSelectedIndex(-1);
                    continue;
                }
                if (c instanceof JTable) {
                    ((JTable)c).getSelectionModel().clearSelection();
                    continue;
                }
                if (!(c instanceof JTextField)) continue;
                ((JTextField)c).select(0, 0);
            }
            panel.putClientProperty(PROP_BULK_ENABLE, enabled);
        }
    }

    public static JTable displayExtendedCells(JTable table) {
        CellExtensionSupport supp = new CellExtensionSupport(table);
        table.addMouseListener(supp);
        table.addMouseMotionListener(supp);
        table.getSelectionModel().addListSelectionListener(supp);
        return table;
    }

    private static class CellExtensionSupport
    implements MouseListener,
    MouseMotionListener,
    ListSelectionListener {
        private JTable listClasses;
        private final CellRendererPane rendererPane = new CellRendererPane();
        private int currentRow = -1;
        private int currentCol = -1;
        private Popup currentPopup;
        private RenderedImage popupContents;

        private CellExtensionSupport(JTable listClasses) {
            this.listClasses = listClasses;
        }

        private void hidePopup() {
            if (this.currentPopup != null) {
                this.currentPopup.hide();
                this.currentPopup = null;
                this.popupContents = null;
                this.currentRow = -1;
                this.currentCol = -1;
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (this.popupContents != null) {
                this.updateTooltipImage(this.popupContents, this.currentRow, this.currentCol);
            }
        }

        private boolean updateTooltipImage(RenderedImage contents, int row, int col) {
            TableCellRenderer renderer = this.listClasses.getCellRenderer(row, col);
            Component component = this.listClasses.prepareRenderer(renderer, row, col);
            if (!(component instanceof JComponent)) {
                return false;
            }
            Rectangle cellRect = this.listClasses.getCellRect(row, col, false);
            Dimension size = component.getPreferredSize();
            Rectangle visibleRect = this.listClasses.getVisibleRect();
            if (cellRect.width >= size.width) {
                this.hidePopup();
                return false;
            }
            if (cellRect.y + size.height > visibleRect.y + visibleRect.height + 1) {
                this.hidePopup();
                return false;
            }
            BufferedImage img = new BufferedImage(size.width, size.height, 1);
            Graphics g = img.getGraphics();
            g.setClip(null);
            g.setColor(this.listClasses.getBackground());
            g.fillRect(0, 0, size.width, size.height);
            g.translate(-cellRect.x, -cellRect.y);
            cellRect.width = size.width;
            this.rendererPane.paintComponent(g, component, this.listClasses, cellRect);
            if (this.listClasses.getShowHorizontalLines()) {
                int rightX = size.width - 1;
                g.translate(cellRect.x, cellRect.y);
                g.setColor(this.listClasses.getForeground());
                g.drawLine(0, 0, rightX, 0);
                g.drawLine(rightX, 0, rightX, size.height);
                g.drawLine(rightX, size.height - 1, 0, size.height - 1);
            }
            g.dispose();
            this.rendererPane.remove(component);
            contents.setImage(img);
            return true;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            Point p = e.getPoint();
            int col = this.listClasses.columnAtPoint(p);
            int row = this.listClasses.rowAtPoint(p);
            if (col < 0 || row < 0) {
                this.hidePopup();
                return;
            }
            if (col == this.currentCol && row == this.currentRow) {
                return;
            }
            Rectangle cellRect = this.listClasses.getCellRect(row, col, false);
            Point pt = cellRect.getLocation();
            SwingUtilities.convertPointToScreen(pt, this.listClasses);
            RenderedImage ri = new RenderedImage();
            if (!this.updateTooltipImage(ri, row, col)) {
                return;
            }
            ri.addMouseListener(this);
            Popup popup = PopupFactory.getSharedInstance().getPopup(this.listClasses, ri, pt.x, pt.y);
            this.popupContents = ri;
            this.currentPopup = popup;
            this.currentCol = col;
            this.currentRow = row;
            popup.show();
            System.err.println("Hello");
        }

        public void redispatchMouseEvent(MouseEvent e) {
            if (!(e.getComponent() instanceof RenderedImage)) {
                return;
            }
            MouseEvent delegate = SwingUtilities.convertMouseEvent(e.getComponent(), e, this.listClasses);
            this.listClasses.dispatchEvent(delegate);
            if (this.listClasses.isEditing()) {
                this.hidePopup();
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.redispatchMouseEvent(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.redispatchMouseEvent(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.redispatchMouseEvent(e);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (e.getSource() == this.listClasses && this.currentPopup != null) {
                Point screen = e.getLocationOnScreen();
                Rectangle visibleRec = this.listClasses.getVisibleRect();
                Point pt = visibleRec.getLocation();
                SwingUtilities.convertPointToScreen(pt, this.listClasses);
                visibleRec.setLocation(pt);
                if (visibleRec.contains(screen)) {
                    return;
                }
                this.hidePopup();
            } else if (e.getSource() == this.popupContents) {
                this.hidePopup();
            }
        }
    }

    private static class RenderedImage
    extends JComponent {
        private BufferedImage image;

        public void setImage(BufferedImage image) {
            this.image = image;
            this.invalidate();
            if (this.isVisible()) {
                this.repaint();
            }
        }

        @Override
        public void paint(Graphics g) {
            g.drawImage(this.image, 0, 0, null);
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(this.image.getWidth(), this.image.getHeight());
        }
    }
}

