/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.BreakTree;
import com.sun.source.tree.CaseLabelTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ContinueTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SwitchExpressionTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.Trees;
import com.sun.tools.javac.api.JavacScope;
import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Enter;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.Log;
import java.io.CharConversionException;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.UnionType;
import javax.lang.model.type.WildcardType;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CodeStyle;
import org.netbeans.api.java.source.CodeStyleUtils;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.java.source.support.ErrorAwareTreePathScanner;
import org.netbeans.api.java.source.support.ErrorAwareTreeScanner;
import org.netbeans.editor.GuardedDocument;
import org.netbeans.modules.java.hints.errors.Bundle;
import org.netbeans.modules.java.source.JavaSourceAccessor;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;
import org.netbeans.spi.java.hints.JavaFixUtilities;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Pair;
import org.openide.xml.XMLUtil;

public class Utilities {
    public static final String JAVA_MIME_TYPE = "text/x-java";
    private static final String DEFAULT_NAME = "name";
    private static final String UNDERSCORE = "_";
    private static final Map<String, String> TYPICAL_KEYWORD_CONVERSIONS = new HashMap<String, String>(){
        {
            this.put("class", "clazz");
            this.put("interface", "intf");
            this.put("new", "nue");
            this.put("static", "statik");
        }
    };
    public static final String TAG_SELECT = "select";
    private static final Map<Tree.Kind, String> operator2DN = new EnumMap<Tree.Kind, String>(Tree.Kind.class);
    private static final EnumSet VARIABLE_KINDS;
    private static final Set<String> PRIMITIVE_NAMES;
    public static final int INSERT_POS_CHILD = 0;
    public static final int INSERT_POS_THEN = 0;
    public static final int INSERT_POS_ELSE = 1;
    public static final int INSERT_POS_UPDATE = 2;
    public static final int INSERT_POS_INIT = 1;
    public static final int INSERT_POS_RESOURCES = 1;

    public static String guessName(CompilationInfo info, TreePath tp) {
        return Utilities.guessName(info, tp, tp);
    }

    public static String guessName(CompilationInfo info, TreePath tp, TreePath scope) {
        return Utilities.guessName(info, tp, scope, null, null);
    }

    public static String guessName(CompilationInfo info, TreePath tp, TreePath scope, String prefix, String suffix) {
        return Utilities.guessName(info, org.netbeans.modules.editor.java.Utilities.varNameSuggestion((Tree)tp.getLeaf()), scope, prefix, suffix, false);
    }

    public static String guessName(CompilationInfo info, String name, TreePath scope, String prefix, String suffix, boolean acceptExistingPrefixes) {
        if (name == null) {
            return DEFAULT_NAME;
        }
        Scope s = info.getTrees().getScope(scope);
        return Utilities.makeNameUnique(info, s, name, Collections.emptySet(), prefix, suffix, acceptExistingPrefixes);
    }

    public static String makeNameUnique(CompilationInfo info, Scope s, String name, String prefix, String suffix) {
        return Utilities.makeNameUnique(info, s, name, Collections.emptySet(), prefix, suffix);
    }

    public static String makeNameUnique(CompilationInfo info, Scope s, String name, Set<String> usedVariables, String prefix, String suffix) {
        return Utilities.makeNameUnique(info, s, name, usedVariables, prefix, suffix, false);
    }

    public static String makeNameUnique(CompilationInfo info, Scope s, String name, Set<String> usedVariables, String prefix, String suffix, boolean acceptExisting) {
        String proposedName;
        boolean cont;
        boolean prefixOK = false;
        boolean suffixOK = false;
        if (acceptExisting) {
            if (prefix != null && !(prefixOK = prefix.isEmpty()) && name.startsWith(prefix)) {
                int pl = prefix.length();
                if (Character.isAlphabetic(prefix.charAt(pl - 1))) {
                    if (name.length() > pl && Character.isUpperCase(name.charAt(pl))) {
                        prefixOK = true;
                    }
                } else {
                    prefixOK = true;
                }
            }
            if (suffix != null && (suffix.isEmpty() || name.endsWith(suffix))) {
                suffixOK = true;
            }
        }
        if (prefixOK && suffixOK) {
            suffix = "";
            prefix = "";
        }
        if (prefix != null && prefix.length() > 0 && Character.isAlphabetic(prefix.charAt(prefix.length() - 1))) {
            StringBuilder nameSb = new StringBuilder(name);
            nameSb.setCharAt(0, Character.toUpperCase(nameSb.charAt(0)));
            name = nameSb.toString();
        }
        int counter = 0;
        block0: do {
            proposedName = Utilities.safeString(prefix) + name + (counter != 0 ? String.valueOf(counter) : "") + Utilities.safeString(suffix);
            cont = false;
            String converted = TYPICAL_KEYWORD_CONVERSIONS.get(proposedName);
            if (converted != null) {
                proposedName = converted;
            }
            if (SourceVersion.isKeyword(proposedName) || usedVariables.contains(proposedName)) {
                ++counter;
                cont = true;
                continue;
            }
            for (Element e : info.getElementUtilities().getLocalMembersAndVars(s, (ElementUtilities.ElementAcceptor)new VariablesFilter())) {
                if (!proposedName.equals(e.getSimpleName().toString())) continue;
                ++counter;
                cont = true;
                continue block0;
            }
        } while (cont);
        return proposedName;
    }

    private static String safeString(String str) {
        return str == null ? "" : str;
    }

    public static String makeNameUnique(CompilationInfo info, Scope s, String name) {
        return Utilities.makeNameUnique(info, s, name, null, null);
    }

    public static String toConstantName(String camelCaseName) {
        StringBuilder result = new StringBuilder();
        char[] chars = camelCaseName.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (Character.isUpperCase(c) && i > 0) {
                if (Character.isLowerCase(chars[i - 1])) {
                    result.append('_');
                } else if (i + 1 < chars.length && Character.isLowerCase(chars[i + 1])) {
                    result.append('_');
                }
            }
            result.append(Character.toUpperCase(c));
        }
        return result.toString();
    }

    public static boolean isEnhancedForLoopIdentifier(TreePath tp) {
        if (tp == null || tp.getLeaf().getKind() != Tree.Kind.IDENTIFIER) {
            return false;
        }
        TreePath parent = tp.getParentPath();
        if (parent == null || parent.getLeaf().getKind() != Tree.Kind.VARIABLE) {
            return false;
        }
        TreePath context = parent.getParentPath();
        return context != null && context.getLeaf().getKind() == Tree.Kind.ENHANCED_FOR_LOOP;
    }

    public static TypeMirror getIterableGenericType(CompilationInfo info, TreePath iterable) {
        TypeElement iterableElement = info.getElements().getTypeElement("java.lang.Iterable");
        if (iterableElement == null) {
            return null;
        }
        TypeMirror iterableType = info.getTrees().getTypeMirror(iterable);
        if (iterableType == null) {
            return null;
        }
        TypeMirror designedType = null;
        if (iterableType.getKind() == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)iterableType;
            if (!info.getTypes().isSubtype(info.getTypes().erasure(declaredType), info.getTypes().erasure(iterableElement.asType()))) {
                return null;
            }
            ExecutableElement iteratorMethod = (ExecutableElement)iterableElement.getEnclosedElements().get(0);
            ExecutableType iteratorMethodType = (ExecutableType)info.getTypes().asMemberOf(declaredType, iteratorMethod);
            List<? extends TypeMirror> typeArguments = ((DeclaredType)iteratorMethodType.getReturnType()).getTypeArguments();
            if (!typeArguments.isEmpty()) {
                designedType = typeArguments.get(0);
            } else {
                TypeElement jlObject = info.getElements().getTypeElement("java.lang.Object");
                if (jlObject != null) {
                    designedType = jlObject.asType();
                }
            }
        } else if (iterableType.getKind() == TypeKind.ARRAY) {
            designedType = ((ArrayType)iterableType).getComponentType();
        }
        if (designedType == null) {
            return null;
        }
        return Utilities.resolveTypeForDeclaration(info, designedType);
    }

    public static String getName(TypeMirror tm) {
        if (tm.getKind().isPrimitive()) {
            return "" + Character.toLowerCase(tm.getKind().name().charAt(0));
        }
        switch (tm.getKind()) {
            case DECLARED: {
                DeclaredType dt = (DeclaredType)tm;
                return Utilities.firstToLower(dt.asElement().getSimpleName().toString());
            }
            case ARRAY: {
                return Utilities.getName(((ArrayType)tm).getComponentType());
            }
        }
        return DEFAULT_NAME;
    }

    private static String firstToLower(String name) {
        if (name.length() == 0) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        boolean toLower = true;
        char last = Character.toLowerCase(name.charAt(0));
        for (int i = 1; i < name.length(); ++i) {
            if (toLower && (Character.isUpperCase(name.charAt(i)) || name.charAt(i) == '_')) {
                result.append(Character.toLowerCase(last));
            } else {
                result.append(last);
                toLower = false;
            }
            last = name.charAt(i);
        }
        result.append(toLower ? Character.toLowerCase(last) : last);
        if (SourceVersion.isKeyword(result)) {
            return "a" + name;
        }
        return result.toString();
    }

    public static ChangeInfo commitAndComputeChangeInfo(FileObject target, ModificationResult diff) throws IOException {
        return Utilities.commitAndComputeChangeInfo(target, diff, TAG_SELECT);
    }

    public static ChangeInfo commitAndComputeChangeInfo(FileObject target, ModificationResult diff, Object tag) throws IOException {
        if (!target.canWrite()) {
            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)NbBundle.getMessage(Utilities.class, (String)"ERR_ReadOnlyTargetFile", (Object)FileUtil.getFileDisplayName((FileObject)target)), 2);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)nd);
            return null;
        }
        diff.commit();
        return Utilities.computeChangeInfo(target, diff, tag);
    }

    public static ChangeInfo computeChangeInfo(FileObject target, final ModificationResult diff, final Object tag) {
        ChangeInfo result;
        block4: {
            List differences = diff.getDifferences(target);
            result = null;
            try {
                if (differences == null) break block4;
                for (ModificationResult.Difference d : differences) {
                    if (d.getNewText() == null) continue;
                    final Position start = d.getStartPosition();
                    Document doc = d.openDocument();
                    final Position[] pos = new Position[2];
                    final Document fdoc = doc;
                    doc.render(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                if (tag != null) {
                                    int[] span = diff.getSpan(tag);
                                    if (span != null) {
                                        pos[0] = fdoc.createPosition(span[0]);
                                        pos[1] = fdoc.createPosition(span[1]);
                                    }
                                } else {
                                    pos[0] = NbDocument.createPosition((Document)fdoc, (int)start.getOffset(), (Position.Bias)Position.Bias.Backward);
                                    pos[1] = pos[0];
                                }
                            }
                            catch (BadLocationException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                    });
                    if (pos[0] != null) {
                        result = new ChangeInfo(target, pos[0], pos[1]);
                    }
                    break;
                }
            }
            catch (IOException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
        return result;
    }

    public static boolean isMethodHeaderInsideGuardedBlock(CompilationInfo info, MethodTree method) {
        try {
            Document doc = info.getDocument();
            if (doc instanceof GuardedDocument) {
                GuardedDocument bdoc = (GuardedDocument)doc;
                int methodStart = (int)info.getTrees().getSourcePositions().getStartPosition(info.getCompilationUnit(), method);
                int methodEnd = (int)info.getTrees().getSourcePositions().getEndPosition(info.getCompilationUnit(), method);
                return (bdoc.getGuardedBlockChain().compareBlock(methodStart, methodEnd) & 1) != 0;
            }
            return false;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return false;
        }
    }

    public static TypeMirror resolveTypeForDeclaration(CompilationInfo info, TypeMirror tm) {
        TypeMirror captureResolved = Utilities.resolveCapturedType(info, tm);
        if (captureResolved == null) {
            return null;
        }
        TypeMirror m = info.getTypeUtilities().getDenotableType(tm);
        if (Utilities.isValidType(m) || !Utilities.isValidType(captureResolved)) {
            return m;
        }
        return captureResolved;
    }

    public static TypeMirror resolveCapturedType(CompilationInfo info, TypeMirror tm) {
        TypeMirror type;
        if (tm == null) {
            return tm;
        }
        if (tm.getKind() == TypeKind.ERROR) {
            tm = info.getTrees().getOriginalType((ErrorType)tm);
        }
        if ((type = Utilities.resolveCapturedTypeInt(info, tm)) == null) {
            return tm;
        }
        if (type.getKind() == TypeKind.WILDCARD) {
            TypeMirror tmirr = ((WildcardType)type).getExtendsBound();
            if (tmirr != null) {
                return tmirr;
            }
            TypeElement te = info.getElements().getTypeElement("java.lang.Object");
            return te == null ? null : te.asType();
        }
        return type;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static TypeMirror resolveCapturedTypeInt(CompilationInfo info, TypeMirror tm) {
        if (tm == null) {
            return tm;
        }
        WildcardType orig = SourceUtils.resolveCapturedType((TypeMirror)tm);
        if (orig != null) {
            tm = orig;
        }
        if (tm.getKind() == TypeKind.WILDCARD) {
            TypeMirror extendsBound = ((WildcardType)tm).getExtendsBound();
            TypeMirror superBound = ((WildcardType)tm).getSuperBound();
            if (extendsBound != null || superBound != null) {
                TypeMirror rct = Utilities.resolveCapturedTypeInt(info, extendsBound != null ? extendsBound : superBound);
                if (rct == null) return null;
                switch (rct.getKind()) {
                    case WILDCARD: {
                        return rct;
                    }
                    case DECLARED: 
                    case ARRAY: 
                    case ERROR: 
                    case TYPEVAR: 
                    case OTHER: {
                        return info.getTypes().getWildcardType((TypeMirror)(extendsBound != null ? rct : null), (TypeMirror)(superBound != null ? rct : null));
                    }
                }
            }
        } else if (tm.getKind() == TypeKind.INTERSECTION) {
            return null;
        }
        if (tm.getKind() == TypeKind.DECLARED) {
            TypeMirror enclosingType;
            DeclaredType dt = (DeclaredType)tm;
            LinkedList<TypeMirror> typeArguments = new LinkedList<TypeMirror>();
            for (TypeMirror typeMirror : dt.getTypeArguments()) {
                TypeMirror targ = Utilities.resolveCapturedTypeInt(info, typeMirror);
                if (targ == null) {
                    if (typeMirror.getKind() == TypeKind.WILDCARD || typeMirror.getKind() == TypeKind.INTERSECTION) {
                        return null;
                    }
                    typeArguments.clear();
                    break;
                }
                typeArguments.add(targ);
            }
            if ((enclosingType = dt.getEnclosingType()).getKind() == TypeKind.DECLARED) {
                return info.getTypes().getDeclaredType((DeclaredType)enclosingType, (TypeElement)dt.asElement(), typeArguments.toArray(new TypeMirror[0]));
            }
            if (dt.asElement() != null) return info.getTypes().getDeclaredType((TypeElement)dt.asElement(), typeArguments.toArray(new TypeMirror[0]));
            return dt;
        }
        if (tm.getKind() != TypeKind.ARRAY) return tm;
        ArrayType at = (ArrayType)tm;
        TypeMirror tm2 = Utilities.resolveCapturedTypeInt(info, at.getComponentType());
        return info.getTypes().getArrayType(tm2 != null ? tm2 : tm);
    }

    public static <T extends Tree> T copyComments(WorkingCopy wc, Tree from, T to) {
        Utilities.copyComments(wc, from, to, true);
        Utilities.copyComments(wc, from, to, false);
        return to;
    }

    public static <T extends Tree> T copyComments(WorkingCopy wc, Tree from, T to, boolean preceding) {
        GeneratorUtilities.get((WorkingCopy)wc).copyComments(from, to, preceding);
        return to;
    }

    public static TypeMirror convertIfAnonymous(TypeMirror tm) {
        Element el;
        EnumSet<ElementKind> fm = EnumSet.of(ElementKind.METHOD, ElementKind.FIELD);
        if (tm instanceof DeclaredType && (el = ((DeclaredType)tm).asElement()) != null && (el.getSimpleName().length() == 0 || fm.contains((Object)el.getEnclosingElement().getKind()))) {
            List<? extends TypeMirror> interfaces = ((TypeElement)el).getInterfaces();
            tm = interfaces.isEmpty() ? ((TypeElement)el).getSuperclass() : interfaces.get(0);
        }
        return tm;
    }

    public static List<List<TreePath>> splitStringConcatenationToElements(CompilationInfo info, TreePath tree) {
        return Utilities.sortOut(info, Utilities.linearize(tree));
    }

    private static List<TreePath> linearize(TreePath tree) {
        LinkedList<TreePath> todo = new LinkedList<TreePath>();
        LinkedList<TreePath> result = new LinkedList<TreePath>();
        todo.add(tree);
        while (!todo.isEmpty()) {
            TreePath tp = (TreePath)todo.remove(0);
            Tree l = tp.getLeaf();
            while (l.getKind() == Tree.Kind.PARENTHESIZED) {
                tp = new TreePath(tp, ((ParenthesizedTree)l).getExpression());
                l = tp.getLeaf();
            }
            if (l.getKind() != Tree.Kind.PLUS) {
                result.add(tp);
                continue;
            }
            BinaryTree bt = (BinaryTree)tp.getLeaf();
            todo.add(0, new TreePath(tp, bt.getRightOperand()));
            todo.add(0, new TreePath(tp, bt.getLeftOperand()));
        }
        return result;
    }

    private static List<List<TreePath>> sortOut(CompilationInfo info, List<TreePath> trees) {
        LinkedList<List<TreePath>> result = new LinkedList<List<TreePath>>();
        LinkedList<TreePath> currentCluster = new LinkedList<TreePath>();
        for (TreePath t : trees) {
            if (Utilities.isConstantString(info, t, true)) {
                currentCluster.add(t);
                continue;
            }
            if (!currentCluster.isEmpty()) {
                result.add(currentCluster);
                currentCluster = new LinkedList();
            }
            result.add(new LinkedList<TreePath>(Collections.singletonList(t)));
        }
        if (!currentCluster.isEmpty()) {
            result.add(currentCluster);
        }
        return result;
    }

    public static boolean isConstantString(CompilationInfo info, TreePath tp) {
        return Utilities.isConstantString(info, tp, false);
    }

    public static boolean isConstantString(CompilationInfo info, TreePath tp, boolean acceptsChars) {
        if (tp.getLeaf().getKind() == Tree.Kind.STRING_LITERAL) {
            return true;
        }
        if (acceptsChars && tp.getLeaf().getKind() == Tree.Kind.CHAR_LITERAL) {
            return true;
        }
        Element el = info.getTrees().getElement(tp);
        if (el != null && (el.getKind() == ElementKind.FIELD || el.getKind() == ElementKind.LOCAL_VARIABLE) && ((VariableElement)el).getConstantValue() instanceof String) {
            return true;
        }
        if (tp.getLeaf().getKind() != Tree.Kind.PLUS) {
            return false;
        }
        List<List<TreePath>> sorted = Utilities.splitStringConcatenationToElements(info, tp);
        if (sorted.size() != 1) {
            return false;
        }
        List<TreePath> part = sorted.get(0);
        for (TreePath c : part) {
            if (!Utilities.isConstantString(info, c, acceptsChars)) continue;
            return true;
        }
        return false;
    }

    public static boolean isStringOrCharLiteral(Tree t) {
        return t != null && (t.getKind() == Tree.Kind.STRING_LITERAL || t.getKind() == Tree.Kind.CHAR_LITERAL);
    }

    @NonNull
    public static Collection<? extends TreePath> resolveFieldGroup(@NonNull CompilationInfo info, @NonNull TreePath variable) {
        Collection<Tree> children;
        Tree leaf = variable.getLeaf();
        if (leaf.getKind() != Tree.Kind.VARIABLE) {
            return Collections.singleton(variable);
        }
        TreePath parentPath = variable.getParentPath();
        switch (parentPath.getLeaf().getKind()) {
            case BLOCK: {
                children = ((BlockTree)parentPath.getLeaf()).getStatements();
                break;
            }
            case ANNOTATION_TYPE: 
            case CLASS: 
            case ENUM: 
            case INTERFACE: {
                children = ((ClassTree)parentPath.getLeaf()).getMembers();
                break;
            }
            case CASE: {
                children = ((CaseTree)parentPath.getLeaf()).getStatements();
                break;
            }
            default: {
                children = Collections.singleton(leaf);
            }
        }
        LinkedList<TreePath> result = new LinkedList<TreePath>();
        ModifiersTree currentModifiers = ((VariableTree)leaf).getModifiers();
        for (Tree c : children) {
            if (c.getKind() != Tree.Kind.VARIABLE || ((VariableTree)c).getModifiers() != currentModifiers) continue;
            result.add(new TreePath(parentPath, c));
        }
        return result;
    }

    public static String shortDisplayName(CompilationInfo info, ExpressionTree expression) {
        return (String)new HintDisplayNameVisitor(info).scan(expression, null);
    }

    public static TreePath findOwningExecutable(HintContext ctx, TreePath from, boolean lambdaOrInitializer) {
        return Utilities.findOwningExecutable(from, lambdaOrInitializer);
    }

    public static TreePath findOwningExecutable(TreePath from, boolean lambdaOrInitializer) {
        Tree.Kind k = null;
        block5: while (from != null && !TreeUtilities.CLASS_TREE_KINDS.contains((Object)(k = from.getLeaf().getKind()))) {
            switch (k) {
                case METHOD: {
                    break block5;
                }
                case LAMBDA_EXPRESSION: {
                    return lambdaOrInitializer ? from : null;
                }
                case BLOCK: {
                    TreePath par = from.getParentPath();
                    Tree l = par.getLeaf();
                    if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)l.getKind())) {
                        return lambdaOrInitializer ? from : null;
                    }
                }
                default: {
                    from = from.getParentPath();
                    continue block5;
                }
            }
        }
        return from == null || k != Tree.Kind.METHOD ? null : from;
    }

    public static TreePath findTopLevelBlock(TreePath from) {
        if (from.getLeaf().getKind() == Tree.Kind.COMPILATION_UNIT) {
            return null;
        }
        TreePath save = null;
        while (from != null) {
            Tree.Kind k = from.getParentPath().getLeaf().getKind();
            if (k == Tree.Kind.METHOD || k == Tree.Kind.LAMBDA_EXPRESSION) {
                return from;
            }
            if (k == Tree.Kind.VARIABLE) {
                save = from;
            } else {
                if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)k)) {
                    if (save != null) {
                        return save;
                    }
                    if (from.getLeaf().getKind() == Tree.Kind.BLOCK) {
                        return from;
                    }
                    return null;
                }
                save = null;
            }
            from = from.getParentPath();
        }
        return null;
    }

    public static boolean isInConstructor(TreePath path) {
        TreePath method = Utilities.findOwningExecutable(path, false);
        if (method == null || method.getLeaf().getKind() != Tree.Kind.METHOD) {
            return false;
        }
        return ((MethodTree)method.getLeaf()).getName().contentEquals("<init>");
    }

    public static boolean isInConstructor(HintContext ctx) {
        TreePath method = Utilities.findOwningExecutable(ctx, ctx.getPath(), false);
        if (method == null) {
            return false;
        }
        Element enclosingMethodElement = ctx.getInfo().getTrees().getElement(method);
        return enclosingMethodElement != null && enclosingMethodElement.getKind() == ElementKind.CONSTRUCTOR;
    }

    public static boolean isReferencedIn(CompilationInfo info, TreePath variable, Iterable<? extends TreePath> in) {
        final Trees trees = info.getTrees();
        final Element e = trees.getElement(variable);
        if (e == null) {
            return false;
        }
        for (TreePath treePath : in) {
            if (e.equals(trees.getElement(treePath))) {
                return true;
            }
            boolean occurs = new ErrorAwareTreePathScanner<Boolean, Void>(){
                private boolean found = false;

                public Boolean scan(Tree tree, Void p) {
                    if (this.found) {
                        return true;
                    }
                    if (tree == null) {
                        return false;
                    }
                    TreePath currentPath = new TreePath(this.getCurrentPath(), tree);
                    Element currentElement = trees.getElement(currentPath);
                    if (e.equals(currentElement)) {
                        this.found = true;
                        return true;
                    }
                    return (Boolean)super.scan(tree, (Object)p);
                }

                public Boolean reduce(Boolean r1, Boolean r2) {
                    if (r1 == null) {
                        return r2;
                    }
                    if (r2 == null) {
                        return r1;
                    }
                    return r1 != false || r2 != false;
                }
            }.scan(treePath, null) == Boolean.TRUE;
            if (!occurs) continue;
            return true;
        }
        return false;
    }

    public static Pair<List<? extends TypeMirror>, List<String>> resolveArguments(CompilationInfo info, TreePath invocation, List<? extends ExpressionTree> realArguments, Element target) {
        MethodArguments ma = Utilities.resolveArguments(info, invocation, realArguments, target, null);
        if (ma == null) {
            return null;
        }
        return Pair.of(ma.parameterTypes, ma.parameterNames);
    }

    /*
     * WARNING - void declaration
     */
    public static MethodArguments resolveArguments(CompilationInfo info, TreePath invocation, List<? extends ExpressionTree> realArguments, Element target, TypeMirror returnType) {
        Element el;
        TreePath enclosingMethod;
        LinkedList<void> argumentTypes = new LinkedList<void>();
        LinkedList<String> argumentNames = new LinkedList<String>();
        ArrayList<Element> usedLocalTypeVariables = new ArrayList<Element>();
        HashSet<String> usedArgumentNames = new HashSet<String>();
        for (enclosingMethod = invocation; enclosingMethod != null && !TreeUtilities.CLASS_TREE_KINDS.contains((Object)enclosingMethod.getLeaf().getKind()) && enclosingMethod.getLeaf().getKind() != Tree.Kind.METHOD; enclosingMethod = enclosingMethod.getParentPath()) {
        }
        ExecutableElement method = null;
        if (enclosingMethod != null && enclosingMethod.getLeaf().getKind() == Tree.Kind.METHOD && (el = info.getTrees().getElement(enclosingMethod)) != null && (el.getKind() == ElementKind.METHOD || el.getKind() == ElementKind.CONSTRUCTOR)) {
            method = (ExecutableElement)el;
        }
        if (returnType != null) {
            if (!Utilities.verifyTypeVarAccessible(method, returnType, usedLocalTypeVariables, target)) {
                return null;
            }
        } else {
            method = null;
        }
        CodeStyle codeStyle = CodeStyle.getDefault((FileObject)info.getFileObject());
        for (ExpressionTree expressionTree : realArguments) {
            String augmentedName;
            void var15_16;
            TypeMirror typeMirror;
            TreePath argPath = new TreePath(invocation, expressionTree);
            TypeMirror typeMirror3 = info.getTrees().getTypeMirror(argPath);
            typeMirror3 = Utilities.convertIfAnonymous(typeMirror3);
            if (typeMirror3 == null || typeMirror3.getKind() == TypeKind.NONE || Utilities.containsErrorsRecursively(typeMirror3)) {
                return null;
            }
            TypeMirror typeMirror4 = Utilities.resolveTypeForDeclaration(info, typeMirror3);
            if (!Utilities.verifyTypeVarAccessible(method, typeMirror4, usedLocalTypeVariables, target)) {
                return null;
            }
            if (typeMirror4.getKind() == TypeKind.NULL && (typeMirror = info.getElements().getTypeElement("java.lang.Object").asType()) == null) {
                return null;
            }
            argumentTypes.add(var15_16);
            String proposedName = null;
            Element elem = info.getTrees().getElement(argPath);
            if (elem != null && elem.getKind() == ElementKind.ENUM_CONSTANT) {
                proposedName = Utilities.firstToLower(elem.getEnclosingElement().getSimpleName().toString());
            }
            if (proposedName == null) {
                proposedName = org.netbeans.modules.editor.java.Utilities.varNameSuggestion((Tree)expressionTree);
            }
            if (proposedName == null) {
                proposedName = Utilities.getName((TypeMirror)var15_16);
            }
            if (proposedName == null) {
                proposedName = "arg";
            }
            if (usedArgumentNames.contains(augmentedName = CodeStyleUtils.addPrefixSuffix((CharSequence)proposedName, (String)codeStyle.getParameterNamePrefix(), (String)codeStyle.getParameterNameSuffix()))) {
                int num = 0;
                while (usedArgumentNames.contains(augmentedName = CodeStyleUtils.addPrefixSuffix((CharSequence)(proposedName + num), (String)codeStyle.getParameterNamePrefix(), (String)codeStyle.getParameterNameSuffix()))) {
                    ++num;
                }
            }
            argumentNames.add(augmentedName);
            usedArgumentNames.add(augmentedName);
        }
        LinkedList<TypeMirror> typeParamTypes = new LinkedList<TypeMirror>();
        LinkedList<String> linkedList = new LinkedList<String>();
        if (method != null) {
            for (TypeParameterElement typeParameterElement : method.getTypeParameters()) {
                if (!usedLocalTypeVariables.contains(typeParameterElement)) continue;
                typeParamTypes.add(typeParameterElement.asType());
                linkedList.add(typeParameterElement.getSimpleName().toString());
            }
        }
        return new MethodArguments(argumentTypes, argumentNames, typeParamTypes, linkedList);
    }

    private static boolean verifyTypeVarAccessible(ExecutableElement method, TypeMirror forType, List<Element> usedLocalTypeVariables, Element target) {
        Collection<TypeVariable> typeVars = Utilities.containedTypevarsRecursively(forType);
        if (method != null) {
            Iterator<TypeVariable> it = typeVars.iterator();
            while (it.hasNext()) {
                TypeVariable tvar = it.next();
                Element tvarEl = tvar.asElement();
                if (!method.getTypeParameters().contains(tvarEl)) continue;
                usedLocalTypeVariables.add(tvarEl);
                it.remove();
            }
        }
        return Utilities.allTypeVarsAccessible(typeVars, target);
    }

    public static boolean containsErrorsRecursively(TypeMirror tm) {
        switch (tm.getKind()) {
            case ERROR: {
                return true;
            }
            case DECLARED: {
                DeclaredType type = (DeclaredType)tm;
                for (TypeMirror typeMirror : type.getTypeArguments()) {
                    if (!Utilities.containsErrorsRecursively(typeMirror)) continue;
                    return true;
                }
                return false;
            }
            case ARRAY: {
                return Utilities.containsErrorsRecursively(((ArrayType)tm).getComponentType());
            }
            case WILDCARD: {
                if (((WildcardType)tm).getExtendsBound() != null && Utilities.containsErrorsRecursively(((WildcardType)tm).getExtendsBound())) {
                    return true;
                }
                return ((WildcardType)tm).getSuperBound() != null && Utilities.containsErrorsRecursively(((WildcardType)tm).getSuperBound());
            }
            case OTHER: {
                return true;
            }
        }
        return false;
    }

    public static boolean exitsFromAllBranchers(CompilationInfo info, TreePath from) {
        ExitsFromAllBranches efab = new ExitsFromAllBranches(info);
        return efab.scan(from, null) == Boolean.TRUE;
    }

    @NonNull
    public static Collection<TypeVariable> containedTypevarsRecursively(@NullAllowed TypeMirror tm) {
        if (tm == null) {
            return Collections.emptyList();
        }
        LinkedList<TypeVariable> typeVars = new LinkedList<TypeVariable>();
        Utilities.containedTypevarsRecursively(tm, typeVars);
        return typeVars;
    }

    private static void containedTypevarsRecursively(@NonNull TypeMirror tm, @NonNull Collection<TypeVariable> typeVars) {
        switch (tm.getKind()) {
            case TYPEVAR: {
                typeVars.add((TypeVariable)tm);
                break;
            }
            case DECLARED: {
                DeclaredType type = (DeclaredType)tm;
                for (TypeMirror typeMirror : type.getTypeArguments()) {
                    Utilities.containedTypevarsRecursively(typeMirror, typeVars);
                }
                break;
            }
            case ARRAY: {
                Utilities.containedTypevarsRecursively(((ArrayType)tm).getComponentType(), typeVars);
                break;
            }
            case WILDCARD: {
                if (((WildcardType)tm).getExtendsBound() != null) {
                    Utilities.containedTypevarsRecursively(((WildcardType)tm).getExtendsBound(), typeVars);
                }
                if (((WildcardType)tm).getSuperBound() == null) break;
                Utilities.containedTypevarsRecursively(((WildcardType)tm).getSuperBound(), typeVars);
            }
        }
    }

    public static boolean allTypeVarsAccessible(Collection<TypeVariable> typeVars, Element target) {
        if (target == null) {
            return typeVars.isEmpty();
        }
        HashSet<TypeVariable> targetTypeVars = new HashSet<TypeVariable>();
        block4: while (target.getKind() != ElementKind.PACKAGE) {
            List<? extends TypeParameterElement> tpes;
            switch (target.getKind()) {
                case ANNOTATION_TYPE: 
                case CLASS: 
                case ENUM: 
                case INTERFACE: 
                case RECORD: {
                    tpes = ((TypeElement)target).getTypeParameters();
                    break;
                }
                case METHOD: 
                case CONSTRUCTOR: {
                    tpes = ((ExecutableElement)target).getTypeParameters();
                    break;
                }
                default: {
                    break block4;
                }
            }
            for (TypeParameterElement typeParameterElement : tpes) {
                targetTypeVars.add((TypeVariable)typeParameterElement.asType());
            }
            if (target.getModifiers().contains((Object)Modifier.STATIC)) break;
            target = target.getEnclosingElement();
        }
        return targetTypeVars.containsAll(typeVars);
    }

    public static String target2String(TypeElement target) {
        Name qualifiedName = target.getQualifiedName();
        if (qualifiedName == null) {
            Logger.getLogger(Utilities.class.getName()).warning("Target qualified name could not be resolved.");
            return "";
        }
        String qnString = qualifiedName.toString();
        if (qnString.length() == 0) {
            qnString = target.asType().toString();
        }
        try {
            qnString = XMLUtil.toElementContent((String)qnString);
        }
        catch (CharConversionException ex) {
            Logger.getLogger(Utilities.class.getName()).log(Level.FINE, null, ex);
        }
        return qnString;
    }

    public static Visibility effectiveVisibility(TreePath tp) {
        Visibility result = null;
        while (tp != null) {
            Visibility current = Visibility.forTree(tp.getLeaf());
            if (current != null) {
                result = result != null ? result.enclosedBy(current) : current;
            }
            tp = tp.getParentPath();
        }
        return result;
    }

    public static boolean isValidElement(Element e) {
        return e != null && Utilities.isValidType(e.asType());
    }

    public static boolean isValidValueType(TypeMirror m) {
        return Utilities.isValidType(m) && m.getKind() != TypeKind.EXECUTABLE;
    }

    public static boolean isValidType(TypeMirror m) {
        return m != null && m.getKind() != TypeKind.PACKAGE && m.getKind() != TypeKind.OTHER && m.getKind() != TypeKind.ERROR;
    }

    public static boolean isTargetWritable(@NonNull TypeElement target, @NonNull CompilationInfo info) {
        TypeElement outermostType = info.getElementUtilities().outermostTypeElement((Element)target);
        FileObject fo = SourceUtils.getFile((ElementHandle)ElementHandle.create((Element)outermostType), (ClasspathInfo)info.getClasspathInfo());
        return fo != null && fo.canWrite();
    }

    public static Visibility getAccessModifiers(@NonNull CompilationInfo info, @NullAllowed TypeElement source, @NonNull TypeElement target) {
        if (target.getKind().isInterface()) {
            return Visibility.PUBLIC;
        }
        TypeElement outterMostSource = source != null ? info.getElementUtilities().outermostTypeElement((Element)source) : null;
        TypeElement outterMostTarget = info.getElementUtilities().outermostTypeElement((Element)target);
        if (outterMostTarget.equals(outterMostSource)) {
            return Visibility.PRIVATE;
        }
        Element sourcePackage = outterMostSource != null ? outterMostSource.getEnclosingElement() : (info.getCompilationUnit().getPackageName() != null ? info.getTrees().getElement(new TreePath(new TreePath(info.getCompilationUnit()), info.getCompilationUnit().getPackage())) : info.getElements().getPackageElement(""));
        Element targetPackage = outterMostTarget.getEnclosingElement();
        if (sourcePackage != null && sourcePackage.equals(targetPackage)) {
            return Visibility.PACKAGE_PRIVATE;
        }
        return Visibility.PUBLIC;
    }

    public static boolean isSymbolUsed(CompilationInfo info, TreePath target, CharSequence variableName, Scope localScope) {
        SourcePositions[] pos = new SourcePositions[1];
        ExpressionTree t = info.getTreeUtilities().parseExpression(variableName.toString(), pos);
        TypeMirror tm = info.getTreeUtilities().attributeTree((Tree)t, localScope);
        Element el = info.getTrees().getElement(new TreePath(target, t));
        if (el == null) {
            return false;
        }
        ElementKind k = el.getKind();
        return VARIABLE_KINDS.contains((Object)k);
    }

    public static boolean isSystemExit(CompilationInfo info, Element e) {
        if (e == null || e.getKind() != ElementKind.METHOD) {
            return false;
        }
        ExecutableElement ee = (ExecutableElement)e;
        Name n = ee.getSimpleName();
        if (n.contentEquals("exit") || n.contentEquals("halt")) {
            TypeElement tel = info.getElementUtilities().enclosingTypeElement(e);
            if (tel == null) {
                return false;
            }
            Name ofqn = tel.getQualifiedName();
            if (ofqn.contentEquals("java.lang.System") || ofqn.contentEquals("java.lang.Runtime")) {
                return true;
            }
        }
        return false;
    }

    public static List<? extends TypeMirror> getUnionExceptions(CompilationInfo info, TreePath cP, CatchTree ct) {
        if (ct.getParameter() == null) {
            return Collections.emptyList();
        }
        TypeMirror exT = info.getTrees().getTypeMirror(new TreePath(cP, ct.getParameter()));
        return Utilities.getCaughtExceptions(exT);
    }

    private static List<? extends TypeMirror> getCaughtExceptions(TypeMirror caught) {
        if (caught == null) {
            return Collections.emptyList();
        }
        switch (caught.getKind()) {
            case UNION: {
                boolean cloned = false;
                List<? extends TypeMirror> types = ((UnionType)caught).getAlternatives();
                for (int i = types.size() - 1; i >= 0; --i) {
                    TypeMirror m = types.get(i);
                    TypeKind mk = m.getKind();
                    if (mk != null && mk == TypeKind.DECLARED) continue;
                    if (!cloned) {
                        types = new ArrayList<TypeMirror>(types);
                    }
                    types.remove(i);
                }
                return types;
            }
            case DECLARED: {
                return Collections.singletonList(caught);
            }
        }
        return Collections.emptyList();
    }

    public static TypeKind getPrimitiveKind(CompilationInfo ci, TypeMirror tm) {
        if (tm == null) {
            return null;
        }
        if (tm.getKind().isPrimitive()) {
            return tm.getKind();
        }
        if (Utilities.isPrimitiveWrapperType(tm)) {
            return ci.getTypes().unboxedType(tm).getKind();
        }
        return null;
    }

    public static TypeMirror unboxIfNecessary(CompilationInfo ci, TypeMirror tm) {
        if (Utilities.isPrimitiveWrapperType(tm)) {
            return ci.getTypes().unboxedType(tm);
        }
        return tm;
    }

    public static boolean isPrimitiveWrapperType(TypeMirror tm) {
        if (tm == null || tm.getKind() != TypeKind.DECLARED) {
            return false;
        }
        Element el = ((DeclaredType)tm).asElement();
        if (el == null || el.getKind() != ElementKind.CLASS) {
            return false;
        }
        String s = ((TypeElement)el).getQualifiedName().toString();
        return PRIMITIVE_NAMES.contains(s);
    }

    public static boolean checkAlternativeInvocation(CompilationInfo ci, TreePath invPath, TreePath origPath, TreePath valPath, String customPrefix) {
        ExpressionTree sel;
        Tree l = invPath.getLeaf();
        if (l.getKind() == Tree.Kind.NEW_CLASS) {
            NewClassTree nct = (NewClassTree)invPath.getLeaf();
            sel = nct.getIdentifier();
        } else if (l.getKind() == Tree.Kind.METHOD_INVOCATION) {
            MethodInvocationTree mit = (MethodInvocationTree)invPath.getLeaf();
            sel = mit.getMethodSelect();
        } else {
            return false;
        }
        return Utilities.resolveAlternativeInvocation(ci, invPath, origPath, sel, valPath, customPrefix);
    }

    private static Tree getInvocationIdentifier(Tree inv) {
        if (inv.getKind() == Tree.Kind.METHOD_INVOCATION) {
            return ((MethodInvocationTree)inv).getMethodSelect();
        }
        if (inv.getKind() == Tree.Kind.NEW_CLASS) {
            return ((NewClassTree)inv).getIdentifier();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TypeMirror attributeTree(JavacTaskImpl jti, Tree tree, Scope scope, final List<Diagnostic<? extends JavaFileObject>> errors, final @NullAllowed Diagnostic.Kind filter) {
        Log log = Log.instance(jti.getContext());
        JavaFileObject prev = log.useSource(new DummyJFO());
        Enter enter = Enter.instance(jti.getContext());
        Log.DiscardDiagnosticHandler discardHandler = new Log.DiscardDiagnosticHandler(log){
            private Diagnostic.Kind f;
            {
                super(log);
                this.f = filter == null ? Diagnostic.Kind.ERROR : filter;
            }

            @Override
            public void report(JCDiagnostic diag) {
                if (diag.getKind().compareTo(this.f) >= 0) {
                    errors.add(diag);
                }
            }
        };
        try {
            Attr attr = Attr.instance(jti.getContext());
            Env<AttrContext> env = ((JavacScope)scope).getEnv();
            if (tree instanceof JCTree.JCExpression) {
                Type type = attr.attribExpr((JCTree)tree, env, Type.noType);
                return type;
            }
            Type type = attr.attribStat((JCTree)tree, env);
            return type;
        }
        finally {
            log.useSource(prev);
            log.popDiagnosticHandler(discardHandler);
        }
    }

    private static boolean resolveAlternativeInvocation(CompilationInfo ci, TreePath invPath, TreePath origPath, Tree sel, TreePath valPath, String customPrefix) {
        TreePath newInvPath;
        Tree t;
        TreePath stPath;
        CharSequence source = ci.getSnapshot().getText();
        Element e = ci.getTrees().getElement(invPath);
        if (!(e instanceof ExecutableElement)) {
            return false;
        }
        SourcePositions sp = ci.getTrees().getSourcePositions();
        int invOffset = (int)sp.getEndPosition(ci.getCompilationUnit(), sel) - 1;
        int origExpStart = (int)sp.getStartPosition(ci.getCompilationUnit(), origPath.getLeaf());
        int origExpEnd = (int)sp.getEndPosition(ci.getCompilationUnit(), origPath.getLeaf());
        if (invOffset < 0 || origExpStart < 0 || origExpEnd < 0) {
            return false;
        }
        TreePath exp = invPath;
        boolean statement = false;
        do {
            boolean breakPrev = false;
            TreePath previousPath = exp;
            Tree previous = exp.getLeaf();
            Tree t2 = (exp = exp.getParentPath()).getLeaf();
            Class<? extends Tree> c = t2.getKind().asInterface();
            if (c == CompoundAssignmentTree.class || c == AssignmentTree.class) break;
            switch (t2.getKind()) {
                case VARIABLE: {
                    VariableTree vt = (VariableTree)t2;
                    if (vt.getInitializer() != previous) break;
                    breakPrev = true;
                    break;
                }
                case CONDITIONAL_EXPRESSION: {
                    ConditionalExpressionTree ctree = (ConditionalExpressionTree)t2;
                    if (ctree.getCondition() != previous) break;
                    breakPrev = true;
                    break;
                }
                case DO_WHILE_LOOP: {
                    DoWhileLoopTree dlp = (DoWhileLoopTree)t2;
                    if (dlp.getCondition() != previous) break;
                    breakPrev = true;
                    break;
                }
                case FOR_LOOP: {
                    ForLoopTree flp = (ForLoopTree)t2;
                    if (previous != flp.getCondition()) break;
                    breakPrev = true;
                    break;
                }
                case ENHANCED_FOR_LOOP: {
                    EnhancedForLoopTree eflp = (EnhancedForLoopTree)t2;
                    if (previous != eflp.getExpression()) break;
                    breakPrev = true;
                    break;
                }
                case SWITCH: {
                    StatementTree st = (SwitchTree)t2;
                    if (previous != st.getExpression()) break;
                    breakPrev = true;
                    break;
                }
                case SYNCHRONIZED: {
                    StatementTree st = (SynchronizedTree)t2;
                    if (previous != st.getExpression()) break;
                    breakPrev = true;
                    break;
                }
                case WHILE_LOOP: {
                    WhileLoopTree wlt = (WhileLoopTree)t2;
                    if (previous != wlt.getCondition()) break;
                    breakPrev = true;
                    break;
                }
                case IF: {
                    IfTree it = (IfTree)t2;
                    if (previous != it.getCondition()) break;
                    breakPrev = true;
                    break;
                }
            }
            if (breakPrev) {
                exp = previousPath;
                break;
            }
            if (!Utilities.isStatement(t2)) continue;
            statement = true;
            break;
        } while (exp.getParentPath() != null);
        if (!statement) {
            for (stPath = exp; stPath != null && !Utilities.isStatement(stPath.getLeaf()); stPath = stPath.getParentPath()) {
            }
        }
        if (stPath == null) {
            return false;
        }
        int baseIndex = (int)sp.getStartPosition(ci.getCompilationUnit(), exp.getLeaf());
        if (baseIndex < 0) {
            return false;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(source.subSequence(baseIndex, origExpStart));
        sb.append("(");
        if (customPrefix != null) {
            sb.append(customPrefix);
        }
        int valStart = (int)sp.getStartPosition(ci.getCompilationUnit(), valPath.getLeaf());
        int valEnd = (int)sp.getEndPosition(ci.getCompilationUnit(), valPath.getLeaf());
        int expEndPos = (int)sp.getEndPosition(ci.getCompilationUnit(), exp.getLeaf());
        if (valStart < 0 || valEnd < 0 || expEndPos < 0) {
            return false;
        }
        sb.append(source.subSequence(valStart, valEnd)).append(")");
        sb.append(source.subSequence(origExpEnd, expEndPos));
        SourcePositions[] nsp = new SourcePositions[1];
        if (statement) {
            sb.append(";");
            t = ci.getTreeUtilities().parseStatement(sb.toString(), nsp);
        } else {
            t = ci.getTreeUtilities().parseExpression(sb.toString(), nsp);
        }
        Scope s = ci.getTreeUtilities().scopeFor(Math.max(0, expEndPos - 1));
        ArrayList<Diagnostic<? extends JavaFileObject>> diags = new ArrayList<Diagnostic<? extends JavaFileObject>>();
        Utilities.attributeTree(JavaSourceAccessor.getINSTANCE().getJavacTask(ci), t, s, diags, null);
        if (!diags.isEmpty()) {
            return false;
        }
        TreePath newPath = new TreePath(exp.getParentPath(), t);
        for (newInvPath = ci.getTreeUtilities().pathFor(newPath, invOffset - baseIndex + 1, nsp[0]); newInvPath != null && newInvPath.getLeaf().getKind() != Tree.Kind.METHOD_INVOCATION && newInvPath.getLeaf().getKind() != Tree.Kind.NEW_CLASS; newInvPath = newInvPath.getParentPath()) {
        }
        if (newInvPath == null) {
            return false;
        }
        TreePath orig = new TreePath(invPath, Utilities.getInvocationIdentifier(invPath.getLeaf()));
        TreePath alt = new TreePath(newInvPath, Utilities.getInvocationIdentifier(newInvPath.getLeaf()));
        TypeMirror origType = ci.getTrees().getTypeMirror(orig);
        TypeMirror altType = ci.getTrees().getTypeMirror(alt);
        return altType != null && ci.getTypes().isSameType(altType, origType);
    }

    public static boolean isJavaString(CompilationInfo ci, TypeMirror m) {
        if (m == null || m.getKind() != TypeKind.DECLARED) {
            return false;
        }
        Element e = ((DeclaredType)m).asElement();
        return e.getKind() == ElementKind.CLASS && ((TypeElement)e).getQualifiedName().contentEquals("java.lang.String");
    }

    public static String stripVariableName(CodeStyle style, VariableElement el) {
        String n = el.getSimpleName().toString();
        switch (el.getKind()) {
            case PARAMETER: {
                return Utilities.stripVariableName(n, style.getParameterNamePrefix(), style.getParameterNameSuffix());
            }
            case LOCAL_VARIABLE: 
            case RESOURCE_VARIABLE: 
            case EXCEPTION_PARAMETER: {
                return Utilities.stripVariableName(n, style.getLocalVarNamePrefix(), style.getLocalVarNameSuffix());
            }
            case FIELD: 
            case ENUM_CONSTANT: {
                return Utilities.stripVariableName(n, style.getFieldNamePrefix(), style.getFieldNameSuffix());
            }
        }
        return n;
    }

    private static String stripVariableName(String n, String prefix, String suffix) {
        if (!prefix.isEmpty() && n.startsWith(prefix) && n.length() > prefix.length()) {
            n = Character.isLetter(prefix.charAt(prefix.length() - 1)) ? Character.toLowerCase(n.charAt(prefix.length())) + n.substring(prefix.length() + 1) : n.substring(prefix.length());
        }
        if (!suffix.isEmpty() && n.endsWith(suffix) && n.length() > suffix.length()) {
            n = n.substring(0, n.length() - suffix.length());
        }
        return n;
    }

    public static List<TreePath> getStatementPaths(TreePath firstLeaf) {
        switch (firstLeaf.getParentPath().getLeaf().getKind()) {
            case BLOCK: {
                return Utilities.getTreePaths(firstLeaf.getParentPath(), ((BlockTree)firstLeaf.getParentPath().getLeaf()).getStatements());
            }
            case CASE: {
                return Utilities.getTreePaths(firstLeaf.getParentPath(), ((CaseTree)firstLeaf.getParentPath().getLeaf()).getStatements());
            }
        }
        return Collections.singletonList(firstLeaf);
    }

    private static List<TreePath> getTreePaths(TreePath parent, List<? extends Tree> trees) {
        ArrayList<TreePath> ll = new ArrayList<TreePath>(trees.size());
        for (Tree tree : trees) {
            ll.add(new TreePath(parent, tree));
        }
        return ll;
    }

    public static boolean loosesPrecision(TypeMirror from, TypeMirror to) {
        if (!from.getKind().isPrimitive() || !to.getKind().isPrimitive()) {
            return false;
        }
        if (to.getKind() == TypeKind.CHAR) {
            return true;
        }
        if (from.getKind() == TypeKind.CHAR) {
            return to.getKind() == TypeKind.BYTE || to.getKind() == TypeKind.SHORT;
        }
        return to.getKind().ordinal() < from.getKind().ordinal();
    }

    public static Map<? extends ExecutableElement, ? extends ExecutableElement> findConflictingMethods(CompilationInfo info, TypeElement clazz, Iterable<? extends ExecutableElement> methods) {
        return Utilities.findConflictingMethods(info, clazz, false, methods);
    }

    public static Map<? extends ExecutableElement, ? extends ExecutableElement> findConflictingMethods(CompilationInfo info, TypeElement clazz, boolean inherited, Iterable<? extends ExecutableElement> methods) {
        HashMap<Name, ArrayList<ExecutableElement>> currentByName = new HashMap<Name, ArrayList<ExecutableElement>>();
        HashMap<ExecutableElement, ExecutableElement> ret = new HashMap<ExecutableElement, ExecutableElement>();
        Iterable<Element> col = inherited ? info.getElementUtilities().getMembers(clazz.asType(), null) : clazz.getEnclosedElements();
        for (Element element : col) {
            if (element.getKind() != ElementKind.METHOD) continue;
            ExecutableElement ee = (ExecutableElement)element;
            Name n = ee.getSimpleName();
            ArrayList<ExecutableElement> named = (ArrayList<ExecutableElement>)currentByName.get(n);
            if (named == null) {
                named = new ArrayList<ExecutableElement>(3);
                currentByName.put(n, named);
            }
            named.add(ee);
        }
        for (ExecutableElement executableElement : methods) {
            ExecutableType et;
            DeclaredType asMemberOf = (DeclaredType)clazz.asType();
            try {
                et = (ExecutableType)info.getTypes().asMemberOf(asMemberOf, executableElement);
            }
            catch (IllegalArgumentException iae) {
                continue;
            }
            Collection candidates = (Collection)currentByName.get(executableElement.getSimpleName());
            if (candidates == null) continue;
            block4: for (ExecutableElement e : candidates) {
                ExecutableElement ee;
                if (e.getKind() != ElementKind.METHOD || !(ee = e).getSimpleName().equals(executableElement.getSimpleName()) || ee.getParameters().size() != et.getParameterTypes().size()) continue;
                for (int i = 0; i < ee.getParameters().size(); ++i) {
                    TypeMirror t1 = ee.getParameters().get(i).asType();
                    TypeMirror t2 = et.getParameterTypes().get(i);
                    if (!info.getTypes().isSameType(info.getTypes().erasure(t1), info.getTypes().erasure(t2))) continue block4;
                }
                ret.put(executableElement, e);
            }
        }
        return ret;
    }

    private static boolean isSuperCtorInvocation(Tree t) {
        if (t.getKind() == Tree.Kind.EXPRESSION_STATEMENT) {
            t = ((ExpressionStatementTree)t).getExpression();
        }
        if (t.getKind() != Tree.Kind.METHOD_INVOCATION) {
            return false;
        }
        MethodInvocationTree mit = (MethodInvocationTree)t;
        if (mit.getMethodSelect() == null || mit.getMethodSelect().getKind() != Tree.Kind.IDENTIFIER) {
            return false;
        }
        return ((IdentifierTree)mit.getMethodSelect()).getName().contentEquals("super");
    }

    public static Tree insertStatement(WorkingCopy wc, TreePath anchor, List<? extends StatementTree> before, List<? extends StatementTree> after) {
        anchor = Utilities.findStatementOrExpression(anchor);
        return Utilities.insertStatement(wc, anchor.getParentPath(), anchor.getLeaf(), before, after, 0);
    }

    public static Tree insertStatement(WorkingCopy wc, TreePath parentBlock, Tree anchor, List<? extends StatementTree> before, List<? extends StatementTree> after, int position) {
        if (parentBlock == null) {
            throw new IllegalArgumentException("One of parent/anchor must be specified");
        }
        List<Object> list = new ArrayList<StatementTree>();
        Tree parent = wc.resolveRewriteTarget(parentBlock.getLeaf());
        TreePath parentPath = parent == parentBlock ? parentBlock : new TreePath(parentBlock.getParentPath(), parent);
        TreeMaker mk = wc.getTreeMaker();
        Tree child = null;
        List<? extends StatementTree> forInit = null;
        List<? extends ExpressionStatementTree> forUpdate = null;
        boolean superInvocationPresent = false;
        boolean convertExpressionLambda = false;
        block0 : switch (parent.getKind()) {
            case LAMBDA_EXPRESSION: {
                LambdaExpressionTree let = (LambdaExpressionTree)parent;
                child = let.getBody();
                convertExpressionLambda = let.getBodyKind() == LambdaExpressionTree.BodyKind.EXPRESSION;
                break;
            }
            case TRY: {
                child = ((TryTree)parent).getFinallyBlock();
                break;
            }
            case IF: {
                child = position != 1 ? ((IfTree)parent).getThenStatement() : ((IfTree)parent).getElseStatement();
                break;
            }
            case DO_WHILE_LOOP: {
                child = ((DoWhileLoopTree)parent).getStatement();
                break;
            }
            case WHILE_LOOP: {
                child = ((WhileLoopTree)parent).getStatement();
                break;
            }
            case CASE: {
                list.addAll(((CaseTree)parent).getStatements());
                break;
            }
            case FOR_LOOP: {
                forInit = ((ForLoopTree)parent).getInitializer();
                forUpdate = ((ForLoopTree)parent).getUpdate();
                switch (position) {
                    case 1: {
                        list.addAll(forInit);
                        break block0;
                    }
                    case 2: {
                        list.addAll(forUpdate);
                        break block0;
                    }
                }
                child = ((ForLoopTree)parent).getStatement();
                break;
            }
            case ENHANCED_FOR_LOOP: {
                child = ((ForLoopTree)parent).getStatement();
                break;
            }
            case BLOCK: {
                List<? extends StatementTree> stats = Utilities.getRealStatements((CompilationInfo)wc, parentPath);
                if (parentBlock.getParentPath().getLeaf().getKind() == Tree.Kind.METHOD && ((MethodTree)parentBlock.getParentPath().getLeaf()).getName().contentEquals("<init>")) {
                    superInvocationPresent = !stats.isEmpty() && Utilities.isSuperCtorInvocation(stats.get(0));
                }
                list.addAll(stats);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported parent kind: " + (Object)((Object)parentBlock.getLeaf().getKind()));
            }
        }
        Tree result = null;
        if (child == null) {
            int indexAt = 0;
            ArrayList<Object> newList = new ArrayList<Object>(list.size());
            if (anchor != null) {
                indexAt = list.indexOf(anchor);
                if (indexAt == -1) {
                    throw new IllegalArgumentException("Anchor not proper child of its parent");
                }
            } else if (superInvocationPresent && before != null && indexAt == 0 && !Utilities.isSuperCtorInvocation(before.get(0))) {
                indexAt = 1;
            }
            newList.addAll(list.subList(0, indexAt));
            if (before != null) {
                newList.addAll(before);
            }
            if (anchor != null) {
                newList.add((StatementTree)anchor);
            } else {
                newList.addAll(list.subList(indexAt, list.size()));
            }
            if (after != null) {
                newList.addAll(after);
            }
            if (anchor != null) {
                newList.addAll(list.subList(indexAt + 1, list.size()));
            }
            Tree newChild = newList.size() == 1 ? (Tree)newList.get(0) : mk.Block(newList, false);
            block15 : switch (parent.getKind()) {
                case TRY: {
                    switch (position) {
                        case 1: {
                            result = mk.Try(newList, ((TryTree)parent).getBlock(), ((TryTree)parent).getCatches(), ((TryTree)parent).getFinallyBlock());
                            wc.rewrite(parent, result);
                            break block15;
                        }
                    }
                    result = mk.Try(((TryTree)parent).getResources(), ((TryTree)parent).getBlock(), ((TryTree)parent).getCatches(), mk.Block(newList, false));
                    wc.rewrite(parent, result);
                    break;
                }
                case IF: {
                    switch (position) {
                        case 1: {
                            result = mk.If(((IfTree)parent).getCondition(), ((IfTree)parent).getThenStatement(), (StatementTree)newChild);
                            wc.rewrite(parent, result);
                            break block15;
                        }
                    }
                    result = mk.If(((IfTree)parent).getCondition(), (StatementTree)newChild, ((IfTree)parent).getElseStatement());
                    wc.rewrite(parent, result);
                    break;
                }
                case CASE: {
                    result = mk.Case(((CaseTree)parent).getExpression(), newList);
                    wc.rewrite(parent, result);
                    break;
                }
                case FOR_LOOP: {
                    switch (position) {
                        case 1: {
                            result = mk.ForLoop(newList, ((ForLoopTree)parent).getCondition(), forUpdate, ((ForLoopTree)parent).getStatement());
                            wc.rewrite(parent, result);
                            break block15;
                        }
                        case 2: {
                            result = mk.ForLoop(forInit, ((ForLoopTree)parent).getCondition(), newList, ((ForLoopTree)parent).getStatement());
                            wc.rewrite(parent, result);
                            break block15;
                        }
                    }
                    throw new IllegalArgumentException();
                }
                case BLOCK: {
                    wc.rewrite(parent, (Tree)mk.Block(newList, ((BlockTree)parent).isStatic()));
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        } else if (child.getKind() == Tree.Kind.BLOCK) {
            list = Utilities.getRealStatements((CompilationInfo)wc, new TreePath(parentPath, child));
            int indexAt = 0;
            ArrayList<Object> newList = new ArrayList<Object>(list.size());
            if (anchor != null && (indexAt = list.indexOf(anchor)) == -1) {
                throw new IllegalArgumentException("Anchor not proper child of its parent");
            }
            newList.addAll(list.subList(0, indexAt));
            if (before != null) {
                newList.addAll(before);
            }
            if (anchor != null) {
                newList.add((StatementTree)anchor);
            } else {
                newList.addAll(list);
            }
            if (after != null) {
                newList.addAll(after);
            }
            BlockTree newChild = mk.Block(newList, false);
            wc.rewrite(child, (Tree)newChild);
        } else {
            LambdaExpressionTree let;
            Tree toRewrite = child;
            ArrayList<StatementTree> newList = new ArrayList<StatementTree>();
            if (before != null) {
                newList.addAll(before);
            }
            Tree ch = child;
            if (convertExpressionLambda) {
                let = (LambdaExpressionTree)parent;
                TypeMirror oldType = wc.getTrees().getTypeMirror(new TreePath(parentBlock, let.getBody()));
                if (!Utilities.isStatement(child)) {
                    if (oldType != null && oldType.getKind() != TypeKind.VOID) {
                        newList.add((StatementTree)mk.asReplacementOf((Tree)mk.Return((ExpressionTree)let.getBody()), child));
                    } else {
                        newList.add(mk.ExpressionStatement((ExpressionTree)let.getBody()));
                    }
                }
            } else {
                newList.add((StatementTree)wc.resolveRewriteTarget(ch));
            }
            if (after != null) {
                newList.addAll(after);
            }
            result = mk.Block(newList, false);
            if (convertExpressionLambda) {
                let = (LambdaExpressionTree)parent;
                toRewrite = mk.LambdaExpression(let.getParameters(), result);
            }
            wc.rewrite(toRewrite, result);
        }
        return result;
    }

    public static Tree removeStatement(WorkingCopy wc, TreePath toRemove) {
        return Utilities.removeStatements(wc, toRemove, null);
    }

    public static TreePath findStatementOrExpression(TreePath path) {
        while (!Utilities.isStatement(path.getLeaf())) {
            Tree l = path.getLeaf();
            TreePath next = path.getParentPath();
            if (next == null) {
                return null;
            }
            Tree t = next.getLeaf();
            if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)t.getKind())) {
                return null;
            }
            if (t.getKind() == Tree.Kind.LAMBDA_EXPRESSION) break;
            path = next;
        }
        return path;
    }

    public static Tree removeStatements(WorkingCopy wc, TreePath toRemove, Tree removeEnd) {
        toRemove = Utilities.findStatementOrExpression(toRemove);
        TreePath parent = toRemove.getParentPath();
        switch (parent.getLeaf().getKind()) {
            case EXPRESSION_STATEMENT: {
                return Utilities.removeStatement(wc, parent);
            }
            case LAMBDA_EXPRESSION: 
            case DO_WHILE_LOOP: 
            case FOR_LOOP: 
            case ENHANCED_FOR_LOOP: 
            case WHILE_LOOP: 
            case IF: {
                return Utilities.replaceStatement(wc, toRemove, Collections.singletonList(wc.getTreeMaker().Block(Collections.emptyList(), false)));
            }
            case BLOCK: {
                BlockTree originalBlock = (BlockTree)parent.getLeaf();
                BlockTree bt = (BlockTree)wc.resolveRewriteTarget((Tree)originalBlock);
                List<? extends StatementTree> stats = originalBlock == bt ? Utilities.getRealStatements((CompilationInfo)wc, parent) : bt.getStatements();
                int index = stats.indexOf(toRemove.getLeaf());
                if (index == -1) {
                    throw new IllegalArgumentException("Not proper child of the parent path");
                }
                int indexTo = index;
                if (removeEnd != null && (indexTo = stats.indexOf(indexTo)) == -1) {
                    throw new IllegalArgumentException("Not proper child of the parent path");
                }
                ArrayList<StatementTree> sts = new ArrayList<StatementTree>(stats.size() - 1);
                if (index > 0) {
                    sts.addAll(stats.subList(0, index));
                }
                sts.addAll(stats.subList(indexTo + 1, stats.size()));
                BlockTree nb = wc.getTreeMaker().Block(sts, bt.isStatic());
                wc.rewrite(parent.getLeaf(), (Tree)nb);
                return nb;
            }
        }
        throw new IllegalArgumentException("Unknown parent type");
    }

    private static List<? extends StatementTree> getRealStatements(CompilationInfo info, TreePath path) {
        assert (path.getLeaf().getKind() == Tree.Kind.BLOCK);
        BlockTree bt = (BlockTree)path.getLeaf();
        List<? extends StatementTree> stats = bt.getStatements();
        if (stats.isEmpty()) {
            return stats;
        }
        ArrayList<? extends StatementTree> newStats = null;
        for (int i = 0; i < stats.size(); ++i) {
            StatementTree t = stats.get(i);
            TreePath stPath = new TreePath(path, t);
            if (!info.getTreeUtilities().isSynthetic(stPath)) {
                newStats = new ArrayList(stats.size());
                newStats.addAll(stats.subList(i, stats.size()));
                break;
            }
            newStats = new ArrayList<StatementTree>(stats.size());
        }
        return newStats == null ? stats : newStats;
    }

    public static Tree replaceStatement(WorkingCopy wc, TreePath tp, List<? extends StatementTree> stats) {
        if (!Utilities.isStatement(tp.getLeaf())) {
            throw new IllegalArgumentException();
        }
        if (stats == null || stats.isEmpty()) {
            return Utilities.removeStatement(wc, tp);
        }
        return Utilities.replaceStatements(wc, tp, null, stats);
    }

    private static boolean isStatement(Tree t) {
        return StatementTree.class.isAssignableFrom(t.getKind().asInterface());
    }

    public static Tree replaceStatements(WorkingCopy wc, TreePath tp, Tree last, List<? extends StatementTree> stats) {
        Tree t;
        int current;
        List<Tree> statements;
        if ((tp = Utilities.findStatementOrExpression(tp)) == null) {
            throw new IllegalArgumentException();
        }
        if (stats == null || stats.isEmpty()) {
            return Utilities.removeStatements(wc, tp, last);
        }
        TreeMaker make = wc.getTreeMaker();
        Tree parent = tp.getParentPath().getLeaf();
        boolean trueBranch = false;
        switch (parent.getKind()) {
            case LAMBDA_EXPRESSION: {
                if (stats.size() == 1) {
                    LambdaExpressionTree let = (LambdaExpressionTree)parent;
                    StatementTree st = stats.get(0);
                    if (st.getKind() == Tree.Kind.RETURN) {
                        ExpressionTree x = ((ReturnTree)st).getExpression();
                        if (let.getBodyKind() == LambdaExpressionTree.BodyKind.EXPRESSION) {
                            wc.rewrite(let.getBody(), (Tree)x);
                            return let;
                        }
                        LambdaExpressionTree t2 = make.LambdaExpression(let.getParameters(), (Tree)x);
                        wc.rewrite((Tree)let, (Tree)t2);
                        return let;
                    }
                    if (let.getBodyKind() == LambdaExpressionTree.BodyKind.EXPRESSION) {
                        LambdaExpressionTree t3 = make.LambdaExpression(let.getParameters(), (Tree)make.Block(stats, false));
                        wc.rewrite((Tree)let, (Tree)t3);
                        return let;
                    }
                    BlockTree t4 = make.Block(stats, false);
                    wc.rewrite(let.getBody(), (Tree)t4);
                    return let;
                }
                statements = Collections.singletonList(((LambdaExpressionTree)parent).getBody());
                break;
            }
            case IF: {
                trueBranch = ((IfTree)parent).getThenStatement() == tp.getLeaf();
                statements = Collections.singletonList(trueBranch ? ((IfTree)parent).getThenStatement() : ((IfTree)parent).getElseStatement());
                break;
            }
            case WHILE_LOOP: {
                statements = Collections.singletonList(((WhileLoopTree)parent).getStatement());
                break;
            }
            case DO_WHILE_LOOP: {
                statements = Collections.singletonList(((DoWhileLoopTree)parent).getStatement());
                break;
            }
            case FOR_LOOP: {
                statements = Collections.singletonList(((ForLoopTree)parent).getStatement());
                break;
            }
            case ENHANCED_FOR_LOOP: {
                statements = Collections.singletonList(((EnhancedForLoopTree)parent).getStatement());
                break;
            }
            case BLOCK: {
                statements = Utilities.getRealStatements((CompilationInfo)wc, tp.getParentPath());
                break;
            }
            case CASE: {
                statements = ((CaseTree)parent).getStatements();
                break;
            }
            case METHOD: {
                BlockTree methodBody = stats.size() == 1 && stats.get(0).getKind() == Tree.Kind.BLOCK ? (BlockTree)stats.get(0) : wc.getTreeMaker().Block(stats, false);
                wc.rewrite((Tree)((MethodTree)parent).getBody(), (Tree)methodBody);
                return methodBody;
            }
            default: {
                throw new IllegalStateException(parent.getKind().name());
            }
        }
        Tree var = tp.getLeaf();
        int upTo = current = statements.indexOf(tp.getLeaf());
        if (last != null && (upTo = statements.indexOf(last)) == -1) {
            throw new IllegalArgumentException();
        }
        ArrayList<Tree> newStatements = new ArrayList<Tree>();
        newStatements.addAll(statements.subList(0, current));
        newStatements.add((StatementTree)make.asReplacementOf((Tree)stats.get(0), var));
        newStatements.addAll(stats.subList(1, stats.size()));
        newStatements.addAll(statements.subList(upTo + 1, statements.size()));
        Tree toRewrite = parent;
        StatementTree blockOrStat = newStatements.size() == 1 ? ((t = (Tree)newStatements.get(0)).getKind() == Tree.Kind.VARIABLE ? make.Block(newStatements, false) : (StatementTree)t) : make.Block(newStatements, false);
        Tree target = blockOrStat;
        switch (parent.getKind()) {
            case LAMBDA_EXPRESSION: {
                LambdaExpressionTree let = (LambdaExpressionTree)parent;
                if (let.getBodyKind() == LambdaExpressionTree.BodyKind.EXPRESSION) {
                    target = make.LambdaExpression(let.getParameters(), (Tree)blockOrStat);
                    break;
                }
                toRewrite = let.getBody();
                break;
            }
            case IF: {
                target = make.If(((IfTree)parent).getCondition(), trueBranch ? blockOrStat : ((IfTree)parent).getThenStatement(), !trueBranch ? blockOrStat : ((IfTree)parent).getElseStatement());
                break;
            }
            case WHILE_LOOP: {
                target = make.WhileLoop(((WhileLoopTree)parent).getCondition(), blockOrStat);
                break;
            }
            case DO_WHILE_LOOP: {
                target = make.DoWhileLoop(((DoWhileLoopTree)parent).getCondition(), blockOrStat);
                break;
            }
            case FOR_LOOP: {
                target = make.ForLoop(((ForLoopTree)parent).getInitializer(), ((ForLoopTree)parent).getCondition(), ((ForLoopTree)parent).getUpdate(), blockOrStat);
                break;
            }
            case ENHANCED_FOR_LOOP: {
                target = make.EnhancedForLoop(((EnhancedForLoopTree)parent).getVariable(), ((EnhancedForLoopTree)parent).getExpression(), blockOrStat);
                break;
            }
            case BLOCK: {
                target = make.Block(newStatements, ((BlockTree)parent).isStatic());
                break;
            }
            case CASE: {
                target = make.Case(((CaseTree)parent).getExpression(), newStatements);
                break;
            }
            default: {
                throw new IllegalStateException(parent.getKind().name());
            }
        }
        StatementTree ret = (StatementTree)make.asReplacementOf(target, toRewrite);
        wc.rewrite(toRewrite, (Tree)ret);
        return ret;
    }

    public static ExpressionTree negate(TreeMaker make, ExpressionTree original, Tree parent) {
        ExpressionTree newTree;
        switch (original.getKind()) {
            case PARENTHESIZED: {
                ExpressionTree expr = ((ParenthesizedTree)original).getExpression();
                newTree = Utilities.negate(make, expr, original);
                break;
            }
            case LOGICAL_COMPLEMENT: {
                newTree = ((UnaryTree)original).getExpression();
                while (newTree.getKind() == Tree.Kind.PARENTHESIZED && !JavaFixUtilities.requiresParenthesis((Tree)((ParenthesizedTree)newTree).getExpression(), (Tree)original, (Tree)parent)) {
                    newTree = ((ParenthesizedTree)newTree).getExpression();
                }
                break;
            }
            case NOT_EQUAL_TO: {
                newTree = Utilities.negateBinaryOperator(make, original, Tree.Kind.EQUAL_TO, false);
                break;
            }
            case EQUAL_TO: {
                newTree = Utilities.negateBinaryOperator(make, original, Tree.Kind.NOT_EQUAL_TO, false);
                break;
            }
            case BOOLEAN_LITERAL: {
                newTree = make.Literal((Object)((Boolean)((LiteralTree)original).getValue() == false ? 1 : 0));
                break;
            }
            case CONDITIONAL_AND: {
                newTree = Utilities.negateBinaryOperator(make, original, Tree.Kind.CONDITIONAL_OR, true);
                break;
            }
            case CONDITIONAL_OR: {
                newTree = Utilities.negateBinaryOperator(make, original, Tree.Kind.CONDITIONAL_AND, true);
                break;
            }
            case LESS_THAN: {
                newTree = Utilities.negateBinaryOperator(make, original, Tree.Kind.GREATER_THAN_EQUAL, false);
                break;
            }
            case LESS_THAN_EQUAL: {
                newTree = Utilities.negateBinaryOperator(make, original, Tree.Kind.GREATER_THAN, false);
                break;
            }
            case GREATER_THAN: {
                newTree = Utilities.negateBinaryOperator(make, original, Tree.Kind.LESS_THAN_EQUAL, false);
                break;
            }
            case GREATER_THAN_EQUAL: {
                newTree = Utilities.negateBinaryOperator(make, original, Tree.Kind.LESS_THAN, false);
                break;
            }
            default: {
                newTree = make.Unary(Tree.Kind.LOGICAL_COMPLEMENT, original);
                if (!JavaFixUtilities.requiresParenthesis((Tree)original, (Tree)original, (Tree)newTree)) break;
                newTree = make.Unary(Tree.Kind.LOGICAL_COMPLEMENT, (ExpressionTree)make.Parenthesized(original));
            }
        }
        if (JavaFixUtilities.requiresParenthesis((Tree)newTree, (Tree)original, (Tree)parent)) {
            newTree = make.Parenthesized(newTree);
        }
        return newTree;
    }

    private static ExpressionTree negateBinaryOperator(TreeMaker make, Tree original, Tree.Kind newKind, boolean negateOperands) {
        BinaryTree bt = (BinaryTree)original;
        ExpressionTree left = bt.getLeftOperand();
        ExpressionTree right = bt.getRightOperand();
        if (negateOperands) {
            left = Utilities.negate(make, left, original);
            right = Utilities.negate(make, right, original);
        }
        return make.Binary(newKind, left, right);
    }

    public static FileObject getModuleInfo(CompilationInfo info) {
        if (info.getSourceVersion().compareTo(SourceVersion.RELEASE_9) > 0) {
            return null;
        }
        return info.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.SOURCE).findResource("module-info.java");
    }

    public static boolean isModular(CompilationInfo info) {
        return Utilities.getModuleInfo(info) != null;
    }

    public static boolean isAnonymousType(TypeMirror type) {
        DeclaredType dt;
        TypeElement typeElem;
        return type.getKind() == TypeKind.DECLARED && (typeElem = (TypeElement)(dt = (DeclaredType)type).asElement()).getNestingKind() == NestingKind.ANONYMOUS;
    }

    public static ExecutableElement getFunctionalMethodFromElement(CompilationInfo info, Element element) {
        Element classType = info.getTypes().asElement(element.asType());
        if (classType == null || !classType.getKind().isInterface()) {
            return null;
        }
        ExecutableElement elementToReturn = null;
        int methodCounter = 0;
        for (Element element2 : classType.getEnclosedElements()) {
            if (element2.getKind() != ElementKind.METHOD || !element2.getModifiers().contains((Object)Modifier.ABSTRACT)) continue;
            elementToReturn = (ExecutableElement)element2;
            ++methodCounter;
        }
        if (methodCounter != 1) {
            return null;
        }
        return elementToReturn;
    }

    public static boolean completesNormally(CompilationInfo info, TreePath tp) {
        class Scanner
        extends TreePathScanner<Void, Void> {
            private boolean completesNormally = true;
            private Set<Tree> seenTrees = new HashSet<Tree>();
            final /* synthetic */ CompilationInfo val$info;

            Scanner(CompilationInfo compilationInfo) {
                this.val$info = compilationInfo;
            }

            @Override
            public Void visitReturn(ReturnTree node, Void p) {
                this.completesNormally = false;
                return null;
            }

            @Override
            public Void visitBreak(BreakTree node, Void p) {
                this.completesNormally &= this.seenTrees.contains(this.val$info.getTreeUtilities().getBreakContinueTarget(this.getCurrentPath()));
                return null;
            }

            @Override
            public Void visitContinue(ContinueTree node, Void p) {
                this.completesNormally &= this.seenTrees.contains(this.val$info.getTreeUtilities().getBreakContinueTarget(this.getCurrentPath()));
                return null;
            }

            @Override
            public Void visitThrow(ThrowTree node, Void p) {
                this.completesNormally = false;
                return null;
            }

            @Override
            public Void visitIf(IfTree node, Void p) {
                boolean origCompletesNormally = this.completesNormally;
                this.scan((Tree)node.getThenStatement(), p);
                boolean afterThen = this.completesNormally;
                this.completesNormally = origCompletesNormally;
                this.scan((Tree)node.getElseStatement(), p);
                this.completesNormally |= afterThen;
                return null;
            }

            @Override
            public Void visitSwitch(SwitchTree node, Void p) {
                boolean hasDefault = node.getCases().stream().anyMatch(c -> c.getExpression() == null);
                if (node.getCases().size() > 0) {
                    this.scan((Tree)node.getCases().get(node.getCases().size() - 1), p);
                }
                this.completesNormally |= !hasDefault;
                return null;
            }

            @Override
            public Void scan(Tree tree, Void p) {
                this.seenTrees.add(tree);
                return (Void)super.scan(tree, p);
            }

            @Override
            public Void visitLambdaExpression(LambdaExpressionTree node, Void p) {
                return null;
            }

            @Override
            public Void visitClass(ClassTree node, Void p) {
                return null;
            }
        }
        Scanner scanner = new Scanner(info);
        scanner.scan(tp, null);
        return scanner.completesNormally;
    }

    public static boolean isCompatibleWithSwitchExpression(SwitchTree st) {
        boolean firstCase = true;
        Name leftTreeName = null;
        int caseCount = 0;
        List<? extends CaseTree> cases = st.getCases();
        block5: for (CaseTree caseTree : cases) {
            ++caseCount;
            ArrayList<? extends StatementTree> statements = new ArrayList<StatementTree>(caseTree.getStatements());
            switch (statements.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    Name exprTree;
                    if (firstCase && leftTreeName == null && ((StatementTree)statements.get(0)).getKind() == Tree.Kind.RETURN) break;
                    if (caseCount == cases.size() && ((StatementTree)statements.get(0)).getKind() == Tree.Kind.EXPRESSION_STATEMENT) {
                        if (firstCase) {
                            leftTreeName = Utilities.getLeftTreeName((StatementTree)statements.get(0));
                            if (leftTreeName != null) continue block5;
                            return false;
                        }
                        exprTree = Utilities.getLeftTreeName((StatementTree)statements.get(0));
                        if (leftTreeName != null && exprTree != null && leftTreeName.contentEquals(exprTree)) break;
                        return false;
                    }
                    return false;
                }
                case 2: {
                    Name exprTree;
                    if (((StatementTree)statements.get(0)).getKind() == Tree.Kind.EXPRESSION_STATEMENT && ((StatementTree)statements.get(1)).getKind() == Tree.Kind.BREAK) {
                        if (firstCase) {
                            leftTreeName = Utilities.getLeftTreeName((StatementTree)statements.get(0));
                            if (leftTreeName == null) {
                                return false;
                            }
                            firstCase = false;
                        }
                        exprTree = Utilities.getLeftTreeName((StatementTree)statements.get(0));
                        if (leftTreeName != null && exprTree != null && leftTreeName.contentEquals(exprTree)) break;
                        return false;
                    }
                    return false;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    public static void performRewriteRuleSwitch(final JavaFix.TransformationContext ctx, TreePath tp, final Tree st, boolean isSwitchExpression) {
        List<? extends CaseTree> cases;
        ExpressionTree switchExpr;
        boolean ruleSwitchFlag;
        final WorkingCopy wc = ctx.getWorkingCopy();
        final TreeMaker make = wc.getTreeMaker();
        ArrayList<CaseTree> newCases = new ArrayList<CaseTree>();
        SWITCH_TYPE switchType = SWITCH_TYPE.TRADITIONAL_SWITCH;
        JCTree typeCastTree = null;
        final HashSet<VariableElement> variablesDeclaredInOtherCases = new HashSet<VariableElement>();
        ArrayList<? extends CaseLabelTree> patterns = new ArrayList<CaseLabelTree>();
        JCTree.JCExpression leftVariable = null;
        boolean bl = ruleSwitchFlag = st.getKind() == Tree.Kind.SWITCH_EXPRESSION;
        if (ruleSwitchFlag) {
            switchExpr = ((SwitchExpressionTree)st).getExpression();
            cases = ((SwitchExpressionTree)st).getCases();
            switchType = SWITCH_TYPE.RULE_SWITCH;
        } else {
            switchExpr = ((SwitchTree)st).getExpression();
            cases = ((SwitchTree)st).getCases();
        }
        Iterator<? extends CaseTree> it = cases.iterator();
        while (it.hasNext()) {
            CaseTree ct = it.next();
            TreePath casePath = new TreePath(tp, ct);
            patterns.addAll(ct.getLabels());
            ArrayList<? extends StatementTree> statements = ct.getStatements() == null ? new ArrayList<JCTree.JCStatement>(((JCTree.JCCase)ct).stats) : new ArrayList<StatementTree>(ct.getStatements());
            if (statements.isEmpty()) {
                if (it.hasNext()) {
                    continue;
                }
            } else if (!ruleSwitchFlag && ((StatementTree)statements.get(statements.size() - 1)).getKind() == Tree.Kind.BREAK && ctx.getWorkingCopy().getTreeUtilities().getBreakContinueTarget(new TreePath(new TreePath(tp, ct), (Tree)statements.get(statements.size() - 1))) == st) {
                statements.remove(statements.size() - 1);
            } else {
                new TreePathScanner<Void, Void>(){

                    @Override
                    public Void visitBlock(BlockTree node, Void p) {
                        if (!node.getStatements().isEmpty() && node.getStatements().get(node.getStatements().size() - 1).getKind() == Tree.Kind.BREAK && ctx.getWorkingCopy().getTreeUtilities().getBreakContinueTarget(new TreePath(this.getCurrentPath(), node.getStatements().get(node.getStatements().size() - 1))) == st) {
                            wc.rewrite((Tree)node, (Tree)make.removeBlockStatement(node, node.getStatements().get(node.getStatements().size() - 1)));
                        }
                        return (Void)super.visitBlock(node, p);
                    }
                }.scan(new TreePath(new TreePath(tp, ct), (Tree)statements.get(statements.size() - 1)), (Void)null);
            }
            final HashSet<Element> seenVariables = new HashSet<Element>();
            int idx = 0;
            for (StatementTree statementTree : new ArrayList<StatementTree>(statements)) {
                ExpressionTree expr;
                TreePath treePath = new TreePath(casePath, statementTree);
                if (statementTree.getKind() == Tree.Kind.EXPRESSION_STATEMENT && (expr = ((ExpressionStatementTree)statementTree).getExpression()).getKind() == Tree.Kind.ASSIGNMENT) {
                    AssignmentTree at = (AssignmentTree)expr;
                    Element var = wc.getTrees().getElement(new TreePath(new TreePath(treePath, at), at.getVariable()));
                    if (variablesDeclaredInOtherCases.contains(var)) {
                        seenVariables.add(var);
                        wc.rewrite((Tree)statementTree, (Tree)make.Variable(make.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)var.getSimpleName(), make.Type(var.asType()), at.getExpression()));
                    }
                }
                final HashSet thisStatementSeenVariables = new HashSet();
                new TreePathScanner<Void, Void>(){

                    @Override
                    public Void visitIdentifier(IdentifierTree node, Void p) {
                        Element el = wc.getTrees().getElement(this.getCurrentPath());
                        if (variablesDeclaredInOtherCases.contains(el) && seenVariables.add(el)) {
                            thisStatementSeenVariables.add(el);
                        }
                        return (Void)super.visitIdentifier(node, p);
                    }
                }.scan(treePath, (Void)null);
                if (!thisStatementSeenVariables.isEmpty()) {
                    for (Element el : thisStatementSeenVariables) {
                        VariableElement var = (VariableElement)el;
                        statements.add(idx++, make.Variable(make.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)var.getSimpleName(), make.Type(var.asType()), null));
                    }
                }
                ++idx;
            }
            Tree body = make.Block(statements, false);
            if (statements.size() == 1 && (((StatementTree)statements.get(0)).getKind() == Tree.Kind.EXPRESSION_STATEMENT || ((StatementTree)statements.get(0)).getKind() == Tree.Kind.THROW || ((StatementTree)statements.get(0)).getKind() == Tree.Kind.BLOCK)) {
                body = (Tree)statements.get(0);
            }
            if (isSwitchExpression) {
                switchType = SWITCH_TYPE.SWITCH_EXPRESSION;
                if (((StatementTree)statements.get(0)).getKind() == Tree.Kind.RETURN) {
                    body = ((JCTree.JCReturn)statements.get(0)).getExpression();
                } else {
                    JCTree.JCExpressionStatement jCExpressionStatement = (JCTree.JCExpressionStatement)statements.get(0);
                    body = ((JCTree.JCAssign)jCExpressionStatement.expr).rhs;
                    leftVariable = ((JCTree.JCAssign)jCExpressionStatement.expr).lhs;
                }
                if (body.getKind() == Tree.Kind.TYPE_CAST) {
                    typeCastTree = ((JCTree.JCTypeCast)body).getType();
                    body = ((JCTree.JCTypeCast)body).getExpression();
                }
                newCases.add(make.CasePatterns(patterns, ct.getGuard(), (Tree)make.ExpressionStatement((ExpressionTree)body)));
            } else {
                newCases.add(make.CasePatterns(patterns, ct.getGuard(), body));
            }
            patterns = new ArrayList();
            for (StatementTree statementTree : Utilities.getSwitchStatement(ct)) {
                if (statementTree.getKind() != Tree.Kind.VARIABLE) continue;
                variablesDeclaredInOtherCases.add((VariableElement)wc.getTrees().getElement(new TreePath(casePath, statementTree)));
            }
        }
        ExpressionTree et = null;
        switch (switchType) {
            case SWITCH_EXPRESSION: {
                et = (ExpressionTree)make.SwitchExpression(switchExpr, newCases);
                if (typeCastTree != null) {
                    et = make.Parenthesized(et);
                    et = make.TypeCast(typeCastTree, et);
                }
                if (leftVariable != null) {
                    wc.rewrite(st, (Tree)make.ExpressionStatement((ExpressionTree)make.Assignment((ExpressionTree)leftVariable, et)));
                    break;
                }
                wc.rewrite(st, (Tree)make.Return(et));
                break;
            }
            case RULE_SWITCH: {
                wc.rewrite(st, make.SwitchExpression(switchExpr, newCases));
                break;
            }
            case TRADITIONAL_SWITCH: {
                wc.rewrite((Tree)((SwitchTree)st), (Tree)make.Switch(switchExpr, newCases));
                break;
            }
        }
    }

    private static List<? extends StatementTree> getSwitchStatement(CaseTree ct) {
        if (ct.getStatements() != null) {
            return ct.getStatements();
        }
        if (ct instanceof JCTree.JCCase) {
            return ((JCTree.JCCase)ct).stats;
        }
        return null;
    }

    private static Name getLeftTreeName(StatementTree statement) {
        if (statement.getKind() != Tree.Kind.EXPRESSION_STATEMENT) {
            return null;
        }
        JCTree.JCExpressionStatement jceTree = (JCTree.JCExpressionStatement)statement;
        if (jceTree.expr.getKind() != Tree.Kind.ASSIGNMENT) {
            return null;
        }
        JCTree.JCAssign assignTree = (JCTree.JCAssign)jceTree.expr;
        return ((JCTree.JCIdent)assignTree.lhs).name;
    }

    public static boolean isJDKVersionLower(int previewUntilJDK) {
        return Integer.valueOf(SourceVersion.latest().name().split(UNDERSCORE)[1]).compareTo(previewUntilJDK) <= 0;
    }

    static {
        operator2DN.put(Tree.Kind.AND, "&");
        operator2DN.put(Tree.Kind.XOR, "^");
        operator2DN.put(Tree.Kind.OR, "|");
        operator2DN.put(Tree.Kind.CONDITIONAL_AND, "&&");
        operator2DN.put(Tree.Kind.CONDITIONAL_OR, "||");
        operator2DN.put(Tree.Kind.MULTIPLY_ASSIGNMENT, "*=");
        operator2DN.put(Tree.Kind.DIVIDE_ASSIGNMENT, "/=");
        operator2DN.put(Tree.Kind.REMAINDER_ASSIGNMENT, "%=");
        operator2DN.put(Tree.Kind.PLUS_ASSIGNMENT, "+=");
        operator2DN.put(Tree.Kind.MINUS_ASSIGNMENT, "-=");
        operator2DN.put(Tree.Kind.LEFT_SHIFT_ASSIGNMENT, "<<=");
        operator2DN.put(Tree.Kind.RIGHT_SHIFT_ASSIGNMENT, ">>=");
        operator2DN.put(Tree.Kind.UNSIGNED_RIGHT_SHIFT_ASSIGNMENT, ">>>=");
        operator2DN.put(Tree.Kind.AND_ASSIGNMENT, "&=");
        operator2DN.put(Tree.Kind.XOR_ASSIGNMENT, "^=");
        operator2DN.put(Tree.Kind.OR_ASSIGNMENT, "|=");
        operator2DN.put(Tree.Kind.BITWISE_COMPLEMENT, "~");
        operator2DN.put(Tree.Kind.LOGICAL_COMPLEMENT, "!");
        operator2DN.put(Tree.Kind.MULTIPLY, "*");
        operator2DN.put(Tree.Kind.DIVIDE, "/");
        operator2DN.put(Tree.Kind.REMAINDER, "%");
        operator2DN.put(Tree.Kind.PLUS, "+");
        operator2DN.put(Tree.Kind.MINUS, "-");
        operator2DN.put(Tree.Kind.LEFT_SHIFT, "<<");
        operator2DN.put(Tree.Kind.RIGHT_SHIFT, ">>");
        operator2DN.put(Tree.Kind.UNSIGNED_RIGHT_SHIFT, ">>>");
        operator2DN.put(Tree.Kind.LESS_THAN, "<");
        operator2DN.put(Tree.Kind.GREATER_THAN, ">");
        operator2DN.put(Tree.Kind.LESS_THAN_EQUAL, "<=");
        operator2DN.put(Tree.Kind.GREATER_THAN_EQUAL, ">=");
        operator2DN.put(Tree.Kind.EQUAL_TO, "==");
        operator2DN.put(Tree.Kind.NOT_EQUAL_TO, "!=");
        VARIABLE_KINDS = EnumSet.of(ElementKind.LOCAL_VARIABLE, new ElementKind[]{ElementKind.ENUM_CONSTANT, ElementKind.FIELD, ElementKind.PARAMETER, ElementKind.RESOURCE_VARIABLE, ElementKind.EXCEPTION_PARAMETER, ElementKind.TYPE_PARAMETER});
        PRIMITIVE_NAMES = new HashSet<String>(8);
        PRIMITIVE_NAMES.add("java.lang.Integer");
        PRIMITIVE_NAMES.add("java.lang.Character");
        PRIMITIVE_NAMES.add("java.lang.Long");
        PRIMITIVE_NAMES.add("java.lang.Byte");
        PRIMITIVE_NAMES.add("java.lang.Short");
        PRIMITIVE_NAMES.add("java.lang.Boolean");
        PRIMITIVE_NAMES.add("java.lang.Float");
        PRIMITIVE_NAMES.add("java.lang.Double");
    }

    private static final class DummyJFO
    extends SimpleJavaFileObject {
        private DummyJFO() {
            super(URI.create("dummy.java"), JavaFileObject.Kind.SOURCE);
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
            return "";
        }
    }

    public static enum Visibility {
        PRIVATE(EnumSet.of(Modifier.PRIVATE)),
        PACKAGE_PRIVATE(EnumSet.noneOf(Modifier.class)),
        PROTECTED(EnumSet.of(Modifier.PROTECTED)),
        PUBLIC(EnumSet.of(Modifier.PUBLIC));

        private final Set<Modifier> modifiers;

        private Visibility(Set<Modifier> modifiers) {
            this.modifiers = modifiers;
        }

        public Visibility enclosedBy(Visibility encl) {
            return Visibility.values()[Math.min(this.ordinal(), encl.ordinal())];
        }

        public Set<Modifier> getRequiredModifiers() {
            return this.modifiers;
        }

        public static Visibility forModifiers(ModifiersTree mt) {
            if (mt.getFlags().contains((Object)Modifier.PUBLIC)) {
                return PUBLIC;
            }
            if (mt.getFlags().contains((Object)Modifier.PROTECTED)) {
                return PROTECTED;
            }
            if (mt.getFlags().contains((Object)Modifier.PRIVATE)) {
                return PRIVATE;
            }
            return PACKAGE_PRIVATE;
        }

        public static Visibility forElement(Element el) {
            if (el.getModifiers().contains((Object)Modifier.PUBLIC)) {
                return PUBLIC;
            }
            if (el.getModifiers().contains((Object)Modifier.PROTECTED)) {
                return PROTECTED;
            }
            if (el.getModifiers().contains((Object)Modifier.PRIVATE)) {
                return PRIVATE;
            }
            return PACKAGE_PRIVATE;
        }

        public static Visibility forTree(Tree t) {
            switch (t.getKind()) {
                case ANNOTATION_TYPE: 
                case CLASS: 
                case ENUM: 
                case INTERFACE: {
                    return Visibility.forModifiers(((ClassTree)t).getModifiers());
                }
                case VARIABLE: {
                    return Visibility.forModifiers(((VariableTree)t).getModifiers());
                }
                case METHOD: {
                    return Visibility.forModifiers(((MethodTree)t).getModifiers());
                }
            }
            return null;
        }
    }

    private static final class ExitsFromAllBranches
    extends ErrorAwareTreePathScanner<Boolean, Void> {
        private CompilationInfo info;
        private final Set<Tree> seenTrees = new HashSet<Tree>();
        private final Stack<Pair<Set<TypeMirror>, Tree>> caughtExceptions = new Stack();
        private final Set<Tree> targetTrees = new HashSet<Tree>();

        public ExitsFromAllBranches(CompilationInfo info) {
            this.info = info;
        }

        public Boolean scan(TreePath path, Void p) {
            this.seenTrees.add(path.getLeaf());
            Boolean ret = (Boolean)super.scan(path, (Object)p);
            boolean pending = !this.targetTrees.isEmpty();
            this.targetTrees.remove(path.getLeaf());
            return pending ? Boolean.FALSE : ret;
        }

        public Boolean scan(Tree tree, Void p) {
            if (!this.targetTrees.isEmpty()) {
                return false;
            }
            this.seenTrees.add(tree);
            Boolean ret = (Boolean)super.scan(tree, (Object)p);
            boolean pending = !this.targetTrees.isEmpty();
            this.targetTrees.remove(tree);
            return pending ? null : ret;
        }

        public Boolean visitLambdaExpression(LambdaExpressionTree node, Void p) {
            return false;
        }

        public Boolean visitMethodInvocation(MethodInvocationTree node, Void p) {
            Element el = this.info.getTrees().getElement(this.getCurrentPath());
            if (Utilities.isSystemExit(this.info, el)) {
                return true;
            }
            return (Boolean)super.visitMethodInvocation(node, (Object)p);
        }

        public Boolean visitArrayType(ArrayTypeTree node, Void p) {
            return (Boolean)super.visitArrayType(node, (Object)p);
        }

        public Boolean visitDoWhileLoop(DoWhileLoopTree node, Void p) {
            return this.scan((Tree)node.getStatement(), p);
        }

        public Boolean visitEnhancedForLoop(EnhancedForLoopTree node, Void p) {
            return null;
        }

        public Boolean visitForLoop(ForLoopTree node, Void p) {
            return null;
        }

        public Boolean visitWhileLoop(WhileLoopTree node, Void p) {
            return null;
        }

        public Boolean visitIf(IfTree node, Void p) {
            return this.scan((Tree)node.getThenStatement(), null) == Boolean.TRUE && this.scan((Tree)node.getElseStatement(), null) == Boolean.TRUE;
        }

        public Boolean visitSwitch(SwitchTree node, Void p) {
            TypeMirror exprType;
            boolean lastCaseExit = false;
            boolean defaultSeen = false;
            HashSet<Element> enumValues = null;
            if (node.getExpression() != null && Utilities.isValidType(exprType = this.info.getTrees().getTypeMirror(new TreePath(this.getCurrentPath(), node.getExpression()))) && exprType.getKind() == TypeKind.DECLARED) {
                Element element = ((DeclaredType)exprType).asElement();
                enumValues = new HashSet<Element>();
                for (Element element2 : element.getEnclosedElements()) {
                    if (element2.getKind() != ElementKind.ENUM_CONSTANT) continue;
                    enumValues.add(element2);
                }
            }
            for (CaseTree caseTree : node.getCases()) {
                Boolean res = this.scan((Tree)caseTree, null);
                if (res == Boolean.FALSE) {
                    return res;
                }
                boolean bl = lastCaseExit = res == Boolean.TRUE;
                if (caseTree.getExpression() == null) {
                    defaultSeen = true;
                    continue;
                }
                if (enumValues == null) continue;
                TreePath treePath = new TreePath(this.getCurrentPath(), caseTree);
                Element v = this.info.getTrees().getElement(new TreePath(treePath, caseTree.getExpression()));
                if (v == null) continue;
                enumValues.remove(v);
            }
            if (enumValues != null && enumValues.isEmpty()) {
                defaultSeen = true;
            }
            return lastCaseExit == Boolean.TRUE && defaultSeen;
        }

        public Boolean visitReturn(ReturnTree node, Void p) {
            return true;
        }

        public Boolean visitBreak(BreakTree node, Void p) {
            StatementTree target = this.info.getTreeUtilities().getBreakContinueTarget(this.getCurrentPath());
            boolean known = this.seenTrees.contains(target);
            if (known) {
                this.targetTrees.add(target);
            }
            return !known;
        }

        public Boolean visitContinue(ContinueTree node, Void p) {
            return this.visitBreak(null, p);
        }

        public Boolean visitClass(ClassTree node, Void p) {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Boolean visitTry(TryTree node, Void p) {
            HashSet<TypeMirror> caught = new HashSet<TypeMirror>();
            for (CatchTree catchTree : node.getCatches()) {
                TypeMirror t = this.info.getTrees().getTypeMirror(new TreePath(new TreePath(this.getCurrentPath(), catchTree), catchTree.getParameter()));
                if (t == null) continue;
                caught.add(t);
            }
            this.caughtExceptions.push((Pair<Set<TypeMirror>, Tree>)Pair.of(caught, (Object)node));
            try {
                Boolean bl = this.scan((Tree)node.getBlock(), p) == Boolean.TRUE || this.scan((Tree)node.getFinallyBlock(), p) == Boolean.TRUE;
                return bl;
            }
            finally {
                this.caughtExceptions.pop();
            }
        }

        public Boolean visitThrow(ThrowTree node, Void p) {
            TypeMirror type = this.info.getTrees().getTypeMirror(new TreePath(this.getCurrentPath(), node.getExpression()));
            boolean isCaught = false;
            block0: for (Pair pair : this.caughtExceptions) {
                Set caught = (Set)pair.first();
                for (TypeMirror c : caught) {
                    if (!this.info.getTypes().isSubtype(type, c)) continue;
                    isCaught = true;
                    this.targetTrees.add((Tree)pair.second());
                    break block0;
                }
            }
            return super.visitThrow(node, (Object)p) == Boolean.TRUE || !isCaught;
        }
    }

    public static class MethodArguments {
        public final List<? extends TypeMirror> parameterTypes;
        public final List<String> parameterNames;
        public final List<? extends TypeMirror> typeParameterTypes;
        public final List<String> typeParameterNames;

        public MethodArguments(List<? extends TypeMirror> parameterTypes, List<String> parameterNames, List<? extends TypeMirror> typeParameterTypes, List<String> typeParameterNames) {
            this.parameterTypes = parameterTypes;
            this.parameterNames = parameterNames;
            this.typeParameterTypes = typeParameterTypes;
            this.typeParameterNames = typeParameterNames;
        }
    }

    private static class HintDisplayNameVisitor
    extends ErrorAwareTreeScanner<String, Void> {
        private CompilationInfo info;

        public HintDisplayNameVisitor(CompilationInfo info) {
            this.info = info;
        }

        public String visitIdentifier(IdentifierTree tree, Void v) {
            return "..." + tree.getName().toString();
        }

        public String visitMethodInvocation(MethodInvocationTree tree, Void v) {
            ExpressionTree methodSelect = tree.getMethodSelect();
            return "..." + this.simpleName(methodSelect) + "(...)";
        }

        public String visitArrayAccess(ArrayAccessTree node, Void p) {
            return "..." + this.simpleName(node.getExpression()) + "[]";
        }

        public String visitNewClass(NewClassTree nct, Void p) {
            return "...new " + this.simpleName(nct.getIdentifier()) + "(...)";
        }

        public String visitNewArray(NewArrayTree nct, Void p) {
            return "...new " + this.simpleName(nct.getType()) + "[...]";
        }

        public String visitBinary(BinaryTree node, Void p) {
            String dn = (String)operator2DN.get((Object)node.getKind());
            return (String)this.scan(node.getLeftOperand(), p) + dn + (String)this.scan(node.getRightOperand(), p);
        }

        public String visitLiteral(LiteralTree node, Void p) {
            if (node.getValue() instanceof String) {
                return "...";
            }
            int start = (int)this.info.getTrees().getSourcePositions().getStartPosition(this.info.getCompilationUnit(), node);
            int end = (int)this.info.getTrees().getSourcePositions().getEndPosition(this.info.getCompilationUnit(), node);
            if (start < 0 || end < 0 || end < start) {
                return node.toString();
            }
            return this.info.getText().substring(start, end);
        }

        private String simpleName(Tree t) {
            if (t == null) {
                return Bundle.DisplayName_Unknown();
            }
            if (t.getKind() == Tree.Kind.IDENTIFIER) {
                return ((IdentifierTree)t).getName().toString();
            }
            if (t.getKind() == Tree.Kind.MEMBER_SELECT) {
                return ((MemberSelectTree)t).getIdentifier().toString();
            }
            if (t.getKind() == Tree.Kind.METHOD_INVOCATION) {
                return (String)this.scan(t, null);
            }
            if (t.getKind() == Tree.Kind.PARAMETERIZED_TYPE) {
                return this.simpleName(((ParameterizedTypeTree)t).getType()) + "<...>";
            }
            if (t.getKind() == Tree.Kind.ARRAY_ACCESS) {
                return this.simpleName(((ArrayAccessTree)t).getExpression()) + "[]";
            }
            if (t.getKind() == Tree.Kind.PARENTHESIZED) {
                return "(" + this.simpleName(((ParenthesizedTree)t).getExpression()) + ")";
            }
            if (t.getKind() == Tree.Kind.TYPE_CAST) {
                return this.simpleName(((TypeCastTree)t).getType());
            }
            if (t.getKind() == Tree.Kind.ARRAY_TYPE) {
                return this.simpleName(((ArrayTypeTree)t).getType());
            }
            if (t.getKind() == Tree.Kind.PRIMITIVE_TYPE) {
                return ((PrimitiveTypeTree)t).getPrimitiveTypeKind().name().toLowerCase();
            }
            throw new IllegalStateException("Currently unsupported kind of tree: " + (Object)((Object)t.getKind()));
        }
    }

    public static final class VariablesFilter
    implements ElementUtilities.ElementAcceptor {
        private static final Set<ElementKind> ACCEPTABLE_KINDS = EnumSet.of(ElementKind.ENUM_CONSTANT, ElementKind.EXCEPTION_PARAMETER, ElementKind.FIELD, ElementKind.LOCAL_VARIABLE, ElementKind.PARAMETER);

        public boolean accept(Element e, TypeMirror type) {
            return ACCEPTABLE_KINDS.contains((Object)e.getKind());
        }
    }

    static enum SWITCH_TYPE {
        TRADITIONAL_SWITCH,
        RULE_SWITCH,
        SWITCH_EXPRESSION;

    }
}

