/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.codegen.ui;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.websvc.saas.codegen.SaasClientCodeGenerationManager;
import org.netbeans.modules.websvc.saas.codegen.SaasClientCodeGenerator;
import org.netbeans.modules.websvc.saas.codegen.model.CustomClientSaasBean;
import org.netbeans.modules.websvc.saas.codegen.model.ParameterInfo;
import org.netbeans.modules.websvc.saas.codegen.ui.ProgressDialog;
import org.netbeans.modules.websvc.saas.codegen.util.Util;
import org.netbeans.modules.websvc.saas.model.CustomSaasMethod;
import org.netbeans.modules.websvc.saas.model.SaasMethod;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.ActiveEditorDrop;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class CustomClientEditorDrop
implements ActiveEditorDrop {
    private CustomSaasMethod method;
    private FileObject targetFO;
    private RequestProcessor.Task generatorTask;

    public CustomClientEditorDrop(CustomSaasMethod method) {
        this.method = method;
    }

    public boolean handleTransfer(JTextComponent targetComponent) {
        if (SaasClientCodeGenerationManager.canAccept((SaasMethod)this.method, targetComponent.getDocument())) {
            return this.doHandleTransfer(targetComponent);
        }
        return false;
    }

    private boolean doHandleTransfer(final JTextComponent targetComponent) {
        final Document targetDoc = targetComponent.getDocument();
        FileObject targetSource = NbEditorUtilities.getFileObject((Document)targetComponent.getDocument());
        Project targetProject = FileOwnerQuery.getOwner((FileObject)targetSource);
        final String displayName = this.method.getName();
        this.targetFO = CustomClientEditorDrop.getTargetFile(targetComponent);
        if (this.targetFO == null) {
            return false;
        }
        final ArrayList errors = new ArrayList();
        final ProgressDialog dialog = new ProgressDialog(NbBundle.getMessage(CustomClientEditorDrop.class, (String)"LBL_CodeGenProgress", (Object)displayName));
        this.generatorTask = RequestProcessor.getDefault().create(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    SaasClientCodeGenerator codegen = (SaasClientCodeGenerator)SaasClientCodeGenerationManager.lookup((SaasMethod)CustomClientEditorDrop.this.method, targetDoc);
                    if (codegen == null) {
                        Util.showUnsupportedDropMessage(new Object[]{CustomClientEditorDrop.this.targetFO.getNameExt(), "REST Resource"});
                        return;
                    }
                    codegen.init((SaasMethod)CustomClientEditorDrop.this.method, targetDoc);
                    codegen.setDropLocation(targetComponent);
                    CustomClientSaasBean bean = (CustomClientSaasBean)codegen.getBean();
                    List<ParameterInfo> allParams = bean.filterParametersByAuth(bean.filterParameters(new ParameterInfo.ParamFilter[]{ParameterInfo.ParamFilter.FIXED}));
                    boolean response = Util.showDialog(displayName, allParams, targetDoc);
                    if (response) {
                        Util.doGenerateCode(codegen, dialog, errors);
                    }
                }
                catch (Exception ioe) {
                    errors.add(ioe);
                }
                finally {
                    dialog.close();
                }
            }
        });
        this.generatorTask.schedule(50);
        dialog.open();
        if (errors.size() > 0) {
            Exceptions.printStackTrace((Throwable)((Throwable)errors.get(0)));
            return false;
        }
        return true;
    }

    public static FileObject getTargetFile(JTextComponent targetComponent) {
        if (targetComponent == null) {
            return null;
        }
        DataObject d = NbEditorUtilities.getDataObject((Document)targetComponent.getDocument());
        if (d == null) {
            return null;
        }
        EditorCookie ec = (EditorCookie)d.getCookie(EditorCookie.class);
        if (ec == null || ec.getOpenedPanes() == null) {
            return null;
        }
        return d.getPrimaryFile();
    }
}

