/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.search.backend.smo;

import org.apache.maven.search.api.transport.Java11HttpClientTransport;
import org.apache.maven.search.api.transport.Transport;
import org.apache.maven.search.backend.smo.SmoSearchBackend;
import org.apache.maven.search.backend.smo.internal.SmoSearchBackendImpl;

public final class SmoSearchBackendFactory {
    public static final String DEFAULT_BACKEND_ID = "central-smo";
    public static final String DEFAULT_REPOSITORY_ID = "central";
    public static final String DEFAULT_SMO_URI = "https://search.maven.org/solrsearch/select";

    private SmoSearchBackendFactory() {
    }

    public static SmoSearchBackend createDefault() {
        return SmoSearchBackendFactory.create(DEFAULT_BACKEND_ID, DEFAULT_REPOSITORY_ID, DEFAULT_SMO_URI, (Transport)new Java11HttpClientTransport());
    }

    public static SmoSearchBackend create(String backendId, String repositoryId, String smoUri, Transport transport) {
        return new SmoSearchBackendImpl(backendId, repositoryId, smoUri, transport);
    }
}

