/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.stackanalyzer;

import java.awt.Container;
import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import org.netbeans.modules.java.stackanalyzer.AnalyserCellRenderer;
import org.netbeans.modules.java.stackanalyzer.StackLineAnalyser;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

final class AnalyzeStackTopComponent
extends TopComponent {
    private static AnalyzeStackTopComponent instance;
    private static final String PREFERRED_ID = "AnalyzeStackTopComponent";
    private JButton insertButton;
    private JList list;
    private JScrollPane scrollPane;

    private AnalyzeStackTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(AnalyzeStackTopComponent.class, (String)"CTL_AnalyzeStackTopComponent"));
        this.setToolTipText(NbBundle.getMessage(AnalyzeStackTopComponent.class, (String)"HINT_AnalyzeStackTopComponent"));
        this.getActionMap().put("paste-from-clipboard", new PasteAction());
        this.insertButton.getActionMap().put("paste-from-clipboard", new PasteAction());
        this.scrollPane.getActionMap().put("paste-from-clipboard", new PasteAction());
        this.list.setBackground(UIManager.getColor("Tree.background"));
        this.list.getActionMap().put("paste-from-clipboard", new PasteAction());
        this.list.setCellRenderer(new AnalyserCellRenderer());
        this.list.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '\n') {
                    String currentLine = (String)AnalyzeStackTopComponent.this.list.getSelectedValue();
                    AnalyzeStackTopComponent.this.open(currentLine);
                }
            }
        });
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 1) {
                    return;
                }
                int i = AnalyzeStackTopComponent.this.list.locationToIndex(e.getPoint());
                if (i < 0) {
                    return;
                }
                String currentLine = (String)AnalyzeStackTopComponent.this.list.getModel().getElementAt(i);
                AnalyzeStackTopComponent.this.open(currentLine);
            }
        });
        this.list.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                String line;
                StackLineAnalyser.Link link;
                Rectangle r;
                int i = AnalyzeStackTopComponent.this.list.locationToIndex(e.getPoint());
                if (i >= 0 && (r = AnalyzeStackTopComponent.this.list.getCellBounds(i, i)).contains(e.getPoint()) && (link = StackLineAnalyser.analyse(line = (String)AnalyzeStackTopComponent.this.list.getModel().getElementAt(i))) != null) {
                    AnalyzeStackTopComponent.this.list.setCursor(Cursor.getPredefinedCursor(12));
                    return;
                }
                AnalyzeStackTopComponent.this.list.setCursor(Cursor.getDefaultCursor());
            }

            @Override
            public void mouseExited(MouseEvent e) {
                AnalyzeStackTopComponent.this.list.setCursor(Cursor.getDefaultCursor());
            }
        });
    }

    public void fill(BufferedReader r) {
        DefaultListModel model = new DefaultListModel();
        AnalyzeStackTopComponent.fillListModel(r, model);
        if (!model.isEmpty()) {
            this.list.setModel(model);
        }
    }

    static void fillListModel(BufferedReader r, DefaultListModel model) {
        String lastLine = null;
        try {
            String currentLine;
            while ((currentLine = r.readLine()) != null) {
                String together;
                if (StackLineAnalyser.matches(currentLine = currentLine.replaceAll("\u001b\\[[\\d;]*[^\\d;]", "").strip())) {
                    if (lastLine != null) {
                        model.addElement(lastLine);
                    }
                    model.addElement(currentLine);
                    lastLine = null;
                    continue;
                }
                if (lastLine == null) {
                    lastLine = currentLine;
                    continue;
                }
                if (lastLine.endsWith("at")) {
                    lastLine = lastLine + " ";
                }
                if (StackLineAnalyser.matches(together = lastLine + currentLine)) {
                    model.addElement(together);
                    lastLine = null;
                    continue;
                }
                model.addElement(lastLine);
                lastLine = currentLine;
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void initComponents() {
        this.insertButton = new JButton();
        this.scrollPane = new JScrollPane();
        this.list = new JList();
        this.setName("Form");
        Mnemonics.setLocalizedText((AbstractButton)this.insertButton, (String)NbBundle.getBundle(AnalyzeStackTopComponent.class).getString("AnalyzeStackTopComponent.insertButton.text"));
        this.insertButton.setName("insertButton");
        this.insertButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AnalyzeStackTopComponent.this.insertButtonActionPerformed(evt);
            }
        });
        this.scrollPane.setName("scrollPane");
        this.list.setSelectionMode(0);
        this.list.setName("list");
        this.scrollPane.setViewportView(this.list);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPane, -1, 394, Short.MAX_VALUE).addComponent(this.insertButton)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.insertButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scrollPane, -1, 367, Short.MAX_VALUE).addContainerGap()));
        this.insertButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AnalyzeStackTopComponent.class, (String)"AnalyzeStackTopComponent.insertButton.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AnalyzeStackTopComponent.class, (String)"AnalyzeStackTopComponent.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AnalyzeStackTopComponent.class, (String)"AnalyzeStackTopComponent.AccessibleContext.accessibleDescription"));
    }

    private void insertButtonActionPerformed(ActionEvent evt) {
        try {
            Clipboard clipBoard = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable transferable = clipBoard.getContents((Object)this);
            if (!transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                return;
            }
            Reader reader = DataFlavor.stringFlavor.getReaderForText(transferable);
            BufferedReader r = new BufferedReader(reader);
            this.fill(r);
        }
        catch (UnsupportedFlavorException | IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public static synchronized AnalyzeStackTopComponent getDefault() {
        if (instance == null) {
            instance = new AnalyzeStackTopComponent();
        }
        return instance;
    }

    public static synchronized AnalyzeStackTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            Logger.getLogger(AnalyzeStackTopComponent.class.getName()).warning("Cannot find AnalyzeStackTopComponent component. It will not be located properly in the window system.");
            AnalyzeStackTopComponent analyzeStackTopComponent = AnalyzeStackTopComponent.getDefault();
            analyzeStackTopComponent.insertButtonActionPerformed(null);
            return analyzeStackTopComponent;
        }
        if (win instanceof AnalyzeStackTopComponent) {
            AnalyzeStackTopComponent analyzeStackTopComponent = (AnalyzeStackTopComponent)win;
            analyzeStackTopComponent.insertButtonActionPerformed(null);
            return analyzeStackTopComponent;
        }
        Logger.getLogger(AnalyzeStackTopComponent.class.getName()).warning("There seem to be multiple components with the 'AnalyzeStackTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return AnalyzeStackTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.java.stackanalyzer.AnalyzeStackTopComponent");
    }

    private void open(String line) {
        StackLineAnalyser.Link link = StackLineAnalyser.analyse(line);
        if (link != null) {
            link.show();
        }
    }

    private class PasteAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            AnalyzeStackTopComponent.this.insertButtonActionPerformed(null);
        }
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return AnalyzeStackTopComponent.getDefault();
        }
    }
}

