/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.compiler;

import groovy.lang.GroovyClassLoader;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.decompiled.AsmDecompiler;
import org.codehaus.groovy.ast.decompiled.AsmReferenceResolver;
import org.codehaus.groovy.ast.decompiled.ClassStub;
import org.codehaus.groovy.ast.decompiled.DecompiledClassNode;
import org.codehaus.groovy.classgen.Verifier;
import org.codehaus.groovy.control.ClassNodeResolver;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.SourceUnit;
import org.netbeans.modules.groovy.editor.compiler.PerfData;

public class NbClassNodeResolver
extends ClassNodeResolver {
    public ClassNodeResolver.LookupResult findClassNode(String name, CompilationUnit compilationUnit) {
        return this.tryAsLoaderClassOrScript(name, compilationUnit);
    }

    private ClassNodeResolver.LookupResult tryAsLoaderClassOrScript(String name, CompilationUnit compilationUnit) {
        ClassNodeResolver.LookupResult result;
        GroovyClassLoader loader = compilationUnit.getClassLoader();
        Map options = compilationUnit.getConfiguration().getOptimizationOptions();
        boolean useAsm = !Boolean.FALSE.equals(options.get("asmResolving"));
        boolean useClassLoader = !Boolean.FALSE.equals(options.get("classLoaderResolving"));
        ClassNodeResolver.LookupResult lookupResult = result = useAsm ? this.findDecompiled(name, compilationUnit, loader) : null;
        if (result != null) {
            return result;
        }
        return NbClassNodeResolver.tryAsScript(name, compilationUnit, null);
    }

    protected AsmReferenceResolver createReferencesResolver(CompilationUnit unit) {
        return new AsmReferenceResolver((ClassNodeResolver)this, unit);
    }

    protected ClassStub parseClass(URL resource) throws IOException {
        return AsmDecompiler.parseClass((URL)resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassNodeResolver.LookupResult findDecompiled(String name, CompilationUnit compilationUnit, GroovyClassLoader loader) {
        ClassNode node = ClassHelper.make((String)name);
        if (node.isResolved()) {
            return new ClassNodeResolver.LookupResult(null, node);
        }
        TimestampedClassNode asmClass = null;
        String fileName = name.replace('.', '/') + ".class";
        URL resource = loader.getResource(fileName);
        long t = System.currentTimeMillis();
        if (resource != null) {
            try {
                URLConnection c = resource.openConnection();
                asmClass = new TimestampedClassNode(c.getLastModified(), this.parseClass(resource), this.createReferencesResolver(compilationUnit));
                if (!asmClass.getName().equals(name)) {
                    asmClass = null;
                }
            }
            catch (IOException iOException) {
            }
            finally {
                long t2 = System.currentTimeMillis();
                PerfData.context().addPerfCounter("findDecompiled - parsing", t2 - t);
            }
        }
        if (asmClass != null) {
            long t3 = System.currentTimeMillis();
            long t5 = 0L;
            try {
                ClassNodeResolver.LookupResult lr = NbClassNodeResolver.tryAsScript(name, compilationUnit, asmClass);
                t5 = System.currentTimeMillis();
                ClassNodeResolver.LookupResult lookupResult = lr;
                return lookupResult;
            }
            finally {
                if (t5 > 0L) {
                    PerfData.context().addPerfCounter("findDecompiled - tryAsScrupt", t5 - t3);
                }
            }
        }
        return null;
    }

    private static ClassNodeResolver.LookupResult tryAsScript(String name, CompilationUnit compilationUnit, ClassNode oldClass) {
        ClassNodeResolver.LookupResult lr = null;
        if (oldClass != null) {
            lr = new ClassNodeResolver.LookupResult(null, oldClass);
        }
        if (name.startsWith("java.")) {
            return lr;
        }
        if (name.indexOf(36) != -1) {
            return lr;
        }
        GroovyClassLoader gcl = compilationUnit.getClassLoader();
        URL url = null;
        try {
            url = gcl.getResourceLoader().loadGroovySource(name);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (url != null && (oldClass == null || NbClassNodeResolver.isSourceNewer(url, oldClass))) {
            SourceUnit su = compilationUnit.addSource(url);
            return new ClassNodeResolver.LookupResult(su, null);
        }
        return lr;
    }

    private static boolean isSourceNewer(URL source, ClassNode cls) {
        try {
            long lastMod;
            if (source.getProtocol().equals("file")) {
                String path = source.getPath().replace('/', File.separatorChar).replace('|', ':');
                File file = new File(path);
                lastMod = file.lastModified();
            } else {
                URLConnection conn = source.openConnection();
                lastMod = conn.getLastModified();
                conn.getInputStream().close();
            }
            return lastMod > NbClassNodeResolver.getTimeStamp(cls);
        }
        catch (IOException e) {
            return false;
        }
    }

    private static long getTimeStamp(ClassNode cls) {
        if (!(cls instanceof DecompiledClassNode)) {
            return Verifier.getTimestamp((Class)cls.getTypeClass());
        }
        return ((DecompiledClassNode)cls).getCompilationTimeStamp();
    }

    private static class TimestampedClassNode
    extends DecompiledClassNode {
        private final long timestamp;

        public TimestampedClassNode(long timestamp, ClassStub data, AsmReferenceResolver resolver) {
            super(data, resolver);
            this.timestamp = timestamp;
        }

        public long getCompilationTimeStamp() {
            return this.timestamp;
        }
    }
}

