/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.design.view.widget;

import org.netbeans.modules.websvc.design.javamodel.MethodModel;
import org.netbeans.modules.websvc.design.javamodel.ParamModel;
import org.netbeans.modules.websvc.design.view.widget.TableModel;
import org.openide.util.NbBundle;

public class ParametersTableModel
implements TableModel<ParamModel> {
    private transient MethodModel method;
    private transient boolean nameEditable;

    public ParametersTableModel(MethodModel method, boolean nameEditable) {
        this.method = method;
        this.nameEditable = nameEditable;
    }

    @Override
    public int getRowCount() {
        return this.method.getParams().size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return NbBundle.getMessage(ParametersTableModel.class, (String)"LBL_Parameter_Name");
            }
            case 1: {
                return NbBundle.getMessage(ParametersTableModel.class, (String)"LBL_Parameter_Type");
            }
        }
        throw new IllegalArgumentException("");
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.nameEditable;
            }
            case 1: {
                return false;
            }
        }
        return false;
    }

    @Override
    public String getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex >= 0 && rowIndex < this.getRowCount()) {
            switch (columnIndex) {
                case 0: {
                    return this.getUserObject(rowIndex).getName();
                }
                case 1: {
                    return this.getUserObject(rowIndex).getParamType();
                }
            }
            throw new IllegalArgumentException("");
        }
        return null;
    }

    @Override
    public void setValueAt(String aValue, int rowIndex, int columnIndex) {
        if (rowIndex >= 0 && rowIndex < this.getRowCount()) {
            switch (columnIndex) {
                case 0: {
                    this.getUserObject(rowIndex).setName(aValue);
                    break;
                }
                case 1: {
                    throw new IllegalArgumentException("");
                }
                default: {
                    throw new IllegalArgumentException("");
                }
            }
        }
    }

    @Override
    public ParamModel getUserObject(int rowIndex) {
        return this.method.getParams().get(rowIndex);
    }
}

